#ifndef _GFile_H
#define _GFile_H

#include "GImage.h"
#include "GImageComponent.h"

/* GFile is an abstract decendant of GImage.  Derivatives of this class
 * represent various image file formats.  Known examples are:
 *
 *     GFile_TIFF
 *     GFile_JPEG
 *     GFile_KDC
 * 
 * Written by:  Chris Studholme
 * Last Update: 8-January-2000
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */

class GFile : public GImage {

 protected:
  GImageComponent* red;
  GImageComponent* green;
  GImageComponent* blue;

 public:
  virtual bool isOK()=0;

  int getPreferredWidth() {
    return getWidth();
  }
  int getPreferredHeight() {
    return getHeight();
  }

  static void calculateBestMinMax(int& min, int& max, 
				  unsigned int* histogram);

  static void addToHistogram(unsigned int* histogram, 
			     unsigned char* array, int narray);

  virtual void FindBestMinMax(int& min, int& max) {
    min=0;
    max=255;
  }

  virtual void FindWhiteBalance(float& r, float& b, int min=0) {
    float meanred = red->getMeanValue();
    float meangreen = green->getMeanValue();
    float meanblue = blue->getMeanValue();
    r=(meanred-min)/(meangreen-min);
    b=(meanblue-min)/(meangreen-min);
  }

  int ReduceGrain(bool extra=false) {
    return red->ReduceGrain(extra) +
      green->ReduceGrain(extra) +
      blue->ReduceGrain(extra);
  }

};

#endif

