
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQProcess.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QProcess>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QProcessEnvironment>
#include <QThread>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QProcess

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QProcess::staticMetaObject);
}


//  Constructor QProcess::QProcess(QObject *parent)


static void _init_ctor_QProcess_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QProcess> ();
}

static void _call_ctor_QProcess_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QProcess *> (new QProcess (arg1));
}


// QStringList QProcess::arguments()


static void _init_f_arguments_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_arguments_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QProcess *)cls)->arguments ());
}


// bool QProcess::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProcess *)cls)->atEnd ());
}


// qint64 QProcess::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QProcess *)cls)->bytesAvailable ());
}


// qint64 QProcess::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QProcess *)cls)->bytesToWrite ());
}


// bool QProcess::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProcess *)cls)->canReadLine ());
}


// void QProcess::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->close ();
}


// void QProcess::closeReadChannel(QProcess::ProcessChannel channel)


static void _init_f_closeReadChannel_2800 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("channel");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_closeReadChannel_2800 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->closeReadChannel (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannel>(arg1).cref());
}


// void QProcess::closeWriteChannel()


static void _init_f_closeWriteChannel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeWriteChannel_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->closeWriteChannel ();
}


// QStringList QProcess::environment()


static void _init_f_environment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_environment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QProcess *)cls)->environment ());
}


// QProcess::ProcessError QProcess::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProcess::ProcessError>::target_type > ((qt_gsi::Converter<QProcess::ProcessError>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessError>(((QProcess *)cls)->error ()));
}


// int QProcess::exitCode()


static void _init_f_exitCode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exitCode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QProcess *)cls)->exitCode ());
}


// QProcess::ExitStatus QProcess::exitStatus()


static void _init_f_exitStatus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ExitStatus>::target_type > ();
}

static void _call_f_exitStatus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProcess::ExitStatus>::target_type > ((qt_gsi::Converter<QProcess::ExitStatus>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ExitStatus>(((QProcess *)cls)->exitStatus ()));
}


// QProcess::InputChannelMode QProcess::inputChannelMode()


static void _init_f_inputChannelMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::InputChannelMode>::target_type > ();
}

static void _call_f_inputChannelMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProcess::InputChannelMode>::target_type > ((qt_gsi::Converter<QProcess::InputChannelMode>::target_type)qt_gsi::CppToQtAdaptor<QProcess::InputChannelMode>(((QProcess *)cls)->inputChannelMode ()));
}


// bool QProcess::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QProcess *)cls)->isSequential ());
}


// void QProcess::kill()


static void _init_f_kill_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_kill_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->kill ();
}


// bool QProcess::open(QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_open_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_open_3242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QIODevice::OpenModeFlag> arg1 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::ReadWrite, heap);
  ret.write<bool > ((bool)((QProcess *)cls)->open (arg1));
}


// Q_PID QProcess::pid()


static void _init_f_pid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Q_PID>::target_type > ();
}

static void _call_f_pid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Q_PID>::target_type > ((qt_gsi::Converter<Q_PID>::target_type)qt_gsi::CppToQtAdaptor<Q_PID>(((QProcess *)cls)->pid ()));
}


// QProcess::ProcessChannelMode QProcess::processChannelMode()


static void _init_f_processChannelMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ();
}

static void _call_f_processChannelMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ((qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessChannelMode>(((QProcess *)cls)->processChannelMode ()));
}


// QProcessEnvironment QProcess::processEnvironment()


static void _init_f_processEnvironment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QProcessEnvironment > ();
}

static void _call_f_processEnvironment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QProcessEnvironment > ((QProcessEnvironment)((QProcess *)cls)->processEnvironment ());
}


// qint64 QProcess::processId()


static void _init_f_processId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_processId_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QProcess *)cls)->processId ());
}


// QString QProcess::program()


static void _init_f_program_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_program_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QProcess *)cls)->program ());
}


// QByteArray QProcess::readAllStandardError()


static void _init_f_readAllStandardError_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_readAllStandardError_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QProcess *)cls)->readAllStandardError ());
}


// QByteArray QProcess::readAllStandardOutput()


static void _init_f_readAllStandardOutput_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_readAllStandardOutput_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QProcess *)cls)->readAllStandardOutput ());
}


// QProcess::ProcessChannel QProcess::readChannel()


static void _init_f_readChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessChannel>::target_type > ();
}

static void _call_f_readChannel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProcess::ProcessChannel>::target_type > ((qt_gsi::Converter<QProcess::ProcessChannel>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessChannel>(((QProcess *)cls)->readChannel ()));
}


// QProcess::ProcessChannelMode QProcess::readChannelMode()


static void _init_f_readChannelMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ();
}

static void _call_f_readChannelMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type > ((qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessChannelMode>(((QProcess *)cls)->readChannelMode ()));
}


// void QProcess::setArguments(const QStringList &arguments)


static void _init_f_setArguments_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arguments");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setArguments_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setArguments (arg1);
}


// void QProcess::setEnvironment(const QStringList &environment)


static void _init_f_setEnvironment_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("environment");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnvironment_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = gsi::arg_reader<const QStringList & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setEnvironment (arg1);
}


// void QProcess::setInputChannelMode(QProcess::InputChannelMode mode)


static void _init_f_setInputChannelMode_2982 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QProcess::InputChannelMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputChannelMode_2982 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QProcess::InputChannelMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QProcess::InputChannelMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setInputChannelMode (qt_gsi::QtToCppAdaptor<QProcess::InputChannelMode>(arg1).cref());
}


// void QProcess::setProcessChannelMode(QProcess::ProcessChannelMode mode)


static void _init_f_setProcessChannelMode_3189 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProcessChannelMode_3189 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setProcessChannelMode (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannelMode>(arg1).cref());
}


// void QProcess::setProcessEnvironment(const QProcessEnvironment &environment)


static void _init_f_setProcessEnvironment_3302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("environment");
  decl->add_arg<const QProcessEnvironment & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProcessEnvironment_3302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QProcessEnvironment &arg1 = gsi::arg_reader<const QProcessEnvironment & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setProcessEnvironment (arg1);
}


// void QProcess::setProgram(const QString &program)


static void _init_f_setProgram_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProgram_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setProgram (arg1);
}


// void QProcess::setReadChannel(QProcess::ProcessChannel channel)


static void _init_f_setReadChannel_2800 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("channel");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadChannel_2800 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QProcess::ProcessChannel>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setReadChannel (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannel>(arg1).cref());
}


// void QProcess::setReadChannelMode(QProcess::ProcessChannelMode mode)


static void _init_f_setReadChannelMode_3189 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadChannelMode_3189 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QProcess::ProcessChannelMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setReadChannelMode (qt_gsi::QtToCppAdaptor<QProcess::ProcessChannelMode>(arg1).cref());
}


// void QProcess::setStandardErrorFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_setStandardErrorFile_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIODevice::Truncate");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStandardErrorFile_5159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QIODevice::OpenModeFlag> arg2 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::Truncate, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setStandardErrorFile (arg1, arg2);
}


// void QProcess::setStandardInputFile(const QString &fileName)


static void _init_f_setStandardInputFile_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardInputFile_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setStandardInputFile (arg1);
}


// void QProcess::setStandardOutputFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_setStandardOutputFile_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIODevice::Truncate");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStandardOutputFile_5159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QIODevice::OpenModeFlag> arg2 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::Truncate, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setStandardOutputFile (arg1, arg2);
}


// void QProcess::setStandardOutputProcess(QProcess *destination)


static void _init_f_setStandardOutputProcess_1438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destination");
  decl->add_arg<QProcess * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardOutputProcess_1438 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QProcess *arg1 = gsi::arg_reader<QProcess * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setStandardOutputProcess (arg1);
}


// void QProcess::setWorkingDirectory(const QString &dir)


static void _init_f_setWorkingDirectory_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWorkingDirectory_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->setWorkingDirectory (arg1);
}


// void QProcess::start(const QString &program, const QStringList &arguments, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_start_7488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const QStringList & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_start_7488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = gsi::arg_reader<const QStringList & >() (args, heap);
  QFlags<QIODevice::OpenModeFlag> arg3 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::ReadWrite, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->start (arg1, arg2, arg3);
}


// void QProcess::start(const QString &command, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_start_5159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("command");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_start_5159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QIODevice::OpenModeFlag> arg2 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::ReadWrite, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->start (arg1, arg2);
}


// void QProcess::start(QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_start_3242 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_start_3242 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QIODevice::OpenModeFlag> arg1 = args ? gsi::arg_reader<QFlags<QIODevice::OpenModeFlag> >() (args, heap) : gsi::arg_maker<QFlags<QIODevice::OpenModeFlag> >() (QIODevice::ReadWrite, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->start (arg1);
}


// QProcess::ProcessState QProcess::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QProcess::ProcessState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QProcess::ProcessState>::target_type > ((qt_gsi::Converter<QProcess::ProcessState>::target_type)qt_gsi::CppToQtAdaptor<QProcess::ProcessState>(((QProcess *)cls)->state ()));
}


// void QProcess::terminate()


static void _init_f_terminate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_terminate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QProcess *)cls)->terminate ();
}


// bool QProcess::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForBytesWritten (arg1));
}


// bool QProcess::waitForFinished(int msecs)


static void _init_f_waitForFinished_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForFinished_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForFinished (arg1));
}


// bool QProcess::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForReadyRead (arg1));
}


// bool QProcess::waitForStarted(int msecs)


static void _init_f_waitForStarted_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForStarted_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (30000, heap);
  ret.write<bool > ((bool)((QProcess *)cls)->waitForStarted (arg1));
}


// QString QProcess::workingDirectory()


static void _init_f_workingDirectory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_workingDirectory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QProcess *)cls)->workingDirectory ());
}


// static int QProcess::execute(const QString &program, const QStringList &arguments)


static void _init_f_execute_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const QStringList & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_execute_4354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = gsi::arg_reader<const QStringList & >() (args, heap);
  ret.write<int > ((int)QProcess::execute (arg1, arg2));
}


// static int QProcess::execute(const QString &command)


static void _init_f_execute_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("command");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_execute_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)QProcess::execute (arg1));
}


// static QString QProcess::nullDevice()


static void _init_f_nullDevice_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_nullDevice_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)QProcess::nullDevice ());
}


// static bool QProcess::startDetached(const QString &program, const QStringList &arguments, const QString &workingDirectory, qint64 *pid)


static void _init_f_startDetached_7335 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const QStringList & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("workingDirectory");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pid", true, "0");
  decl->add_arg<qint64 * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_startDetached_7335 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = gsi::arg_reader<const QStringList & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  qint64 *arg4 = args ? gsi::arg_reader<qint64 * >() (args, heap) : gsi::arg_maker<qint64 * >() (0, heap);
  ret.write<bool > ((bool)QProcess::startDetached (arg1, arg2, arg3, arg4));
}


// static bool QProcess::startDetached(const QString &program, const QStringList &arguments)


static void _init_f_startDetached_4354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("program");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arguments");
  decl->add_arg<const QStringList & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_startDetached_4354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QStringList &arg2 = gsi::arg_reader<const QStringList & >() (args, heap);
  ret.write<bool > ((bool)QProcess::startDetached (arg1, arg2));
}


// static bool QProcess::startDetached(const QString &command)


static void _init_f_startDetached_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("command");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_startDetached_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QProcess::startDetached (arg1));
}


// static QStringList QProcess::systemEnvironment()


static void _init_f_systemEnvironment_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_systemEnvironment_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QProcess::systemEnvironment ());
}


// static QString QProcess::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QProcess::tr (arg1, arg2, arg3));
}


// static QString QProcess::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QProcess::trUtf8 (arg1, arg2, arg3));
}



namespace gsi
{

static gsi::Methods methods_QProcess () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QProcess::QProcess(QObject *parent)\nThis method creates an object of class QProcess.", &_init_ctor_QProcess_1302, &_call_ctor_QProcess_1302);
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":arguments", "@brief Method QStringList QProcess::arguments()\n", true, &_init_f_arguments_c0, &_call_f_arguments_c0);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QProcess::atEnd()\nThis is a reimplementation of QIODevice::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QProcess::bytesAvailable()\nThis is a reimplementation of QIODevice::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QProcess::bytesToWrite()\nThis is a reimplementation of QIODevice::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
  methods += new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QProcess::canReadLine()\nThis is a reimplementation of QIODevice::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QProcess::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("closeReadChannel", "@brief Method void QProcess::closeReadChannel(QProcess::ProcessChannel channel)\n", false, &_init_f_closeReadChannel_2800, &_call_f_closeReadChannel_2800);
  methods += new qt_gsi::GenericMethod ("closeWriteChannel", "@brief Method void QProcess::closeWriteChannel()\n", false, &_init_f_closeWriteChannel_0, &_call_f_closeWriteChannel_0);
  methods += new qt_gsi::GenericMethod (":environment", "@brief Method QStringList QProcess::environment()\n", true, &_init_f_environment_c0, &_call_f_environment_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QProcess::ProcessError QProcess::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("exitCode", "@brief Method int QProcess::exitCode()\n", true, &_init_f_exitCode_c0, &_call_f_exitCode_c0);
  methods += new qt_gsi::GenericMethod ("exitStatus", "@brief Method QProcess::ExitStatus QProcess::exitStatus()\n", true, &_init_f_exitStatus_c0, &_call_f_exitStatus_c0);
  methods += new qt_gsi::GenericMethod (":inputChannelMode", "@brief Method QProcess::InputChannelMode QProcess::inputChannelMode()\n", true, &_init_f_inputChannelMode_c0, &_call_f_inputChannelMode_c0);
  methods += new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QProcess::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
  methods += new qt_gsi::GenericMethod ("kill", "@brief Method void QProcess::kill()\n", false, &_init_f_kill_0, &_call_f_kill_0);
  methods += new qt_gsi::GenericMethod ("open", "@brief Method bool QProcess::open(QFlags<QIODevice::OpenModeFlag> mode)\nThis is a reimplementation of QIODevice::open", false, &_init_f_open_3242, &_call_f_open_3242);
  methods += new qt_gsi::GenericMethod ("pid", "@brief Method Q_PID QProcess::pid()\n", true, &_init_f_pid_c0, &_call_f_pid_c0);
  methods += new qt_gsi::GenericMethod (":processChannelMode", "@brief Method QProcess::ProcessChannelMode QProcess::processChannelMode()\n", true, &_init_f_processChannelMode_c0, &_call_f_processChannelMode_c0);
  methods += new qt_gsi::GenericMethod (":processEnvironment", "@brief Method QProcessEnvironment QProcess::processEnvironment()\n", true, &_init_f_processEnvironment_c0, &_call_f_processEnvironment_c0);
  methods += new qt_gsi::GenericMethod ("processId", "@brief Method qint64 QProcess::processId()\n", true, &_init_f_processId_c0, &_call_f_processId_c0);
  methods += new qt_gsi::GenericMethod (":program", "@brief Method QString QProcess::program()\n", true, &_init_f_program_c0, &_call_f_program_c0);
  methods += new qt_gsi::GenericMethod ("readAllStandardError", "@brief Method QByteArray QProcess::readAllStandardError()\n", false, &_init_f_readAllStandardError_0, &_call_f_readAllStandardError_0);
  methods += new qt_gsi::GenericMethod ("readAllStandardOutput", "@brief Method QByteArray QProcess::readAllStandardOutput()\n", false, &_init_f_readAllStandardOutput_0, &_call_f_readAllStandardOutput_0);
  methods += new qt_gsi::GenericMethod (":readChannel", "@brief Method QProcess::ProcessChannel QProcess::readChannel()\n", true, &_init_f_readChannel_c0, &_call_f_readChannel_c0);
  methods += new qt_gsi::GenericMethod (":readChannelMode", "@brief Method QProcess::ProcessChannelMode QProcess::readChannelMode()\n", true, &_init_f_readChannelMode_c0, &_call_f_readChannelMode_c0);
  methods += new qt_gsi::GenericMethod ("setArguments|arguments=", "@brief Method void QProcess::setArguments(const QStringList &arguments)\n", false, &_init_f_setArguments_2437, &_call_f_setArguments_2437);
  methods += new qt_gsi::GenericMethod ("setEnvironment|environment=", "@brief Method void QProcess::setEnvironment(const QStringList &environment)\n", false, &_init_f_setEnvironment_2437, &_call_f_setEnvironment_2437);
  methods += new qt_gsi::GenericMethod ("setInputChannelMode|inputChannelMode=", "@brief Method void QProcess::setInputChannelMode(QProcess::InputChannelMode mode)\n", false, &_init_f_setInputChannelMode_2982, &_call_f_setInputChannelMode_2982);
  methods += new qt_gsi::GenericMethod ("setProcessChannelMode|processChannelMode=", "@brief Method void QProcess::setProcessChannelMode(QProcess::ProcessChannelMode mode)\n", false, &_init_f_setProcessChannelMode_3189, &_call_f_setProcessChannelMode_3189);
  methods += new qt_gsi::GenericMethod ("setProcessEnvironment|processEnvironment=", "@brief Method void QProcess::setProcessEnvironment(const QProcessEnvironment &environment)\n", false, &_init_f_setProcessEnvironment_3302, &_call_f_setProcessEnvironment_3302);
  methods += new qt_gsi::GenericMethod ("setProgram|program=", "@brief Method void QProcess::setProgram(const QString &program)\n", false, &_init_f_setProgram_2025, &_call_f_setProgram_2025);
  methods += new qt_gsi::GenericMethod ("setReadChannel|readChannel=", "@brief Method void QProcess::setReadChannel(QProcess::ProcessChannel channel)\n", false, &_init_f_setReadChannel_2800, &_call_f_setReadChannel_2800);
  methods += new qt_gsi::GenericMethod ("setReadChannelMode|readChannelMode=", "@brief Method void QProcess::setReadChannelMode(QProcess::ProcessChannelMode mode)\n", false, &_init_f_setReadChannelMode_3189, &_call_f_setReadChannelMode_3189);
  methods += new qt_gsi::GenericMethod ("setStandardErrorFile", "@brief Method void QProcess::setStandardErrorFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_setStandardErrorFile_5159, &_call_f_setStandardErrorFile_5159);
  methods += new qt_gsi::GenericMethod ("setStandardInputFile", "@brief Method void QProcess::setStandardInputFile(const QString &fileName)\n", false, &_init_f_setStandardInputFile_2025, &_call_f_setStandardInputFile_2025);
  methods += new qt_gsi::GenericMethod ("setStandardOutputFile", "@brief Method void QProcess::setStandardOutputFile(const QString &fileName, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_setStandardOutputFile_5159, &_call_f_setStandardOutputFile_5159);
  methods += new qt_gsi::GenericMethod ("setStandardOutputProcess", "@brief Method void QProcess::setStandardOutputProcess(QProcess *destination)\n", false, &_init_f_setStandardOutputProcess_1438, &_call_f_setStandardOutputProcess_1438);
  methods += new qt_gsi::GenericMethod ("setWorkingDirectory|workingDirectory=", "@brief Method void QProcess::setWorkingDirectory(const QString &dir)\n", false, &_init_f_setWorkingDirectory_2025, &_call_f_setWorkingDirectory_2025);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QProcess::start(const QString &program, const QStringList &arguments, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_start_7488, &_call_f_start_7488);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QProcess::start(const QString &command, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_start_5159, &_call_f_start_5159);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QProcess::start(QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_start_3242, &_call_f_start_3242);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QProcess::ProcessState QProcess::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("terminate", "@brief Method void QProcess::terminate()\n", false, &_init_f_terminate_0, &_call_f_terminate_0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QProcess::waitForBytesWritten(int msecs)\nThis is a reimplementation of QIODevice::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
  methods += new qt_gsi::GenericMethod ("waitForFinished", "@brief Method bool QProcess::waitForFinished(int msecs)\n", false, &_init_f_waitForFinished_767, &_call_f_waitForFinished_767);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QProcess::waitForReadyRead(int msecs)\nThis is a reimplementation of QIODevice::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
  methods += new qt_gsi::GenericMethod ("waitForStarted", "@brief Method bool QProcess::waitForStarted(int msecs)\n", false, &_init_f_waitForStarted_767, &_call_f_waitForStarted_767);
  methods += new qt_gsi::GenericMethod (":workingDirectory", "@brief Method QString QProcess::workingDirectory()\n", true, &_init_f_workingDirectory_c0, &_call_f_workingDirectory_c0);
  methods += gsi::qt_signal ("aboutToClose()", "aboutToClose", "@brief Signal declaration for QProcess::aboutToClose()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("bytesWritten(qint64)", "bytesWritten", gsi::arg("bytes"), "@brief Signal declaration for QProcess::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QProcess::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QProcess::ProcessError>::target_type & > ("error(QProcess::ProcessError)", "error_sig", gsi::arg("error"), "@brief Signal declaration for QProcess::error(QProcess::ProcessError error)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("finished(int)", "finished_int", gsi::arg("exitCode"), "@brief Signal declaration for QProcess::finished(int exitCode)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const qt_gsi::Converter<QProcess::ExitStatus>::target_type & > ("finished(int, QProcess::ExitStatus)", "finished", gsi::arg("exitCode"), gsi::arg("exitStatus"), "@brief Signal declaration for QProcess::finished(int exitCode, QProcess::ExitStatus exitStatus)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QProcess::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readChannelFinished()", "readChannelFinished", "@brief Signal declaration for QProcess::readChannelFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyRead()", "readyRead", "@brief Signal declaration for QProcess::readyRead()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyReadStandardError()", "readyReadStandardError", "@brief Signal declaration for QProcess::readyReadStandardError()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyReadStandardOutput()", "readyReadStandardOutput", "@brief Signal declaration for QProcess::readyReadStandardOutput()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("started()", "started", "@brief Signal declaration for QProcess::started()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QProcess::ProcessState>::target_type & > ("stateChanged(QProcess::ProcessState)", "stateChanged", gsi::arg("state"), "@brief Signal declaration for QProcess::stateChanged(QProcess::ProcessState state)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("execute", "@brief Static method int QProcess::execute(const QString &program, const QStringList &arguments)\nThis method is static and can be called without an instance.", &_init_f_execute_4354, &_call_f_execute_4354);
  methods += new qt_gsi::GenericStaticMethod ("execute", "@brief Static method int QProcess::execute(const QString &command)\nThis method is static and can be called without an instance.", &_init_f_execute_2025, &_call_f_execute_2025);
  methods += new qt_gsi::GenericStaticMethod ("nullDevice", "@brief Static method QString QProcess::nullDevice()\nThis method is static and can be called without an instance.", &_init_f_nullDevice_0, &_call_f_nullDevice_0);
  methods += new qt_gsi::GenericStaticMethod ("startDetached", "@brief Static method bool QProcess::startDetached(const QString &program, const QStringList &arguments, const QString &workingDirectory, qint64 *pid)\nThis method is static and can be called without an instance.", &_init_f_startDetached_7335, &_call_f_startDetached_7335);
  methods += new qt_gsi::GenericStaticMethod ("startDetached", "@brief Static method bool QProcess::startDetached(const QString &program, const QStringList &arguments)\nThis method is static and can be called without an instance.", &_init_f_startDetached_4354, &_call_f_startDetached_4354);
  methods += new qt_gsi::GenericStaticMethod ("startDetached", "@brief Static method bool QProcess::startDetached(const QString &command)\nThis method is static and can be called without an instance.", &_init_f_startDetached_2025, &_call_f_startDetached_2025);
  methods += new qt_gsi::GenericStaticMethod ("systemEnvironment", "@brief Static method QStringList QProcess::systemEnvironment()\nThis method is static and can be called without an instance.", &_init_f_systemEnvironment_0, &_call_f_systemEnvironment_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QProcess::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QProcess::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QIODevice> &qtdecl_QIODevice ();

qt_gsi::QtNativeClass<QProcess> decl_QProcess (qtdecl_QIODevice (), "QtCore", "QProcess",
  methods_QProcess (),
  "@qt\n@brief Binding of QProcess");


GSI_QTCORE_PUBLIC gsi::Class<QProcess> &qtdecl_QProcess () { return decl_QProcess; }

}


//  Implementation of the enum wrapper class for QProcess::ExitStatus
namespace qt_gsi
{

static gsi::Enum<QProcess::ExitStatus> decl_QProcess_ExitStatus_Enum ("QtCore", "QProcess_ExitStatus",
    gsi::enum_const ("NormalExit", QProcess::NormalExit, "@brief Enum constant QProcess::NormalExit") +
    gsi::enum_const ("CrashExit", QProcess::CrashExit, "@brief Enum constant QProcess::CrashExit"),
  "@qt\n@brief This class represents the QProcess::ExitStatus enum");

static gsi::QFlagsClass<QProcess::ExitStatus > decl_QProcess_ExitStatus_Enums ("QtCore", "QProcess_QFlags_ExitStatus",
  "@qt\n@brief This class represents the QFlags<QProcess::ExitStatus> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ExitStatus_Enum_in_parent (decl_QProcess_ExitStatus_Enum.defs ());
static gsi::ClassExt<QProcess> decl_QProcess_ExitStatus_Enum_as_child (decl_QProcess_ExitStatus_Enum, "ExitStatus");
static gsi::ClassExt<QProcess> decl_QProcess_ExitStatus_Enums_as_child (decl_QProcess_ExitStatus_Enums, "QFlags_ExitStatus");

}


//  Implementation of the enum wrapper class for QProcess::InputChannelMode
namespace qt_gsi
{

static gsi::Enum<QProcess::InputChannelMode> decl_QProcess_InputChannelMode_Enum ("QtCore", "QProcess_InputChannelMode",
    gsi::enum_const ("ManagedInputChannel", QProcess::ManagedInputChannel, "@brief Enum constant QProcess::ManagedInputChannel") +
    gsi::enum_const ("ForwardedInputChannel", QProcess::ForwardedInputChannel, "@brief Enum constant QProcess::ForwardedInputChannel"),
  "@qt\n@brief This class represents the QProcess::InputChannelMode enum");

static gsi::QFlagsClass<QProcess::InputChannelMode > decl_QProcess_InputChannelMode_Enums ("QtCore", "QProcess_QFlags_InputChannelMode",
  "@qt\n@brief This class represents the QFlags<QProcess::InputChannelMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_InputChannelMode_Enum_in_parent (decl_QProcess_InputChannelMode_Enum.defs ());
static gsi::ClassExt<QProcess> decl_QProcess_InputChannelMode_Enum_as_child (decl_QProcess_InputChannelMode_Enum, "InputChannelMode");
static gsi::ClassExt<QProcess> decl_QProcess_InputChannelMode_Enums_as_child (decl_QProcess_InputChannelMode_Enums, "QFlags_InputChannelMode");

}


//  Implementation of the enum wrapper class for QProcess::ProcessChannel
namespace qt_gsi
{

static gsi::Enum<QProcess::ProcessChannel> decl_QProcess_ProcessChannel_Enum ("QtCore", "QProcess_ProcessChannel",
    gsi::enum_const ("StandardOutput", QProcess::StandardOutput, "@brief Enum constant QProcess::StandardOutput") +
    gsi::enum_const ("StandardError", QProcess::StandardError, "@brief Enum constant QProcess::StandardError"),
  "@qt\n@brief This class represents the QProcess::ProcessChannel enum");

static gsi::QFlagsClass<QProcess::ProcessChannel > decl_QProcess_ProcessChannel_Enums ("QtCore", "QProcess_QFlags_ProcessChannel",
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessChannel> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessChannel_Enum_in_parent (decl_QProcess_ProcessChannel_Enum.defs ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessChannel_Enum_as_child (decl_QProcess_ProcessChannel_Enum, "ProcessChannel");
static gsi::ClassExt<QProcess> decl_QProcess_ProcessChannel_Enums_as_child (decl_QProcess_ProcessChannel_Enums, "QFlags_ProcessChannel");

}


//  Implementation of the enum wrapper class for QProcess::ProcessChannelMode
namespace qt_gsi
{

static gsi::Enum<QProcess::ProcessChannelMode> decl_QProcess_ProcessChannelMode_Enum ("QtCore", "QProcess_ProcessChannelMode",
    gsi::enum_const ("SeparateChannels", QProcess::SeparateChannels, "@brief Enum constant QProcess::SeparateChannels") +
    gsi::enum_const ("MergedChannels", QProcess::MergedChannels, "@brief Enum constant QProcess::MergedChannels") +
    gsi::enum_const ("ForwardedChannels", QProcess::ForwardedChannels, "@brief Enum constant QProcess::ForwardedChannels") +
    gsi::enum_const ("ForwardedOutputChannel", QProcess::ForwardedOutputChannel, "@brief Enum constant QProcess::ForwardedOutputChannel") +
    gsi::enum_const ("ForwardedErrorChannel", QProcess::ForwardedErrorChannel, "@brief Enum constant QProcess::ForwardedErrorChannel"),
  "@qt\n@brief This class represents the QProcess::ProcessChannelMode enum");

static gsi::QFlagsClass<QProcess::ProcessChannelMode > decl_QProcess_ProcessChannelMode_Enums ("QtCore", "QProcess_QFlags_ProcessChannelMode",
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessChannelMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessChannelMode_Enum_in_parent (decl_QProcess_ProcessChannelMode_Enum.defs ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessChannelMode_Enum_as_child (decl_QProcess_ProcessChannelMode_Enum, "ProcessChannelMode");
static gsi::ClassExt<QProcess> decl_QProcess_ProcessChannelMode_Enums_as_child (decl_QProcess_ProcessChannelMode_Enums, "QFlags_ProcessChannelMode");

}


//  Implementation of the enum wrapper class for QProcess::ProcessError
namespace qt_gsi
{

static gsi::Enum<QProcess::ProcessError> decl_QProcess_ProcessError_Enum ("QtCore", "QProcess_ProcessError",
    gsi::enum_const ("FailedToStart", QProcess::FailedToStart, "@brief Enum constant QProcess::FailedToStart") +
    gsi::enum_const ("Crashed", QProcess::Crashed, "@brief Enum constant QProcess::Crashed") +
    gsi::enum_const ("Timedout", QProcess::Timedout, "@brief Enum constant QProcess::Timedout") +
    gsi::enum_const ("ReadError", QProcess::ReadError, "@brief Enum constant QProcess::ReadError") +
    gsi::enum_const ("WriteError", QProcess::WriteError, "@brief Enum constant QProcess::WriteError") +
    gsi::enum_const ("UnknownError", QProcess::UnknownError, "@brief Enum constant QProcess::UnknownError"),
  "@qt\n@brief This class represents the QProcess::ProcessError enum");

static gsi::QFlagsClass<QProcess::ProcessError > decl_QProcess_ProcessError_Enums ("QtCore", "QProcess_QFlags_ProcessError",
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessError> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessError_Enum_in_parent (decl_QProcess_ProcessError_Enum.defs ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessError_Enum_as_child (decl_QProcess_ProcessError_Enum, "ProcessError");
static gsi::ClassExt<QProcess> decl_QProcess_ProcessError_Enums_as_child (decl_QProcess_ProcessError_Enums, "QFlags_ProcessError");

}


//  Implementation of the enum wrapper class for QProcess::ProcessState
namespace qt_gsi
{

static gsi::Enum<QProcess::ProcessState> decl_QProcess_ProcessState_Enum ("QtCore", "QProcess_ProcessState",
    gsi::enum_const ("NotRunning", QProcess::NotRunning, "@brief Enum constant QProcess::NotRunning") +
    gsi::enum_const ("Starting", QProcess::Starting, "@brief Enum constant QProcess::Starting") +
    gsi::enum_const ("Running", QProcess::Running, "@brief Enum constant QProcess::Running"),
  "@qt\n@brief This class represents the QProcess::ProcessState enum");

static gsi::QFlagsClass<QProcess::ProcessState > decl_QProcess_ProcessState_Enums ("QtCore", "QProcess_QFlags_ProcessState",
  "@qt\n@brief This class represents the QFlags<QProcess::ProcessState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QProcess> inject_QProcess_ProcessState_Enum_in_parent (decl_QProcess_ProcessState_Enum.defs ());
static gsi::ClassExt<QProcess> decl_QProcess_ProcessState_Enum_as_child (decl_QProcess_ProcessState_Enum, "ProcessState");
static gsi::ClassExt<QProcess> decl_QProcess_ProcessState_Enums_as_child (decl_QProcess_ProcessState_Enums, "QFlags_ProcessState");

}

