// $Id: gc_parse_pop.h,v 1.7 2018/01/03 21:32:56 mkkuhner Exp $

/*
Copyright 2002-2005 Mary K. Kuhner, Peter Beerli, and Joseph Felsenstein

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

/* Authors: Mary Kuhner, Jon Yamato, and Joseph Felsenstein */


#ifndef GC_PARSE_POP_H
#define GC_PARSE_POP_H

#include "wx/string.h"

class GCParse;

class GCParsePop
{
  private:
    GCParsePop();           // undefined

    const GCParse *         m_parse;
    const size_t            m_indexInParse;
    const wxString          m_name;
  public:
    GCParsePop(const GCParse * parse, size_t indexInParse, wxString name);
    ~GCParsePop();

    const GCParse & GetParse()          const;
    size_t          GetIndexInParse()   const;
    wxString        GetName()           const;
};

#endif  // GC_PARSE_POP_H

//____________________________________________________________________________________
