/***********************************************************************************

    Copyright (C) 2007-2019 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include <cairomm/surface.h>

#include "chart_surface.hpp"


using namespace LIFEO;


// WIDGETCHART =====================================================================================
ChartSurface::ChartSurface( ChartElem* chart_elem, int w )
{
    m_hovered_step = -1;
    m_surface = Cairo::ImageSurface::create( Cairo::FORMAT_RGB24, w, w*WH_RATIO );
    auto cr = Cairo::Context::create( m_surface );

    set_diary( chart_elem->get_diary() );
    m_data.set_from_string( chart_elem->get_definition() );
    calculate_points();

    resize( w, w*WH_RATIO );

    Chart::draw( cr );
}
