/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETCHART_HEADER
#define LIFEOGRAPH_WIDGETCHART_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "../helpers.hpp"
#include "chart.hpp"
#include "widget_entrypicker.hpp"
#include "widget_picker.hpp"


namespace LIFEO
{

using namespace HELPERS;


class WidgetChart : public Gtk::DrawingArea, public Chart
{
    public:
        WidgetChart();
        ~WidgetChart() {}

        Gtk::Widget*                get_widget()
        { return m_Ol_chart; }

        void                        set_diary( Diary* diary );

        void                        refresh_editabilitiy()
        { m_Po_properties->set_sensitive( m_p2diary->is_in_edit_mode() ); }

        void                        refresh() override
        {
            if( Glib::RefPtr< Gdk::Window > window = get_window() )
                window->invalidate( false );
        }

        void                        handle_y_axis_changed();
        void                        handle_tag_changed( Entry* );
        void                        handle_para_filter_tag_changed( Entry* );
        void                        handle_value_type_changed();
        void                        handle_filter_changed( const Ustring& );
        void                        handle_tagged_only_toggled();
        void                        handle_period_changed();
        void                        handle_underlay_previous_toggled();
        void                        handle_underlay_planned_toggled();
        void                        calculate_and_plot( bool = true );
        void                        update_child_widgets_per_data();

        std::string                 get_as_string();
        void                        set_from_string( const Ustring& );

        SignalVoid                  signal_changed()
        { return m_Sg_changed; }

    protected:
        void                        on_size_allocate( Gtk::Allocation& ) override;
        bool                        on_scroll_event( GdkEventScroll* ) override;
        bool                        on_button_press_event( GdkEventButton* ) override;
        bool                        on_button_release_event( GdkEventButton* ) override;
        bool                        on_motion_notify_event( GdkEventMotion* ) override;
        bool                        on_leave_notify_event( GdkEventCrossing* ) override;
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& ) override;

        Glib::RefPtr< Gtk::Builder >
                                    m_builder;

        Gtk::Overlay*               m_Ol_chart;
        Gtk::Revealer*              m_Rv_settings;
        Gtk::Popover*               m_Po_properties;
        Gtk::Scale*                 m_Sc_zoom;
        Gtk::ComboBoxText*          m_CB_value_type;
        Gtk::ComboBoxText*          m_CB_y_axis;
        Gtk::Box*                   m_Bx_tag_params;
        WidgetEntryPicker*          m_WEP_y_tag;
        WidgetEntryPicker*          m_WEP_para_filter_tag;
        WidgetPicker< Filter >*     m_W_picker_filter;
        Gtk::RadioButton*           m_RB_weekly;
        Gtk::RadioButton*           m_RB_monthly;
        Gtk::RadioButton*           m_RB_yearly;
        Gtk::ModelButton*           m_B_tagged_only;
        Gtk::Box*                   m_Bx_underlay;
        Gtk::CheckButton*           m_ChB_underlay_previous;
        Gtk::CheckButton*           m_ChB_underlay_planned;

        Action                      m_A_tagged_only;

        SignalVoid                  m_Sg_changed;
};

} // end of namespace LIFEO

#endif
