/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.lisaac.ldt.model.ILisaacModel;
import org.lisaac.ldt.model.LisaacCompletionParser;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.Section;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.model.types.ITypeMono;
import org.lisaac.ldt.model.types.TypeParameter;
import org.lisaac.ldt.outline.OutlineItem;
import org.lisaac.ldt.outline.OutlinePrototype;
import org.lisaac.ldt.outline.OutlineSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prototype {
    protected IFile file;
    protected ILisaacModel parent;
    protected LisaacParser parser;
    protected String name;
    protected String typeStyle;
    protected HashMap<String, Slot> parentList;
    protected HashMap<String, Slot> slotList;
    protected TypeParameter[] genericList;
    protected String headerData;
    protected String headerComment;
    protected Section firstSection;
    protected int nameOffset;
    protected Position authorOffset;
    protected Position bibliographyOffset;
    protected Position copyrightOffset;

    public Prototype(IFile file, String name, ILisaacModel model) {
        this.file = file;
        this.name = name;
        this.parent = model;
        this.parser = model.getParser();
        this.slotList = new HashMap();
        this.parentList = new HashMap();
    }

    public ILisaacModel getModel() {
        return this.parent;
    }

    public boolean setName(String n) {
        if (this.name != null && this.name.equals(n)) {
            return false;
        }
        this.name = n;
        return true;
    }

    public IFile getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getName() {
        return this.name;
    }

    public int getGenericIndex(TypeParameter param) {
        if (this.genericList != null) {
            int i = 0;
            while (i < this.genericList.length) {
                if (this.genericList[i].equals(param)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void setGenericList(TypeParameter[] list) {
        this.genericList = list;
    }

    public void setHeaderComment(String comment) {
        this.headerComment = comment;
    }

    public void addHeaderData(String slotName, String data, Position position) {
        String info = "\n<g>" + slotName + "</g> " + data;
        this.headerData = this.headerData == null ? info : String.valueOf(this.headerData) + info;
        if (slotName.equals("author")) {
            this.authorOffset = position;
        } else if (slotName.equals("bibliography")) {
            this.bibliographyOffset = position;
        } else if (slotName.equals("copyright")) {
            this.copyrightOffset = position;
        }
    }

    public LisaacParser openParser() {
        this.parser.initialize();
        return this.parser;
    }

    public void setTypeStyle(String s) {
        this.typeStyle = s;
    }

    public String getTypeStyle() {
        return this.typeStyle;
    }

    public Section getFirstSection() {
        return this.firstSection;
    }

    public void setFirstSection(Section s) {
        this.firstSection = s;
    }

    public boolean isExpanded() {
        if (this.typeStyle != null) {
            return this.typeStyle.equals("Expanded") || this.name.equals("TRUE") || this.name.equals("FALSE");
        }
        return false;
    }

    public Slot lookupSlot(String n) {
        Slot result = null;
        result = this.getSlot(n);
        if (result == null) {
            result = this.getParentSlot(n);
        }
        if (result == null) {
            Collection<Slot> values = this.parentList.values();
            for (Slot slotParent : values) {
                IType typeParent = slotParent.getResultType();
                try {
                    Prototype parent = LisaacCompletionParser.findPrototype("" + typeParent);
                    if (parent == null || (result = parent.lookupSlot(n)) == null) continue;
                    return result;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
        }
        return result;
    }

    public Slot getSlot(String n) {
        if (this.slotList.containsKey(n)) {
            return this.slotList.get(n);
        }
        return null;
    }

    public Slot getParentSlot(String n) {
        if (this.parentList.containsKey(n)) {
            return this.parentList.get(n);
        }
        return null;
    }

    public Slot getSlot(int offset) {
        return this.getSlot(this.openParser(), offset);
    }

    public Slot getSlot(String s, int offset) {
        return this.getSlot(new LisaacParser(null, s), offset);
    }

    public Slot getSlot(LisaacParser parser, int offset) {
        boolean again;
        String source = parser.getSource();
        if (offset >= source.length() - 1) {
            return null;
        }
        do {
            again = false;
            while (offset > 0 && source.charAt(offset) != '\n') {
                --offset;
            }
            if (offset <= 0 || source.length() <= 4) continue;
            if (source.charAt(offset + 1) == ' ' && source.charAt(offset + 2) == ' ' && (source.charAt(offset + 3) == '+' || source.charAt(offset + 3) == '-')) {
                String slotName = parser.readSlotNameFromOffset(offset + 4, false);
                if (slotName == null) continue;
                return this.getSlot(slotName);
            }
            again = true;
            --offset;
        } while (again);
        return null;
    }

    public void lookupSlotMatch(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        this.getSlotMatch(n, matchList, offset, length);
        this.getParentSlotMatch(n, matchList, offset, length);
        Collection<Slot> values = this.parentList.values();
        for (Slot slotParent : values) {
            IType typeParent = slotParent.getResultType();
            try {
                Prototype parent = LisaacCompletionParser.findPrototype("" + typeParent);
                if (parent == null) continue;
                parent.lookupSlotMatch(n, matchList, offset, length);
            }
            catch (CoreException coreException) {}
        }
    }

    public void getSlotMatch(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        Collection<Slot> values = this.slotList.values();
        for (Slot slot : values) {
            if (!slot.match(n)) continue;
            slot.getSlotMatchProposals(matchList, offset, length, n.length());
        }
    }

    public void getParentSlotMatch(String n, ArrayList<ICompletionProposal> matchList, int offset, int length) {
        Collection<Slot> values = this.parentList.values();
        for (Slot slot : values) {
            if (!slot.match(n)) continue;
            slot.getSlotMatchProposals(matchList, offset, length, n.length());
        }
    }

    public Slot getSlotFromKeyword(String keyword, LisaacParser parser, int baseOffset) throws CoreException {
        String source = parser.getSource();
        int bracketLevel = 0;
        int invBracketLevel = 0;
        Prototype receiver = null;
        Slot result = null;
        char c = '\u0000';
        int offset = baseOffset;
        if (offset >= source.length() - 1) {
            return null;
        }
        parser.enableErrorReport(false);
        while (offset > 0) {
            c = source.charAt(offset);
            if (c == '\n') {
                offset = this.unreadSingleLineComment(offset, source);
                continue;
            }
            if (c == '(' || c == '{' || c == '[') {
                if (bracketLevel == 0) break;
                --bracketLevel;
                ++invBracketLevel;
            }
            if (c == ')' || c == '}' || c == ']') {
                ++bracketLevel;
                --invBracketLevel;
            }
            if (c == '\"' || c == '\'' || c == '`') {
                offset = this.unreadString(c, offset, source);
                continue;
            }
            if (bracketLevel == 0 && invBracketLevel == 0) {
                if (c == ';' || c == '.' || (c != '=' || source.length() - offset <= 2 ? c == '-' && source.length() - offset > 2 && source.charAt(offset - 1) == '<' : source.charAt(offset - 1) == ':' || source.charAt(offset - 1) == '?')) break;
                if (LisaacParser.isOperatorSymbol(c)) {
                    if ((c == '+' || c == '-') && offset - 3 > 0 && source.charAt(offset - 1) == ' ' && source.charAt(offset - 2) == ' ' && source.charAt(offset - 3) == '\n') {
                        String slotName = parser.readSlotNameFromOffset(offset + 1, false);
                        parser.enableErrorReport(true);
                        if (slotName != null) {
                            result = this.lookupSlot(slotName);
                            if (result == null) {
                                return null;
                            }
                            if (result.keywordCount() == 1) {
                                if (result.getName().compareTo(keyword) == 0) {
                                    return result;
                                }
                                return null;
                            }
                            offset = baseOffset;
                            while (offset < source.length() - 1 && Character.isJavaIdentifierPart(source.charAt(offset))) {
                                ++offset;
                            }
                            while (offset < source.length() - 1 && Character.isWhitespace(source.charAt(offset))) {
                                ++offset;
                            }
                            if (source.charAt(offset) != ':') {
                                return result;
                            }
                            return null;
                        }
                    }
                    if (offset - 1 <= 0 || c != '/' || source.charAt(offset - 1) != '*') break;
                    offset = this.unreadMultiLineComment(offset, source);
                    continue;
                }
            }
            --offset;
        }
        if (result == null) {
            if (c == '.') {
                int pointOffset = offset--;
                bracketLevel = 0;
                invBracketLevel = 0;
                while (offset > 0) {
                    c = source.charAt(offset);
                    if (c == '(' || c == '{' || c == '[') {
                        if (bracketLevel == 0) break;
                        --bracketLevel;
                        ++invBracketLevel;
                    }
                    if (c == ')' || c == '}' || c == ']') {
                        ++bracketLevel;
                        --invBracketLevel;
                    }
                    if (bracketLevel == 0 && invBracketLevel == 0) {
                        if (c == ';' || (c != '=' || source.length() - offset <= 2 ? c == '-' && source.length() - offset > 2 && source.charAt(offset - 1) == '<' : source.charAt(offset - 1) == ':' || source.charAt(offset - 1) == '?')) break;
                        if (LisaacParser.isOperatorSymbol(c)) break;
                        if (c == '\"' || c == '\'' || c == '`') {
                            offset = this.unreadString(c, offset, source);
                            continue;
                        }
                    }
                    --offset;
                }
                if (offset > 0) {
                    LisaacCompletionParser p = new LisaacCompletionParser(source, (LisaacModel)this.getModel());
                    receiver = p.readReceiver(offset + 1, pointOffset, this);
                    offset = pointOffset;
                }
            } else {
                receiver = this;
            }
            parser.setPosition(offset + 1);
            parser.readSpace();
            String slotName = parser.readKeywordInSendMsg(keyword, baseOffset);
            if (slotName != null && receiver != null) {
                result = receiver.lookupSlot(slotName);
            }
        }
        parser.enableErrorReport(true);
        return result;
    }

    private int unreadSingleLineComment(int offset, String source) {
        int saveOffset = --offset;
        while (offset > 0) {
            char c = source.charAt(offset);
            if (c == '\n') {
                return saveOffset;
            }
            if (offset - 1 > 0 && c == '/' && source.charAt(offset - 1) == '/') {
                offset -= 2;
                break;
            }
            if (c == '\"' || c == '\'' || c == '`') {
                offset = this.unreadString(c, offset, source);
                continue;
            }
            --offset;
        }
        if (offset < 0) {
            offset = 0;
        }
        return offset;
    }

    private int unreadMultiLineComment(int offset, String source) {
        offset -= 2;
        while (offset > 0) {
            char c = source.charAt(offset);
            if (offset - 1 > 0 && c == '*' && source.charAt(offset - 1) == '/') {
                offset -= 2;
                break;
            }
            --offset;
        }
        if (offset < 0) {
            offset = 0;
        }
        return offset;
    }

    private int unreadString(char type, int offset, String source) {
        char c;
        do {
            c = source.charAt(--offset);
        } while (offset > 0 && c != type);
        if (c == type) {
            --offset;
        }
        return offset;
    }

    public void addSlot(Slot s) {
        this.slotList.put(s.getName(), s);
    }

    public void addParentSlot(Slot s) {
        this.parentList.put(s.getName(), s);
    }

    public String getHoverInformation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<b>");
        buffer.append(this.name);
        buffer.append("</b>");
        if (this.headerComment != null) {
            buffer.append("\n" + this.headerComment);
        }
        if (this.headerData != null) {
            buffer.append("\n\n" + this.headerData);
        }
        return buffer.toString();
    }

    public List<OutlineItem> getOutlineItems() {
        ArrayList<OutlineItem> sections = new ArrayList<OutlineItem>();
        Section current = this.firstSection;
        while (current != null) {
            sections.add(new OutlineSection(current));
            current = current.getNext();
        }
        ArrayList<OutlineItem> result = new ArrayList<OutlineItem>();
        result.add(new OutlinePrototype(this, sections));
        return result;
    }

    public void getSlotProposals(ArrayList<ICompletionProposal> proposals, int offset, int length) {
        Collection<Slot> values = this.slotList.values();
        for (Slot slot : values) {
            slot.getSlotProposals(proposals, offset, length);
        }
        values = this.parentList.values();
        for (Slot slotParent : values) {
            IType typeParent = slotParent.getResultType();
            try {
                Prototype parent = LisaacCompletionParser.findPrototype("" + typeParent);
                if (parent == null) continue;
                parent.getSlotProposals(proposals, offset, length);
            }
            catch (CoreException coreException) {}
        }
    }

    public ArrayList<org.eclipse.jface.text.Position> getPositions() {
        ArrayList<org.eclipse.jface.text.Position> result = new ArrayList<org.eclipse.jface.text.Position>();
        Section current = this.firstSection;
        while (current != null) {
            Position p = current.getPosition();
            result.add(new org.eclipse.jface.text.Position(p.offset, p.length));
            current = current.getNext();
        }
        Collection<Slot> values = this.slotList.values();
        for (Slot slot : values) {
            Position p = slot.getPositionBody();
            if (p == null) continue;
            result.add(new org.eclipse.jface.text.Position(p.offset, p.length));
        }
        return result;
    }

    public IPath getWorkspacePath() {
        return this.file.getFullPath();
    }

    public Change refactorRenameSelf(String newName) {
        TextFileChange change = new TextFileChange("Change 'name' slot in section header", this.file);
        MultiTextEdit edit = new MultiTextEdit();
        edit.addChild((TextEdit)new DeleteEdit(this.nameOffset, this.name.length()));
        edit.addChild((TextEdit)new InsertEdit(this.nameOffset, newName));
        change.setEdit((TextEdit)edit);
        return change;
    }

    public Change refactorRenamePrototype(String oldName, String newName) {
        MultiTextEdit edit = new MultiTextEdit();
        Section current = this.firstSection;
        while (current != null) {
            Position p = current.getPosition();
            ITypeMono[] typeList = current.getTypeList();
            if (typeList != null) {
                int i = 0;
                while (i < typeList.length) {
                    if (typeList[i].toString().compareTo(oldName) == 0) {
                        typeList[i].rename(oldName, newName);
                        edit.addChild((TextEdit)new DeleteEdit(p.offset + 1, p.length - 1));
                        edit.addChild((TextEdit)new InsertEdit(p.offset + 1, String.valueOf(current.getName()) + "\n\n  "));
                        typeList[i].rename(newName, oldName);
                    }
                    ++i;
                }
            }
            current = current.getNext();
        }
        Collection<Slot> values = this.slotList.values();
        for (Slot slot : values) {
            TextEdit[] slotEdits = slot.refactorRenamePrototype(oldName, newName);
            if (slotEdits == null) continue;
            edit.addChildren(slotEdits);
        }
        if (edit.getChildrenSize() > 0) {
            TextFileChange change = new TextFileChange("Rename prototype occurences", this.file);
            change.setEdit((TextEdit)edit);
            return change;
        }
        return null;
    }

    public Change refactorHeader(String author, String bibliography, String copyright, String license) {
        MultiTextEdit edit = new MultiTextEdit();
        this.refactorHeaderSlot("author", this.authorOffset, author, edit);
        this.refactorHeaderSlot("bibliography", this.bibliographyOffset, bibliography, edit);
        this.refactorHeaderSlot("copyright", this.copyrightOffset, copyright, edit);
        if (license != null) {
            int offset = this.getOffsetBeforeSection();
            edit.addChild((TextEdit)new DeleteEdit(0, offset - 1));
            edit.addChild((TextEdit)new InsertEdit(0, license));
        }
        if (edit.getChildrenSize() > 0) {
            TextFileChange change = new TextFileChange("Update Section Header", this.file);
            change.setEdit((TextEdit)edit);
            return change;
        }
        return null;
    }

    private void refactorHeaderSlot(String name, Position pos, String newValue, MultiTextEdit edit) {
        if (newValue != null) {
            if (pos != null) {
                edit.addChild((TextEdit)new DeleteEdit(pos.offset, pos.length));
                edit.addChild((TextEdit)new InsertEdit(pos.offset, "\"" + newValue + "\""));
            } else {
                String slot = "\n  - " + name + " := \"" + newValue + "\";";
                edit.addChild((TextEdit)new InsertEdit(this.getOffsetAfterName(), slot));
            }
        }
    }

    private int getOffsetAfterName() {
        LisaacParser parser = this.openParser();
        parser.setPosition(this.nameOffset);
        parser.readCapIdentifier();
        parser.readCharacter(';');
        return parser.getOffset();
    }

    private int getOffsetBeforeSection() {
        LisaacParser parser = this.openParser();
        parser.setPosition(0);
        if (parser.readThisKeyword("Section")) {
            return parser.getOffset() - 7;
        }
        return 0;
    }

    public void setNameOffset(int offset) {
        this.nameOffset = offset;
    }

    public void setAuthorOffset(Position p) {
        this.authorOffset = p;
    }

    public void setBibliographyOffset(Position p) {
        this.bibliographyOffset = p;
    }

    public void setCopyrightOffset(Position p) {
        this.copyrightOffset = p;
    }

    public IRegion getRegionAt(int line, int column) {
        LisaacParser parser = this.openParser();
        parser.readTokenAt(line, column);
        return new Region(parser.getOffset(), parser.getLastString().length());
    }
}

