// interface.h
// LiVES
// (c) G. Finch 2003 - 2018 <salsaman+lives@gmail.com>
// Released under the GNU GPL 3 or later
// see file ../COPYING for licensing details

#ifndef HAS_LIVES_INTERFACE_H
#define HAS_LIVES_INTERFACE_H

// CE timeline bars
#define OVERDRAW_MARGIN 16

/// clip editor hrule height
#define CE_HRULE_HEIGHT ((int)(20. * widget_opts.scale))

/// clip edit vid/aud bar height
#define CE_VIDBAR_HEIGHT ((int)(4. * widget_opts.scale))

/// clip edit vid/aud bar height
#define CE_AUDBAR_HEIGHT ((int)(16. * widget_opts.scale))

#define MSG_AREA_VMARGIN 10
#define LAYOUT_SIZE_MIN 32

void draw_little_bars(double ptrtime, int which);
double lives_ce_update_timeline(int frame, double x);  ///< pointer position in timeline
void update_timer_bars(int posx, int posy, int width, int height, int which); ///< draw the timer bars
void redraw_timer_bars(double oldx, double newx, int which); ///< paint a damage region
void show_playbar_labels(int clipno);

void msg_area_scroll(LiVESAdjustment *, livespointer userdata);
void msg_area_scroll_to_end(LiVESWidget *, LiVESAdjustment *);
boolean on_msg_area_scroll(LiVESWidget *, LiVESXEventScroll *, livespointer user_data);

EXPOSE_FN_PROTOTYPE(expose_msg_area);

LiVESWidget *create_info_error_dialog(lives_dialog_t info_type, const char *text, LiVESWindow *transient, int mask, boolean is_blocking);
LiVESWidget *create_opensel_dialog(void);
LiVESWidget *create_encoder_prep_dialog(const char *text1, const char *text2, boolean opt_resize);

void widget_add_preview(LiVESWidget *widget, LiVESBox *for_preview, LiVESBox *for_button,
                        LiVESBox *for_deinterlace, int preview_type);  ///< for fileselector preview

boolean do_audio_choice_dialog(short startup_phase);

boolean do_layout_recover_dialog(void);

void do_keys_window(void);

void do_mt_keys_window(void);

LiVESWidget *create_cleardisk_advanced_dialog(void);

LiVESWidget *make_autoreload_check(LiVESHBox *parent, boolean is_active);

typedef struct {
  LiVESWidget *dialog;
  LiVESWidget *textview_type;
  LiVESWidget *textview_fps;
  LiVESWidget *textview_size;
  LiVESWidget *textview_frames;
  LiVESWidget *textview_vtime;
  LiVESWidget *textview_fsize;
  LiVESWidget *textview_ltime;
  LiVESWidget *textview_rtime;
  LiVESWidget *textview_lrate;
  LiVESWidget *textview_rrate;
} lives_clipinfo_t;

lives_clipinfo_t *create_clip_info_window(int audio_channels, boolean is_mt);

typedef struct {
  LiVESWidget *dialog;
  LiVESWidget *entry;
  LiVESWidget *dir_entry;
  LiVESWidget *name_entry;
  LiVESWidget *warn_checkbutton;
  LiVESList *setlist;
} _entryw;

_entryw *create_rename_dialog(int type);
_entryw *create_location_dialog(void);
_entryw *create_cds_dialog(int type);

typedef struct __insertw {
  LiVESWidget *insert_dialog;
  LiVESWidget *with_sound;
  LiVESWidget *without_sound;
  LiVESWidget *spinbutton_times;
  LiVESWidget *fit_checkbutton;
} _insertw;

_insertw *create_insert_dialog(void);

typedef struct __commentsw {
  LiVESWidget *comments_dialog;
  LiVESWidget *title_entry;
  LiVESWidget *author_entry;
  LiVESWidget *comment_entry;
  LiVESWidget *subt_checkbutton;
  LiVESWidget *subt_entry;
} _commentsw;

_commentsw *create_comments_dialog(lives_clip_t *sfile, char *filename);

typedef struct {
  LiVESWidget *dialog;
  LiVESWidget *clear_button;
  LiVESWidget *delete_button;
  LiVESWidget *textview;
  LiVESWidget *table;
} text_window;

text_window *create_text_window(const char *title_part, const char *text, LiVESTextBuffer *);

typedef struct {
  LiVESWidget *dialog;
  LiVESWidget *time_spin;
  boolean is_sel;
} aud_dialog_t;

typedef struct {
  boolean use_advanced;
  LiVESWidget *advbutton;
  LiVESWidget *adv_vbox;
  LiVESWidget *combod;
  LiVESWidget *comboo;
  LiVESWidget *spinbuttoni;
  LiVESWidget *spinbuttonw;
  LiVESWidget *spinbuttonh;
  LiVESWidget *spinbuttonf;
  LiVESWidget *radiobuttond;
} lives_tvcardw_t;

#define LIVES_PREVIEW_TYPE_VIDEO_AUDIO 1
#define LIVES_PREVIEW_TYPE_AUDIO_ONLY 2
#define LIVES_PREVIEW_TYPE_RANGE 3
#define LIVES_PREVIEW_TYPE_IMAGE_ONLY 4

#define LIVES_FILE_SELECTION_UNDEFINED 0
#define LIVES_FILE_SELECTION_VIDEO_AUDIO 1
#define LIVES_FILE_SELECTION_AUDIO_ONLY 2
#define LIVES_FILE_SELECTION_VIDEO_AUDIO_MULTI 3
#define LIVES_FILE_SELECTION_VIDEO_RANGE 4
#define LIVES_FILE_SELECTION_IMAGE_ONLY 5
#define LIVES_FILE_SELECTION_SAVE 6

aud_dialog_t *create_audfade_dialog(int type);
LiVESWidget *create_combo_dialog(int type, LiVESList *list);

xprocess *create_processing(const char *text);
xprocess *create_threaded_dialog(char *text, boolean has_cancel, boolean *td_had_focus);
void add_to_clipmenu(void);
void remove_from_clipmenu(void);
void make_play_window(void);
void resize_play_window(void);
void kill_play_window(void);
void make_preview_box(void);
void play_window_set_title(void);
void add_to_playframe(void);
LiVESWidget *create_cdtrack_dialog(int type, livespointer user_data);

typedef struct {
  LiVESWidget *dialog;
  LiVESWidget *atrigger_button;
  LiVESWidget *atrigger_spin;
  LiVESWidget *apb_button;
  LiVESWidget *mute_button;
  LiVESWidget *debug_button;
} autolives_window;

autolives_window *autolives_pre_dialog(void);

LiVESTextView *create_output_textview(void);
char *choose_file(const char *dir, const char *fname, char **const filt, LiVESFileChooserAction act, const char *title, LiVESWidget *extra);
LiVESWidget *choose_file_with_preview(const char *dir, const char *title, char **const filt, int preview_type);
void add_suffix_check(LiVESBox *box, const char *ext);

const lives_special_aspect_t *add_aspect_ratio_button(LiVESSpinButton *sp_width, LiVESSpinButton *sp_height, LiVESBox *container);

_commentsw *commentsw;
_entryw *renamew;
_entryw *locw;
_insertw *insertw;
text_window *textwindow;

#define DEF_AUD_FADE_SECS 10. ///< default time to offer fade audio in/out for

#define MIN_MSGBOX_WIDTH ((int)(620. * widget_opts.scale))

// textboxes for clip info
#define TB_WIDTH ((int)(200.*widget_opts.scale))
#define TB_HEIGHT_VID ((int)(80.*widget_opts.scale))
#define TB_HEIGHT_AUD ((int)(50.*widget_opts.scale))

typedef enum {
  LIVES_MATCH_UNDEFINED = 0,
  LIVES_MATCH_NEAREST,
  LIVES_MATCH_AT_LEAST,
  LIVES_MATCH_AT_MOST,
  LIVES_MATCH_HIGHEST,
  LIVES_MATCH_LOWEST,
  LIVES_MATCH_CHOICE,
  LIVES_MATCH_SPECIFIED
} lives_size_match_t;

typedef struct {
  char URI[8192];
  char save_dir[PATH_MAX];
  char fname[PATH_MAX];
  char format[256];
  int desired_width;
  int desired_height;
  float desired_fps;  // unused for now
  lives_size_match_t matchsize;
  boolean do_update;
  char vidchoice[512];
  char audchoice[512];

  // TODO: add audio bitrate ?, audio_lang, get_sub, sub_format, sub_language, etc.

} lives_remote_clip_request_t;

lives_remote_clip_request_t *run_youtube_dialog(void);
boolean youtube_select_format(lives_remote_clip_request_t *);

#endif
