; RUN: llc -march=hexagon < %s | FileCheck %s

; Check the individual vshuff shuffles for all 128 controls.

; This is an identity shuffle: there should not be any shuffling code emitted.
; CHECK-LABEL: vshuff_00:
; CHECK-NOT: vshuff(
define <256 x i8> @vshuff_00(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_01:
; CHECK: [[REG01:r[0-9]+]] = #1
; CHECK: vshuff(v1,v0,[[REG01]])
define <256 x i8> @vshuff_01(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_02:
; CHECK: [[REG02:r[0-9]+]] = #2
; CHECK: vshuff(v1,v0,[[REG02]])
define <256 x i8> @vshuff_02(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_03:
; CHECK: [[REG03:r[0-9]+]] = #3
; CHECK: vshuff(v1,v0,[[REG03]])
define <256 x i8> @vshuff_03(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_04:
; CHECK: [[REG04:r[0-9]+]] = #4
; CHECK: vshuff(v1,v0,[[REG04]])
define <256 x i8> @vshuff_04(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_05:
; CHECK: [[REG05:r[0-9]+]] = #5
; CHECK: vshuff(v1,v0,[[REG05]])
define <256 x i8> @vshuff_05(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_06:
; CHECK: [[REG06:r[0-9]+]] = #6
; CHECK: vshuff(v1,v0,[[REG06]])
define <256 x i8> @vshuff_06(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_07:
; CHECK: [[REG07:r[0-9]+]] = #7
; CHECK: vshuff(v1,v0,[[REG07]])
define <256 x i8> @vshuff_07(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_08:
; CHECK: [[REG08:r[0-9]+]] = #8
; CHECK: vshuff(v1,v0,[[REG08]])
define <256 x i8> @vshuff_08(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_09:
; CHECK: [[REG09:r[0-9]+]] = #9
; CHECK: vshuff(v1,v0,[[REG09]])
define <256 x i8> @vshuff_09(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_0a:
; CHECK: [[REG0a:r[0-9]+]] = #10
; CHECK: vshuff(v1,v0,[[REG0a]])
define <256 x i8> @vshuff_0a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_0b:
; CHECK: [[REG0b:r[0-9]+]] = #11
; CHECK: vshuff(v1,v0,[[REG0b]])
define <256 x i8> @vshuff_0b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_0c:
; CHECK: [[REG0c:r[0-9]+]] = #12
; CHECK: vshuff(v1,v0,[[REG0c]])
define <256 x i8> @vshuff_0c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_0d:
; CHECK: [[REG0d:r[0-9]+]] = #13
; CHECK: vshuff(v1,v0,[[REG0d]])
define <256 x i8> @vshuff_0d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_0e:
; CHECK: [[REG0e:r[0-9]+]] = #14
; CHECK: vshuff(v1,v0,[[REG0e]])
define <256 x i8> @vshuff_0e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_0f:
; CHECK: [[REG0f:r[0-9]+]] = #15
; CHECK: vshuff(v1,v0,[[REG0f]])
define <256 x i8> @vshuff_0f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_10:
; CHECK: [[REG10:r[0-9]+]] = #16
; CHECK: vshuff(v1,v0,[[REG10]])
define <256 x i8> @vshuff_10(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_11:
; CHECK: [[REG11:r[0-9]+]] = #17
; CHECK: vshuff(v1,v0,[[REG11]])
define <256 x i8> @vshuff_11(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_12:
; CHECK: [[REG12:r[0-9]+]] = #18
; CHECK: vshuff(v1,v0,[[REG12]])
define <256 x i8> @vshuff_12(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_13:
; CHECK: [[REG13:r[0-9]+]] = #19
; CHECK: vshuff(v1,v0,[[REG13]])
define <256 x i8> @vshuff_13(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_14:
; CHECK: [[REG14:r[0-9]+]] = #20
; CHECK: vshuff(v1,v0,[[REG14]])
define <256 x i8> @vshuff_14(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_15:
; CHECK: [[REG15:r[0-9]+]] = #21
; CHECK: vshuff(v1,v0,[[REG15]])
define <256 x i8> @vshuff_15(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_16:
; CHECK: [[REG16:r[0-9]+]] = #22
; CHECK: vshuff(v1,v0,[[REG16]])
define <256 x i8> @vshuff_16(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_17:
; CHECK: [[REG17:r[0-9]+]] = #23
; CHECK: vshuff(v1,v0,[[REG17]])
define <256 x i8> @vshuff_17(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_18:
; CHECK: [[REG18:r[0-9]+]] = #24
; CHECK: vshuff(v1,v0,[[REG18]])
define <256 x i8> @vshuff_18(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_19:
; CHECK: [[REG19:r[0-9]+]] = #25
; CHECK: vshuff(v1,v0,[[REG19]])
define <256 x i8> @vshuff_19(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_1a:
; CHECK: [[REG1a:r[0-9]+]] = #26
; CHECK: vshuff(v1,v0,[[REG1a]])
define <256 x i8> @vshuff_1a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_1b:
; CHECK: [[REG1b:r[0-9]+]] = #27
; CHECK: vshuff(v1,v0,[[REG1b]])
define <256 x i8> @vshuff_1b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_1c:
; CHECK: [[REG1c:r[0-9]+]] = #28
; CHECK: vshuff(v1,v0,[[REG1c]])
define <256 x i8> @vshuff_1c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_1d:
; CHECK: [[REG1d:r[0-9]+]] = #29
; CHECK: vshuff(v1,v0,[[REG1d]])
define <256 x i8> @vshuff_1d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_1e:
; CHECK: [[REG1e:r[0-9]+]] = #30
; CHECK: vshuff(v1,v0,[[REG1e]])
define <256 x i8> @vshuff_1e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_1f:
; CHECK: [[REG1f:r[0-9]+]] = #31
; CHECK: vshuff(v1,v0,[[REG1f]])
define <256 x i8> @vshuff_1f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_20:
; CHECK: [[REG20:r[0-9]+]] = #32
; CHECK: vshuff(v1,v0,[[REG20]])
define <256 x i8> @vshuff_20(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_21:
; CHECK: [[REG21:r[0-9]+]] = #33
; CHECK: vshuff(v1,v0,[[REG21]])
define <256 x i8> @vshuff_21(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_22:
; CHECK: [[REG22:r[0-9]+]] = #34
; CHECK: vshuff(v1,v0,[[REG22]])
define <256 x i8> @vshuff_22(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_23:
; CHECK: [[REG23:r[0-9]+]] = #35
; CHECK: vshuff(v1,v0,[[REG23]])
define <256 x i8> @vshuff_23(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_24:
; CHECK: [[REG24:r[0-9]+]] = #36
; CHECK: vshuff(v1,v0,[[REG24]])
define <256 x i8> @vshuff_24(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_25:
; CHECK: [[REG25:r[0-9]+]] = #37
; CHECK: vshuff(v1,v0,[[REG25]])
define <256 x i8> @vshuff_25(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_26:
; CHECK: [[REG26:r[0-9]+]] = #38
; CHECK: vshuff(v1,v0,[[REG26]])
define <256 x i8> @vshuff_26(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_27:
; CHECK: [[REG27:r[0-9]+]] = #39
; CHECK: vshuff(v1,v0,[[REG27]])
define <256 x i8> @vshuff_27(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_28:
; CHECK: [[REG28:r[0-9]+]] = #40
; CHECK: vshuff(v1,v0,[[REG28]])
define <256 x i8> @vshuff_28(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_29:
; CHECK: [[REG29:r[0-9]+]] = #41
; CHECK: vshuff(v1,v0,[[REG29]])
define <256 x i8> @vshuff_29(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_2a:
; CHECK: [[REG2a:r[0-9]+]] = #42
; CHECK: vshuff(v1,v0,[[REG2a]])
define <256 x i8> @vshuff_2a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_2b:
; CHECK: [[REG2b:r[0-9]+]] = #43
; CHECK: vshuff(v1,v0,[[REG2b]])
define <256 x i8> @vshuff_2b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_2c:
; CHECK: [[REG2c:r[0-9]+]] = #44
; CHECK: vshuff(v1,v0,[[REG2c]])
define <256 x i8> @vshuff_2c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_2d:
; CHECK: [[REG2d:r[0-9]+]] = #45
; CHECK: vshuff(v1,v0,[[REG2d]])
define <256 x i8> @vshuff_2d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_2e:
; CHECK: [[REG2e:r[0-9]+]] = #46
; CHECK: vshuff(v1,v0,[[REG2e]])
define <256 x i8> @vshuff_2e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_2f:
; CHECK: [[REG2f:r[0-9]+]] = #47
; CHECK: vshuff(v1,v0,[[REG2f]])
define <256 x i8> @vshuff_2f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_30:
; CHECK: [[REG30:r[0-9]+]] = #48
; CHECK: vshuff(v1,v0,[[REG30]])
define <256 x i8> @vshuff_30(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_31:
; CHECK: [[REG31:r[0-9]+]] = #49
; CHECK: vshuff(v1,v0,[[REG31]])
define <256 x i8> @vshuff_31(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_32:
; CHECK: [[REG32:r[0-9]+]] = #50
; CHECK: vshuff(v1,v0,[[REG32]])
define <256 x i8> @vshuff_32(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_33:
; CHECK: [[REG33:r[0-9]+]] = #51
; CHECK: vshuff(v1,v0,[[REG33]])
define <256 x i8> @vshuff_33(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_34:
; CHECK: [[REG34:r[0-9]+]] = #52
; CHECK: vshuff(v1,v0,[[REG34]])
define <256 x i8> @vshuff_34(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_35:
; CHECK: [[REG35:r[0-9]+]] = #53
; CHECK: vshuff(v1,v0,[[REG35]])
define <256 x i8> @vshuff_35(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_36:
; CHECK: [[REG36:r[0-9]+]] = #54
; CHECK: vshuff(v1,v0,[[REG36]])
define <256 x i8> @vshuff_36(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_37:
; CHECK: [[REG37:r[0-9]+]] = #55
; CHECK: vshuff(v1,v0,[[REG37]])
define <256 x i8> @vshuff_37(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_38:
; CHECK: [[REG38:r[0-9]+]] = #56
; CHECK: vshuff(v1,v0,[[REG38]])
define <256 x i8> @vshuff_38(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_39:
; CHECK: [[REG39:r[0-9]+]] = #57
; CHECK: vshuff(v1,v0,[[REG39]])
define <256 x i8> @vshuff_39(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_3a:
; CHECK: [[REG3a:r[0-9]+]] = #58
; CHECK: vshuff(v1,v0,[[REG3a]])
define <256 x i8> @vshuff_3a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_3b:
; CHECK: [[REG3b:r[0-9]+]] = #59
; CHECK: vshuff(v1,v0,[[REG3b]])
define <256 x i8> @vshuff_3b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_3c:
; CHECK: [[REG3c:r[0-9]+]] = #60
; CHECK: vshuff(v1,v0,[[REG3c]])
define <256 x i8> @vshuff_3c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_3d:
; CHECK: [[REG3d:r[0-9]+]] = #61
; CHECK: vshuff(v1,v0,[[REG3d]])
define <256 x i8> @vshuff_3d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_3e:
; CHECK: [[REG3e:r[0-9]+]] = #62
; CHECK: vshuff(v1,v0,[[REG3e]])
define <256 x i8> @vshuff_3e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_3f:
; CHECK: [[REG3f:r[0-9]+]] = #63
; CHECK: vshuff(v1,v0,[[REG3f]])
define <256 x i8> @vshuff_3f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_40:
; CHECK: [[REG40:r[0-9]+]] = #64
; CHECK: vshuff(v1,v0,[[REG40]])
define <256 x i8> @vshuff_40(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_41:
; CHECK: [[REG41:r[0-9]+]] = #65
; CHECK: vshuff(v1,v0,[[REG41]])
define <256 x i8> @vshuff_41(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_42:
; CHECK: [[REG42:r[0-9]+]] = #66
; CHECK: vshuff(v1,v0,[[REG42]])
define <256 x i8> @vshuff_42(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_43:
; CHECK: [[REG43:r[0-9]+]] = #67
; CHECK: vshuff(v1,v0,[[REG43]])
define <256 x i8> @vshuff_43(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_44:
; CHECK: [[REG44:r[0-9]+]] = #68
; CHECK: vshuff(v1,v0,[[REG44]])
define <256 x i8> @vshuff_44(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_45:
; CHECK: [[REG45:r[0-9]+]] = #69
; CHECK: vshuff(v1,v0,[[REG45]])
define <256 x i8> @vshuff_45(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_46:
; CHECK: [[REG46:r[0-9]+]] = #70
; CHECK: vshuff(v1,v0,[[REG46]])
define <256 x i8> @vshuff_46(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_47:
; CHECK: [[REG47:r[0-9]+]] = #71
; CHECK: vshuff(v1,v0,[[REG47]])
define <256 x i8> @vshuff_47(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_48:
; CHECK: [[REG48:r[0-9]+]] = #72
; CHECK: vshuff(v1,v0,[[REG48]])
define <256 x i8> @vshuff_48(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_49:
; CHECK: [[REG49:r[0-9]+]] = #73
; CHECK: vshuff(v1,v0,[[REG49]])
define <256 x i8> @vshuff_49(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_4a:
; CHECK: [[REG4a:r[0-9]+]] = #74
; CHECK: vshuff(v1,v0,[[REG4a]])
define <256 x i8> @vshuff_4a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_4b:
; CHECK: [[REG4b:r[0-9]+]] = #75
; CHECK: vshuff(v1,v0,[[REG4b]])
define <256 x i8> @vshuff_4b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_4c:
; CHECK: [[REG4c:r[0-9]+]] = #76
; CHECK: vshuff(v1,v0,[[REG4c]])
define <256 x i8> @vshuff_4c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_4d:
; CHECK: [[REG4d:r[0-9]+]] = #77
; CHECK: vshuff(v1,v0,[[REG4d]])
define <256 x i8> @vshuff_4d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_4e:
; CHECK: [[REG4e:r[0-9]+]] = #78
; CHECK: vshuff(v1,v0,[[REG4e]])
define <256 x i8> @vshuff_4e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_4f:
; CHECK: [[REG4f:r[0-9]+]] = #79
; CHECK: vshuff(v1,v0,[[REG4f]])
define <256 x i8> @vshuff_4f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_50:
; CHECK: [[REG50:r[0-9]+]] = #80
; CHECK: vshuff(v1,v0,[[REG50]])
define <256 x i8> @vshuff_50(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_51:
; CHECK: [[REG51:r[0-9]+]] = #81
; CHECK: vshuff(v1,v0,[[REG51]])
define <256 x i8> @vshuff_51(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_52:
; CHECK: [[REG52:r[0-9]+]] = #82
; CHECK: vshuff(v1,v0,[[REG52]])
define <256 x i8> @vshuff_52(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_53:
; CHECK: [[REG53:r[0-9]+]] = #83
; CHECK: vshuff(v1,v0,[[REG53]])
define <256 x i8> @vshuff_53(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_54:
; CHECK: [[REG54:r[0-9]+]] = #84
; CHECK: vshuff(v1,v0,[[REG54]])
define <256 x i8> @vshuff_54(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_55:
; CHECK: [[REG55:r[0-9]+]] = #85
; CHECK: vshuff(v1,v0,[[REG55]])
define <256 x i8> @vshuff_55(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_56:
; CHECK: [[REG56:r[0-9]+]] = #86
; CHECK: vshuff(v1,v0,[[REG56]])
define <256 x i8> @vshuff_56(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_57:
; CHECK: [[REG57:r[0-9]+]] = #87
; CHECK: vshuff(v1,v0,[[REG57]])
define <256 x i8> @vshuff_57(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_58:
; CHECK: [[REG58:r[0-9]+]] = #88
; CHECK: vshuff(v1,v0,[[REG58]])
define <256 x i8> @vshuff_58(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_59:
; CHECK: [[REG59:r[0-9]+]] = #89
; CHECK: vshuff(v1,v0,[[REG59]])
define <256 x i8> @vshuff_59(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_5a:
; CHECK: [[REG5a:r[0-9]+]] = #90
; CHECK: vshuff(v1,v0,[[REG5a]])
define <256 x i8> @vshuff_5a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_5b:
; CHECK: [[REG5b:r[0-9]+]] = #91
; CHECK: vshuff(v1,v0,[[REG5b]])
define <256 x i8> @vshuff_5b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_5c:
; CHECK: [[REG5c:r[0-9]+]] = #92
; CHECK: vshuff(v1,v0,[[REG5c]])
define <256 x i8> @vshuff_5c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_5d:
; CHECK: [[REG5d:r[0-9]+]] = #93
; CHECK: vshuff(v1,v0,[[REG5d]])
define <256 x i8> @vshuff_5d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_5e:
; CHECK: [[REG5e:r[0-9]+]] = #94
; CHECK: vshuff(v1,v0,[[REG5e]])
define <256 x i8> @vshuff_5e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_5f:
; CHECK: [[REG5f:r[0-9]+]] = #95
; CHECK: vshuff(v1,v0,[[REG5f]])
define <256 x i8> @vshuff_5f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_60:
; CHECK: [[REG60:r[0-9]+]] = #96
; CHECK: vshuff(v1,v0,[[REG60]])
define <256 x i8> @vshuff_60(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_61:
; CHECK: [[REG61:r[0-9]+]] = #97
; CHECK: vshuff(v1,v0,[[REG61]])
define <256 x i8> @vshuff_61(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_62:
; CHECK: [[REG62:r[0-9]+]] = #98
; CHECK: vshuff(v1,v0,[[REG62]])
define <256 x i8> @vshuff_62(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_63:
; CHECK: [[REG63:r[0-9]+]] = #99
; CHECK: vshuff(v1,v0,[[REG63]])
define <256 x i8> @vshuff_63(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_64:
; CHECK: [[REG64:r[0-9]+]] = #100
; CHECK: vshuff(v1,v0,[[REG64]])
define <256 x i8> @vshuff_64(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_65:
; CHECK: [[REG65:r[0-9]+]] = #101
; CHECK: vshuff(v1,v0,[[REG65]])
define <256 x i8> @vshuff_65(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_66:
; CHECK: [[REG66:r[0-9]+]] = #102
; CHECK: vshuff(v1,v0,[[REG66]])
define <256 x i8> @vshuff_66(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_67:
; CHECK: [[REG67:r[0-9]+]] = #103
; CHECK: vshuff(v1,v0,[[REG67]])
define <256 x i8> @vshuff_67(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_68:
; CHECK: [[REG68:r[0-9]+]] = #104
; CHECK: vshuff(v1,v0,[[REG68]])
define <256 x i8> @vshuff_68(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_69:
; CHECK: [[REG69:r[0-9]+]] = #105
; CHECK: vshuff(v1,v0,[[REG69]])
define <256 x i8> @vshuff_69(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_6a:
; CHECK: [[REG6a:r[0-9]+]] = #106
; CHECK: vshuff(v1,v0,[[REG6a]])
define <256 x i8> @vshuff_6a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_6b:
; CHECK: [[REG6b:r[0-9]+]] = #107
; CHECK: vshuff(v1,v0,[[REG6b]])
define <256 x i8> @vshuff_6b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_6c:
; CHECK: [[REG6c:r[0-9]+]] = #108
; CHECK: vshuff(v1,v0,[[REG6c]])
define <256 x i8> @vshuff_6c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_6d:
; CHECK: [[REG6d:r[0-9]+]] = #109
; CHECK: vshuff(v1,v0,[[REG6d]])
define <256 x i8> @vshuff_6d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_6e:
; CHECK: [[REG6e:r[0-9]+]] = #110
; CHECK: vshuff(v1,v0,[[REG6e]])
define <256 x i8> @vshuff_6e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_6f:
; CHECK: [[REG6f:r[0-9]+]] = #111
; CHECK: vshuff(v1,v0,[[REG6f]])
define <256 x i8> @vshuff_6f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_70:
; CHECK: [[REG70:r[0-9]+]] = #112
; CHECK: vshuff(v1,v0,[[REG70]])
define <256 x i8> @vshuff_70(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_71:
; CHECK: [[REG71:r[0-9]+]] = #113
; CHECK: vshuff(v1,v0,[[REG71]])
define <256 x i8> @vshuff_71(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_72:
; CHECK: [[REG72:r[0-9]+]] = #114
; CHECK: vshuff(v1,v0,[[REG72]])
define <256 x i8> @vshuff_72(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_73:
; CHECK: [[REG73:r[0-9]+]] = #115
; CHECK: vshuff(v1,v0,[[REG73]])
define <256 x i8> @vshuff_73(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_74:
; CHECK: [[REG74:r[0-9]+]] = #116
; CHECK: vshuff(v1,v0,[[REG74]])
define <256 x i8> @vshuff_74(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_75:
; CHECK: [[REG75:r[0-9]+]] = #117
; CHECK: vshuff(v1,v0,[[REG75]])
define <256 x i8> @vshuff_75(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_76:
; CHECK: [[REG76:r[0-9]+]] = #118
; CHECK: vshuff(v1,v0,[[REG76]])
define <256 x i8> @vshuff_76(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_77:
; CHECK: [[REG77:r[0-9]+]] = #119
; CHECK: vshuff(v1,v0,[[REG77]])
define <256 x i8> @vshuff_77(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_78:
; CHECK: [[REG78:r[0-9]+]] = #120
; CHECK: vshuff(v1,v0,[[REG78]])
define <256 x i8> @vshuff_78(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 192, i32 193, i32 194, i32 195, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 200, i32 201, i32 202, i32 203, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 208, i32 209, i32 210, i32 211, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 216, i32 217, i32 218, i32 219, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 224, i32 225, i32 226, i32 227, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 232, i32 233, i32 234, i32 235, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 240, i32 241, i32 242, i32 243, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 248, i32 249, i32 250, i32 251, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_79:
; CHECK: [[REG79:r[0-9]+]] = #121
; CHECK: vshuff(v1,v0,[[REG79]])
define <256 x i8> @vshuff_79(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 4, i32 132, i32 6, i32 134, i32 1, i32 129, i32 3, i32 131, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 12, i32 140, i32 14, i32 142, i32 9, i32 137, i32 11, i32 139, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 20, i32 148, i32 22, i32 150, i32 17, i32 145, i32 19, i32 147, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 28, i32 156, i32 30, i32 158, i32 25, i32 153, i32 27, i32 155, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 36, i32 164, i32 38, i32 166, i32 33, i32 161, i32 35, i32 163, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 44, i32 172, i32 46, i32 174, i32 41, i32 169, i32 43, i32 171, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 52, i32 180, i32 54, i32 182, i32 49, i32 177, i32 51, i32 179, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 60, i32 188, i32 62, i32 190, i32 57, i32 185, i32 59, i32 187, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 68, i32 196, i32 70, i32 198, i32 65, i32 193, i32 67, i32 195, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 76, i32 204, i32 78, i32 206, i32 73, i32 201, i32 75, i32 203, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 84, i32 212, i32 86, i32 214, i32 81, i32 209, i32 83, i32 211, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 92, i32 220, i32 94, i32 222, i32 89, i32 217, i32 91, i32 219, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 100, i32 228, i32 102, i32 230, i32 97, i32 225, i32 99, i32 227, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 108, i32 236, i32 110, i32 238, i32 105, i32 233, i32 107, i32 235, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 116, i32 244, i32 118, i32 246, i32 113, i32 241, i32 115, i32 243, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 124, i32 252, i32 126, i32 254, i32 121, i32 249, i32 123, i32 251, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_7a:
; CHECK: [[REG7a:r[0-9]+]] = #122
; CHECK: vshuff(v1,v0,[[REG7a]])
define <256 x i8> @vshuff_7a(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 4, i32 5, i32 132, i32 133, i32 2, i32 3, i32 130, i32 131, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 12, i32 13, i32 140, i32 141, i32 10, i32 11, i32 138, i32 139, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 20, i32 21, i32 148, i32 149, i32 18, i32 19, i32 146, i32 147, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 28, i32 29, i32 156, i32 157, i32 26, i32 27, i32 154, i32 155, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 36, i32 37, i32 164, i32 165, i32 34, i32 35, i32 162, i32 163, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 44, i32 45, i32 172, i32 173, i32 42, i32 43, i32 170, i32 171, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 52, i32 53, i32 180, i32 181, i32 50, i32 51, i32 178, i32 179, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 60, i32 61, i32 188, i32 189, i32 58, i32 59, i32 186, i32 187, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 68, i32 69, i32 196, i32 197, i32 66, i32 67, i32 194, i32 195, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 76, i32 77, i32 204, i32 205, i32 74, i32 75, i32 202, i32 203, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 84, i32 85, i32 212, i32 213, i32 82, i32 83, i32 210, i32 211, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 92, i32 93, i32 220, i32 221, i32 90, i32 91, i32 218, i32 219, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 100, i32 101, i32 228, i32 229, i32 98, i32 99, i32 226, i32 227, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 108, i32 109, i32 236, i32 237, i32 106, i32 107, i32 234, i32 235, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 116, i32 117, i32 244, i32 245, i32 114, i32 115, i32 242, i32 243, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 124, i32 125, i32 252, i32 253, i32 122, i32 123, i32 250, i32 251, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_7b:
; CHECK: [[REG7b:r[0-9]+]] = #123
; CHECK: vshuff(v1,v0,[[REG7b]])
define <256 x i8> @vshuff_7b(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 4, i32 132, i32 5, i32 133, i32 2, i32 130, i32 3, i32 131, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 12, i32 140, i32 13, i32 141, i32 10, i32 138, i32 11, i32 139, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 20, i32 148, i32 21, i32 149, i32 18, i32 146, i32 19, i32 147, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 28, i32 156, i32 29, i32 157, i32 26, i32 154, i32 27, i32 155, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 36, i32 164, i32 37, i32 165, i32 34, i32 162, i32 35, i32 163, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 44, i32 172, i32 45, i32 173, i32 42, i32 170, i32 43, i32 171, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 52, i32 180, i32 53, i32 181, i32 50, i32 178, i32 51, i32 179, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 60, i32 188, i32 61, i32 189, i32 58, i32 186, i32 59, i32 187, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 68, i32 196, i32 69, i32 197, i32 66, i32 194, i32 67, i32 195, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 76, i32 204, i32 77, i32 205, i32 74, i32 202, i32 75, i32 203, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 84, i32 212, i32 85, i32 213, i32 82, i32 210, i32 83, i32 211, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 92, i32 220, i32 93, i32 221, i32 90, i32 218, i32 91, i32 219, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 100, i32 228, i32 101, i32 229, i32 98, i32 226, i32 99, i32 227, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 108, i32 236, i32 109, i32 237, i32 106, i32 234, i32 107, i32 235, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 116, i32 244, i32 117, i32 245, i32 114, i32 242, i32 115, i32 243, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 124, i32 252, i32 125, i32 253, i32 122, i32 250, i32 123, i32 251, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_7c:
; CHECK: [[REG7c:r[0-9]+]] = #124
; CHECK: vshuff(v1,v0,[[REG7c]])
define <256 x i8> @vshuff_7c(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 2, i32 3, i32 128, i32 129, i32 130, i32 131, i32 4, i32 5, i32 6, i32 7, i32 132, i32 133, i32 134, i32 135, i32 8, i32 9, i32 10, i32 11, i32 136, i32 137, i32 138, i32 139, i32 12, i32 13, i32 14, i32 15, i32 140, i32 141, i32 142, i32 143, i32 16, i32 17, i32 18, i32 19, i32 144, i32 145, i32 146, i32 147, i32 20, i32 21, i32 22, i32 23, i32 148, i32 149, i32 150, i32 151, i32 24, i32 25, i32 26, i32 27, i32 152, i32 153, i32 154, i32 155, i32 28, i32 29, i32 30, i32 31, i32 156, i32 157, i32 158, i32 159, i32 32, i32 33, i32 34, i32 35, i32 160, i32 161, i32 162, i32 163, i32 36, i32 37, i32 38, i32 39, i32 164, i32 165, i32 166, i32 167, i32 40, i32 41, i32 42, i32 43, i32 168, i32 169, i32 170, i32 171, i32 44, i32 45, i32 46, i32 47, i32 172, i32 173, i32 174, i32 175, i32 48, i32 49, i32 50, i32 51, i32 176, i32 177, i32 178, i32 179, i32 52, i32 53, i32 54, i32 55, i32 180, i32 181, i32 182, i32 183, i32 56, i32 57, i32 58, i32 59, i32 184, i32 185, i32 186, i32 187, i32 60, i32 61, i32 62, i32 63, i32 188, i32 189, i32 190, i32 191, i32 64, i32 65, i32 66, i32 67, i32 192, i32 193, i32 194, i32 195, i32 68, i32 69, i32 70, i32 71, i32 196, i32 197, i32 198, i32 199, i32 72, i32 73, i32 74, i32 75, i32 200, i32 201, i32 202, i32 203, i32 76, i32 77, i32 78, i32 79, i32 204, i32 205, i32 206, i32 207, i32 80, i32 81, i32 82, i32 83, i32 208, i32 209, i32 210, i32 211, i32 84, i32 85, i32 86, i32 87, i32 212, i32 213, i32 214, i32 215, i32 88, i32 89, i32 90, i32 91, i32 216, i32 217, i32 218, i32 219, i32 92, i32 93, i32 94, i32 95, i32 220, i32 221, i32 222, i32 223, i32 96, i32 97, i32 98, i32 99, i32 224, i32 225, i32 226, i32 227, i32 100, i32 101, i32 102, i32 103, i32 228, i32 229, i32 230, i32 231, i32 104, i32 105, i32 106, i32 107, i32 232, i32 233, i32 234, i32 235, i32 108, i32 109, i32 110, i32 111, i32 236, i32 237, i32 238, i32 239, i32 112, i32 113, i32 114, i32 115, i32 240, i32 241, i32 242, i32 243, i32 116, i32 117, i32 118, i32 119, i32 244, i32 245, i32 246, i32 247, i32 120, i32 121, i32 122, i32 123, i32 248, i32 249, i32 250, i32 251, i32 124, i32 125, i32 126, i32 127, i32 252, i32 253, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_7d:
; CHECK: [[REG7d:r[0-9]+]] = #125
; CHECK: vshuff(v1,v0,[[REG7d]])
define <256 x i8> @vshuff_7d(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 2, i32 130, i32 1, i32 129, i32 3, i32 131, i32 4, i32 132, i32 6, i32 134, i32 5, i32 133, i32 7, i32 135, i32 8, i32 136, i32 10, i32 138, i32 9, i32 137, i32 11, i32 139, i32 12, i32 140, i32 14, i32 142, i32 13, i32 141, i32 15, i32 143, i32 16, i32 144, i32 18, i32 146, i32 17, i32 145, i32 19, i32 147, i32 20, i32 148, i32 22, i32 150, i32 21, i32 149, i32 23, i32 151, i32 24, i32 152, i32 26, i32 154, i32 25, i32 153, i32 27, i32 155, i32 28, i32 156, i32 30, i32 158, i32 29, i32 157, i32 31, i32 159, i32 32, i32 160, i32 34, i32 162, i32 33, i32 161, i32 35, i32 163, i32 36, i32 164, i32 38, i32 166, i32 37, i32 165, i32 39, i32 167, i32 40, i32 168, i32 42, i32 170, i32 41, i32 169, i32 43, i32 171, i32 44, i32 172, i32 46, i32 174, i32 45, i32 173, i32 47, i32 175, i32 48, i32 176, i32 50, i32 178, i32 49, i32 177, i32 51, i32 179, i32 52, i32 180, i32 54, i32 182, i32 53, i32 181, i32 55, i32 183, i32 56, i32 184, i32 58, i32 186, i32 57, i32 185, i32 59, i32 187, i32 60, i32 188, i32 62, i32 190, i32 61, i32 189, i32 63, i32 191, i32 64, i32 192, i32 66, i32 194, i32 65, i32 193, i32 67, i32 195, i32 68, i32 196, i32 70, i32 198, i32 69, i32 197, i32 71, i32 199, i32 72, i32 200, i32 74, i32 202, i32 73, i32 201, i32 75, i32 203, i32 76, i32 204, i32 78, i32 206, i32 77, i32 205, i32 79, i32 207, i32 80, i32 208, i32 82, i32 210, i32 81, i32 209, i32 83, i32 211, i32 84, i32 212, i32 86, i32 214, i32 85, i32 213, i32 87, i32 215, i32 88, i32 216, i32 90, i32 218, i32 89, i32 217, i32 91, i32 219, i32 92, i32 220, i32 94, i32 222, i32 93, i32 221, i32 95, i32 223, i32 96, i32 224, i32 98, i32 226, i32 97, i32 225, i32 99, i32 227, i32 100, i32 228, i32 102, i32 230, i32 101, i32 229, i32 103, i32 231, i32 104, i32 232, i32 106, i32 234, i32 105, i32 233, i32 107, i32 235, i32 108, i32 236, i32 110, i32 238, i32 109, i32 237, i32 111, i32 239, i32 112, i32 240, i32 114, i32 242, i32 113, i32 241, i32 115, i32 243, i32 116, i32 244, i32 118, i32 246, i32 117, i32 245, i32 119, i32 247, i32 120, i32 248, i32 122, i32 250, i32 121, i32 249, i32 123, i32 251, i32 124, i32 252, i32 126, i32 254, i32 125, i32 253, i32 127, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_7e:
; CHECK: [[REG7e:r[0-9]+]] = #126
; CHECK: vshuff(v1,v0,[[REG7e]])
define <256 x i8> @vshuff_7e(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 1, i32 128, i32 129, i32 2, i32 3, i32 130, i32 131, i32 4, i32 5, i32 132, i32 133, i32 6, i32 7, i32 134, i32 135, i32 8, i32 9, i32 136, i32 137, i32 10, i32 11, i32 138, i32 139, i32 12, i32 13, i32 140, i32 141, i32 14, i32 15, i32 142, i32 143, i32 16, i32 17, i32 144, i32 145, i32 18, i32 19, i32 146, i32 147, i32 20, i32 21, i32 148, i32 149, i32 22, i32 23, i32 150, i32 151, i32 24, i32 25, i32 152, i32 153, i32 26, i32 27, i32 154, i32 155, i32 28, i32 29, i32 156, i32 157, i32 30, i32 31, i32 158, i32 159, i32 32, i32 33, i32 160, i32 161, i32 34, i32 35, i32 162, i32 163, i32 36, i32 37, i32 164, i32 165, i32 38, i32 39, i32 166, i32 167, i32 40, i32 41, i32 168, i32 169, i32 42, i32 43, i32 170, i32 171, i32 44, i32 45, i32 172, i32 173, i32 46, i32 47, i32 174, i32 175, i32 48, i32 49, i32 176, i32 177, i32 50, i32 51, i32 178, i32 179, i32 52, i32 53, i32 180, i32 181, i32 54, i32 55, i32 182, i32 183, i32 56, i32 57, i32 184, i32 185, i32 58, i32 59, i32 186, i32 187, i32 60, i32 61, i32 188, i32 189, i32 62, i32 63, i32 190, i32 191, i32 64, i32 65, i32 192, i32 193, i32 66, i32 67, i32 194, i32 195, i32 68, i32 69, i32 196, i32 197, i32 70, i32 71, i32 198, i32 199, i32 72, i32 73, i32 200, i32 201, i32 74, i32 75, i32 202, i32 203, i32 76, i32 77, i32 204, i32 205, i32 78, i32 79, i32 206, i32 207, i32 80, i32 81, i32 208, i32 209, i32 82, i32 83, i32 210, i32 211, i32 84, i32 85, i32 212, i32 213, i32 86, i32 87, i32 214, i32 215, i32 88, i32 89, i32 216, i32 217, i32 90, i32 91, i32 218, i32 219, i32 92, i32 93, i32 220, i32 221, i32 94, i32 95, i32 222, i32 223, i32 96, i32 97, i32 224, i32 225, i32 98, i32 99, i32 226, i32 227, i32 100, i32 101, i32 228, i32 229, i32 102, i32 103, i32 230, i32 231, i32 104, i32 105, i32 232, i32 233, i32 106, i32 107, i32 234, i32 235, i32 108, i32 109, i32 236, i32 237, i32 110, i32 111, i32 238, i32 239, i32 112, i32 113, i32 240, i32 241, i32 114, i32 115, i32 242, i32 243, i32 116, i32 117, i32 244, i32 245, i32 118, i32 119, i32 246, i32 247, i32 120, i32 121, i32 248, i32 249, i32 122, i32 123, i32 250, i32 251, i32 124, i32 125, i32 252, i32 253, i32 126, i32 127, i32 254, i32 255>
  ret <256 x i8> %p
}

; CHECK-LABEL: vshuff_7f:
; CHECK: [[REG7f:r[0-9]+]] = #127
; CHECK: vshuff(v1,v0,[[REG7f]])
define <256 x i8> @vshuff_7f(<256 x i8> %v0, <256 x i8> %v1) #0 {
  %p = shufflevector <256 x i8> %v0, <256 x i8> undef, <256 x i32> < i32 0, i32 128, i32 1, i32 129, i32 2, i32 130, i32 3, i32 131, i32 4, i32 132, i32 5, i32 133, i32 6, i32 134, i32 7, i32 135, i32 8, i32 136, i32 9, i32 137, i32 10, i32 138, i32 11, i32 139, i32 12, i32 140, i32 13, i32 141, i32 14, i32 142, i32 15, i32 143, i32 16, i32 144, i32 17, i32 145, i32 18, i32 146, i32 19, i32 147, i32 20, i32 148, i32 21, i32 149, i32 22, i32 150, i32 23, i32 151, i32 24, i32 152, i32 25, i32 153, i32 26, i32 154, i32 27, i32 155, i32 28, i32 156, i32 29, i32 157, i32 30, i32 158, i32 31, i32 159, i32 32, i32 160, i32 33, i32 161, i32 34, i32 162, i32 35, i32 163, i32 36, i32 164, i32 37, i32 165, i32 38, i32 166, i32 39, i32 167, i32 40, i32 168, i32 41, i32 169, i32 42, i32 170, i32 43, i32 171, i32 44, i32 172, i32 45, i32 173, i32 46, i32 174, i32 47, i32 175, i32 48, i32 176, i32 49, i32 177, i32 50, i32 178, i32 51, i32 179, i32 52, i32 180, i32 53, i32 181, i32 54, i32 182, i32 55, i32 183, i32 56, i32 184, i32 57, i32 185, i32 58, i32 186, i32 59, i32 187, i32 60, i32 188, i32 61, i32 189, i32 62, i32 190, i32 63, i32 191, i32 64, i32 192, i32 65, i32 193, i32 66, i32 194, i32 67, i32 195, i32 68, i32 196, i32 69, i32 197, i32 70, i32 198, i32 71, i32 199, i32 72, i32 200, i32 73, i32 201, i32 74, i32 202, i32 75, i32 203, i32 76, i32 204, i32 77, i32 205, i32 78, i32 206, i32 79, i32 207, i32 80, i32 208, i32 81, i32 209, i32 82, i32 210, i32 83, i32 211, i32 84, i32 212, i32 85, i32 213, i32 86, i32 214, i32 87, i32 215, i32 88, i32 216, i32 89, i32 217, i32 90, i32 218, i32 91, i32 219, i32 92, i32 220, i32 93, i32 221, i32 94, i32 222, i32 95, i32 223, i32 96, i32 224, i32 97, i32 225, i32 98, i32 226, i32 99, i32 227, i32 100, i32 228, i32 101, i32 229, i32 102, i32 230, i32 103, i32 231, i32 104, i32 232, i32 105, i32 233, i32 106, i32 234, i32 107, i32 235, i32 108, i32 236, i32 109, i32 237, i32 110, i32 238, i32 111, i32 239, i32 112, i32 240, i32 113, i32 241, i32 114, i32 242, i32 115, i32 243, i32 116, i32 244, i32 117, i32 245, i32 118, i32 246, i32 119, i32 247, i32 120, i32 248, i32 121, i32 249, i32 122, i32 250, i32 123, i32 251, i32 124, i32 252, i32 125, i32 253, i32 126, i32 254, i32 127, i32 255>
  ret <256 x i8> %p
}

attributes #0 = { nounwind readnone "target-cpu"="hexagonv60" "target-features"="+hvx,+hvx-length128b" }
