; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+d,+zfh,+v -target-abi=ilp32d \
; RUN:     -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+d,+zfh,+v -target-abi=lp64d \
; RUN:     -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV64

declare void @llvm.masked.scatter.v1i8.v1p0i8(<1 x i8>, <1 x i8*>, i32, <1 x i1>)

define void @mscatter_v1i8(<1 x i8> %val, <1 x i8*> %ptrs, <1 x i1> %m) {
; RV32-LABEL: mscatter_v1i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e8, mf8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v1i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e8, mf8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v1i8.v1p0i8(<1 x i8> %val, <1 x i8*> %ptrs, i32 1, <1 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v2i8.v2p0i8(<2 x i8>, <2 x i8*>, i32, <2 x i1>)

define void @mscatter_v2i8(<2 x i8> %val, <2 x i8*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v2i8.v2p0i8(<2 x i8> %val, <2 x i8*> %ptrs, i32 1, <2 x i1> %m)
  ret void
}

define void @mscatter_v2i16_truncstore_v2i8(<2 x i16> %val, <2 x i8*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i16_truncstore_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e8, mf8, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i16_truncstore_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e8, mf8, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i16> %val to <2 x i8>
  call void @llvm.masked.scatter.v2i8.v2p0i8(<2 x i8> %tval, <2 x i8*> %ptrs, i32 1, <2 x i1> %m)
  ret void
}

define void @mscatter_v2i32_truncstore_v2i8(<2 x i32> %val, <2 x i8*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i32_truncstore_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i32_truncstore_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i32> %val to <2 x i8>
  call void @llvm.masked.scatter.v2i8.v2p0i8(<2 x i8> %tval, <2 x i8*> %ptrs, i32 1, <2 x i1> %m)
  ret void
}

define void @mscatter_v2i64_truncstore_v2i8(<2 x i64> %val, <2 x i8*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i64_truncstore_v2i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i64_truncstore_v2i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i64> %val to <2 x i8>
  call void @llvm.masked.scatter.v2i8.v2p0i8(<2 x i8> %tval, <2 x i8*> %ptrs, i32 1, <2 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v4i8.v4p0i8(<4 x i8>, <4 x i8*>, i32, <4 x i1>)

define void @mscatter_v4i8(<4 x i8> %val, <4 x i8*> %ptrs, <4 x i1> %m) {
; RV32-LABEL: mscatter_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i8.v4p0i8(<4 x i8> %val, <4 x i8*> %ptrs, i32 1, <4 x i1> %m)
  ret void
}

define void @mscatter_truemask_v4i8(<4 x i8> %val, <4 x i8*> %ptrs) {
; RV32-LABEL: mscatter_truemask_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_truemask_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e8, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4i8.v4p0i8(<4 x i8> %val, <4 x i8*> %ptrs, i32 1, <4 x i1> %mtrue)
  ret void
}

define void @mscatter_falsemask_v4i8(<4 x i8> %val, <4 x i8*> %ptrs) {
; RV32-LABEL: mscatter_falsemask_v4i8:
; RV32:       # %bb.0:
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_falsemask_v4i8:
; RV64:       # %bb.0:
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i8.v4p0i8(<4 x i8> %val, <4 x i8*> %ptrs, i32 1, <4 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.scatter.v8i8.v8p0i8(<8 x i8>, <8 x i8*>, i32, <8 x i1>)

define void @mscatter_v8i8(<8 x i8> %val, <8 x i8*> %ptrs, <8 x i1> %m) {
; RV32-LABEL: mscatter_v8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e8, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v8i8.v8p0i8(<8 x i8> %val, <8 x i8*> %ptrs, i32 1, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i8(<8 x i8> %val, i8* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vsetvli zero, zero, e8, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vsetvli zero, zero, e8, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <8 x i8> %idxs
  call void @llvm.masked.scatter.v8i8.v8p0i8(<8 x i8> %val, <8 x i8*> %ptrs, i32 1, <8 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v1i16.v1p0i16(<1 x i16>, <1 x i16*>, i32, <1 x i1>)

define void @mscatter_v1i16(<1 x i16> %val, <1 x i16*> %ptrs, <1 x i1> %m) {
; RV32-LABEL: mscatter_v1i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v1i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v1i16.v1p0i16(<1 x i16> %val, <1 x i16*> %ptrs, i32 2, <1 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v2i16.v2p0i16(<2 x i16>, <2 x i16*>, i32, <2 x i1>)

define void @mscatter_v2i16(<2 x i16> %val, <2 x i16*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v2i16.v2p0i16(<2 x i16> %val, <2 x i16*> %ptrs, i32 2, <2 x i1> %m)
  ret void
}

define void @mscatter_v2i32_truncstore_v2i16(<2 x i32> %val, <2 x i16*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i32_truncstore_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i32_truncstore_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i32> %val to <2 x i16>
  call void @llvm.masked.scatter.v2i16.v2p0i16(<2 x i16> %tval, <2 x i16*> %ptrs, i32 2, <2 x i1> %m)
  ret void
}

define void @mscatter_v2i64_truncstore_v2i16(<2 x i64> %val, <2 x i16*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i64_truncstore_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i64_truncstore_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i64> %val to <2 x i16>
  call void @llvm.masked.scatter.v2i16.v2p0i16(<2 x i16> %tval, <2 x i16*> %ptrs, i32 2, <2 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v4i16.v4p0i16(<4 x i16>, <4 x i16*>, i32, <4 x i1>)

define void @mscatter_v4i16(<4 x i16> %val, <4 x i16*> %ptrs, <4 x i1> %m) {
; RV32-LABEL: mscatter_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i16.v4p0i16(<4 x i16> %val, <4 x i16*> %ptrs, i32 2, <4 x i1> %m)
  ret void
}

define void @mscatter_truemask_v4i16(<4 x i16> %val, <4 x i16*> %ptrs) {
; RV32-LABEL: mscatter_truemask_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_truemask_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4i16.v4p0i16(<4 x i16> %val, <4 x i16*> %ptrs, i32 2, <4 x i1> %mtrue)
  ret void
}

define void @mscatter_falsemask_v4i16(<4 x i16> %val, <4 x i16*> %ptrs) {
; RV32-LABEL: mscatter_falsemask_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_falsemask_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i16.v4p0i16(<4 x i16> %val, <4 x i16*> %ptrs, i32 2, <4 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.scatter.v8i16.v8p0i16(<8 x i16>, <8 x i16*>, i32, <8 x i1>)

define void @mscatter_v8i16(<8 x i16> %val, <8 x i16*> %ptrs, <8 x i1> %m) {
; RV32-LABEL: mscatter_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v8i16.v8p0i16(<8 x i16> %val, <8 x i16*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i8_v8i16(<8 x i16> %val, i16* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i8> %idxs
  call void @llvm.masked.scatter.v8i16.v8p0i16(<8 x i16> %val, <8 x i16*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i8_v8i16(<8 x i16> %val, i16* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i16> %eidxs
  call void @llvm.masked.scatter.v8i16.v8p0i16(<8 x i16> %val, <8 x i16*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i8_v8i16(<8 x i16> %val, i16* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i8_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i8_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i16> %eidxs
  call void @llvm.masked.scatter.v8i16.v8p0i16(<8 x i16> %val, <8 x i16*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i16(<8 x i16> %val, i16* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i16, i16* %base, <8 x i16> %idxs
  call void @llvm.masked.scatter.v8i16.v8p0i16(<8 x i16> %val, <8 x i16*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v1i32.v1p0i32(<1 x i32>, <1 x i32*>, i32, <1 x i1>)

define void @mscatter_v1i32(<1 x i32> %val, <1 x i32*> %ptrs, <1 x i1> %m) {
; RV32-LABEL: mscatter_v1i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v1i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v1i32.v1p0i32(<1 x i32> %val, <1 x i32*> %ptrs, i32 4, <1 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v2i32.v2p0i32(<2 x i32>, <2 x i32*>, i32, <2 x i1>)

define void @mscatter_v2i32(<2 x i32> %val, <2 x i32*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v2i32.v2p0i32(<2 x i32> %val, <2 x i32*> %ptrs, i32 4, <2 x i1> %m)
  ret void
}

define void @mscatter_v2i64_truncstore_v2i32(<2 x i64> %val, <2 x i32*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i64_truncstore_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV32-NEXT:    vnsrl.wx v8, v8, zero
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i64_truncstore_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV64-NEXT:    vnsrl.wx v8, v8, zero
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  %tval = trunc <2 x i64> %val to <2 x i32>
  call void @llvm.masked.scatter.v2i32.v2p0i32(<2 x i32> %tval, <2 x i32*> %ptrs, i32 4, <2 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v4i32.v4p0i32(<4 x i32>, <4 x i32*>, i32, <4 x i1>)

define void @mscatter_v4i32(<4 x i32> %val, <4 x i32*> %ptrs, <4 x i1> %m) {
; RV32-LABEL: mscatter_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i32.v4p0i32(<4 x i32> %val, <4 x i32*> %ptrs, i32 4, <4 x i1> %m)
  ret void
}

define void @mscatter_truemask_v4i32(<4 x i32> %val, <4 x i32*> %ptrs) {
; RV32-LABEL: mscatter_truemask_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_truemask_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4i32.v4p0i32(<4 x i32> %val, <4 x i32*> %ptrs, i32 4, <4 x i1> %mtrue)
  ret void
}

define void @mscatter_falsemask_v4i32(<4 x i32> %val, <4 x i32*> %ptrs) {
; RV32-LABEL: mscatter_falsemask_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_falsemask_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i32.v4p0i32(<4 x i32> %val, <4 x i32*> %ptrs, i32 4, <4 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32>, <8 x i32*>, i32, <8 x i1>)

define void @mscatter_v8i32(<8 x i32> %val, <8 x i32*> %ptrs, <8 x i1> %m) {
; RV32-LABEL: mscatter_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i8_v8i32(<8 x i32> %val, i32* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i8> %idxs
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i8_v8i32(<8 x i32> %val, i32* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i8_v8i32(<8 x i32> %val, i32* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i8_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i8_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i16_v8i32(<8 x i32> %val, i32* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i16> %idxs
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i16_v8i32(<8 x i32> %val, i32* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i16_v8i32(<8 x i32> %val, i32* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i16_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i16_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i32(<8 x i32> %val, i32* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v10, v10, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i32, i32* %base, <8 x i32> %idxs
  call void @llvm.masked.scatter.v8i32.v8p0i32(<8 x i32> %val, <8 x i32*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v1i64.v1p0i64(<1 x i64>, <1 x i64*>, i32, <1 x i1>)

define void @mscatter_v1i64(<1 x i64> %val, <1 x i64*> %ptrs, <1 x i1> %m) {
; RV32-LABEL: mscatter_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v1i64.v1p0i64(<1 x i64> %val, <1 x i64*> %ptrs, i32 8, <1 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v2i64.v2p0i64(<2 x i64>, <2 x i64*>, i32, <2 x i1>)

define void @mscatter_v2i64(<2 x i64> %val, <2 x i64*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v2i64.v2p0i64(<2 x i64> %val, <2 x i64*> %ptrs, i32 8, <2 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v4i64.v4p0i64(<4 x i64>, <4 x i64*>, i32, <4 x i1>)

define void @mscatter_v4i64(<4 x i64> %val, <4 x i64*> %ptrs, <4 x i1> %m) {
; RV32-LABEL: mscatter_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i64.v4p0i64(<4 x i64> %val, <4 x i64*> %ptrs, i32 8, <4 x i1> %m)
  ret void
}

define void @mscatter_truemask_v4i64(<4 x i64> %val, <4 x i64*> %ptrs) {
; RV32-LABEL: mscatter_truemask_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_truemask_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4i64.v4p0i64(<4 x i64> %val, <4 x i64*> %ptrs, i32 8, <4 x i1> %mtrue)
  ret void
}

define void @mscatter_falsemask_v4i64(<4 x i64> %val, <4 x i64*> %ptrs) {
; RV32-LABEL: mscatter_falsemask_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_falsemask_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4i64.v4p0i64(<4 x i64> %val, <4 x i64*> %ptrs, i32 8, <4 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64>, <8 x i64*>, i32, <8 x i1>)

define void @mscatter_v8i64(<8 x i64> %val, <8 x i64*> %ptrs, <8 x i1> %m) {
; RV32-LABEL: mscatter_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i8_v8i64(<8 x i64> %val, i64* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i8> %idxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i8_v8i64(<8 x i64> %val, i64* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf8 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i8_v8i64(<8 x i64> %val, i64* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i8_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf8 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i8_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i16_v8i64(<8 x i64> %val, i64* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i16> %idxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i16_v8i64(<8 x i64> %val, i64* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i16_v8i64(<8 x i64> %val, i64* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i16_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i16_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i32_v8i64(<8 x i64> %val, i64* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i32> %idxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i32_v8i64(<8 x i64> %val, i64* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i32_v8i64(<8 x i64> %val, i64* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i32_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i32_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i64(<8 x i64> %val, i64* %base, <8 x i64> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsll.vi v12, v12, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i64, i64* %base, <8 x i64> %idxs
  call void @llvm.masked.scatter.v8i64.v8p0i64(<8 x i64> %val, <8 x i64*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v1f16.v1p0f16(<1 x half>, <1 x half*>, i32, <1 x i1>)

define void @mscatter_v1f16(<1 x half> %val, <1 x half*> %ptrs, <1 x i1> %m) {
; RV32-LABEL: mscatter_v1f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v1f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e16, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v1f16.v1p0f16(<1 x half> %val, <1 x half*> %ptrs, i32 2, <1 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v2f16.v2p0f16(<2 x half>, <2 x half*>, i32, <2 x i1>)

define void @mscatter_v2f16(<2 x half> %val, <2 x half*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e16, mf4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v2f16.v2p0f16(<2 x half> %val, <2 x half*> %ptrs, i32 2, <2 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v4f16.v4p0f16(<4 x half>, <4 x half*>, i32, <4 x i1>)

define void @mscatter_v4f16(<4 x half> %val, <4 x half*> %ptrs, <4 x i1> %m) {
; RV32-LABEL: mscatter_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4f16.v4p0f16(<4 x half> %val, <4 x half*> %ptrs, i32 2, <4 x i1> %m)
  ret void
}

define void @mscatter_truemask_v4f16(<4 x half> %val, <4 x half*> %ptrs) {
; RV32-LABEL: mscatter_truemask_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_truemask_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e16, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4f16.v4p0f16(<4 x half> %val, <4 x half*> %ptrs, i32 2, <4 x i1> %mtrue)
  ret void
}

define void @mscatter_falsemask_v4f16(<4 x half> %val, <4 x half*> %ptrs) {
; RV32-LABEL: mscatter_falsemask_v4f16:
; RV32:       # %bb.0:
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_falsemask_v4f16:
; RV64:       # %bb.0:
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4f16.v4p0f16(<4 x half> %val, <4 x half*> %ptrs, i32 2, <4 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.scatter.v8f16.v8p0f16(<8 x half>, <8 x half*>, i32, <8 x i1>)

define void @mscatter_v8f16(<8 x half> %val, <8 x half*> %ptrs, <8 x i1> %m) {
; RV32-LABEL: mscatter_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v8f16.v8p0f16(<8 x half> %val, <8 x half*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i8_v8f16(<8 x half> %val, half* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <8 x i8> %idxs
  call void @llvm.masked.scatter.v8f16.v8p0f16(<8 x half> %val, <8 x half*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i8_v8f16(<8 x half> %val, half* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <8 x i16> %eidxs
  call void @llvm.masked.scatter.v8f16.v8p0f16(<8 x half> %val, <8 x half*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i8_v8f16(<8 x half> %val, half* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i8_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i8_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i16>
  %ptrs = getelementptr inbounds half, half* %base, <8 x i16> %eidxs
  call void @llvm.masked.scatter.v8f16.v8p0f16(<8 x half> %val, <8 x half*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8f16(<8 x half> %val, half* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8f16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v10, v9
; RV32-NEXT:    vadd.vv v10, v10, v10
; RV32-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8f16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v12, v9
; RV64-NEXT:    vadd.vv v12, v12, v12
; RV64-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds half, half* %base, <8 x i16> %idxs
  call void @llvm.masked.scatter.v8f16.v8p0f16(<8 x half> %val, <8 x half*> %ptrs, i32 2, <8 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v1f32.v1p0f32(<1 x float>, <1 x float*>, i32, <1 x i1>)

define void @mscatter_v1f32(<1 x float> %val, <1 x float*> %ptrs, <1 x i1> %m) {
; RV32-LABEL: mscatter_v1f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v1f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e32, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v1f32.v1p0f32(<1 x float> %val, <1 x float*> %ptrs, i32 4, <1 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v2f32.v2p0f32(<2 x float>, <2 x float*>, i32, <2 x i1>)

define void @mscatter_v2f32(<2 x float> %val, <2 x float*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e32, mf2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v2f32.v2p0f32(<2 x float> %val, <2 x float*> %ptrs, i32 4, <2 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v4f32.v4p0f32(<4 x float>, <4 x float*>, i32, <4 x i1>)

define void @mscatter_v4f32(<4 x float> %val, <4 x float*> %ptrs, <4 x i1> %m) {
; RV32-LABEL: mscatter_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4f32.v4p0f32(<4 x float> %val, <4 x float*> %ptrs, i32 4, <4 x i1> %m)
  ret void
}

define void @mscatter_truemask_v4f32(<4 x float> %val, <4 x float*> %ptrs) {
; RV32-LABEL: mscatter_truemask_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_truemask_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4f32.v4p0f32(<4 x float> %val, <4 x float*> %ptrs, i32 4, <4 x i1> %mtrue)
  ret void
}

define void @mscatter_falsemask_v4f32(<4 x float> %val, <4 x float*> %ptrs) {
; RV32-LABEL: mscatter_falsemask_v4f32:
; RV32:       # %bb.0:
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_falsemask_v4f32:
; RV64:       # %bb.0:
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4f32.v4p0f32(<4 x float> %val, <4 x float*> %ptrs, i32 4, <4 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float>, <8 x float*>, i32, <8 x i1>)

define void @mscatter_v8f32(<8 x float> %val, <8 x float*> %ptrs, <8 x i1> %m) {
; RV32-LABEL: mscatter_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i8_v8f32(<8 x float> %val, float* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <8 x i8> %idxs
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i8_v8f32(<8 x float> %val, float* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i8_v8f32(<8 x float> %val, float* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i8_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf4 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i8_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i16_v8f32(<8 x float> %val, float* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <8 x i16> %idxs
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i16_v8f32(<8 x float> %val, float* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i16_v8f32(<8 x float> %val, float* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i16_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vzext.vf2 v12, v10
; RV32-NEXT:    vsll.vi v10, v12, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i16_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i32>
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %eidxs
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8f32(<8 x float> %val, float* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8f32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v10, v10, 2
; RV32-NEXT:    vsoxei32.v v8, (a0), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8f32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v12, v10
; RV64-NEXT:    vsll.vi v12, v12, 2
; RV64-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds float, float* %base, <8 x i32> %idxs
  call void @llvm.masked.scatter.v8f32.v8p0f32(<8 x float> %val, <8 x float*> %ptrs, i32 4, <8 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v1f64.v1p0f64(<1 x double>, <1 x double*>, i32, <1 x i1>)

define void @mscatter_v1f64(<1 x double> %val, <1 x double*> %ptrs, <1 x i1> %m) {
; RV32-LABEL: mscatter_v1f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v1f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e64, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v1f64.v1p0f64(<1 x double> %val, <1 x double*> %ptrs, i32 8, <1 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v2f64.v2p0f64(<2 x double>, <2 x double*>, i32, <2 x i1>)

define void @mscatter_v2f64(<2 x double> %val, <2 x double*> %ptrs, <2 x i1> %m) {
; RV32-LABEL: mscatter_v2f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v2f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v9, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v2f64.v2p0f64(<2 x double> %val, <2 x double*> %ptrs, i32 8, <2 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v4f64.v4p0f64(<4 x double>, <4 x double*>, i32, <4 x i1>)

define void @mscatter_v4f64(<4 x double> %val, <4 x double*> %ptrs, <4 x i1> %m) {
; RV32-LABEL: mscatter_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4f64.v4p0f64(<4 x double> %val, <4 x double*> %ptrs, i32 8, <4 x i1> %m)
  ret void
}

define void @mscatter_truemask_v4f64(<4 x double> %val, <4 x double*> %ptrs) {
; RV32-LABEL: mscatter_truemask_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v10
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_truemask_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v10
; RV64-NEXT:    ret
  %mhead = insertelement <4 x i1> poison, i1 1, i32 0
  %mtrue = shufflevector <4 x i1> %mhead, <4 x i1> poison, <4 x i32> zeroinitializer
  call void @llvm.masked.scatter.v4f64.v4p0f64(<4 x double> %val, <4 x double*> %ptrs, i32 8, <4 x i1> %mtrue)
  ret void
}

define void @mscatter_falsemask_v4f64(<4 x double> %val, <4 x double*> %ptrs) {
; RV32-LABEL: mscatter_falsemask_v4f64:
; RV32:       # %bb.0:
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_falsemask_v4f64:
; RV64:       # %bb.0:
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v4f64.v4p0f64(<4 x double> %val, <4 x double*> %ptrs, i32 8, <4 x i1> zeroinitializer)
  ret void
}

declare void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double>, <8 x double*>, i32, <8 x i1>)

define void @mscatter_v8f64(<8 x double> %val, <8 x double*> %ptrs, <8 x i1> %m) {
; RV32-LABEL: mscatter_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (zero), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (zero), v12, v0.t
; RV64-NEXT:    ret
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i8_v8f64(<8 x double> %val, double* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf4 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i8> %idxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i8_v8f64(<8 x double> %val, double* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf8 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i8_v8f64(<8 x double> %val, double* %base, <8 x i8> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i8_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf8 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i8_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf8 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i8> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i16_v8f64(<8 x double> %val, double* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsext.vf2 v14, v12
; RV32-NEXT:    vsll.vi v12, v14, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i16> %idxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i16_v8f64(<8 x double> %val, double* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i16_v8f64(<8 x double> %val, double* %base, <8 x i16> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i16_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf4 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i16_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf4 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i16> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8i32_v8f64(<8 x double> %val, double* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i32> %idxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_sext_v8i32_v8f64(<8 x double> %val, double* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_sext_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_sext_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = sext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_zext_v8i32_v8f64(<8 x double> %val, double* %base, <8 x i32> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_zext_v8i32_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vzext.vf2 v16, v12
; RV32-NEXT:    vsll.vi v12, v16, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_zext_v8i32_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vzext.vf2 v16, v12
; RV64-NEXT:    vsll.vi v12, v16, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %eidxs = zext <8 x i32> %idxs to <8 x i64>
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %eidxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

define void @mscatter_baseidx_v8f64(<8 x double> %val, double* %base, <8 x i64> %idxs, <8 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v8f64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV32-NEXT:    vsll.vi v12, v12, 3
; RV32-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32-NEXT:    vnsrl.wx v16, v12, zero
; RV32-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v8f64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 8, e64, m4, ta, mu
; RV64-NEXT:    vsll.vi v12, v12, 3
; RV64-NEXT:    vsoxei64.v v8, (a0), v12, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds double, double* %base, <8 x i64> %idxs
  call void @llvm.masked.scatter.v8f64.v8p0f64(<8 x double> %val, <8 x double*> %ptrs, i32 8, <8 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v16i8.v16p0i8(<16 x i8>, <16 x i8*>, i32, <16 x i1>)

define void @mscatter_baseidx_v16i8(<16 x i8> %val, i8* %base, <16 x i8> %idxs, <16 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, mu
; RV32-NEXT:    vsext.vf4 v12, v9
; RV32-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v12, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v9
; RV64-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <16 x i8> %idxs
  call void @llvm.masked.scatter.v16i8.v16p0i8(<16 x i8> %val, <16 x i8*> %ptrs, i32 1, <16 x i1> %m)
  ret void
}

declare void @llvm.masked.scatter.v32i8.v32p0i8(<32 x i8>, <32 x i8*>, i32, <32 x i1>)

define void @mscatter_baseidx_v32i8(<32 x i8> %val, i8* %base, <32 x i8> %idxs, <32 x i1> %m) {
; RV32-LABEL: mscatter_baseidx_v32i8:
; RV32:       # %bb.0:
; RV32-NEXT:    li a1, 32
; RV32-NEXT:    vsetvli zero, a1, e32, m8, ta, mu
; RV32-NEXT:    vsext.vf4 v16, v10
; RV32-NEXT:    vsetvli zero, zero, e8, m2, ta, mu
; RV32-NEXT:    vsoxei32.v v8, (a0), v16, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: mscatter_baseidx_v32i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v10
; RV64-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    vsetivli zero, 16, e8, m2, ta, mu
; RV64-NEXT:    vslidedown.vi v8, v8, 16
; RV64-NEXT:    vslidedown.vi v10, v10, 16
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, mu
; RV64-NEXT:    vsext.vf8 v16, v10
; RV64-NEXT:    vsetivli zero, 2, e8, mf4, ta, mu
; RV64-NEXT:    vslidedown.vi v0, v0, 2
; RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, mu
; RV64-NEXT:    vsoxei64.v v8, (a0), v16, v0.t
; RV64-NEXT:    ret
  %ptrs = getelementptr inbounds i8, i8* %base, <32 x i8> %idxs
  call void @llvm.masked.scatter.v32i8.v32p0i8(<32 x i8> %val, <32 x i8*> %ptrs, i32 1, <32 x i1> %m)
  ret void
}
