; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX940-NO-PRELOAD %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=1 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX940-PRELOAD-1 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=2 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX940-PRELOAD-2 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=4 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX940-PRELOAD-4 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx940 -amdgpu-kernarg-preload-count=8 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX940-PRELOAD-8 %s

; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx90a -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX90a-NO-PRELOAD %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx90a -amdgpu-kernarg-preload-count=1 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX90a-PRELOAD-1 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx90a -amdgpu-kernarg-preload-count=2 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX90a-PRELOAD-2 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx90a -amdgpu-kernarg-preload-count=4 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX90a-PRELOAD-4 %s
; RUN: llc -mtriple=amdgcn--amdhsa -mcpu=gfx90a -amdgpu-kernarg-preload-count=8 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX90a-PRELOAD-8 %s

define amdgpu_kernel void @ptr1_i8(ptr addrspace(1) %out, i8 %arg0) #0 {
; GFX940-NO-PRELOAD-LABEL: ptr1_i8:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: ptr1_i8:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: ptr1_i8:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: ptr1_i8:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: ptr1_i8:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: ptr1_i8:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: ptr1_i8:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: ptr1_i8:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: ptr1_i8:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: ptr1_i8:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i8 %arg0 to i32
  store i32 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @ptr1_i8_zext_arg(ptr addrspace(1) %out, i8 zeroext %arg0) #0 {
; GFX940-NO-PRELOAD-LABEL: ptr1_i8_zext_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: ptr1_i8_zext_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: ptr1_i8_zext_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: ptr1_i8_zext_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: ptr1_i8_zext_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    s_and_b32 s0, s4, 0xff
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: ptr1_i8_zext_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: ptr1_i8_zext_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: ptr1_i8_zext_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: ptr1_i8_zext_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: ptr1_i8_zext_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    s_and_b32 s2, s2, 0xff
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i8 %arg0 to i32
  store i32 %ext, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ptr1_i16_preload_arg(ptr addrspace(1) %out, i16 %arg0) #0 {
; GFX940-NO-PRELOAD-LABEL: ptr1_i16_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    s_and_b32 s0, s4, 0xffff
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: ptr1_i16_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    s_and_b32 s0, s4, 0xffff
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: ptr1_i16_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    s_and_b32 s0, s4, 0xffff
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: ptr1_i16_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    s_and_b32 s0, s4, 0xffff
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: ptr1_i16_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    s_and_b32 s0, s4, 0xffff
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: ptr1_i16_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: ptr1_i16_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: ptr1_i16_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: ptr1_i16_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: ptr1_i16_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i16 %arg0 to i32
  store i32 %ext, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ptr1_i32_preload_arg(ptr addrspace(1) %out, i32 %arg0) #0 {
; GFX940-NO-PRELOAD-LABEL: ptr1_i32_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: ptr1_i32_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: ptr1_i32_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: ptr1_i32_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: ptr1_i32_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: ptr1_i32_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: ptr1_i32_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: ptr1_i32_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: ptr1_i32_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: ptr1_i32_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store i32 %arg0, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @i32_ptr1_i32_preload_arg(i32 %arg0, ptr addrspace(1) %out, i32 %arg1) #0 {
; GFX940-NO-PRELOAD-LABEL: i32_ptr1_i32_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x8
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    s_add_i32 s0, s5, s4
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: i32_ptr1_i32_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX940-PRELOAD-1-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x8
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    s_add_i32 s0, s5, s4
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: i32_ptr1_i32_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX940-PRELOAD-2-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x8
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    s_add_i32 s0, s5, s4
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: i32_ptr1_i32_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX940-PRELOAD-4-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x8
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    s_add_i32 s0, s5, s4
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: i32_ptr1_i32_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dword s4, s[0:1], 0x10
; GFX940-PRELOAD-8-NEXT:    s_load_dword s5, s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x8
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    s_add_i32 s0, s5, s4
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: i32_ptr1_i32_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s2, s[4:5], 0x10
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    s_add_i32 s2, s3, s2
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: i32_ptr1_i32_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s2, s[4:5], 0x10
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    s_add_i32 s2, s3, s2
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: i32_ptr1_i32_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s2, s[4:5], 0x10
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    s_add_i32 s2, s3, s2
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: i32_ptr1_i32_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s2, s[4:5], 0x10
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    s_add_i32 s2, s3, s2
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: i32_ptr1_i32_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s2, s[4:5], 0x10
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s3, s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x8
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    s_add_i32 s2, s3, s2
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  %add = add i32 %arg0, %arg1
  store i32 %add, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @ptr1_i16_i16_preload_arg(ptr addrspace(1) %out, i16 %arg0, i16 %arg1) #0 {
; GFX940-NO-PRELOAD-LABEL: ptr1_i16_i16_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    s_lshr_b32 s0, s4, 16
; GFX940-NO-PRELOAD-NEXT:    s_and_b32 s1, s4, 0xffff
; GFX940-NO-PRELOAD-NEXT:    s_add_i32 s0, s1, s0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: ptr1_i16_i16_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    s_lshr_b32 s0, s4, 16
; GFX940-PRELOAD-1-NEXT:    s_and_b32 s1, s4, 0xffff
; GFX940-PRELOAD-1-NEXT:    s_add_i32 s0, s1, s0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: ptr1_i16_i16_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    s_lshr_b32 s0, s4, 16
; GFX940-PRELOAD-2-NEXT:    s_and_b32 s1, s4, 0xffff
; GFX940-PRELOAD-2-NEXT:    s_add_i32 s0, s1, s0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: ptr1_i16_i16_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    s_lshr_b32 s0, s4, 16
; GFX940-PRELOAD-4-NEXT:    s_and_b32 s1, s4, 0xffff
; GFX940-PRELOAD-4-NEXT:    s_add_i32 s0, s1, s0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: ptr1_i16_i16_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    s_lshr_b32 s0, s4, 16
; GFX940-PRELOAD-8-NEXT:    s_and_b32 s1, s4, 0xffff
; GFX940-PRELOAD-8-NEXT:    s_add_i32 s0, s1, s0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: ptr1_i16_i16_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    s_lshr_b32 s3, s2, 16
; GFX90a-NO-PRELOAD-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-NO-PRELOAD-NEXT:    s_add_i32 s2, s2, s3
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: ptr1_i16_i16_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    s_lshr_b32 s3, s2, 16
; GFX90a-PRELOAD-1-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-1-NEXT:    s_add_i32 s2, s2, s3
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: ptr1_i16_i16_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    s_lshr_b32 s3, s2, 16
; GFX90a-PRELOAD-2-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-2-NEXT:    s_add_i32 s2, s2, s3
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: ptr1_i16_i16_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    s_lshr_b32 s3, s2, 16
; GFX90a-PRELOAD-4-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-4-NEXT:    s_add_i32 s2, s2, s3
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: ptr1_i16_i16_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    s_lshr_b32 s3, s2, 16
; GFX90a-PRELOAD-8-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX90a-PRELOAD-8-NEXT:    s_add_i32 s2, s2, s3
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  %ext = zext i16 %arg0 to i32
  %ext1 = zext i16 %arg1 to i32
  %add = add i32 %ext, %ext1
  store i32 %add, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @ptr1_v2i8_preload_arg(ptr addrspace(1) %out, <2 x i8> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: ptr1_v2i8_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-NO-PRELOAD-NEXT:    global_store_short v0, v1, s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: ptr1_v2i8_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-1-NEXT:    global_store_short v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: ptr1_v2i8_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-2-NEXT:    global_store_short v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: ptr1_v2i8_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-4-NEXT:    global_store_short v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: ptr1_v2i8_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dword s4, s[0:1], 0x8
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s4
; GFX940-PRELOAD-8-NEXT:    global_store_short v0, v1, s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: ptr1_v2i8_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_short v0, v1, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: ptr1_v2i8_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_short v0, v1, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: ptr1_v2i8_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_short v0, v1, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: ptr1_v2i8_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_short v0, v1, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: ptr1_v2i8_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_short v0, v1, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <2 x i8> %in, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @byref_preload_arg(ptr addrspace(1) %out, ptr addrspace(4) byref(i32) align(256) %in.byref, i32 %after.offset) #0 {
; GFX940-NO-PRELOAD-LABEL: byref_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x100
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s3
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[4:5] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: byref_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x100
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s3
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v2, s[4:5] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: byref_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x100
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s3
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v2, s[4:5] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: byref_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x100
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s3
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v2, s[4:5] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: byref_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x100
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s3
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[4:5] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v2, s[4:5] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_waitcnt vmcnt(0)
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: byref_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x100
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s1
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[2:3]
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: byref_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x100
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s1
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v2, s[2:3]
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: byref_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x100
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s1
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v2, s[2:3]
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: byref_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x100
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s1
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v2, s[2:3]
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: byref_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x100
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s1
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v2, s[2:3]
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt vmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  %in = load i32, ptr addrspace(4) %in.byref
  store volatile i32 %in, ptr addrspace(1) %out, align 4
  store volatile i32 %after.offset, ptr addrspace(1) %out, align 4
  ret void
}


define amdgpu_kernel void @v8i32_arg(ptr addrspace(1) nocapture %out, <8 x i32> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: v8i32_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16 sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_nop 1
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: v8i32_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16 sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_nop 1
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: v8i32_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16 sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_nop 1
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: v8i32_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16 sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_nop 1
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: v8i32_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x20
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16 sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_nop 1
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: v8i32_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX90a-NO-PRELOAD-NEXT:    s_nop 0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: v8i32_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX90a-PRELOAD-1-NEXT:    s_nop 0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: v8i32_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX90a-PRELOAD-2-NEXT:    s_nop 0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: v8i32_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX90a-PRELOAD-4-NEXT:    s_nop 0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: v8i32_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x20
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] offset:16
; GFX90a-PRELOAD-8-NEXT:    s_nop 0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <8 x i32> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v3i16_preload_arg(ptr addrspace(1) nocapture %out, <3 x i16> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: v3i16_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-NO-PRELOAD-NEXT:    global_store_short v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: v3i16_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-1-NEXT:    global_store_short v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: v3i16_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-2-NEXT:    global_store_short v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: v3i16_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-4-NEXT:    global_store_short v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: v3i16_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-8-NEXT:    global_store_short v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: v3i16_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_short v0, v1, s[0:1] offset:4
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: v3i16_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_short v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: v3i16_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_short v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: v3i16_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_short v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: v3i16_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_short v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <3 x i16> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v3i32_preload_arg(ptr addrspace(1) nocapture %out, <3 x i32> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: v3i32_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: v3i32_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: v3i32_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: v3i32_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: v3i32_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: v3i32_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: v3i32_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: v3i32_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: v3i32_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: v3i32_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <3 x i32> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v3f32_preload_arg(ptr addrspace(1) nocapture %out, <3 x float> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: v3f32_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: v3f32_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: v3f32_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: v3f32_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: v3f32_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x10
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx3 v3, v[0:2], s[2:3] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: v3f32_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: v3f32_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: v3f32_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: v3f32_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: v3f32_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x10
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s1
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx3 v3, v[0:2], s[6:7]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <3 x float> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v5i8_preload_arg(ptr addrspace(1) nocapture %out, <5 x i8> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: v5i8_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-NO-PRELOAD-NEXT:    global_store_byte v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: v5i8_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-1-NEXT:    global_store_byte v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-1-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: v5i8_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-2-NEXT:    global_store_byte v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-2-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: v5i8_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-4-NEXT:    global_store_byte v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-4-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: v5i8_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s2
; GFX940-PRELOAD-8-NEXT:    global_store_byte v0, v1, s[0:1] offset:4 sc0 sc1
; GFX940-PRELOAD-8-NEXT:    global_store_dword v0, v2, s[0:1] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: v5i8_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-NO-PRELOAD-NEXT:    global_store_byte v0, v1, s[0:1] offset:4
; GFX90a-NO-PRELOAD-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: v5i8_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-1-NEXT:    global_store_byte v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-1-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: v5i8_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-2-NEXT:    global_store_byte v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-2-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: v5i8_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-4-NEXT:    global_store_byte v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-4-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: v5i8_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s2
; GFX90a-PRELOAD-8-NEXT:    global_store_byte v0, v1, s[0:1] offset:4
; GFX90a-PRELOAD-8-NEXT:    global_store_dword v0, v2, s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <5 x i8> %in, ptr addrspace(1) %out, align 4
  ret void
}

define amdgpu_kernel void @v5f64_arg(ptr addrspace(1) nocapture %out, <5 x double> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: v5f64_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x60
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx2 v4, v[2:3], s[12:13] offset:32 sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] offset:16 sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_nop 1
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: v5f64_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x60
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx2 v4, v[2:3], s[12:13] offset:32 sc0 sc1
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] offset:16 sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_nop 1
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: v5f64_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x60
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx2 v4, v[2:3], s[12:13] offset:32 sc0 sc1
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] offset:16 sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_nop 1
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: v5f64_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x60
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx2 v4, v[2:3], s[12:13] offset:32 sc0 sc1
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] offset:16 sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_nop 1
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: v5f64_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x60
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx8 s[4:11], s[0:1], 0x40
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx2 s[12:13], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b64_e32 v[2:3], s[2:3]
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s8
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx2 v4, v[2:3], s[12:13] offset:32 sc0 sc1
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s9
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s10
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s11
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] offset:16 sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_nop 1
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s4
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s5
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s6
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s7
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[12:13] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: v5f64_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x60
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x40
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_pk_mov_b32 v[2:3], s[0:1], s[0:1] op_sel:[0,1]
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16
; GFX90a-NO-PRELOAD-NEXT:    s_nop 0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: v5f64_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x60
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x40
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_pk_mov_b32 v[2:3], s[0:1], s[0:1] op_sel:[0,1]
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16
; GFX90a-PRELOAD-1-NEXT:    s_nop 0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: v5f64_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x60
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x40
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_pk_mov_b32 v[2:3], s[0:1], s[0:1] op_sel:[0,1]
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16
; GFX90a-PRELOAD-2-NEXT:    s_nop 0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: v5f64_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x60
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x40
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_pk_mov_b32 v[2:3], s[0:1], s[0:1] op_sel:[0,1]
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16
; GFX90a-PRELOAD-4-NEXT:    s_nop 0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: v5f64_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x60
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x40
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v4, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_pk_mov_b32 v[2:3], s[0:1], s[0:1] op_sel:[0,1]
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s12
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx2 v4, v[2:3], s[2:3] offset:32
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s13
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s14
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s15
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3] offset:16
; GFX90a-PRELOAD-8-NEXT:    s_nop 0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s8
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s9
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, s10
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v3, s11
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx4 v4, v[0:3], s[2:3]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <5 x double> %in, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @v8i8_preload_arg(ptr addrspace(1) %out, <8 x i8> %in) #0 {
; GFX940-NO-PRELOAD-LABEL: v8i8_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b64_e32 v[0:1], s[2:3]
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: v8i8_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b64_e32 v[0:1], s[2:3]
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: v8i8_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b64_e32 v[0:1], s[2:3]
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: v8i8_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b64_e32 v[0:1], s[2:3]
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: v8i8_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b64_e32 v[0:1], s[2:3]
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: v8i8_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_pk_mov_b32 v[0:1], s[2:3], s[2:3] op_sel:[0,1]
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: v8i8_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_pk_mov_b32 v[0:1], s[2:3], s[2:3] op_sel:[0,1]
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: v8i8_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_pk_mov_b32 v[0:1], s[2:3], s[2:3] op_sel:[0,1]
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: v8i8_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_pk_mov_b32 v[0:1], s[2:3], s[2:3] op_sel:[0,1]
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: v8i8_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_pk_mov_b32 v[0:1], s[2:3], s[2:3] op_sel:[0,1]
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store <8 x i8> %in, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @i64_kernel_preload_arg(ptr addrspace(1) %out, i64 %a) #0 {
; GFX940-NO-PRELOAD-LABEL: i64_kernel_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: i64_kernel_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: i64_kernel_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: i64_kernel_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: i64_kernel_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: i64_kernel_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: i64_kernel_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: i64_kernel_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: i64_kernel_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: i64_kernel_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store i64 %a, ptr addrspace(1) %out, align 8
  ret void
}

define amdgpu_kernel void @f64_kernel_preload_arg(ptr addrspace(1) %out, double %in) #0 {
; GFX940-NO-PRELOAD-LABEL: f64_kernel_preload_arg:
; GFX940-NO-PRELOAD:       ; %bb.0:
; GFX940-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX940-PRELOAD-1-LABEL: f64_kernel_preload_arg:
; GFX940-PRELOAD-1:       ; %bb.0:
; GFX940-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-1-NEXT:    s_endpgm
;
; GFX940-PRELOAD-2-LABEL: f64_kernel_preload_arg:
; GFX940-PRELOAD-2:       ; %bb.0:
; GFX940-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-2-NEXT:    s_endpgm
;
; GFX940-PRELOAD-4-LABEL: f64_kernel_preload_arg:
; GFX940-PRELOAD-4:       ; %bb.0:
; GFX940-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-4-NEXT:    s_endpgm
;
; GFX940-PRELOAD-8-LABEL: f64_kernel_preload_arg:
; GFX940-PRELOAD-8:       ; %bb.0:
; GFX940-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x0
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-PRELOAD-8-NEXT:    s_endpgm
;
; GFX90a-NO-PRELOAD-LABEL: f64_kernel_preload_arg:
; GFX90a-NO-PRELOAD:       ; %bb.0:
; GFX90a-NO-PRELOAD-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-NO-PRELOAD-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-NO-PRELOAD-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-NO-PRELOAD-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-NO-PRELOAD-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-1-LABEL: f64_kernel_preload_arg:
; GFX90a-PRELOAD-1:       ; %bb.0:
; GFX90a-PRELOAD-1-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-1-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-1-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-1-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-1-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-2-LABEL: f64_kernel_preload_arg:
; GFX90a-PRELOAD-2:       ; %bb.0:
; GFX90a-PRELOAD-2-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-2-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-2-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-2-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-2-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-4-LABEL: f64_kernel_preload_arg:
; GFX90a-PRELOAD-4:       ; %bb.0:
; GFX90a-PRELOAD-4-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-4-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-4-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-4-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-4-NEXT:    s_endpgm
;
; GFX90a-PRELOAD-8-LABEL: f64_kernel_preload_arg:
; GFX90a-PRELOAD-8:       ; %bb.0:
; GFX90a-PRELOAD-8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v2, 0
; GFX90a-PRELOAD-8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v0, s2
; GFX90a-PRELOAD-8-NEXT:    v_mov_b32_e32 v1, s3
; GFX90a-PRELOAD-8-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX90a-PRELOAD-8-NEXT:    s_endpgm
  store double %in, ptr addrspace(1) %out
  ret void
}

attributes #0 = { "amdgpu-no-agpr" "amdgpu-no-completion-action" "amdgpu-no-default-queue" "amdgpu-no-dispatch-id" "amdgpu-no-dispatch-ptr" "amdgpu-no-heap-ptr" "amdgpu-no-hostcall-ptr" "amdgpu-no-lds-kernel-id" "amdgpu-no-multigrid-sync-arg" "amdgpu-no-queue-ptr" "amdgpu-no-workgroup-id-x" "amdgpu-no-workgroup-id-y" "amdgpu-no-workgroup-id-z" "amdgpu-no-workitem-id-x" "amdgpu-no-workitem-id-y" "amdgpu-no-workitem-id-z" }
