; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

; REQUIRES: has_logf128
declare fp128 @llvm.log.f128(fp128)
declare fp128 @logl(fp128)

define fp128 @log_e_64(){
; CHECK-LABEL: define fp128 @log_e_64() {
; CHECK-NEXT:    ret fp128 0xL300000000000000040010A2B23F3BAB7
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000004005000000000000)
  ret fp128 %A
}

define fp128 @log_e_smallest_positive_subnormal_number(){
; CHECK-LABEL: define fp128 @log_e_smallest_positive_subnormal_number() {
; CHECK-NEXT:    ret fp128 0xL3000000000000000C00C654628220780
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000010000000000000000)
  ret fp128 %A
}

define fp128 @log_e_largest_subnormal_number(){
; CHECK-LABEL: define fp128 @log_e_largest_subnormal_number() {
; CHECK-NEXT:    ret fp128 0xLD000000000000000C00C62D918CE2421
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xLFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF)
  ret fp128 %A
}

define fp128 @log_e_smallest_positive_normal_number(){
;
; CHECK-LABEL: define fp128 @log_e_smallest_positive_normal_number() {
; CHECK-NEXT:    ret fp128 0xLD000000000000000C00C62D918CE2421
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000000001000000000000)
  ret fp128 %A
}

define fp128 @log_e_largest_normal_number(){
; CHECK-LABEL: define fp128 @log_e_largest_normal_number() {
; CHECK-NEXT:    ret fp128 0xLF000000000000000400C62E42FEFA39E
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xLFFFFFFFFFFFFFFFF7FFEFFFFFFFFFFFF)
  ret fp128 %A
}

define fp128 @log_e_largest_number_less_than_one(){
; CHECK-LABEL: define fp128 @log_e_largest_number_less_than_one() {
; CHECK-NEXT:    ret fp128 0xL0000000000000000BF8E000000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xLFFFFFFFFFFFFFFFF3FFEFFFFFFFFFFFF)
  ret fp128 %A
}

define fp128 @log_e_1(){
; CHECK-LABEL: define fp128 @log_e_1() {
; CHECK-NEXT:    ret fp128 0xL00000000000000000000000000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000003FFF000000000000)
  ret fp128 %A
}

define fp128 @log_e_smallest_number_larger_than_one(){
; CHECK-LABEL: define fp128 @log_e_smallest_number_larger_than_one() {
; CHECK-NEXT:    ret fp128 0xL00000000000000003F8F000000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000013FFF000000000000)
  ret fp128 %A
}

define fp128 @log_e_negative_2(){
; CHECK-LABEL: define fp128 @log_e_negative_2() {
; CHECK-NEXT:    ret fp128 0xL00000000000000007FFF800000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL0000000000000000C000000000000000)
  ret fp128 %A
}

define fp128 @log_e_0(){
; CHECK-LABEL: define fp128 @log_e_0() {
; CHECK-NEXT:    ret fp128 0xL0000000000000000FFFF000000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000000000000000000000)
  ret fp128 %A
}

define fp128 @log_e_negative_0(){
; CHECK-LABEL: define fp128 @log_e_negative_0() {
; CHECK-NEXT:    ret fp128 0xL0000000000000000FFFF000000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000008000000000000000)
  ret fp128 %A
}

define fp128 @log_e_infinity(){
; CHECK-LABEL: define fp128 @log_e_infinity() {
; CHECK-NEXT:    ret fp128 0xL00000000000000007FFF000000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000007FFF000000000000)
  ret fp128 %A
}

define fp128 @log_e_negative_infinity(){
; CHECK-LABEL: define fp128 @log_e_negative_infinity() {
; CHECK-NEXT:    ret fp128 0xL00000000000000007FFF800000000000
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL0000000000000000FFFF000000000000)
  ret fp128 %A
}

define fp128 @log_e_nan(){
; CHECK-LABEL: define fp128 @log_e_nan() {
; CHECK-NEXT:    ret fp128 0xL00000000000000007FFF800000000001
;
  %A = call fp128 @llvm.log.f128(fp128 noundef 0xL00000000000000007FFF000000000001)
  ret fp128 %A
}

define <2 x fp128> @log_e_negative_2_vector(){
; CHECK-LABEL: define <2 x fp128> @log_e_negative_2_vector() {
; CHECK-NEXT:    ret <2 x fp128> <fp128 0xL00000000000000007FFF800000000000, fp128 0xL00000000000000007FFF800000000000>
;
  %A = call <2 x fp128> @llvm.log.v2f128(<2 x fp128> <fp128 0xL0000000000000000C000000000000000, fp128 0xL0000000000000000C000000000000001>)
  ret <2 x fp128> %A
}

define fp128 @logl_e_64(){
; CHECK-LABEL: define fp128 @logl_e_64() {
; CHECK-NEXT:    [[A:%.*]] = call fp128 @logl(fp128 noundef 0xL00000000000000004005000000000000)
; CHECK-NEXT:    ret fp128 0xL300000000000000040010A2B23F3BAB7
;
  %A = call fp128 @logl(fp128 noundef 0xL00000000000000004005000000000000)
  ret fp128 %A
}

define fp128 @logl_e_0(){
; CHECK-LABEL: define fp128 @logl_e_0() {
; CHECK-NEXT:    [[A:%.*]] = call fp128 @logl(fp128 noundef 0xL00000000000000000000000000000000)
; CHECK-NEXT:    ret fp128 [[A]]
;
  %A = call fp128 @logl(fp128 noundef 0xL00000000000000000000000000000000)
  ret fp128 %A
}

define fp128 @logl_e_infinity(){
; CHECK-LABEL: define fp128 @logl_e_infinity() {
; CHECK-NEXT:    [[A:%.*]] = call fp128 @logl(fp128 noundef 0xL00000000000000007FFF000000000000)
; CHECK-NEXT:    ret fp128 0xL00000000000000007FFF000000000000
;
  %A = call fp128 @logl(fp128 noundef 0xL00000000000000007FFF000000000000)
  ret fp128 %A
}

define fp128 @logl_e_nan(){
; CHECK-LABEL: define fp128 @logl_e_nan() {
; CHECK-NEXT:    [[A:%.*]] = call fp128 @logl(fp128 noundef 0xL00000000000000007FFF000000000001)
; CHECK-NEXT:    ret fp128 [[A]]
;
  %A = call fp128 @logl(fp128 noundef 0xL00000000000000007FFF000000000001)
  ret fp128 %A
}


define fp128 @logl_e_negative_2(){
; CHECK-LABEL: define fp128 @logl_e_negative_2() {
; CHECK-NEXT:    [[A:%.*]] = call fp128 @logl(fp128 noundef 0xL0000000000000000C000000000000000)
; CHECK-NEXT:    ret fp128 [[A]]
;
  %A = call fp128 @logl(fp128 noundef 0xL0000000000000000C000000000000000)
  ret fp128 %A
}
