; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt --code-model=large < %s | FileCheck %s --check-prefixes=OPT
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-small-local-dynamic-tls --code-model=large < %s | FileCheck %s --check-prefixes=SMALL
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-altivec -mtriple powerpc64-ibm-aix-xcoff \
; RUN:      -mattr=+aix-shared-lib-tls-model-opt -mattr=+aix-small-local-dynamic-tls \
; RUN:      --code-model=large < %s | FileCheck %s --check-prefixes=BOTH

@VarTLSLD1 = internal thread_local(localdynamic) global i32 42, align 4

define i32 @Single_LD(i32 %P, i32 %Q) {
; OPT-LABEL: Single_LD:
; OPT:       # %bb.0: # %entry
; OPT-NEXT:    and 4, 3, 4
; OPT-NEXT:    addis 3, L..C0@u(2)
; OPT-NEXT:    ld 3, L..C0@l(3)
; OPT-NEXT:    cmpwi 4, -1
; OPT-NEXT:    lwzx 3, 13, 3
; OPT-NEXT:    blr
;
; SMALL-LABEL: Single_LD:
; SMALL:       # %bb.0: # %entry
; SMALL-NEXT:    mflr 0
; SMALL-NEXT:    stdu 1, -48(1)
; SMALL-NEXT:    and 6, 3, 4
; SMALL-NEXT:    addis 3, L..C0@u(2)
; SMALL-NEXT:    std 0, 64(1)
; SMALL-NEXT:    ld 3, L..C0@l(3)
; SMALL-NEXT:    bla .__tls_get_mod[PR]
; SMALL-NEXT:    cmpwi 6, -1
; SMALL-NEXT:    lwz 3, VarTLSLD1[TL]@ld(3)
; SMALL-NEXT:    addi 1, 1, 48
; SMALL-NEXT:    ld 0, 16(1)
; SMALL-NEXT:    mtlr 0
; SMALL-NEXT:    blr
;
; BOTH-LABEL: Single_LD:
; BOTH:       # %bb.0: # %entry
; BOTH-NEXT:    and 4, 3, 4
; BOTH-NEXT:    addis 3, L..C0@u(2)
; BOTH-NEXT:    ld 3, L..C0@l(3)
; BOTH-NEXT:    cmpwi 4, -1
; BOTH-NEXT:    lwzx 3, 13, 3
; BOTH-NEXT:    blr
entry:
  %a = icmp slt i32 %P, 0
  %b = icmp slt i32 %Q, 0
  %c = and i1 %a, %b
  %tls1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD1)
  %load1 = load i32, ptr %tls1, align 4
  br i1 %c, label %bb1, label %return

bb1:
  %tls2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @VarTLSLD1)
  %load2 = load i32, ptr %tls2, align 4
  ret i32 %load2

return:
  ret i32 %load1
}

; OPT-LABEL: .toc
; OPT-LABEL: L..C0:
; OPT-NEXT: .tc VarTLSLD1[TE],VarTLSLD1[TL]@ie

; SMALL-LABEL: .toc
; SMALL-LABEL: L..C0:
; SMALL-NEXT: .tc _Renamed..5f24__TLSML[TC],_Renamed..5f24__TLSML[TC]@ml
; SMALL-NEXT: .rename _Renamed..5f24__TLSML[TC],"_$TLSML"

; BOTH-LABEL: .toc
; BOTH-LABEL: L..C0:
; BOTH-NEXT: .tc VarTLSLD1[TE],VarTLSLD1[TL]@ie
