import unittest
from aminer.parsing.MatchContext import MatchContext
from aminer.parsing.HexStringModelElement import HexStringModelElement


class HexStringModelElementTest(unittest.TestCase):
    """Unittests for the HexStringModelElement."""

    def test1check_all_values(self):
        """Try all values and check if the desired results are produced."""
        allowed_chars = [b'0', b'1', b'2', b'3', b'4', b'5', b'6', b'7', b'8', b'9', b'a', b'b', b'c', b'd', b'e', b'f']
        char1 = b'\x00'
        char2 = b'\x00'
        hex_string_model_element = HexStringModelElement('id')

        while ord(char2) < ord(b'\x7F'):
            match_context = MatchContext(char2 + char1)
            match_element = hex_string_model_element.get_match_element('match', match_context)
            if char2 in allowed_chars and char1 in allowed_chars:
                self.assertEqual(match_element.get_match_object(), char2 + char1)
            else:
                self.assertEqual(match_element, None)
            if ord(char1) == 0x7f:
                char1 = b'\x00'
                char2 = bytes(chr(ord(char2) + 1), 'utf-8')
            else:
                char1 = bytes(chr(ord(char1) + 1), 'utf-8')

        allowed_chars = [b'0', b'1', b'2', b'3', b'4', b'5', b'6', b'7', b'8', b'9', b'A', b'B', b'C', b'D', b'E', b'F']
        char1 = b'\x00'
        char2 = b'\x00'
        hex_string_model_element = HexStringModelElement('id', True)

        while ord(char2) < ord(b'\x7F'):
            match_context = MatchContext(char2 + char1)
            match_element = hex_string_model_element.get_match_element('match', match_context)
            if char2 in allowed_chars and char1 in allowed_chars:
                self.assertEqual(match_element.get_match_object(), char2 + char1)
            else:
                self.assertEqual(match_element, None)
            if ord(char1) == 0x7f:
                char1 = b'\x00'
                char2 = bytes(chr(ord(char2) + 1), 'utf-8')
            else:
                char1 = bytes(chr(ord(char1) + 1), 'utf-8')


if __name__ == "__main__":
    unittest.main()
