.TH CHECKPC 8 2007-02-22 "LPRng" "checkpc command"
.SH NAME
checkpc \- check out the printcap database
.SH SYNOPSIS
.B checkpc
.RB [ " \-aflprsV " ]
.RB [ " \-A" \fIage\fP[ DHMS "] ]"
.RB [ " \-D\fIdebugflags\fP " ]
.RB [ " \-P\fIprinter\fP " ]
.RB [ " \-t " \fIsize\fP[ kM "] ]"
.SH DESCRIPTION
.B Checkpc
is used to check for the existence and correct permissions of entries
in the
.I printcap
database.
It is useful when installing a new printcap database and cleaning up
existing printer spoolers.
.TP
.B \-a
Do not create accounting files (:af).
.TP
.B \-f
The fix flag will cause the checkpc program create and fix
various files and permissions.
It does this in a simple minded manner,
and the program may have to be run several times until all permissions
are correct.
It also reports in extremely verbose details its actions.
.TP
.B \-l
Do not create log files (:lf).
.TP
.B \-p
Print verbose printcap information.
Useful if interested in the printcap values.
.TP
.B \-r
remove junk or job files older than the age set by -A.
You must set the age to a non-zero value otherwise no files are removed.
.TP
.B \-s
Do not create filter status files (:ps).
.TP
.B "\-A \fIAge\fR[\fBDHMS\fR]"
Report junk or job files older than age.
The age time can have a suffix
days (D)
hours (H),
minutes (M),
or
seconds (S);
default is days.
.TP
.BI "\-D " debugflags
Run the program with debugging flags.
See the LPRng HOWTO for details of the flags actions.
.TP
.B \-V
Verbose mode.
.TP
.BI "\-P " printer
Process only the specified print queue.
.TP
.B "\-t \fIsize\fR[\fBkM\fR]"
Truncate log files (:lf) to the specified size in Kbytes
or Mbytes (default is Mbytes).
.TP
.BI "\-T " serial-line
set process name and start feature test
.SH "ANNOYING FEATURES"
If the
.BR \-f (fix)
option is specified and you do not run this as root,
it will complain,
but attempt to carry out the operations.
This will lead to a large number of failures reports
if the ownership and/or permissions are incorrect.
.SH FILES
The files used by LPRng are set by values in the
printer configuration file and by configuration options.
The following are a commonly used set of default values.
.nf
.ta \w'/var/spool/lpd/printcap.<hostname>           'u
_LPD_CONF_PATH_	LPRng configuration file
${HOME}/.printcap	user printer description file
_PRINTCAP_PATH_	printer description file
_LPD_PERMS_PATH_	permissions
_LOCKFILE_	lock file for queue control
/var/spool/lpd		spool directories
/var/spool/lpd/QUEUE/control	queue control
/var/spool/lpd/QUEUE/log	trace or debug log file
/var/spool/lpd/QUEUE/acct	accounting file
/var/spool/lpd/QUEUE/status	status file
.fi
.SH "SEE ALSO"
.BR lpd.conf (5),
.BR lpc (8),
.BR lpd (8),
.BR lpr (1),
.BR lpq (1),
.BR lprm (1),
.BR printcap (5),
.BR lpd.perms (5),
.BR pr (1),
.BR lprng_certs (1),
.BR lprng_index_certs (1).
.SH "AUTHOR"
Patrick Powell <papowell@lprng.com>.
.SH DIAGNOSTICS
Most of the diagnostics are self explanatory.
If you are puzzled over the exact cause of failure,
set the debugging level on (-D5) and run again.

The debugging information will
help you to pinpoint the exact cause of failure.
.SH "HISTORY"
LPRng is a enhanced printer spooler system
with functionality similar to the Berkeley LPR software.
The LPRng developer mailing list is lprng-devel@lists.sourceforge.net;
subscribe by visiting
.B https://lists.sourceforge.net/lists/listinfo/lprng-devel
or sending mail to
.B lprng-request@lists.sourceforge.net
with
the word
.I subscribe
in the body.
.br
The software is available via
.B http://lprng.sourceforge.net
