---
disqus: emacs-lsp 
---

# 7.0 Release

I am pleased to announce `lsp-mode` 7.0!

Here are the most important features/news in 7.0 release

## lsp-mode/the team/the ecosystem

`lsp-mode` team and the activity in the repo has vastly increased. `lsp-mode` is
no longer one man project but it is a product of `Emacs LSP` team and emacs
community. This has allowed us to implement some very time consuming
changes/refactoring(more about them bellow) which an year ago were unthinkable
due to the lack manpower. `emacs-lsp` repo has become a nice place to start
contributing to open source or learn `elisp` and now there are 244 contributors
in the main repo. Even more some of the current maintainers had zero elisp
knowledge before doing their first `lsp-mode` contributions.

We started moving out some of the server specific packages(e. g. [lsp-dart](https://emacs-lsp.github.io/lsp-dart)
maintained by [ericdallo](https://github.com/ericdallo) and [lsp-metals](https://emacs-lsp.github.io/lsp-metals) 
maintained by [kurnevsky](https://github.com/kurnevsky), [lsp-python-ms](https://emacs-lsp.github.io/lsp-python-ms) 
by [seagle0128](https://github.com/seagle0128), etc) in order to provide focused 
support by a an expert in the language at hand. Considering where we were few months ago the
level of integrated experience provided by those packages has increased and
often it is comparable with backed by paid full time developers editors like
`VScode`. Here it is a gif illustrating that: [lsp-dart](https://files.gitter.im/emacs-lsp/lsp-mode/1kGs/lsp-dart-dap-flutter.gif). 
LSP in its nature should be language agnostic but in order to be comparable with `VScode`
`lsp-mode` should support language server extensions as well which is much more
work than the work on protocol itself and requires a constant monitoring of the
server repo since there is no contract and the server team might change the
contract whenever they want. On the bright side `lsp-mode` has attracted several
server side developers or `lsp-mode` team members(e. g. [mpanarin](https://github.com/mpanarin)) 
has become server side contributors and often we are ahead of changes or we directly
address issues in the server when they arise. We are still looking for
maintainer(s) for JS/TS suite(`typescript-language-server`, `eslint`, `angular`)
though.

## Major features

### 3.16 spec support
We provided full support for 3.14 features one year after the version has been
released. Now, we have support for all major features of 3.16 protocol even
before it has been released (except for result streaming which apparently hasn't
been implemented by any language server).

### New website
It is created [ericdallo](https://github.com/ericdallo) - here it is the [website]( https://emacs-lsp.github.io/lsp-mode/ ). 
Check it out and eventually provide feedback.

### Semantic highlights
This is part of 3.16 spec. It is implemented by [sebastiansturm](https://github.com/sebastiansturm) 
and it can be enabled by setting `lsp-enable-semantic-highlighting`. We have dropped the Theia
protocol support for semantic highlighting since it is not going to make to the
official spec. ATM it is supported by `Rust Analyzer`, `Clangd`(from master
branch) and `lua` language server.

### org-mode integration(preview)
`org-mode` mode is the `Emacs` flagman and this integration brings up the
literate programming to a new level. The integration is pretty raw but usable -
you basically can run `lsp-mode` language intelligence over `org-mode` source
block directly in the `org-mode` document. We have achieved that by creating
virtual buffer abstraction which allows us to fake the server that the client
has actually opened the real file.

Check [gif](https://github.com/emacs-lsp/lsp-mode/blob/master/examples/org-mode.gif) and the [docs](https://github.com/emacs-lsp/lsp-mode/blob/master/docs/page/lsp-org.md).

I think that the ability to implement such features is why **`Emacs` is editor in
a league of its own**. And implementing such features is one of the signs that we
are slowly moving from the phase *catching up* into *getting ahead* (or maybe I
am overly optimistic).

### Language Server Protocol bindings, upcoming changes

We generated json schema from the protocol and from that schema we generated
`dash` destructoring, getters, setters, validators, constructors, indication for
optional/required fields, etc. which allow us to perform compile time validation
of the protocol usage. This was huge change because we had to walk through
almost all methods and replace explicit access to the elisp data structure with
protocol usage. At the same time, `emacs-lsp` organization has more than 20k
lines of code. This was coordinated effort and a lot of individuals contributed
to that. The benefits are that we now can switch the underlying data structure
from `hashmap` to `plists` which will yield better performance and also that the
overall quality of the codebase has increased. Example

Before:

``` emacs-lisp
(defun lsp--position-to-point (params)
  "Convert Position object in PARAMS to a point."
  (lsp--line-character-to-point (gethash "line" params)
                                (gethash "character" params)))
```

After:
``` emacs-lisp
(lsp-defun lsp--position-to-point ((&Position :line :character))
  "Convert `Position' object in PARAMS to a point."
  (lsp--line-character-to-point line character))
```

In this example `:line` and `:character` are validated as fields of `Position`
structure. Also, we do some handy conversions, if the field is optional it will
end up with `?` like `:foo?`. To reduce boiler plate code we convert `camelCase`
to `:camel-case` when we are destructoring it.

### Performance optimizations(flycheck, code completion)
We have rewritten the `flycheck` integration - the new integration provides the
same `UE` as the old one but it is much more effective in reporting the errors
to `flycheck` and `lsp` checker is much closer to the traditional `flycheck`
checkers which are initiated/controlled from `Emacs`. Completion integration
code is now much simpler/faster thanks to [kiennq](https://github.com/kiennq).

## What's next
- Upcoming breaking changes
  - Dropping `Emacs 25` support. This will allow us utilize Emacs multi-threading
  to improve `lsp-mode` responsibility
  - Switching from hashtables to plists - once this change goes in users must
  recompile all `lsp-mode` extensions.
  - Drop `company-lsp` support(not ported to use `lsp-protocol.el`)
- Implementing `lsp-mode` configuration wizard to improve beginners experience -
  check this [issue](https://github.com/emacs-lsp/lsp-mode/issues/1813) for more
  details. The overall goal is let user pick settings for all features that are
  opinionated (e. g. `lsp-ui`) and improve the discoverability of `lsp-mode`
  features/extensions/settings.
- We will try to switch to monthly/weakly release cycles and to different person
  for writing the announcements. We might eventually encourage `melpa-stable`
  usage.
