/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class FindDeviceEthernet 
* \brief Class that tries to find apogee devices on the ethernet.
* 
*/ 


#ifndef FINDDEVICEETHERNET_INCLUDE_H__ 
#define FINDDEVICEETHERNET_INCLUDE_H__ 


#include <string>
#include <stdint.h>
#include "DefDllExport.h"

class UdpSocketBase;

class DLL_EXPORT FindDeviceEthernet 
{ 
    public: 

        /*! 
         */
        FindDeviceEthernet();

        /*! 
         */
        virtual ~FindDeviceEthernet(); 


        /*! 
         * Start search for Apogee ethernet device on a particular subnet
         * \param [in]  subnet Subnet address to search, 192.168.0.255 for example.
         * \return Returns a <d></d> demlited string with the ethernet devices found .  A
         * null string of <d></d> is returned if no device is found. Example of one camera string 
         * \verbatim <d>address=192.168.0.20,interface=ethernet,port=80,mac=0009510000FF,deviceType=camera,id=0xfeff,firmwareRev=0x0</d> \endverbatim
         */
        std::string Find(const std::string & subnet);

         /*! 
         * Returns The number of seconds the search has taken
         */
        int32_t GetElapsedSecs();

         /*! 
         * Returns Socket time out value
         */
        int32_t GetTimeout();
    private:
        std::string MakeDeviceStr(const std::string & input);
        void GetId( const std::string & input, std::string & id );
        void GetFirmwareRev( const std::string & input, std::string & firmwareRev );
        void GetIpAddr( const std::string & input, std::string & ipAddr );
        void GetPort( const std::string & input, std::string & port );
        void GetMacAddr( const std::string & input, std::string & mac );
        void GetInterfaceStatus( const std::string & input, std::string & interfaceStatus );
        std::string CameraInfo(const std::string & rawIdStr, 
                                           const std::string & frmwRevStr);

        const std::string m_fileName;
        const std::string m_CamResponse;
        UdpSocketBase * m_socketPtr;


        //disabling the copy ctor and assignment operator
        //generated by the compiler - don't want them
        //Effective C++ Item 6
        FindDeviceEthernet(const FindDeviceEthernet&);
        FindDeviceEthernet& operator=(FindDeviceEthernet&);


}; 

#endif
