.\"
.\" nfsd(8)
.\"
.\" Copyright (C) 1999 Olaf Kirch <okir@monad.swb.de>
.TH rpc.nfsd 8 "20 Feb 2014"
.SH NAME
rpc.nfsd \- NFS server process
.SH SYNOPSIS
.BI "/usr/sbin/rpc.nfsd [" options "]" " "nproc
.SH DESCRIPTION
The
.B rpc.nfsd
program implements the user level part of the NFS service. The
main functionality is handled by the
.B nfsd
kernel module. The user space program merely specifies what sort of sockets
the kernel service should listen on, what NFS versions it should support, and
how many kernel threads it should use.
.P
The
.B rpc.mountd
server provides an ancillary service needed to satisfy mount requests
by NFS clients.
.SH OPTIONS
.TP
.B \-d " or " \-\-debug
enable logging of debugging messages
.TP
.B \-H " or " \-\-host  hostname
specify a particular hostname (or address) that NFS requests will
be accepted on. By default,
.B rpc.nfsd
will accept NFS requests on all known network addresses.
Note that
.B lockd
(which performs file locking services for NFS) may still accept
request on all known network addresses.  This may change in future
releases of the Linux Kernel. This option can be used multiple time 
to listen to more than one interface.
.TP
.B \-p " or " \-\-port  port
specify a different port to listen on for NFS requests. By default,
.B rpc.nfsd
will listen on port 2049.
.TP
.B \-r " or " \-\-rdma
specify that NFS requests on the standard RDMA port ("nfsrdma", port
20049) should be honored.
.TP
.BI \-\-rdma= port
Listen for RDMA requests on an alternate port - may be a number or a
name listed in
.BR /etc/services .
.TP
.B \-N " or " \-\-no-nfs-version vers
This option can be used to request that 
.B rpc.nfsd
does not offer certain versions of NFS. The current version of
.B rpc.nfsd
can support major NFS versions 3,4 and the minor versions 4.0, 4.1 and 4.2.
.TP
.B \-s " or " \-\-syslog
By default,
.B rpc.nfsd
logs error messages (and debug messages, if enabled) to stderr. This option makes 
.B rpc.nfsd
log these messages to syslog instead. Note that errors encountered during
option processing will still be logged to stderr regardless of this option.
.TP
.B \-t " or " \-\-tcp
Instruct the kernel nfs server to open and listen on a TCP socket. This is the default.
.TP
.B \-T " or " \-\-no-tcp
Instruct the kernel nfs server not to open and listen on a TCP socket.
.TP
.B \-u " or " \-\-udp
Instruct the kernel nfs server to open and listen on a UDP socket.
.TP
.B \-U " or " \-\-no-udp
Instruct the kernel nfs server not to open and listen on a UDP socket. This is the default.
.TP
.B \-V " or " \-\-nfs-version vers
This option can be used to request that 
.B rpc.nfsd
offer certain versions of NFS. The current version of
.B rpc.nfsd
can support major NFS versions 3,4 and the minor versions 4.0, 4.1 and 4.2.
.TP
.B \-L " or " \-\-lease-time seconds
Set the lease-time used for NFSv4.  This corresponds to how often
clients need to confirm their state with the server. Valid range is
from 10 to 3600 seconds.
.TP
.B \-G " or " \-\-grace-time seconds
Set the grace-time used for NFSv4 and NLM (for NFSv2 and NFSv3).
New file open requests (NFSv4) and new file locks (NLM) will not be
allowed until after this time has passed to allow clients to recover state.
.TP
.I nproc
specify the number of NFS server threads. By default, eight
threads are started. However, for optimum performance several threads
should be used. The actual figure depends on the number of and the work
load created by the NFS clients, but a useful starting point is
eight threads. Effects of modifying that number can be checked using
the
.BR nfsstat (8)
program.
.P
Note that if the NFS server is already running, then the options for
specifying host, port, and protocol will be ignored.  The number of
processes given will be the only option considered, and the number of
active
.B nfsd
processes will be increased or decreased to match this number.
In particular
.B rpc.nfsd 0
will stop all threads and thus close any open connections.

.SH CONFIGURATION FILE
Many of the options that can be set on the command line can also be
controlled through values set in the
.B [nfsd]
section of the
.I /etc/nfs.conf
configuration file.  Values recognized include:
.TP
.B threads
The number of threads to start.
.TP
.B host
A host name, or comma separated list of host names, that
.I rpc.nfsd
will listen on.  Use of the
.B --host
option replaces all host names listed here.
.TP
.B grace-time
The grace time, for both NFSv4 and NLM, in seconds.
.TP
.B lease-time
The lease time for NFSv4, in seconds.
.TP
.B port
Set the port for TCP/UDP to bind to.
.TP
.B rdma
Enable RDMA port (with "on" or "yes" etc) on the standard port
("nfsrdma", port 20049).
.TP
.B rdma-port
Set an alternate RDMA port.
.TP
.B UDP
Enable (with "on" or "yes" etc) or disable ("off", "no") UDP support.
.TP
.B TCP
Enable or disable TCP support.
.TP
.B vers3
.TP
.B vers4
Enable or disable a major NFS version.  3 and 4 are normally enabled
by default.
.TP
.B vers4.1
.TP
.B vers4.2
Setting these to "off" or similar will disable the selected minor
versions.  Setting to "on" will enable them.  The default values
are determined by the kernel, and usually minor versions default to
being enabled once the implementation is sufficiently complete.

.SH NOTES
If the program is built with TI-RPC support, it will enable any protocol and
address family combinations that are marked visible in the
.B netconfig
database.

.SH SEE ALSO
.BR nfsd (7),
.BR rpc.mountd (8),
.BR exports (5),
.BR exportfs (8),
.BR nfs.conf (5),
.BR rpc.rquotad (8),
.BR nfsstat (8),
.BR netconfig(5).
.SH AUTHOR
Olaf Kirch, Bill Hawes, H. J. Lu, G. Allan Morris III,
and a host of others.
