# dotfile-regex [![NPM version](https://img.shields.io/npm/v/dotfile-regex.svg?style=flat)](https://www.npmjs.com/package/dotfile-regex) [![NPM monthly downloads](https://img.shields.io/npm/dm/dotfile-regex.svg?style=flat)](https://npmjs.org/package/dotfile-regex) [![NPM total downloads](https://img.shields.io/npm/dt/dotfile-regex.svg?style=flat)](https://npmjs.org/package/dotfile-regex) [![Linux Build Status](https://img.shields.io/travis/regexhq/dotfile-regex.svg?style=flat&label=Travis)](https://travis-ci.org/regexhq/dotfile-regex)

> Regular expresson for matching dotfiles.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save dotfile-regex
```

## Usage

To be considered a dot **file**:

* the path must contain a dot that is at the beginning of the string or following a slash
* the next character after the dot must not be another dot
* one or more characters must follow the dot
* a slash must not follow the dot

To check for dot **directories**, use [dotdir-regex](https://github.com/regexps/dotdir-regex) instead.

```js
var dotfileRegex = require('dotfile-regex');

dotfileRegex().test('a/b/c.js');
//=> false

dotfileRegex().test('./git');
//=> false

dotfileRegex().test('.git/foo');
//=> false

dotfileRegex().test('.gitignore');
//=> true

dotfileRegex().test('a/b/c/.gitignore');
//=> true
```

## About

### Related projects

* [dotdir-regex](https://www.npmjs.com/package/dotdir-regex): Regex for matching dot-directories, like `.git/` | [homepage](https://github.com/regexps/dotdir-regex "Regex for matching dot-directories, like `.git/`")
* [is-dotdir](https://www.npmjs.com/package/is-dotdir): Returns true if a path is a dot-directory. | [homepage](https://github.com/jonschlinkert/is-dotdir "Returns true if a path is a dot-directory.")
* [is-dotfile](https://www.npmjs.com/package/is-dotfile): Return true if a file path is (or has) a dotfile. Returns false if the… [more](https://github.com/jonschlinkert/is-dotfile) | [homepage](https://github.com/jonschlinkert/is-dotfile "Return true if a file path is (or has) a dotfile. Returns false if the path is a dot directory.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 3 | [jonschlinkert](https://github.com/jonschlinkert) |
| 1 | [popomore](https://github.com/popomore) |
| 1 | [johnotander](https://github.com/johnotander) |
| 1 | [sindresorhus](https://github.com/sindresorhus) |

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 30, 2017._