// Generated by LiveScript 1.6.0
var parseString, ref$, deepEqual, equal, throws, parseType, q, toString$ = {}.toString;
parseString = require('../../lib/parse-string');
ref$ = require('assert'), deepEqual = ref$.deepEqual, equal = ref$.strictEqual, throws = ref$.throws;
parseType = require('type-check').parseType;
q = function(input, type, expected, options){
  var result;
  result = parseString(parseType(type), input, options);
  switch (toString$.call(expected).slice(8, -1)) {
  case 'Array':
  case 'Object':
    return deepEqual(result, expected);
  default:
    return equal(result, expected);
  }
};
describe('parse-string', function(){
  it('"string"', function(){
    q('string', 'String', '\'string\'');
    q('"string"', 'String', '\'"string"\'');
    q('one\\"two', 'String', '\'one\\"two\'');
    q('"string"', '*', '"string"');
    q("string", 'String', '\'string\'');
    q("'string'", '*', '\'string\'');
    q('string with spaces and: {[(})]', 'String', '\'string with spaces and: {[(})]\'');
    q('string with spaces and: {[(})]', '*', 'string with spaces and:{[(})]');
    return q('string with spaces and: {[(})]', 'String', 'string with spaces and:{[(})]', {
      explicit: true
    });
  });
  it('#date#', function(){
    q('#2011-11-11#', 'Date', '#2011-11-11#');
    q('#2011-11-11#', '*', '#2011-11-11#');
    q('#[] () :: { }#', 'Date', '#[] () :: { }#');
    return q('#[] () :: { }#', '*', '#[] () :: { }#');
  });
  it('/regexp/flags', function(){
    q('/regexp/ig', 'RegExp', '/regexp/ig');
    q('/reg\\/exp/ig', 'RegExp', '/reg\\/exp/ig');
    q('/regexp/ig', '*', '/regexp/ig');
    q('/[ ] {:}/ig', 'RegExp', '/[ ] {:}/ig');
    return q('/[ ] {:}/ig', '*', '/[ ] {:}/ig');
  });
  it('[array]', function(){
    q('[1,2,3]', 'Array', ['1', '2', '3']);
    q('[1,2,3]', '[Number]', ['1', '2', '3']);
    q('[1,2,3]', '*', ['1', '2', '3']);
    q('[one two , three four]', '[String]', ['one two', 'three four']);
    q('[one:two, three:four]', '[String]', ['one:two', 'three:four']);
    q('[1,2,3,]', '*', ['1', '2', '3']);
    q('[1, 2, 3, ]', '*', ['1', '2', '3']);
    q('[]', 'Array', []);
    q('[]', '[Number]', []);
    q('[]', '*', []);
    q('1,2,3', '[Number]', ['1', '2', '3']);
    q('1,2,3', 'Array', ['1', '2', '3']);
    q('1, 2, 3', '[Number]', ['1', '2', '3']);
    q('1, 2, 3', 'Array', ['1', '2', '3']);
    q('', '[Number]', []);
    q('', 'Array', []);
    q('[1,2],[3,4]', 'Array', [['1', '2'], ['3', '4']]);
    return q('[1,2],[3,4]', '[[Number]]', [['1', '2'], ['3', '4']]);
  });
  it('(tuple)', function(){
    q('(1,2)', '(Number, Number)', ['1', '2']);
    q('(1,2)', '*', ['1', '2']);
    q('(1, 2)', '(Number, Number)', ['1', '2']);
    q('(1, 2)', '*', ['1', '2']);
    q('(one two , 2)', '(String, Number)', ['one two', '2']);
    q('1,2', '(Number, Number)', ['1', '2']);
    q('1, 2', '(Number, Number)', ['1', '2']);
    return q('(1,2),(3,4)', '((Number,Number),(Number,Number))', [['1', '2'], ['3', '4']]);
  });
  it('{object}', function(){
    q('{x: 2, y: 3}', 'Object', {
      x: '2',
      y: '3'
    });
    q('{x: 2, y: 3}', '{...}', {
      x: '2',
      y: '3'
    });
    q('{x: 2, y: 3}', 'RegExp{...}', {
      x: '2',
      y: '3'
    });
    q('{x: 2, y: 3}', '{x: Number, y: Number}', {
      x: '2',
      y: '3'
    });
    q('{x: 2, y: 3}', '{x: Number, y: Number}', {
      x: '2',
      y: '3'
    });
    q('{[x]: 2, y(): 3}', '*', {
      '[x]': '2',
      'y()': '3'
    });
    q('{x: 2():, y: 3][}', '*', {
      x: '2():',
      y: '3]['
    });
    q('', 'Object', {});
    q('', '{...}', {});
    q('', '{x: Number, y: Number}', {});
    throws(function(){
      return q('{x}', '*');
    }, /Expected ':', but got 'undefined' instead/);
    q('x: 2, y: 3', 'Object', {
      x: '2',
      y: '3'
    });
    return q('x: 2, y: 3', '{x: Number, y: Number}', {
      x: '2',
      y: '3'
    });
  });
  it('etc', function(){
    q('hi', '*', 'hi');
    q('this is a string', '*', 'this is a string');
    q('&$-1234asdfasw#!.+=%', '*', '&$-1234asdfasw#!.+=%');
    q('x: 2, y: 3', '*', 'x:2,y:3');
    q('1,2', '*', '1,2');
    return q('1,2,3', '*', '1,2,3');
  });
  it('explicit', function(){
    q('1,2,3', '*', '1,2,3', {
      explicit: true
    });
    return q('1,2,3', 'Array', '1,2,3', {
      explicit: true
    });
  });
  return it('nothing', function(){
    return throws(function(){
      return q('', '*');
    }, /Error parsing ''/);
  });
});
