---
id: fast-foundation.matchmediabehavior
title: MatchMediaBehavior class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [MatchMediaBehavior](./fast-foundation.matchmediabehavior.md)

## MatchMediaBehavior class

An abstract behavior to react to media queries. Implementations should implement the `constructListener` method to perform some action based on media query changes.

<b>Signature:</b>

```typescript
export declare abstract class MatchMediaBehavior implements Behavior 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(query)](./fast-foundation.matchmediabehavior._constructor_.md) |  | Constructs a new instance of the <code>MatchMediaBehavior</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [query](./fast-foundation.matchmediabehavior.query.md) |  | MediaQueryList | The media query that the behavior operates on. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [bind(source)](./fast-foundation.matchmediabehavior.bind.md) |  | Binds the behavior to the element. |
|  [constructListener(source)](./fast-foundation.matchmediabehavior.constructlistener.md) |  | Constructs a function that will be invoked with the MediaQueryList context |
|  [unbind(source)](./fast-foundation.matchmediabehavior.unbind.md) |  | Unbinds the behavior from the element. |
