The `x-opam-maintenance` field allows a list of strings matching version
numbers, possibly using the special keywords (latest), (any) and (none):

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (generate_opam_files true)
  > (package (name foo) (allow_empty))
  > (maintenance_intent
  >   "1.2.3"
  >   "(latest)"
  >   "(latest-1234567890)"
  >   "(latest-1).(none)"
  >   "(any).(latest).(none)"
  >   "1.(any).2.(none)"
  >   "3.14.(latest)")
  > EOF
  $ cat dune-project
  (lang dune 3.18)
  (generate_opam_files true)
  (package (name foo) (allow_empty))
  (maintenance_intent
    "1.2.3"
    "(latest)"
    "(latest-1234567890)"
    "(latest-1).(none)"
    "(any).(latest).(none)"
    "1.(any).2.(none)"
    "3.14.(latest)")
  $ dune build foo.opam
  $ cat foo.opam
  # This file is generated by dune, edit dune-project instead
  opam-version: "2.0"
  depends: [
    "dune" {>= "3.18"}
    "odoc" {with-doc}
  ]
  build: [
    ["dune" "subst"] {dev}
    [
      "dune"
      "build"
      "-p"
      name
      "-j"
      jobs
      "@install"
      "@runtest" {with-test}
      "@doc" {with-doc}
    ]
  ]
  x-maintenance-intent: [
    "1.2.3"
    "(latest)"
    "(latest-1234567890)"
    "(latest-1).(none)"
    "(any).(latest).(none)"
    "1.(any).2.(none)"
    "3.14.(latest)"
  ]

The following are all invalid maintenance intents:

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-22:
  2 | (maintenance_intent "")
                          ^^
  Error: empty version
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-29:
  2 | (maintenance_intent "(latest")
                          ^^^^^^^^^
  Error: unclosed parenthesis
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent ").1")
  > EOF
  $ dune build

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent ".1")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-24:
  2 | (maintenance_intent ".1")
                          ^^^^
  Error: unexpected dot
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "1.2.")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-26:
  2 | (maintenance_intent "1.2.")
                          ^^^^^^
  Error: version ends with a dot
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "1.2(latest).3")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-35:
  2 | (maintenance_intent "1.2(latest).3")
                          ^^^^^^^^^^^^^^^
  Error: unexpected parenthesis
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(none-3)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-30:
  2 | (maintenance_intent "(none-3)")
                          ^^^^^^^^^^
  Error: substraction only allowed for "latest", not "none"
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(any-3)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-29:
  2 | (maintenance_intent "(any-3)")
                          ^^^^^^^^^
  Error: substraction only allowed for "latest", not "any"
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest)1")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-31:
  2 | (maintenance_intent "(latest)1")
                          ^^^^^^^^^^^
  Error: missing dot after intent
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest-)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-31:
  2 | (maintenance_intent "(latest-)")
                          ^^^^^^^^^^^
  Error: invalid substraction
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest-0)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-32:
  2 | (maintenance_intent "(latest-0)")
                          ^^^^^^^^^^^^
  Error: invalid substraction
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest-00)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-33:
  2 | (maintenance_intent "(latest-00)")
                          ^^^^^^^^^^^^^
  Error: invalid substraction
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest--1)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-33:
  2 | (maintenance_intent "(latest--1)")
                          ^^^^^^^^^^^^^
  Error: invalid substraction
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest-a)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-32:
  2 | (maintenance_intent "(latest-a)")
                          ^^^^^^^^^^^^
  Error: invalid substraction
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(latest-1")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-31:
  2 | (maintenance_intent "(latest-1")
                          ^^^^^^^^^^^
  Error: unclosed parenthesis
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "(lates)")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 20-29:
  2 | (maintenance_intent "(lates)")
                          ^^^^^^^^^
  Error: unknown intent "lates", expected "any", "latest" or "none"
  [1]

  $ cat >dune-project <<EOF
  > (lang dune 3.18)
  > (maintenance_intent "1.2" "(latest)" "err)" "3.4")
  > EOF
  $ dune build
  File "dune-project", line 2, characters 37-43:
  2 | (maintenance_intent "1.2" "(latest)" "err)" "3.4")
                                           ^^^^^^
  Error: unexpected parenthesis
  [1]
