/* -*- Mode: C; c-basic-offset:4 ; indent-tabs-mode:nil -*- */
/*
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2021 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart,
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * Copyright (c) 2011-2012 Cisco Systems, Inc.  All rights reserved.
 * Copyright (c) 2013      Los Alamos National Security, LLC. All rights
 *                         reserved.
 * Copyright (c) 2015      Research Organization for Information Science
 *                         and Technology (RIST). All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#include "ompi_config.h"

#include "ompi/mpi/fortran/mpif-h/bindings.h"
#include "ompi/mpi/fortran/base/constants.h"
#include "ompi/mca/coll/base/coll_base_util.h"

#if OMPI_BUILD_MPI_PROFILING
#if OPAL_HAVE_WEAK_SYMBOLS
#pragma weak PMPI_INEIGHBOR_ALLTOALLW = ompi_ineighbor_alltoallw_f
#pragma weak pmpi_ineighbor_alltoallw = ompi_ineighbor_alltoallw_f
#pragma weak pmpi_ineighbor_alltoallw_ = ompi_ineighbor_alltoallw_f
#pragma weak pmpi_ineighbor_alltoallw__ = ompi_ineighbor_alltoallw_f

#pragma weak PMPI_Ineighbor_alltoallw_f = ompi_ineighbor_alltoallw_f
#pragma weak PMPI_Ineighbor_alltoallw_f08 = ompi_ineighbor_alltoallw_f
#else
OMPI_GENERATE_F77_BINDINGS (PMPI_INEIGHBOR_ALLTOALLW,
                            pmpi_ineighbor_alltoallw,
                            pmpi_ineighbor_alltoallw_,
                            pmpi_ineighbor_alltoallw__,
                            pompi_ineighbor_alltoallw_f,
                            (char *sendbuf, MPI_Fint *sendcounts, MPI_Aint *sdispls, MPI_Fint *sendtypes, char *recvbuf, MPI_Fint *recvcounts, MPI_Aint *rdispls, MPI_Fint *recvtypes, MPI_Fint *comm, MPI_Fint *request, MPI_Fint *ierr),
                            (sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, rdispls, recvtypes, comm, request, ierr) )
#endif
#endif

#if OPAL_HAVE_WEAK_SYMBOLS
#pragma weak MPI_INEIGHBOR_ALLTOALLW = ompi_ineighbor_alltoallw_f
#pragma weak mpi_ineighbor_alltoallw = ompi_ineighbor_alltoallw_f
#pragma weak mpi_ineighbor_alltoallw_ = ompi_ineighbor_alltoallw_f
#pragma weak mpi_ineighbor_alltoallw__ = ompi_ineighbor_alltoallw_f

#pragma weak MPI_Ineighbor_alltoallw_f = ompi_ineighbor_alltoallw_f
#pragma weak MPI_Ineighbor_alltoallw_f08 = ompi_ineighbor_alltoallw_f
#else
#if ! OMPI_BUILD_MPI_PROFILING
OMPI_GENERATE_F77_BINDINGS (MPI_INEIGHBOR_ALLTOALLW,
                            mpi_ineighbor_alltoallw,
                            mpi_ineighbor_alltoallw_,
                            mpi_ineighbor_alltoallw__,
                            ompi_ineighbor_alltoallw_f,
                            (char *sendbuf, MPI_Fint *sendcounts, MPI_Aint *sdispls, MPI_Fint *sendtypes, char *recvbuf, MPI_Fint *recvcounts, MPI_Aint *rdispls, MPI_Fint *recvtypes, MPI_Fint *comm, MPI_Fint *request, MPI_Fint *ierr),
                            (sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, rdispls, recvtypes, comm, request, ierr) )
#else
#define ompi_ineighbor_alltoallw_f pompi_ineighbor_alltoallw_f
#endif
#endif


void ompi_ineighbor_alltoallw_f(char *sendbuf, MPI_Fint *sendcounts,
                                MPI_Aint *sdispls, MPI_Fint *sendtypes,
                                char *recvbuf, MPI_Fint *recvcounts,
                                MPI_Aint *rdispls, MPI_Fint *recvtypes,
                                MPI_Fint *comm, MPI_Fint *request, MPI_Fint *ierr)
{
    MPI_Comm c_comm;
    MPI_Datatype *c_sendtypes, *c_recvtypes;
    MPI_Request c_request;
    int size, idx = 0, c_ierr;
    OMPI_ARRAY_NAME_DECL(sendcounts);
    OMPI_ARRAY_NAME_DECL(recvcounts);

    c_comm = PMPI_Comm_f2c(*comm);
    PMPI_Comm_size(c_comm, &size);

    c_sendtypes = (MPI_Datatype *) malloc(size * sizeof(MPI_Datatype));
    c_recvtypes = (MPI_Datatype *) malloc(size * sizeof(MPI_Datatype));

    OMPI_ARRAY_FINT_2_INT(sendcounts, size);
    OMPI_ARRAY_FINT_2_INT(recvcounts, size);

    while (size > 0) {
        c_sendtypes[size - 1] = PMPI_Type_f2c(sendtypes[size - 1]);
        c_recvtypes[size - 1] = PMPI_Type_f2c(recvtypes[size - 1]);
        --size;
    }

    /* Ineighbor_alltoallw does not support MPI_IN_PLACE */
    sendbuf = (char *) OMPI_F2C_BOTTOM(sendbuf);
    recvbuf = (char *) OMPI_F2C_BOTTOM(recvbuf);

    c_ierr = PMPI_Ineighbor_alltoallw(sendbuf,
                                     OMPI_ARRAY_NAME_CONVERT(sendcounts),
                                     sdispls,
                                     c_sendtypes,
                                     recvbuf,
                                     OMPI_ARRAY_NAME_CONVERT(recvcounts),
                                     rdispls,
                                     c_recvtypes, c_comm, &c_request);
    if (NULL != ierr) *ierr = OMPI_INT_2_FINT(c_ierr);
    if (MPI_SUCCESS == c_ierr) *request = PMPI_Request_c2f(c_request);

    if ( REQUEST_COMPLETE(c_request)) {
        OMPI_ARRAY_FINT_2_INT_CLEANUP(sendcounts);
        OMPI_ARRAY_FINT_2_INT_CLEANUP(recvcounts);
        free(c_sendtypes);
        free(c_recvtypes);
    } else {
        ompi_coll_base_nbc_request_t* nb_request = (ompi_coll_base_nbc_request_t*)c_request;
        nb_request->data.release_arrays[idx++] = OMPI_ARRAY_NAME_CONVERT(sendcounts);
        nb_request->data.release_arrays[idx++] = OMPI_ARRAY_NAME_CONVERT(recvcounts);
        nb_request->data.release_arrays[idx++] = c_sendtypes;
        nb_request->data.release_arrays[idx++] = c_recvtypes;
        nb_request->data.release_arrays[idx]   = NULL;
    }
}
