# openresolv

openresolv is a [resolvconf](https://en.wikipedia.org/wiki/Resolvconf)
implementation which manages `/etc/resolv.conf`.

`/etc/resolv.conf` is a file that holds the configuration for the local
resolution of domain names.
Normally this file is either static or maintained by a local daemon,
normally a DHCP daemon. But what happens if more than one thing wants to
control the file?
Say you have wired and wireless interfaces to different subnets and run a VPN
or two on top of that, how do you say which one controls the file?
It's also not as easy as just adding and removing the nameservers each client
knows about as different clients could add the same nameservers.

Enter resolvconf, the middleman between the network configuration services and
`/etc/resolv.conf`.
resolvconf itself is just a script that stores, removes and lists a full
`resolv.conf` generated for the interface. It then calls all the helper scripts
it knows about so it can configure the real `/etc/resolv.conf` and optionally
any local nameservers other than libc.

## Reasons for using openresolv

Why openresolv over the
[Debian implementation](http://qref.sourceforge.net/Debian/reference/ch-gateway.en.html#s-dns-resolvconf)?
Here's some reasons:
  *  Works with
  [POSIX shell and userland](http://www.opengroup.org/onlinepubs/009695399)
  *  Does not need awk, grep or sed which means we can work without `/usr`
  mounted
  *  Works with other init systems than Debians' out of the box
  *  Available as a 2 clause
  [BSD license](http://www.freebsd.org/copyright/freebsd-license.html)
  *  Prefer configs via IF_METRIC for dynamic ordering
  *  Configures zones for local resolvers other than libc

The last point is quite important, especially when running VPN systems.
Take the following resolv.conf files which have been generated by a
[DHCP client](https://github.com/NetworkConfiguration/dhcpcd) and sent to resolvconf:

```
# resolv.conf from bge0
search foo.com
nameserver 1.2.3.4

# resolv.conf from tap0
domain bar.org
nameserver 5.6.7.8
```

In this instance, queries for foo.com will go to 1.2.3.4 and queries for
bar.org will go to 5.6.7.8.
This does require the resolvers to be configured to pickup the resolvconf
generated configuration for them though.
openresolv ships with helpers for:
  *  [unbound](http://www.unbound.net/)
  *  [dnsmasq](http://www.thekelleys.org.uk/dnsmasq/doc.html)
  *  [ISC BIND](http://www.isc.org/software/bind)
  *  [PowerDNS Recursor](http://wiki.powerdns.com/trac)

See the
[configuration section](https://roy.marples.name/projects/openresolv/configuration)
for more details.

If openresolv updates `/etc/resolv.conf` it can notify the following of this:
  *  [Bonjour (mdnsd)](https://developer.apple.com/bonjour/)
  *  [avahi](http://www.avahi.org/)
