#!/usr/bin/python

#
# This maintenance script updates the content of the "Orthanc" folder
# to match the latest version of the Orthanc source code.
#

import multiprocessing
import os
import stat
import urllib2

TARGET = os.path.join(os.path.dirname(__file__), 'Orthanc')
PLUGIN_SDK_VERSION_OLD = [ '0.9.5', '1.4.0', '1.5.2', '1.5.4' ]
PLUGIN_SDK_VERSION_NEW = [ '1.9.2' ]
REPOSITORY = 'https://hg.orthanc-server.com/orthanc/raw-file'

FILES = [
    ('OrthancFramework/Resources/CMake/AutoGeneratedCode.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/Compiler.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/DownloadOrthancFramework.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/DownloadPackage.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/GoogleTestConfiguration.cmake', 'CMake'),
    ('OrthancFramework/Resources/EmbedResources.py', '.'),
    ('OrthancFramework/Resources/Toolchains/LinuxStandardBaseToolchain.cmake', '.'),
    ('OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain32.cmake', '.'),
    ('OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain64.cmake', '.'),
    ('OrthancFramework/Resources/Toolchains/MinGWToolchain.cmake', '.'),
    ('OrthancServer/Plugins/Samples/Common/ExportedSymbolsPlugins.list', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.cpp', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.h', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginException.h', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginsExports.cmake', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/VersionScriptPlugins.map', 'Plugins'),
    ('OrthancServer/Sources/Search/DatabaseConstraint.cpp', 'Databases'),
    ('OrthancServer/Sources/Search/DatabaseConstraint.h', 'Databases'),
    ('OrthancServer/Sources/Search/ISqlLookupFormatter.cpp', 'Databases'),
    ('OrthancServer/Sources/Search/ISqlLookupFormatter.h', 'Databases'),
]

SDK = [
    'orthanc/OrthancCPlugin.h',
    'orthanc/OrthancCDatabasePlugin.h',
]


def Download(x):
    branch = x[0]
    source = x[1]
    target = os.path.join(TARGET, x[2])
    print target

    try:
        os.makedirs(os.path.dirname(target))
    except:
        pass

    url = '%s/%s/%s' % (REPOSITORY, branch, source)

    try:
        with open(target, 'w') as f:
            f.write(urllib2.urlopen(url).read())
    except Exception as e:
        raise Exception('Cannot download: %s' % url)    

    
commands = []

for f in FILES:
    commands.append([ 'default',
                      f[0],
                      os.path.join(f[1], os.path.basename(f[0])) ])

for version in PLUGIN_SDK_VERSION_OLD:
    for f in SDK:
        commands.append([
            'Orthanc-%s' % version, 
            'Plugins/Include/%s' % f,
            'Sdk-%s/%s' % (version, f) 
        ])

for version in PLUGIN_SDK_VERSION_NEW:
    for f in SDK:
        commands.append([
            'Orthanc-%s' % version, 
            'OrthancServer/Plugins/Include/%s' % f,
            'Sdk-%s/%s' % (version, f) 
        ])


pool = multiprocessing.Pool(10)  # simultaneous downloads
pool.map(Download, commands)
