/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collection;
import java.util.Objects;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Branch {
    private final InstructionList list;
    private final Display labelTest;
    private final LinkRendering labelPositive;
    private LinkRendering inlinkRendering = LinkRendering.none();
    private final LinkRendering inlabel;
    private LinkRendering special;
    private final HColor color;
    private Ftile ftile;

    public StyleSignature getDefaultStyleDefinitionArrow() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.arrow);
    }

    public StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public boolean containsBreak() {
        return this.list.containsBreak();
    }

    public Branch(StyleBuilder styleBuilder, Swimlane swimlane, LinkRendering labelPositive, Display labelTest, HColor color, LinkRendering inlabel) {
        this.inlabel = Objects.requireNonNull(inlabel);
        this.labelTest = Objects.requireNonNull(labelTest);
        this.labelPositive = Objects.requireNonNull(labelPositive);
        if (UseStyle.useBetaStyle()) {
            Style style = this.getDefaultStyleDefinitionDiamond().getMergedStyle(styleBuilder);
            this.color = color == null ? style.value(PName.BackGroundColor).asColor(styleBuilder.getSkinParam().getThemeStyle(), styleBuilder.getSkinParam().getIHtmlColorSet()) : color;
        } else {
            this.color = color;
        }
        this.list = new InstructionList(swimlane);
    }

    public Collection<WeldingPoint> getWeldingPoints() {
        return this.ftile.getWeldingPoints();
    }

    public void add(Instruction ins) {
        this.list.add(ins);
    }

    public boolean kill() {
        return this.list.kill();
    }

    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        return this.list.addNote(note, position, type, colors, swimlaneNote);
    }

    public final void setInlinkRendering(LinkRendering inlinkRendering) {
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
    }

    public void updateFtile(FtileFactory factory) {
        this.ftile = factory.decorateOut(this.list.createFtile(factory), this.inlinkRendering);
    }

    public Collection<? extends Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    public final Display getLabelPositive() {
        LinkRendering in = this.ftile.getInLinkRendering();
        if (in != null && !Display.isNull(in.getDisplay())) {
            return in.getDisplay();
        }
        return this.labelPositive.getDisplay();
    }

    public final Display getLabelTest() {
        return this.labelTest;
    }

    public final Rainbow getOut() {
        if (this.special != null) {
            return this.special.getRainbow();
        }
        if (this.inlinkRendering == null) {
            return null;
        }
        return this.inlinkRendering.getRainbow();
    }

    public Rainbow getInColor(Rainbow arrowColor) {
        if (this.isEmpty()) {
            return this.getFtile().getOutLinkRendering().getRainbow(arrowColor);
        }
        if (this.labelPositive.getRainbow().size() > 0) {
            return this.labelPositive.getRainbow();
        }
        LinkRendering linkIn = this.getFtile().getInLinkRendering();
        Rainbow color = linkIn.getRainbow(arrowColor);
        if (color.size() == 0) {
            return arrowColor;
        }
        return color;
    }

    public Display getInlabel() {
        return this.inlabel.getDisplay();
    }

    public Rainbow getInRainbow(Rainbow defaultColor) {
        return this.inlabel.getRainbow(defaultColor);
    }

    public Rainbow getLabelPositiveRainbow(Rainbow defaultColor) {
        return this.labelPositive.getRainbow(defaultColor);
    }

    public final Ftile getFtile() {
        return this.ftile;
    }

    public ISkinParam skinParam() {
        return this.ftile.skinParam();
    }

    public final HColor getColor() {
        return this.color;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Instruction getLast() {
        return this.list.getLast();
    }

    public boolean isOnlySingleStopOrSpot() {
        return this.list.isOnlySingleStopOrSpot();
    }

    public void setSpecial(LinkRendering link) {
        this.special = link;
    }

    public final LinkRendering getSpecial() {
        return this.special;
    }
}

