/*
Copyright (C) 2009  Diego Darriba

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package es.uvigo.darwin.prottest.util.collection;

import es.uvigo.darwin.prottest.model.Model;
import pal.alignment.Alignment;

/**
 * A single implementation of ModelCollection.
 */
public class SingleModelCollection extends ModelCollection {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 20090804L;

	/**
	 * Instantiates a new single model collection.
	 */
	public SingleModelCollection(Alignment alignment) {
		super(alignment);
	}
	
	/**
	 * Instantiates a new single model collection.
	 * 
	 * @param models the models
	 */
	public SingleModelCollection(Model[] models, Alignment alignment) {
		super(models, alignment);
	}

        /**
	 * Instantiates a new single model collection.
	 *
	 * @param models the models
	 */
	public SingleModelCollection(ModelCollection models) {
		super(models);
	}

}
