/**********************************************************************
 * $list_path_delays example -- C source code using ACC PLI routines
 *
 * C source to scan through a module and list the min:typ:max rise,
 * fall and turn-off delays of all module paths in a module.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $list_path_delays(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_PathDelays_checktf(),
 *              PLIbook_PathDelays_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_PathDelays_checktf,    /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_PathDelays_calltf,     /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$list_path_delays",           /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_PathDelays_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$list_path_delays must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$list_path_delays arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$list_path_delays arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_PathDelays_calltf()
{
  handle module_h, path_h;
  double delay_set[18];
  int i;

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");

  acc_configure(accMinTypMaxDelays, "true");
  acc_configure(accPathDelayCount,  "6");

  module_h = acc_handle_tfarg(1);
  io_printf("\nPath delays in module %s:\n",
            acc_fetch_fullname(module_h));
  path_h = null;    /* start with known value for target handle */
  while (path_h = acc_next_modpath(module_h, path_h)) {
    io_printf("  %-12s :  ",
              acc_fetch_name(path_h));
    acc_fetch_delays(path_h, delay_set);
    for (i=0; i<18; i++) {
      if ( i == 0 )  /* format output like Verilog syntax */
        io_printf("(");
      else if ( (i % 3) ) 
        io_printf(":");
      else
        io_printf(", ");
      io_printf("%1.1f", delay_set[i]);
    }
    io_printf(")\n\n");
  }
  acc_close();
  return(0);
}
/*********************************************************************/
