/**********************************************************************
 * Example veriusertfs table that is used by many Verilog simulators
 * to register PLI applications that use the TF and ACC libraries of
 * the IEEE 1364 PLI.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

/* prototypes of the PLI application routines */
extern int PLIbook_ListNets_checktf(),
           PLIbook_ListNets_calltf();
extern int PLIbook_TestFetchVal_calltf();
extern int PLIbook_ReadVecVal_checktf(),
           PLIbook_ReadVecVal_calltf();
extern int PLIbook_Func72bit_sizetf(),
           PLIbook_Func72bit_calltf();
extern int PLIbook_TimeInfo_checktf(),
           PLIbook_TimeInfo_calltf();
extern int PLIbook_PrimDelays_checktf(),
           PLIbook_PrimDelays_calltf();
extern int PLIbook_PathDelays_checktf(),
           PLIbook_PathDelays_calltf();
extern int PLIbook_MipdDelays_calltf();
extern int PLIbook_ListParams_checktf(),
           PLIbook_ListParams_calltf();
extern int PLIbook_InvokeCommands_calltf();

/* the veriusertfs table */
s_tfcell veriusertfs[] =
{
    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      0,                             /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_InvokeCommands_calltf, /* calltf routine */
      0,                             /* misctf routine */
      "$print_invoke_commands",      /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ListNets_checktf,      /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ListNets_calltf,       /* calltf routine */
      0,                             /* misctf routine */
      "$list_nets",                  /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      0,                             /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_TestFetchVal_calltf,   /* calltf routine */
      0,                             /* misctf routine */
      "$test_acc_fetch_value",       /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ReadVecVal_checktf,    /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ReadVecVal_calltf,     /* calltf routine */
      0,                             /* misctf routine */
      "$read_vecval",                /* system task/function name */
      1                              /* forward reference = true */
    },

    {userfunction,                   /* type of PLI routine */
      0,                             /* user_data value */
      0,                             /* checktf routine */
      PLIbook_Func72bit_sizetf,      /* sizetf routine */
      PLIbook_Func72bit_calltf,      /* calltf routine */
      0,                             /* misctf routine */
      "$func_72bit",                 /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_TimeInfo_checktf,      /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_TimeInfo_calltf,       /* calltf routine */
      0,                             /* misctf routine */
      "$timescale_info",             /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_PrimDelays_checktf,    /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_PrimDelays_calltf,     /* calltf routine */
      0,                             /* misctf routine */
      "$list_prim_delays",           /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_PathDelays_checktf,    /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_PathDelays_calltf,     /* calltf routine */
      0,                             /* misctf routine */
      "$list_path_delays",           /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      0,                             /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_MipdDelays_calltf,     /* calltf routine */
      0,                             /* misctf routine */
      "$mipd_delays",                /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ListParams_checktf,    /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ListParams_calltf,     /* calltf routine */
      0,                             /* misctf routine */
      "$list_parameters",            /* system task/function name */
      1                              /* forward reference = true */
    },

    {0} /*** final entry must be 0 ***/
};
