# -*- coding: utf-8 -*-

"""Extract registry information."""

from .collection_api import get_collection, get_context  # noqa:F401
from .metaresource_api import (  # noqa:F401
    get_registry,
    get_registry_description,
    get_registry_example,
    get_registry_homepage,
    get_registry_name,
    get_registry_provider_uri_format,
    get_registry_short_name,
    get_registry_uri,
)
from .parse_iri import curie_from_iri, parse_iri  # noqa:F401
from .resolve import (  # noqa:F401
    count_mappings,
    get_appears_in,
    get_banana,
    get_biocontext_uri_format,
    get_bioportal_prefix,
    get_canonical_for,
    get_contact,
    get_contact_email,
    get_contact_github,
    get_contact_name,
    get_contact_orcid,
    get_converter,
    get_curie_pattern,
    get_default_converter,
    get_default_format,
    get_depends_on,
    get_description,
    get_example,
    get_external,
    get_fairsharing_prefix,
    get_has_canonical,
    get_has_parts,
    get_homepage,
    get_identifiers_org_prefix,
    get_json_download,
    get_keywords,
    get_license,
    get_license_conflicts,
    get_mappings,
    get_miriam_uri_format,
    get_miriam_uri_prefix,
    get_n2t_prefix,
    get_name,
    get_namespace_in_lui,
    get_obo_context_prefix_map,
    get_obo_download,
    get_obo_health_url,
    get_obofoundry_prefix,
    get_obofoundry_uri_format,
    get_obofoundry_uri_prefix,
    get_ols_prefix,
    get_ols_uri_format,
    get_ols_uri_prefix,
    get_owl_download,
    get_part_of,
    get_parts_collections,
    get_pattern,
    get_preferred_prefix,
    get_prefixcommons_uri_format,
    get_provided_by,
    get_provides_for,
    get_rdf_download,
    get_registry_invmap,
    get_registry_map,
    get_repository,
    get_resource,
    get_synonyms,
    get_version,
    get_versions,
    get_wikidata_prefix,
    has_no_terms,
    is_deprecated,
    is_novel,
    is_proprietary,
    normalize_curie,
    normalize_parsed_curie,
    normalize_prefix,
    parse_curie,
    read_contributors,
)
from .resolve_identifier import (  # noqa:F401
    get_bioportal_iri,
    get_bioregistry_iri,
    get_default_iri,
    get_identifiers_org_curie,
    get_identifiers_org_iri,
    get_iri,
    get_link,
    get_n2t_iri,
    get_obofoundry_iri,
    get_ols_iri,
    get_providers,
    get_providers_list,
    is_standardizable_curie,
    is_standardizable_identifier,
    is_valid_curie,
    is_valid_identifier,
    miriam_standardize_identifier,
    standardize_identifier,
)
from .resource_manager import Manager, manager  # noqa:F401
from .schema.struct import (  # noqa:F401
    Author,
    Collection,
    Context,
    Provider,
    Registry,
    Resource,
)
from .schema_utils import (  # noqa:F401
    is_mismatch,
    read_collections,
    read_contexts,
    read_metaregistry,
    read_mismatches,
    read_registry,
    registries,
    resources,
    write_contexts,
    write_registry,
)
from .uri_format import (  # noqa:F401
    get_pattern_map,
    get_prefix_map,
    get_uri_format,
    get_uri_prefix,
)
from .utils import curie_to_str  # noqa:F401
