"""Tests for the ijson.parse method"""

import pytest

from .test_base import ARRAY_JSON, ARRAY_JSON_PARSE_EVENTS, JSON, JSON_PARSE_EVENTS

def test_parse(adaptor):
    assert JSON_PARSE_EVENTS == adaptor.parse(JSON)

def test_parse_array(adaptor):
    assert ARRAY_JSON_PARSE_EVENTS == adaptor.parse(ARRAY_JSON)

def test_coro_needs_input_with_two_elements(backend):
    int_element_basic_parse_events = list(backend.basic_parse(b'0', use_float=True))
    # all good
    assert [('', 'number', 0)] == list(backend.parse(int_element_basic_parse_events))
    # one more element in event
    with pytest.raises(ValueError, match="too many values"):
        next(backend.parse(event + ('extra dummy',) for event in int_element_basic_parse_events))
    # one less
    with pytest.raises(ValueError, match="not enough values"):
        next(backend.parse(event[:-1] for event in int_element_basic_parse_events))
    # not an iterable
    with pytest.raises(TypeError, match="cannot unpack"):
        next(backend.parse([None]))


def test_user_events(backend):
    """
    User-provided events work correct -- yajl2_c used to fail with event names
    that weren't generated by itself.
    """
    int_array_basic_parse_events = [
        ('start_array', None),
        ('number', 0),
        ('end_array', None),
    ]
    expected_parse_events = [
        ('', 'start_array', None),
        ('item', 'number', 0),
        ('', 'end_array', None),
    ]
    assert expected_parse_events == list(backend.parse(int_array_basic_parse_events))
