'''
check test vectors
'''


from lib1305 import poly1305


def test_vector1() -> None:
    '''
    backported from NaCl library
    '''
    m = b'\x8e\x99\x3b\x9f\x48\x68\x12\x73\xc2\x96\x50\xba\x32\xfc\x76\xce'
    m += b'\x48\x33\x2e\xa7\x16\x4d\x96\xa4\x47\x6f\xb8\xc5\x31\xa1\x18\x6a'
    m += b'\xc0\xdf\xc1\x7c\x98\xdc\xe8\x7b\x4d\xa7\xf0\x11\xec\x48\xc9\x72'
    m += b'\x71\xd2\xc2\x0f\x9b\x92\x8f\xe2\x27\x0d\x6f\xb8\x63\xd5\x17\x38'
    m += b'\xb4\x8e\xee\xe3\x14\xa7\xcc\x8a\xb9\x32\x16\x45\x48\xe5\x26\xae'
    m += b'\x90\x22\x43\x68\x51\x7a\xcf\xea\xbd\x6b\xb3\x73\x2b\xc0\xe9\xda'
    m += b'\x99\x83\x2b\x61\xca\x01\xb6\xde\x56\x24\x4a\x9e\x88\xd5\xf9\xb3'
    m += b'\x79\x73\xf6\x22\xa4\x3d\x14\xa6\x59\x9b\x1f\x65\x4c\xb4\x5a\x74'
    m += b'\xe3\x55\xa5'
    k = b'\xee\xa6\xa7\x25\x1c\x1e\x72\x91\x6d\x11\xc2\xcb\x21\x4d\x3c\x25'
    k += b'\x25\x39\x12\x1d\x8e\x23\x4e\x65\x2d\x65\x1f\xa4\xc8\xcf\xf8\x80'
    a = b'\xf3\xff\xc7\x70\x3f\x94\x00\xe5\x2a\x7d\xfb\x4b\x3d\x33\x05\xd9'
    poly1305.verify(a, m, k)
    assert a == poly1305.auth(m, k)


def test_vector2() -> None:
    '''
    This function primarily tests the internal freeze() function in lib1305.
    The freeze() function detects if the number is less than p (2**130-5) and
    is therefore finally reduced and if not, then p (2**130-5) is subtracted.
    And this test tests the rare condition where the number is greater than 'p'
    and needs to be subtracted.
    '''
    m = 16 * b'\xff'
    k = b'\x02' + 31 * b'\x00'
    a = b'\x03' + 15 * b'\x00'
    poly1305.verify(a, m, k)
    assert a == poly1305.auth(m, k)
