// core.h
//
// The code in this file is part of Pyxplot
// <http://www.pyxplot.org.uk>
//
// Copyright (C) 2006-2012 Dominic Ford <coders@pyxplot.org.uk>
//               2008-2012 Ross Church
//
// $Id: core.h 1261 2012-07-11 21:38:05Z dcf21 $
//
// Pyxplot is free software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// You should have received a copy of the GNU General Public License along with
// Pyxplot; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA

// ----------------------------------------------------------------------------

#ifndef _CORE_H
#define _CORE_H 1

#include "parser/parser.h"
#include "userspace/context.h"
#include "userspace/pplObj.h"

void ppl_directive_assert (ppl_context *c, parserLine *pl, parserOutput *in);
void ppl_directive_cd     (ppl_context *c, parserLine *pl, parserOutput *in);
void ppl_directive_exec   (ppl_context *c, parserLine *pl, parserOutput *in, int interactive, int iterDepth);
void ppl_directive_global (ppl_context *c, parserLine *pl, parserOutput *in, int interactive, int iterDepth);
void ppl_directive_history(ppl_context *c, parserLine *pl, parserOutput *in);
void ppl_directive_load   (ppl_context *c, parserLine *pl, parserOutput *in, int interactive, int iterDepth);
void ppl_directive_local  (ppl_context *c, parserLine *pl, parserOutput *in, int interactive, int iterDepth);
void ppl_directive_print  (ppl_context *c, parserLine *pl, parserOutput *in);
void ppl_directive_save   (ppl_context *c, parserLine *pl, parserOutput *in);
void ppl_directive_seterror(ppl_context *c, parserLine *pl, parserOutput *in, int interactive);
void ppl_directive_unseterror(ppl_context *c, parserLine *pl, parserOutput *in, int interactive);
void ppl_directive_varset (ppl_context *c, parserLine *pl, parserOutput *in, int interactive, int iterDepth);

#endif
