// Copyright (C) 2016 Klaralvdalens Datakonsult AB (KDAB).
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#ifndef QT3DINPUT_QAXISSETTING_P_H
#define QT3DINPUT_QAXISSETTING_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <Qt3DCore/private/qnode_p.h>

QT_BEGIN_NAMESPACE

namespace Qt3DInput {

class QAxisSettingPrivate : public Qt3DCore::QNodePrivate
{
public:
    QAxisSettingPrivate()
        : Qt3DCore::QNodePrivate()
        , m_deadZoneRadius(0.0f)
        , m_axes()
        , m_smooth(false)
    {}

    float m_deadZoneRadius;
    QList<int> m_axes;
    bool m_smooth;
};

struct QAxisSettingData
{
    float deadZoneRadius;
    QList<int> axes;
    bool smooth;
};

} // Qt3DInput

QT_END_NAMESPACE

#endif // QT3DINPUT_QAXISSETTING_P_H

