// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) DIGITEO - 2009-2011 - Allan CORNET
//
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.
//=============================================================================
function ilib_gen_cleaner(makename,loadername,files)

    [lhs,rhs] = argn(0);

    if (rhs < 1) then
        makename = "makelib";
    end

    if (rhs < 2) then
        loadername = "loader.sce";
    end

    if (rhs < 3) then
        files = [];
    end

    cleanername = "cleaner.sce";

    fd = mopen(cleanername,"wt");
    mfprintf(fd,"// This file is released under the 3-clause BSD license. See COPYING-BSD.\n");
    mfprintf(fd,"// Generated by builder.sce : Please, do not edit this file\n");
    mfprintf(fd,"// cleaner.sce\n");
    mfprintf(fd,"// ------------------------------------------------------\n");
    mfprintf(fd,"curdir = pwd();\n");
    mfprintf(fd,"cleaner_path = get_file_path(''cleaner.sce'');\n");
    mfprintf(fd,"chdir(cleaner_path);\n");
    mfprintf(fd,"// ------------------------------------------------------\n");
    mfprintf(fd,"if fileinfo(''%s'') <> [] then\n",loadername);
    mfprintf(fd,"  mdelete(''%s'');\n",loadername);
    mfprintf(fd,"end\n");
    mfprintf(fd,"// ------------------------------------------------------\n");

    if getos() == "Windows" then
        // Load dynamic_link Internal lib if it"s not already loaded
        if ~ exists("dynamic_linkwindowslib") then
            load("SCI/modules/dynamic_link/macros/windows/lib");
        end

        dlwGenerateCleaner(fd, makename);
    end

    if getos() == "Windows" then
        mfprintf(fd,"if isdir(''Debug'') then\n");
        mfprintf(fd,"  rmdir(''Debug'',''s'');\n");
        mfprintf(fd,"end\n");
        mfprintf(fd,"// ------------------------------------------------------\n");
        mfprintf(fd,"if isdir(''Release'') then\n");
        mfprintf(fd,"  rmdir(''Release'',''s'');\n");
        mfprintf(fd,"end\n");
        mfprintf(fd,"// ------------------------------------------------------\n");
    end

    if files <> [] then
        for i = 1:size(files,"*")
            if ( files(i) <> "" ) then
                mfprintf(fd,"if fileinfo(''%s'') <> [] then\n", files(i));
                mfprintf(fd,"  mdelete(''%s'');\n", files(i));
                mfprintf(fd,"end\n");
                mfprintf(fd,"// ------------------------------------------------------\n");
            end
        end
    end

    mfprintf(fd,"chdir(curdir);\n");
    mfprintf(fd,"// ------------------------------------------------------\n");
    mclose(fd);

    if ilib_verbose() > 1 then
        disp(mgetl("cleaner.sce"));
    end
endfunction
//=============================================================================
