#include "CallXmlLoader.hxx"
/* Generated by GIWS (version 2.0.2) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/graphic_objects.giws.xml
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

Copyright (C) 2012 - 2016 - Scilab Enterprises

This file is hereby licensed under the terms of the GNU GPL v2.0,
pursuant to article 5.3.4 of the CeCILL v.2.1.
This file was originally licensed under the terms of the CeCILL v2.1,
and continues to be available under such terms.
For more information, see the COPYING file which you should have received
along with this program.
*/

namespace org_scilab_modules_graphic_objects {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * CallXmlLoader::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

CallXmlLoader::~CallXmlLoader() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
CallXmlLoader::CallXmlLoader(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
jintLoadjstringjava_lang_StringID=NULL;
jstringSavejintintjstringjava_lang_StringjbooleanbooleanID=NULL;
jintDomLoadjstringjava_lang_StringID=NULL;


}

CallXmlLoader::CallXmlLoader(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        jintLoadjstringjava_lang_StringID=NULL;
jstringSavejintintjstringjava_lang_StringjbooleanbooleanID=NULL;
jintDomLoadjstringjava_lang_StringID=NULL;


}

// Generic methods

void CallXmlLoader::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallXmlLoader");
}
}

void CallXmlLoader::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "CallXmlLoader");
}
}
// Method(s)

int CallXmlLoader::Load (JavaVM * jvm_, char const* filename){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintLoadjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "Load", "(Ljava/lang/String;)I" ) ;
if (jintLoadjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "Load");
}

jstring filename_ = curEnv->NewStringUTF( filename );
if (filename != NULL && filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintLoadjstringjava_lang_StringID ,filename_));
                        curEnv->DeleteLocalRef(filename_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

char* CallXmlLoader::Save (JavaVM * jvm_, int figure, char const* filename, bool isReverse){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jstringSavejintintjstringjava_lang_StringjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "Save", "(ILjava/lang/String;Z)Ljava/lang/String;" ) ;
if (jstringSavejintintjstringjava_lang_StringjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "Save");
}

jstring filename_ = curEnv->NewStringUTF( filename );
if (filename != NULL && filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean isReverse_ = (static_cast<bool>(isReverse) ? JNI_TRUE : JNI_FALSE);

                        jstring res =  static_cast<jstring>( curEnv->CallStaticObjectMethod(cls, jstringSavejintintjstringjava_lang_StringjbooleanbooleanID ,figure, filename_, isReverse_));
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}if (res != NULL) { 

const char *tempString = curEnv->GetStringUTFChars(res, 0);
char * myStringBuffer = new char[strlen(tempString) + 1];
strcpy(myStringBuffer, tempString);
curEnv->ReleaseStringUTFChars(res, tempString);
curEnv->DeleteLocalRef(res);
curEnv->DeleteLocalRef(filename_);
if (curEnv->ExceptionCheck()) {
delete[] myStringBuffer;
                                throw GiwsException::JniCallMethodException(curEnv);
}
return myStringBuffer;
 } else { 
curEnv->DeleteLocalRef(res);
return NULL;
}
}

int CallXmlLoader::DomLoad (JavaVM * jvm_, char const* filename){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID jintDomLoadjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "DomLoad", "(Ljava/lang/String;)I" ) ;
if (jintDomLoadjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "DomLoad");
}

jstring filename_ = curEnv->NewStringUTF( filename );
if (filename != NULL && filename_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                        jint res =  static_cast<jint>( curEnv->CallStaticIntMethod(cls, jintDomLoadjstringjava_lang_StringID ,filename_));
                        curEnv->DeleteLocalRef(filename_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
return res;

}

}
