// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2019 - Samuel GOUGEON
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->
// <-- NO CHECK REF -->

// Unitary tests for tanh()

s = sprand(5, 4, 0.3);
assert_checkequal(tanh(s), sparse(tanh(full(s))));

x = [0:0.01:0.1 0.1:0.1:1 1:20]';
r = [
   0.
   0.0099996666799994604
   0.0199973337599309332
   0.0299910032388201429
   0.0399786803111635697
   0.0499583749578799766
   0.059928103529143503
   0.0698858903164289724
   0.079829769111131349 
   0.0897577847471601048
   0.0996679946249558191
   0.09966799462495583
   0.19737532022490401
   0.29131261245159096
   0.37994896225522484
   0.46211715726000979
   0.5370495669980353
   0.60436777711716361
   0.66403677026784891
   0.71629787019902447
   0.76159415595576485
   0.76159415595576485
   0.964027580075817
   0.99505475368673058
   0.99932929973906703
   0.999909204262595
   0.9999877116507956
   0.99999833694394458
   0.99999977492967596
   0.999999969540041
   0.99999999587769284
   0.99999999944210638
   0.99999999992449728
   0.99999999998978184
   0.99999999999861722
   0.99999999999981282
   0.99999999999997446
   0.99999999999999656
   0.99999999999999956
   0.99999999999999978
   1.
   ];
assert_checkalmostequal(tanh(x), r, %eps);
assert_checkalmostequal(tanh(-x), -r, %eps);
assert_checkequal(1/tanh(-0), -%inf);
