#ifndef __VGAHW_H
#define __VGAHW_H

#include "types.h" // u8
#include "config.h" // CONFIG_*

#include "bochsvga.h" // bochsvga_set_mode
#include "stdvga.h" // stdvga_set_mode
#include "geodevga.h" // geodevga_setup
#include "vgautil.h" // stdvga_list_modes

static inline struct vgamode_s *vgahw_find_mode(int mode) {
    if (CONFIG_VGA_CIRRUS)
        return clext_find_mode(mode);
    if (CONFIG_VGA_ATI)
        return ati_find_mode(mode);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_find_mode(mode);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_find_mode(mode);
    return stdvga_find_mode(mode);
}

static inline int vgahw_set_mode(struct vgamode_s *vmode_g, int flags) {
    if (CONFIG_VGA_CIRRUS)
        return clext_set_mode(vmode_g, flags);
    if (CONFIG_VGA_ATI)
        return ati_set_mode(vmode_g, flags);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_set_mode(vmode_g, flags);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_set_mode(vmode_g, flags);
    return stdvga_set_mode(vmode_g, flags);
}

static inline void vgahw_list_modes(u16 seg, u16 *dest, u16 *last) {
    if (CONFIG_VGA_CIRRUS)
        clext_list_modes(seg, dest, last);
    else if (CONFIG_VGA_ATI)
        ati_list_modes(seg, dest, last);
    else if (CONFIG_VGA_BOCHS)
        bochsvga_list_modes(seg, dest, last);
    else if (CONFIG_VGA_EMULATE_TEXT)
        cbvga_list_modes(seg, dest, last);
    else
        stdvga_list_modes(seg, dest, last);
}

static inline int vgahw_setup(void) {
    if (CONFIG_VGA_CIRRUS)
        return clext_setup();
    if (CONFIG_VGA_ATI)
        return ati_setup();
    if (CONFIG_VGA_BOCHS)
        return bochsvga_setup();
    if (CONFIG_VGA_GEODEGX2 || CONFIG_VGA_GEODELX)
        return geodevga_setup();
    if (CONFIG_VGA_COREBOOT)
        return cbvga_setup();
    if (CONFIG_DISPLAY_BOCHS)
        return bochs_display_setup();
    if (CONFIG_VGA_RAMFB)
        return ramfb_setup();
    return stdvga_setup();
}

static inline int vgahw_get_window(struct vgamode_s *curmode_g, int window) {
    if (CONFIG_VGA_CIRRUS)
        return clext_get_window(curmode_g, window);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_get_window(curmode_g, window);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_get_window(curmode_g, window);
    return stdvga_get_window(curmode_g, window);
}

static inline int vgahw_set_window(struct vgamode_s *curmode_g, int window
                                   , int val) {
    if (CONFIG_VGA_CIRRUS)
        return clext_set_window(curmode_g, window, val);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_set_window(curmode_g, window, val);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_set_window(curmode_g, window, val);
    return stdvga_set_window(curmode_g, window, val);
}

static inline int vgahw_get_linelength(struct vgamode_s *curmode_g) {
    if (CONFIG_VGA_CIRRUS)
        return clext_get_linelength(curmode_g);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_get_linelength(curmode_g);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_get_linelength(curmode_g);
    return stdvga_get_linelength(curmode_g);
}

static inline int vgahw_minimum_linelength(struct vgamode_s *vmode_g) {
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_minimum_linelength(vmode_g);
    return stdvga_minimum_linelength(vmode_g);
}

static inline int vgahw_set_linelength(struct vgamode_s *curmode_g, int val) {
    if (CONFIG_VGA_CIRRUS)
        return clext_set_linelength(curmode_g, val);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_set_linelength(curmode_g, val);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_set_linelength(curmode_g, val);
    return stdvga_set_linelength(curmode_g, val);
}

static inline int vgahw_get_displaystart(struct vgamode_s *curmode_g) {
    if (CONFIG_VGA_CIRRUS)
        return clext_get_displaystart(curmode_g);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_get_displaystart(curmode_g);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_get_displaystart(curmode_g);
    return stdvga_get_displaystart(curmode_g);
}

static inline int vgahw_set_displaystart(struct vgamode_s *curmode_g, int val) {
    if (CONFIG_VGA_CIRRUS)
        return clext_set_displaystart(curmode_g, val);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_set_displaystart(curmode_g, val);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_set_displaystart(curmode_g, val);
    return stdvga_set_displaystart(curmode_g, val);
}

static inline int vgahw_get_dacformat(struct vgamode_s *curmode_g) {
    if (CONFIG_VGA_BOCHS)
        return bochsvga_get_dacformat(curmode_g);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_get_dacformat(curmode_g);
    return stdvga_get_dacformat(curmode_g);
}

static inline int vgahw_set_dacformat(struct vgamode_s *curmode_g, int val) {
    if (CONFIG_VGA_BOCHS)
        return bochsvga_set_dacformat(curmode_g, val);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_set_dacformat(curmode_g, val);
    return stdvga_set_dacformat(curmode_g, val);
}

static inline int vgahw_save_restore(int cmd, u16 seg, void *data) {
    if (CONFIG_VGA_CIRRUS)
        return clext_save_restore(cmd, seg, data);
    if (CONFIG_VGA_BOCHS)
        return bochsvga_save_restore(cmd, seg, data);
    if (CONFIG_VGA_EMULATE_TEXT)
        return cbvga_save_restore(cmd, seg, data);
    return stdvga_save_restore(cmd, seg, data);
}

#endif // vgahw.h
