#include "partcolor.h"
PartColor::PartColor(QObject *parent) : QObject(parent){

}

QString PartColor::name(int part, bool dark){
    QString pc;
    switch (part){
    case 0: pc=(dark)?("#242424"):("#fafafa");
                //Qt::white;
                break;
    case 1: pc=("lightskyblue");break;
    case 2: pc=("darkgoldenrod");break;
    case 3: pc="green";break;
    case 4: pc="yellow";break;
    case 5: pc=("orange");break;
    case 6: pc="black";break;
    case 7: pc=("lightsalmon");break;
    case 8: pc=("lightseagreen");break;
    case 666: pc=("fuchsia");break;
    case -1: pc=("aquamarine");break;
    case -2: pc=("olive");break;
    case -3: pc=("bisque");break;
    default:
        if (part>0)
            pc=QColor::colorNames().at(qMin(part, QColor::colorNames().size()-1));
        else pc=QColor::colorNames().at(qMin(QColor::colorNames().size()-1 + part, QColor::colorNames().size()-1));
    }
    return pc;
}

QColor PartColor::color(int part, bool dark){
    return QColor(name(part,dark));
}
