use clap::CommandFactory;
use clap::Parser;
use clap_complete::generate;

/// Generate shell completions for shotman.
#[derive(Parser)]
struct Completions {
    /// The shell for which completions will be generated.
    #[arg(value_enum)]
    shell: clap_complete::shells::Shell,
}

fn main() {
    let completions = Completions::parse();

    generate(
        completions.shell,
        &mut shotman::Cli::command(),
        "shotman",
        &mut std::io::stdout(),
    );
}
