/**
 * @file test-utils.h
 * @author Peter Rockai (mornfall) <mornfall@danill.sk>
 * @brief Utility functions for the unit tests
 */
#ifndef TAGCOLL_TEST_UTILS_H
#define TAGCOLL_TEST_UTILS_H

#include <wibble/tests.h>

#include <string>
#include <set>
#include <iostream>

#define TEST_TAGCOLL

#ifdef TEST_TAGCOLL
#include <tagcoll/input/string.h>
#include <tagcoll/TextFormat.h>
#endif

namespace tagcoll {
namespace tests {

template<typename OUT>
void parseCollection(const std::string& str, const OUT& out)
{
	input::String input(str);
	textformat::parse(input, out);
}

#define ensure_coll_equals(a, b) \
	__tc_ensure_coll_equals(wibble::tests::Location(__FILE__, __LINE__, #a " == " #b), a, b)
#define inner_ensure_coll_equals(a, b) \
	__tc_ensure_coll_equals(wibble::tests::Location(loc, __FILE__, __LINE__, #a " == " #b), a, b)
template<typename COLL1, typename COLL2>
void __tc_ensure_coll_equals(const wibble::tests::Location& loc, const COLL1& c1, const COLL2& c2);

#define ensure_contains(a, b) \
	_ensure_contains(wibble::tests::Location(__FILE__, __LINE__, #a " contains " #b), a, b)
#define inner_ensure_contains(a, b) \
	_ensure_contains(wibble::tests::Location(loc, __FILE__, __LINE__, #a " contains " #b), a, b)
template<class T>
void _ensure_contains(const wibble::tests::Location& loc, const std::set<T>& s, const T& item)
{
	if (s.find(item) == s.end())
	{
		std::stringstream ss;
		ss << "tagset ";
		for (typename std::set<T>::const_iterator i = s.begin();
				i != s.end(); i++)
			if (i == s.begin())
				ss << *i;
			else
				ss << ", " << *i;
		ss << " does not contain " << item;
		
		throw tut::failure(loc.msg(ss.str()));
	}
}

#define ensure_not_contains(a, b) \
	_ensure_not_contains(wibble::tests::Location(__FILE__, __LINE__, #a " contains " #b), a, b)
#define inner_ensure_not_contains(a, b) \
	_ensure_not_contains(wibble::tests::Location(loc, __FILE__, __LINE__, #a " contains " #b), a, b)
template<class T>
void _ensure_not_contains(const wibble::tests::Location& loc, const std::set<T>& s, const T& item)
{
	if (s.find(item) != s.end())
	{
		std::stringstream ss;
		ss << "tagset ";
		for (typename std::set<T>::const_iterator i = s.begin();
				i != s.end(); i++)
			if (i == s.begin())
				ss << *i;
			else
				ss << ", " << *i;
		ss << " does not contain " << item;
		
		throw tut::failure(loc.msg(ss.str()));
	}
}

#ifdef TEST_TAGCOLL

// Output a test collection for later testing with test_tagged_collection_ro

#define output_test_collection(x) (__output_test_collection(wibble::tests::Location(__FILE__, __LINE__, #x), (x)))
#define inner_output_test_collection(x) (__output_test_collection(wibble::tests::Location(loc, __FILE__, __LINE__, $x), (x)))
template<typename OUT>
void __output_test_collection(const wibble::tests::Location& loc, OUT tc);

#define test_readonly_collection(x) (__test_readonly_collection(wibble::tests::Location(__FILE__, __LINE__, #x), (x)))
#define inner_test_readonly_collection(x) (__test_readonly_collection(wibble::tests::Location(loc, __FILE__, __LINE__, #x), (x)))
template<typename ROCOLL>
void __test_readonly_collection(const wibble::tests::Location& loc, const ROCOLL& tc);


#define test_collection(x) (__test_collection(wibble::tests::Location(__FILE__, __LINE__, #x), (x)))
template<typename COLL>
void __test_collection(const wibble::tests::Location& loc, COLL& tc);

#endif
}
}

/*
namespace tut {
    static void aptInit () {
        pkgInitConfig (*_config);
        _config->Set("Dir", CACHE_DIR);
        _config->Set("Dir::Cache", "cache");
        _config->Set("Dir::State", "state");
        _config->Set("Dir::Etc", "etc");
        _config->Set("Dir::State::status", CACHE_DIR "dpkg-status");
        pkgInitSystem (*_config, _system);
        // _config -> Set ("Capture::Cache::UseExtState", extstate);
    }
}
*/

#endif
