(property-file-syntax)=

# Use the property file

```{tags} audience:administrators, audience:developers
```

%[glossary_term][Property files]
% Text format to store device classes and device servers including their properties.

A property file is a file where you store all the properties related
to devices belonging to a specific device server process. In this
file, one can find:

- Which devices have to be created for each Tango class embedded in
  the device server process
- Device properties
- Device attribute properties

This type of file is not required by a Tango control system as this information is stored in the {term}`Tango
Database` as well.

But if you want to run the {term}`File Database` this is the format that will be used. These files can either be
written from scratch using the example below or exported from [Jive](inv:jive:std#index). To generate a device
server process properties file, select your device server process in the `Server` tab, right click and select
`Save Server Data`. A file selection window pops up allowing you to choose your file name and path. To load a
file into the Tango database, click on `File` then `Load Property File`.

## Property file example

```{code} cpp
:number-lines: 1

 #---------------------------------------------------------
 # SERVER TimeoutTest/manu, TimeoutTest device declaration
 #---------------------------------------------------------

 TimeoutTest/manu/DEVICE/TimeoutTest: "et/to/01",\
                                      "et/to/02",\
                                      "et/to/03"


 # --- et/to/01 properties
 et/to/01->StringProp: Property
 et/to/01->ArrayProp: 1,\
                      2,\
                      3
 et/to/01->attr_min_poll_period: TheAttr,\
                                 1000
 et/to/01->AnotherStringProp: "A long string"
 et/to/01->ArrayStringProp: "the first prop",\
                            "the second prop"

 # --- et/to/01 attribute properties
 et/to/01/TheAttr->display_unit: 1.0
 et/to/01/TheAttr->event_period: 1000
 et/to/01/TheAttr->format: %4d
 et/to/01/TheAttr->min_alarm: -2.0
 et/to/01/TheAttr->min_value: -5.0
 et/to/01/TheAttr->standard_unit: 1.0
 et/to/01/TheAttr->__value: 111
 et/to/01/BooAttr->event_period: 1000
 et/to/01/TestAttr->display_unit: 1.0
 et/to/01/TestAttr->event_period: 1000
 et/to/01/TestAttr->format: %4d
 et/to/01/TestAttr->standard_unit: 1.0
 et/to/01/DbAttr->abs_change: 1.1
 et/to/01/DbAttr->event_period: 1000

 # --- class property
 CLASS/TimeoutTest->InheritedFrom: Device_6Impl
 CLASS/TimeoutTest->doc_url: "https://www.myfancywebsite.eu"

 # --- class attribute property
 CLASS/MotorClass/position->unit: "nm"

 # --- free CtrlSystem property
 FREE/CtrlSystem->AutoAlarmOnChangeEvent: false
```

:::{list-table} Example explanations
:widths: 5 40
:header-rows: 1

*
  - Line
  - Explanation
*
  - 1-3
  - Comment lines start with the `#` character and extend until the end of the line
*
  - 4
  - Blank lines are skipped
*
  - 5-7
  - Device definition. `DEVICE` is the keyword to declare a devices definition sequence.
    The syntax is
    ```text
      <DS name>/<inst name>/DEVICE/<Class name>: dev1,dev2,dev3
    ```
    A device's name can also follow on the next line if the line continuation character `\`
    is used as the last character, see lines 5 and 6. The `"` (quote) characters around
    the device names are generated by Jive and are not mandatory.
*
  - 11
  - Device property definition. The syntax is
    ```text
        <device name>-><property name>: <property value>
    ```
    In the case of array properties, the array element delimiter is the character `,`.
    Array definition can be split over several lines if the last line
    character is `\`. Allowed characters after the `:` delimiter are space, tab or nothing.
*
  - 12-15 \& 15-16
  - Device property (array)
*
  - 18
  - When a device string property contains special characters (spaces), the
    `"` character is used to delimit the strings.
*
  - 22-35
  - Device attribute property definition. The syntax is
    ```text
      <device name>/<attribute name>-><property name>: <property value>
    ```
    Allowed characters after the `:` delimiter are space, tab or nothing.
*
  - 38-39
  - Class property definition. The syntax is
    ```text
      CLASS/<class name>-><property name>: <property value>
    ```
    Allowed characters after the `:` delimiter are space, tab or nothing.
    On line 39, the `"` (quote) characters around the property value are mandatory due
    to the `/` character being contained in the property value.
*
  - 42
  - Class attribute property definition. The syntax is
    ```text
      CLASS/<class name>/<attribute name>-><property name>: <property value>
    ```
    This differs from a class property only by the inserted `/<attribute name>`.
    Allowed characters after the `:` delimiter are space, tab or nothing.
*
  - 45
  - Free properties. The syntax is
    ```text
      FREE/<object name>-><property name>: <property value>
    ```
    Although `object name` can be freely choosen, it is convention to use `CtrlSystem` for free properties
    used in across multiple tango applications.
    Allowed characters after the `:` delimiter are space, tab or nothing.
:::
