---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, numérotation, numérotation par chapitre, 
              pagination
---

# Comment réinitialiser la numérotation des pages à chaque chapitre ?

Pour des manuels techniques à reliure libre, l'usage consiste parfois à numéroter 
les pages par chapitre. En effet, si vos corrections ajoutent une page entière 
au chapitre, vous n'aurez qu'à redistribuer les seules pages de ce chapitre.


## Avec les commandes de base

Une première méthode revient à modifier la définition de la commande qui affiche 
le compteur `page`, à savoir la commande `\thepage`. Voici une méthode 
de Piet van Oostrum. 

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

  \makeatletter % 
  \renewcommand{\thepage}{\thechapter-\arabic{page}}
  \@addtoreset{page}{chapter}
  \makeatother

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

En y ajoutant le petit bout de code suivant (toujours de Piet van Oostrum), 
le compteur de page ne repart pas à zéro mais à un en première page de chapitre :

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte

  \makeatletter % 
  \@addtoreset{page}{chapter}
  \def\@stpelt#1{\global\csname c@#1\endcsname
                 \expandafter\ifx \csname#1\endcsname
                 \page
                 \@ne
                 \else
                 \z@ \fi}
  \makeatother

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

La question "[](modifier_le_style_de_la_numerotation_de_page.md)" 
montre comment avoir un style de numérotation intégrant le numéro de chapitre 
u numéro de page.


## Avec l'extension <ctanpkg:chngcntr>

L'extension <ctanpkg:chngcntr> permet de relier deux compteurs entre eux. 
Avec la commande `\counterwithin*{⟨secondaire⟩}{⟨primaire⟩}`, 
Lorsque le compteur `⟨principal⟩` est mis à jour, le compteur `⟨secondaire⟩` 
est réinitialisé à 0.

Dès lors, il devient possible de relier le compteur de chapitre `chapter` 
et le compteur de page `page`.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{chngcntr}

  \counterwithin*{page}{chapter}

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

La commande `\counterwithin{⟨secondaire⟩}{⟨primaire⟩}` ajoute le numéro 
du compteur `⟨primaire⟩` devant la valeur du compteur `⟨secondaire⟩`. 
ette solution est probablement plus lisible.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{chngcntr}

  \counterwithin{page}{chapter}

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```


## Avec l'extension <ctanpkg:chappg>

L'extension <ctanpkg:chappg>, de Robin Fairbairn, traite ce sujet. 
Le simple appel de l'extension suffit à obtenir le résultat souhaité.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{chappg} 

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

Cette extension propose quelques fonctionnalités plus fines, 
par exemple pour gérer des numérotations pour un index, comme le montre sa 
[documentation](texdoc:chappg).


## Avec l'extension [pagepc](https://ctan.org/tex-archive/macros/latex/contrib/refman/#pagepc.sty)

:::{warning}
L’extension [pagepc](https://ctan.org/tex-archive/macros/latex/contrib/refman/#pagepc.sty) 
est vraisemblablement [obsolète](/1_generalites/histoire/liste_des_packages_obsoletes) 
car datant de 1995. Ce qui suit est informatif. 
:::


L'extension [pagepc](https://ctan.org/tex-archive/macros/latex/contrib/refman/#pagepc.sty),
d'Axel Kielhorn, remet le compteur de page à 1 à chaque début de chapitre.

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lipsum}         % Du faux texte
  \usepackage{pagepc}

  \pageperchapter

\begin{document}
\tableofcontents
\chapter{Un classique incontournable}
\lipsum[1-6] % Le faux texte
\chapter{Un classique incontournable - Suite}
\lipsum[7-12] % Le faux texte
\end{document}
```

:::{sources}
- [Page numbering by chapter](faquk:FAQ-pagebychap)
- [How to reset chapter and section counter with \part](https://tex.stackexchange.com/q/54383), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::