; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
;
; (c) Copyright 2001-2013, the TILP team
;
; $Id$

[Setup]
AppName=TiLP2
AppVerName=TiLP2 1.18
AppPublisher=The TiLP Team
AppPublisherURL=http://lpg.ticalc.org/prj_tilp/news.html
AppSupportURL=http://lpg.ticalc.org/prj_tilp/bug_report.html
AppUpdatesURL=http://lpg.ticalc.org/prj_tilp/win32.html
DefaultDirName={pf}\TiLP
DefaultGroupName=TiLP2
AllowNoIcons=yes
LicenseFile=C:\lpg\tilp2\COPYING
InfoBeforeFile=C:\lpg\tilp2\README.win32
InfoAfterFile=C:\lpg\tilp2\RELEASE

PrivilegesRequired = admin

;--- Shared Stuff ---
[Files]
; TI libraries
Source: "C:\lpg\tifiles2\tests\libtifiles2-10.dll"; DestDir: "{cf}\LPG Shared\libs"; Flags: sharedfile; BeforeInstall: DeleteDll('libtifiles2-8.dll');
Source: "C:\lpg\ticables2\tests\libticables2-7.dll"; DestDir: "{cf}\LPG Shared\libs"; Flags: sharedfile; BeforeInstall: DeleteDll('libticables2-5.dll');
Source: "C:\lpg\ticalcs2\tests\libticalcs2-12.dll"; DestDir: "{cf}\LPG Shared\libs"; Flags: sharedfile; BeforeInstall: DeleteDll('libticalcs2-10.dll');
Source: "C:\lpg\ticonv\tests\libticonv-8.dll"; DestDir: "{cf}\LPG Shared\libs"; Flags: sharedfile; BeforeInstall: DeleteDll('libticonv-6.dll');

; I18n files
Source: "C:\lpg\tifiles2\po\fr.gmo"; DestDir: "{cf}\LPG Shared\libs\locale\fr\LC_MESSAGES"; DestName: "libtifiles2.mo"; Flags: ignoreversion sharedfile;
Source: "C:\lpg\ticables2\po\fr.gmo"; DestDir: "{cf}\LPG Shared\libs\locale\fr\LC_MESSAGES"; DestName: "libticables2.mo"; Flags: ignoreversion sharedfile;
Source: "C:\lpg\ticalcs2\po\fr.gmo"; DestDir: "{cf}\LPG Shared\libs\locale\fr\LC_MESSAGES"; DestName: "libticalcs2.mo"; Flags: ignoreversion sharedfile;

; Misc
;Source: "C:\lpg\gtk\bin\libxml2.dll"; DestDir: "{cf}\LPG Shared\libs"; Flags: onlyifdoesntexist sharedfile; BeforeInstall: DeleteDll('libxml2.dll');
;Source: "C:\lpg\gtk\bin\libglade-2.0-0.dll"; DestDir: "{cf}\LPG Shared\libs"; Flags: onlyifdoesntexist sharedfile; BeforeInstall: DeleteDll('libglade-2.0-0.dll');
Source: "C:\lpg\gtk\bin\gtkthemeselector.exe"; DestDir: "{cf}\LPG Shared\bin"; Flags: ignoreversion sharedfile; BeforeInstall: DeleteExe('gtkthemeselector.exe');

; Downloader
Source: "C:\lpg\tilp2\build\InnoSetup\wget\*.dll"; DestDir: "{cf}\LPG Shared\wget"; Flags: ignoreversion
Source: "C:\lpg\tilp2\build\InnoSetup\wget\wget.exe"; DestDir: "{cf}\LPG Shared\wget"; Flags: ignoreversion
Source: "C:\lpg\tilp2\build\InnoSetup\wget\d_and_i.bat"; DestDir: "{cf}\LPG Shared\wget"; Flags: ignoreversion

; DhaHelper driver
Source: "C:\lpg\ticables2\src\win32\dha\dhahelper.sys"; DestDir: "{cf}\LPG Shared\drivers\dha"; Flags: sharedfile; Check: not Is64BitInstallMode
Source: "C:\lpg\ticables2\src\win32\dha\dhasetup.exe";  DestDir: "{cf}\LPG Shared\drivers\dha"; Flags: sharedfile; Check: not Is64BitInstallMode

; RwPorts driver
Source: "C:\lpg\ticables2\src\win64\rwp\rwports.sys"; DestDir: "{cf}\LPG Shared\drivers\rwp"; Flags: sharedfile; Check: Is64BitInstallMode
Source: "C:\lpg\ticables2\src\win64\rwp\rwpsetup.exe";  DestDir: "{cf}\LPG Shared\drivers\rwp"; Flags: sharedfile; Check: Is64BitInstallMode

; USB driver
Source: "C:\lpg\libusb-win32\bin\*.sys"; DestDir: "{cf}\LPG Shared\drivers\usb"; Flags: sharedfile;
Source: "C:\lpg\libusb-win32\bin\*.dll"; DestDir: "{cf}\LPG Shared\drivers\usb"; Flags: sharedfile;
Source: "C:\lpg\ticables2\src\win32\usb\*.cat"; DestDir: "{cf}\LPG Shared\drivers\usb"; Flags: sharedfile;
Source: "C:\lpg\ticables2\src\win32\usb\*.inf"; DestDir: "{cf}\LPG Shared\drivers\usb"; Flags: sharedfile;
Source: "C:\lpg\libusb-win32\bin\libusb0.dll"; DestDir: "{win}\system32"; Flags: replacesameversion restartreplace uninsneveruninstall;
Source: "C:\lpg\libusb-win32\bin\libusb0_x64.dll"; DestDir: "{win}\system32"; Flags: replacesameversion restartreplace uninsneveruninstall; Check: Is64BitInstallMode

[Registry]
; Create entries for shared libs (needed by other programs)
Root: HKLM; Subkey: "Software\LPG Shared"; ValueType: string; ValueName: "Path"; ValueData: "{cf}\LPG Shared"
Root: HKLM; Subkey: "Software\LPG Shared"; ValueType: string; ValueName: "DllPath"; ValueData: "{cf}\LPG Shared\libs"

;--- End of Shared Stuff ---

[Tasks]
Name: "desktopicon"; Description: "Create a &desktop icon"; GroupDescription: "Additional icons:"; MinVersion: 4,4
Name: "quicklaunchicon"; Description: "Create a &Quick Launch icon"; GroupDescription: "Additional icons:"; MinVersion: 4,4; Flags: unchecked

Name: "tifiles"; Description: "Register file types"; GroupDescription: "File association:";
Name: "slv_drv"; Description: "Install USB drivers"; GroupDescription: "Drivers:";
Name: "dha_drv"; Description: "Install BlackLink/Parallel cable for NT/2k/XP"; GroupDescription: "Drivers:"; MinVersion: 0,4

[Files]
; GTK+Builder files
Source: "C:\lpg\tilp2\builder\*.ui"; DestDir: "{app}\builder"; Flags: ignoreversion;

; Help files
Source: "C:\lpg\tilp2\help\*.png"; DestDir: "{app}\help"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\help\*.htm?"; DestDir: "{app}\help"; Flags: ignoreversion;

; Icons files
Source: "C:\lpg\tilp2\icons\*.ico"; DestDir: "{app}\icons"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\COPYRIGHT"; DestDir: "{app}\icons"; DestName: "Copyright.txt"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Application.ico"; DestDir: "{app}\icons"; DestName: "App_Var.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\List.ico"; DestDir: "{app}\icons"; DestName: "Complex_List.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Matrix.ico"; DestDir: "{app}\icons"; DestName: "Complex_Matrix.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Vector.ico"; DestDir: "{app}\icons"; DestName: "Complex_Vector.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Equation.ico"; DestDir: "{app}\icons"; DestName: "Diff_Equ.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Equation.ico"; DestDir: "{app}\icons"; DestName: "Function.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Equation.ico"; DestDir: "{app}\icons"; DestName: "Parametric.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Equation.ico"; DestDir: "{app}\icons"; DestName: "Polar.ico"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\icons\Equation.ico"; DestDir: "{app}\icons"; DestName: "Y_Var.ico"; Flags: ignoreversion;

; Pixmaps files
Source: "C:\lpg\tilp2\pixmaps\*.xpm"; DestDir: "{app}\pixmaps"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\pixmaps\*.png"; DestDir: "{app}\pixmaps"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\wicons\*.png"; DestDir: "{app}\share\icons"; Flags: ignoreversion;

; i18n files
Source: "C:\lpg\tilp2\po\fr.gmo"; DestDir: "{app}\locale\fr\LC_MESSAGES"; DestName: "tilp2.mo"; Flags: ignoreversion;
Source: "C:\lpg\tilp2\po\de.gmo"; DestDir: "{app}\locale\de\LC_MESSAGES"; DestName: "tilp2.mo"; Flags: ignoreversion;

; Misc files
Source: "C:\lpg\tilp2\README.win32"; DestDir: "{app}"; DestName: "Readme_Win32.txt"; Flags: ignoreversion
Source: "C:\lpg\tilp2\AUTHORS"; DestDir: "{app}"; DestName: "Authors.txt"; Flags: ignoreversion
Source: "C:\lpg\tilp2\CHANGELOG"; DestDir: "{app}"; DestName: "ChangeLog.txt"; Flags: ignoreversion
Source: "C:\lpg\tilp2\COPYING"; DestDir: "{app}"; DestName: "License.txt"; Flags: ignoreversion
Source: "C:\lpg\tilp2\man\ManPage.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "C:\lpg\tilp2\README"; DestDir: "{app}"; DestName: "ReadMe.txt"; Flags: ignoreversion isreadme
Source: "C:\lpg\tilp2\RELEASE"; DestDir: "{app}"; DestName: "Release.txt"; Flags: ignoreversion

; Binaries
Source: "C:\lpg\tilp2\build\msvc\tilp.exe"; DestDir: "{app}"; DestName: "tilp.exe"; Flags: ignoreversion

[Dirs]
Name: "{app}\My TI files"; Flags: uninsneveruninstall;

[INI]
Filename: "{app}\tilp2.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://lpg.ticalc.org/prj_tilp/"
Filename: "{app}\gfm.url"; Section: "InternetShortcut"; Key: "URL"; String: "http://lpg.ticalc.org/prj_gfm/"

[Icons]
Name: "{group}\TiLP"; Filename: "{app}\tilp.exe"; WorkingDir: "{app}\My TI files"
Name: "{group}\TiLP on the Web"; Filename: "{app}\tilp2.url"
Name: "{group}\GFM on the Web"; Filename: "{app}\gfm.url"
Name: "{group}\Uninstall TiLP"; Filename: "{uninstallexe}"
Name: "{group}\User's Manual"; Filename: "{app}\help\Manual_en.html"
Name: "{group}\GTK theme selector"; Filename: "{cf}\LPG Shared\bin\gtkthemeselector.exe";
Name: "{group}\Bug Report"; Filename: "http://sourceforge.net/tracker/?func=add&group_id=18378&atid=118378";
Name: "{group}\USB driver installation"; Filename: "{app}\help\usb_driver.html";

Name: "{userdesktop}\TiLP"; Filename: "{app}\tilp.exe"; WorkingDir: "{app}\My TI files"; MinVersion: 4,4; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\TiLP-2"; Filename: "{app}\tilp.exe"; WorkingDir: "{app}\My TI files"; MinVersion: 4,4; Tasks: quicklaunchicon

[Run]
;Filename: "{app}\tilp.exe"; Description: "Launch TiLP"; StatusMsg: "Running TiLP..."; Flags: postinstall nowait unchecked
Filename: "{app}\gfm.url"; Description: "Download GFM"; Flags: nowait postinstall shellexec;
Filename: "{cf}\LPG Shared\wget\d_and_i.bat"; Description: "Download and install GTK+"; StatusMsg: "Running ..."; Flags: nowait postinstall unchecked hidewizard;
; Drivers installation
Filename: "{cf}\LPG Shared\drivers\dha\dhasetup.exe"; Parameters: "install"; MinVersion: 0,4; Tasks: dha_drv; StatusMsg: "Installing DHA driver (this may take few seconds) ..."
Filename: "rundll32"; Parameters: "libusb0.dll,usb_install_driver_np_rundll {cf}\LPG Shared\drivers\usb\silverlk.inf"; Tasks: slv_drv; StatusMsg: "Installing SilverLink driver (this may take few seconds) ..."
Filename: "rundll32"; Parameters: "libusb0.dll,usb_install_driver_np_rundll {cf}\LPG Shared\drivers\usb\titanium.inf"; Tasks: slv_drv; StatusMsg: "Installing Titanium driver (this may take few seconds) ..."
Filename: "rundll32"; Parameters: "libusb0.dll,usb_install_driver_np_rundll {cf}\LPG Shared\drivers\usb\ti84plus.inf"; Tasks: slv_drv; StatusMsg: "Installing TI84+ driver (this may take few seconds) ..."
Filename: "rundll32"; Parameters: "libusb0.dll,usb_install_driver_np_rundll {cf}\LPG Shared\drivers\usb\ti84pse.inf"; Tasks: slv_drv; StatusMsg: "Installing TI84+/SE driver (this may take few seconds) ..."
Filename: "rundll32"; Parameters: "libusb0.dll,usb_install_driver_np_rundll {cf}\LPG Shared\drivers\usb\nspire.inf"; Tasks: slv_drv; StatusMsg: "Installing NSpire driver (this may take few seconds) ..."

[UninstallRun]
;Filename: "C:\lpg\ticables2\src\win32\dha\dhasetup.exe"; Parameters: "remove"; MinVersion: 0,4; Tasks: dha_drv;
;same for USB drivers...

[Registry]
; Register TiLP in the shell
Root: HKCR; SubKey: "TiLP.TIxx.file"; ValueType: string; ValueData: "TI73..V200 file"
Root: HKCR; Subkey: "TiLP.TIxx.file\DefaultIcon"; ValueType: string; ValueData: "{app}\tilp.exe,0"
Root: HKCR; Subkey: "TiLP.TIxx.file\shell\open";  ValueType: string; ValueData: "Open with &TiLP"
Root: HKCR; Subkey: "TiLP.TIxx.file\shell\open\command"; ValueType: string; ValueData: """{app}\tilp.exe"" ""%1"""
; Boost GTK2 (WinNT/2000/XP)
Root: HKLM; SubKey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"; ValueType: string; ValueName: "PANGO_WIN32_NO_UNISCRIBE"; ValueData: "anything"; MinVersion: 0,4;
; NSpire entries
Root: HKCR; SubKey: ".tns"; ValueType: string;  ValueData: "TiLP.Document"; Tasks: tifiles;
Root: HKCR; SubKey: ".tno"; ValueType: string;  ValueData: "TiLP.OS_Upgrade"; Tasks: tifiles;
; TIGroup entries
Root: HKCR; SubKey: ".tig"; ValueType: string;  ValueData: "TiLP.TIGroup"; Tasks: tifiles;
; V200 file entries
Root: HKCR; SubKey: ".v2a"; ValueType: string;  ValueData: "TiLP.Figure"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2b"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2c"; ValueType: string;  ValueData: "TiLP.Data"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2e"; ValueType: string;  ValueData: "TiLP.Expression"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2f"; ValueType: string;  ValueData: "TiLP.Function"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2k"; ValueType: string;  ValueData: "TiLP.Application"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2n"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2q"; ValueType: string;  ValueData: "TiLP.Certificate"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2r"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2s"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2t"; ValueType: string;  ValueData: "TiLP.Text"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2u"; ValueType: string;  ValueData: "TiLP.OS_Upgrade"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2x"; ValueType: string;  ValueData: "TiLP.Macro"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2y"; ValueType: string;  ValueData: "TiLP.Zipped"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2z"; ValueType: string;  ValueData: "TiLP.Asm_Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".v2?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI92+ file entries
Root: HKCR; SubKey: ".9xa"; ValueType: string;  ValueData: "TiLP.Figure"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xb"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xc"; ValueType: string;  ValueData: "TiLP.Data"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xd"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xe"; ValueType: string;  ValueData: "TiLP.Expression"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xf"; ValueType: string;  ValueData: "TiLP.Function"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xg"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xi"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xk"; ValueType: string;  ValueData: "TiLP.Application"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xl"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xm"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xn"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xp"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xq"; ValueType: string;  ValueData: "TiLP.Certificate"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xr"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xs"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xt"; ValueType: string;  ValueData: "TiLP.Text"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xu"; ValueType: string;  ValueData: "TiLP.OS_Upgrade"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xx"; ValueType: string;  ValueData: "TiLP.Macro"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xy"; ValueType: string;  ValueData: "TiLP.Zipped"; Tasks: tifiles;
Root: HKCR; SubKey: ".9xz"; ValueType: string;  ValueData: "TiLP.Asm_Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".9x?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI92 file entries
Root: HKCR; SubKey: ".92a"; ValueType: string;  ValueData: "TiLP.Figure"; Tasks: tifiles;
Root: HKCR; SubKey: ".92b"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".92c"; ValueType: string;  ValueData: "TiLP.Data"; Tasks: tifiles;
Root: HKCR; SubKey: ".92d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".92e"; ValueType: string;  ValueData: "TiLP.Expression"; Tasks: tifiles;
Root: HKCR; SubKey: ".92f"; ValueType: string;  ValueData: "TiLP.Function"; Tasks: tifiles;
Root: HKCR; SubKey: ".92g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".92i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".92k"; ValueType: string;  ValueData: "TiLP.Application"; Tasks: tifiles;
Root: HKCR; SubKey: ".92l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".92m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".92n"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".92p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".92q"; ValueType: string;  ValueData: "TiLP.Certificate"; Tasks: tifiles;
Root: HKCR; SubKey: ".92r"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".92s"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".92t"; ValueType: string;  ValueData: "TiLP.Text"; Tasks: tifiles;
Root: HKCR; SubKey: ".92u"; ValueType: string;  ValueData: "TiLP.OS_Upgrade"; Tasks: tifiles;
Root: HKCR; SubKey: ".92x"; ValueType: string;  ValueData: "TiLP.Macro"; Tasks: tifiles;
Root: HKCR; SubKey: ".92y"; ValueType: string;  ValueData: "TiLP.Zipped"; Tasks: tifiles;
Root: HKCR; SubKey: ".92z"; ValueType: string;  ValueData: "TiLP.Asm_Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".92?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI89 file entries
Root: HKCR; SubKey: ".89a"; ValueType: string;  ValueData: "TiLP.Figure"; Tasks: tifiles;
Root: HKCR; SubKey: ".89b"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".89c"; ValueType: string;  ValueData: "TiLP.Data"; Tasks: tifiles;
Root: HKCR; SubKey: ".89d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".89e"; ValueType: string;  ValueData: "TiLP.Expression"; Tasks: tifiles;
Root: HKCR; SubKey: ".89f"; ValueType: string;  ValueData: "TiLP.Function"; Tasks: tifiles;
Root: HKCR; SubKey: ".89g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".89i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".89k"; ValueType: string;  ValueData: "TiLP.Application"; Tasks: tifiles;
Root: HKCR; SubKey: ".89l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".89m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".89n"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".89p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".89q"; ValueType: string;  ValueData: "TiLP.Certificate"; Tasks: tifiles;
Root: HKCR; SubKey: ".89r"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".89s"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".89t"; ValueType: string;  ValueData: "TiLP.Text"; Tasks: tifiles;
Root: HKCR; SubKey: ".89u"; ValueType: string;  ValueData: "TiLP.OS_Upgrade"; Tasks: tifiles;
Root: HKCR; SubKey: ".89x"; ValueType: string;  ValueData: "TiLP.Macro"; Tasks: tifiles;
Root: HKCR; SubKey: ".89y"; ValueType: string;  ValueData: "TiLP.Zipped"; Tasks: tifiles;
Root: HKCR; SubKey: ".89z"; ValueType: string;  ValueData: "TiLP.Asm_Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".89?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI86 file entries
Root: HKCR; SubKey: ".86c"; ValueType: string;  ValueData: "TiLP.Complex"; Tasks: tifiles;
Root: HKCR; SubKey: ".86d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".86e"; ValueType: string;  ValueData: "TiLP.Equation"; Tasks: tifiles;
Root: HKCR; SubKey: ".86g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".86i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".86k"; ValueType: string;  ValueData: "TiLP.Constant"; Tasks: tifiles;
Root: HKCR; SubKey: ".86l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".86m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".86n"; ValueType: string;  ValueData: "TiLP.Real"; Tasks: tifiles;
Root: HKCR; SubKey: ".86p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".86r"; ValueType: string;  ValueData: "TiLP.Range"; Tasks: tifiles;
Root: HKCR; SubKey: ".86s"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".86v"; ValueType: string;  ValueData: "TiLP.Vector"; Tasks: tifiles;
Root: HKCR; SubKey: ".86w"; ValueType: string;  ValueData: "TiLP.Window_Setup"; Tasks: tifiles;
Root: HKCR; SubKey: ".86y"; ValueType: string;  ValueData: "TiLP.Y_Var"; Tasks: tifiles;
Root: HKCR; SubKey: ".86z"; ValueType: string;  ValueData: "TiLP.Zoom"; Tasks: tifiles;
Root: HKCR; SubKey: ".86?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI85 file entries
Root: HKCR; SubKey: ".85b"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".85c"; ValueType: string;  ValueData: "TiLP.Complex"; Tasks: tifiles;
Root: HKCR; SubKey: ".85d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".85e"; ValueType: string;  ValueData: "TiLP.Equation"; Tasks: tifiles;
Root: HKCR; SubKey: ".85g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".85i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".85k"; ValueType: string;  ValueData: "TiLP.Constant"; Tasks: tifiles;
Root: HKCR; SubKey: ".85l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".85m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".85n"; ValueType: string;  ValueData: "TiLP.Real"; Tasks: tifiles;
Root: HKCR; SubKey: ".85p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".85r"; ValueType: string;  ValueData: "TiLP.Range"; Tasks: tifiles;
Root: HKCR; SubKey: ".85s"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".85v"; ValueType: string;  ValueData: "TiLP.Vector"; Tasks: tifiles;
Root: HKCR; SubKey: ".85w"; ValueType: string;  ValueData: "TiLP.Window_Setup"; Tasks: tifiles;
Root: HKCR; SubKey: ".85y"; ValueType: string;  ValueData: "TiLP.Y_Var"; Tasks: tifiles;
Root: HKCR; SubKey: ".85z"; ValueType: string;  ValueData: "TiLP.Zoom"; Tasks: tifiles;
Root: HKCR; SubKey: ".85?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI83+ file entries
Root: HKCR; SubKey: ".8xb"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xc"; ValueType: string;  ValueData: "TiLP.Complex"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xd"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xg"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xi"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xk"; ValueType: string;  ValueData: "TiLP.Application"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xl"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xm"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xn"; ValueType: string;  ValueData: "TiLP.Real"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xp"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xq"; ValueType: string;  ValueData: "TiLP.Certificate"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xs"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xt"; ValueType: string;  ValueData: "TiLP.Text"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xu"; ValueType: string;  ValueData: "TiLP.OS_Upgrade"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xv"; ValueType: string;  ValueData: "TiLP.App_Variable"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xw"; ValueType: string;  ValueData: "TiLP.Window_Setup"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xy"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".8xz"; ValueType: string;  ValueData: "TiLP.Zoom"; Tasks: tifiles;
Root: HKCR; SubKey: ".8x?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI83 file entries
Root: HKCR; SubKey: ".83b"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".83c"; ValueType: string;  ValueData: "TiLP.Complex"; Tasks: tifiles;
Root: HKCR; SubKey: ".83d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".83g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".83i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".83l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".83m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".83n"; ValueType: string;  ValueData: "TiLP.Real"; Tasks: tifiles;
Root: HKCR; SubKey: ".83p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".83s"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".83t"; ValueType: string;  ValueData: "TiLP.Text"; Tasks: tifiles;
Root: HKCR; SubKey: ".83w"; ValueType: string;  ValueData: "TiLP.Window_Setup"; Tasks: tifiles;
Root: HKCR; SubKey: ".83y"; ValueType: string;  ValueData: "TiLP.Y_Var"; Tasks: tifiles;
Root: HKCR; SubKey: ".83z"; ValueType: string;  ValueData: "TiLP.Zoom"; Tasks: tifiles;
Root: HKCR; SubKey: ".83?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI82 file entries
Root: HKCR; SubKey: ".82b"; ValueType: string;  ValueData: "TiLP.Backup"; Tasks: tifiles;
Root: HKCR; SubKey: ".82d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".82g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".82i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".82l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".82m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".82n"; ValueType: string;  ValueData: "TiLP.Real"; Tasks: tifiles;
Root: HKCR; SubKey: ".82p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".82t"; ValueType: string;  ValueData: "TiLP.Text"; Tasks: tifiles;
Root: HKCR; SubKey: ".82w"; ValueType: string;  ValueData: "TiLP.Window_Setup"; Tasks: tifiles;
Root: HKCR; SubKey: ".82y"; ValueType: string;  ValueData: "TiLP.Y_Var"; Tasks: tifiles;
Root: HKCR; SubKey: ".82z"; ValueType: string;  ValueData: "TiLP.Zoom"; Tasks: tifiles;
Root: HKCR; SubKey: ".82?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; TI73 file entries
Root: HKCR; SubKey: ".73c"; ValueType: string;  ValueData: "TiLP.Complex"; Tasks: tifiles;
Root: HKCR; SubKey: ".73d"; ValueType: string;  ValueData: "TiLP.GDB"; Tasks: tifiles;
Root: HKCR; SubKey: ".73g"; ValueType: string;  ValueData: "TiLP.Group"; Tasks: tifiles;
Root: HKCR; SubKey: ".73i"; ValueType: string;  ValueData: "TiLP.Picture"; Tasks: tifiles;
Root: HKCR; SubKey: ".73m"; ValueType: string;  ValueData: "TiLP.Matrix"; Tasks: tifiles;
Root: HKCR; SubKey: ".73k"; ValueType: string;  ValueData: "TiLP.Application"; Tasks: tifiles;
Root: HKCR; SubKey: ".73l"; ValueType: string;  ValueData: "TiLP.List"; Tasks: tifiles;
Root: HKCR; SubKey: ".73n"; ValueType: string;  ValueData: "TiLP.Real"; Tasks: tifiles;
Root: HKCR; SubKey: ".73p"; ValueType: string;  ValueData: "TiLP.Program"; Tasks: tifiles;
Root: HKCR; SubKey: ".73q"; ValueType: string;  ValueData: "TiLP.Certificate"; Tasks: tifiles;
Root: HKCR; SubKey: ".73z"; ValueType: string;  ValueData: "TiLP.Zoom"; Tasks: tifiles;
Root: HKCR; SubKey: ".73s"; ValueType: string;  ValueData: "TiLP.String"; Tasks: tifiles;
Root: HKCR; SubKey: ".73t"; ValueType: string;  ValueData: "TiLP.Table_Setup"; Tasks: tifiles;
Root: HKCR; SubKey: ".73u"; ValueType: string;  ValueData: "TiLP.OS_Upgrade"; Tasks: tifiles;
Root: HKCR; SubKey: ".73v"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".73w"; ValueType: string;  ValueData: "TiLP.Window_Setup"; Tasks: tifiles;
Root: HKCR; SubKey: ".73y"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
Root: HKCR; SubKey: ".73?"; ValueType: string;  ValueData: "TiLP.Unknown"; Tasks: tifiles;
; Register generic types
Root: HKCR; Subkey: "TiLP.Application"; ValueType: string; ValueName: ""; ValueData: "Application"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Application\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Application.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Application\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Application\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.App_Variable"; ValueType: string; ValueName: ""; ValueData: "App_Variable"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.App_Variable\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Application.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.App_Variable\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.App_Variable\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Asm_Program"; ValueType: string; ValueName: ""; ValueData: "Asm_Program"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Asm_Program\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Asm_Program.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Asm_Program\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Asm_Program\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Backup"; ValueType: string; ValueName: ""; ValueData: "Backup"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Backup\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Backup.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Backup\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Backup\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Certificate"; ValueType: string; ValueName: ""; ValueData: "Certificate"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Certificate\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Certificate.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Certificate\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Certificate\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Complex"; ValueType: string; ValueName: ""; ValueData: "Complex"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Complex\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Complex.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Complex\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Complex\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Constant"; ValueType: string; ValueName: ""; ValueData: "Constant"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Constant\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Constant.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Constant\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Constant\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Data"; ValueType: string; ValueName: ""; ValueData: "Data"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Data\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Data.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Data\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Data\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Equation"; ValueType: string; ValueName: ""; ValueData: "Equation"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Equation\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Equation.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Equation\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Equation\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Expression"; ValueType: string; ValueName: ""; ValueData: "Expression"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Expression\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Expression.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Expression\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Expression\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Figure"; ValueType: string; ValueName: ""; ValueData: "Figure"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Figure\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Figure.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Figure\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Figure\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Function"; ValueType: string; ValueName: ""; ValueData: "Function"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Function\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Function.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Function\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Function\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.GDB"; ValueType: string; ValueName: ""; ValueData: "Graphic Data Base"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.GDB\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\GDB.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.GDB\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.GDB\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Group"; ValueType: string; ValueName: ""; ValueData: "Group"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Group\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Group.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Group\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Group\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.List"; ValueType: string; ValueName: ""; ValueData: "List"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.List\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\List.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.List\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.List\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Macro"; ValueType: string; ValueName: ""; ValueData: "Macro"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Macro\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Macro.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Macro\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Macro\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Matrix"; ValueType: string; ValueName: ""; ValueData: "Matrix"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Matrix\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Matrix.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Matrix\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Matrix\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.OS_Upgrade"; ValueType: string; ValueName: ""; ValueData: "OS_Upgrade"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.OS_Upgrade\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\OS_Upgrade.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.OS_Upgrade\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.OS_Upgrade\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Picture"; ValueType: string; ValueName: ""; ValueData: "Picture"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Picture\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Picture.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Picture\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Picture\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Program"; ValueType: string; ValueName: ""; ValueData: "Program"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Program\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Program.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Program\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Program\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Range"; ValueType: string; ValueName: ""; ValueData: "Range"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Range\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Range.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Range\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Range\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Real"; ValueType: string; ValueName: ""; ValueData: "Real"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Real\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Real.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Real\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Real\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.String"; ValueType: string; ValueName: ""; ValueData: "String"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.String\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\String.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.String\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.String\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Table_Setup"; ValueType: string; ValueName: ""; ValueData: "Table_Setup"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Table_Setup\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Table_Setup.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Table_Setup\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Table_Setup\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Text"; ValueType: string; ValueName: ""; ValueData: "Text"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Text\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Text.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Text\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Text\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Unknown"; ValueType: string; ValueName: ""; ValueData: "Unknown"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Unknown\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Unknown.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Unknown\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Unknown\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Vector"; ValueType: string; ValueName: ""; ValueData: "Vector"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Vector\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Vector.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Vector\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Vector\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Window_Setup"; ValueType: string; ValueName: ""; ValueData: "Window_Setup"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Window_Setup\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Window_Setup.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Window_Setup\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Window_Setup\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Y_Var"; ValueType: string; ValueName: ""; ValueData: "Y_Var"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Y_Var\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Equation.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Y_Var\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Y_Var\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Zipped"; ValueType: string; ValueName: ""; ValueData: "Zipped"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Zipped\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Zipped.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Zipped\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Zipped\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Zoom"; ValueType: string; ValueName: ""; ValueData: "Zoom"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Zoom\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\Zoom.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Zoom\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Zoom\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

Root: HKCR; Subkey: "TiLP.Document"; ValueType: string; ValueName: ""; ValueData: "Document"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Document\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\icons\TIIcon1.ico"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Document\shell\open";  ValueType: string; ValueData: "Open with &TiLP"; Tasks: tifiles;
Root: HKCR; Subkey: "TiLP.Document\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\tilp.exe"" ""%1"""; Tasks: tifiles;

; Add LPG & GTK libraries to the tilp's path
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\tilp.exe"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\tilp.exe"; ValueType: string; ValueData: "{app}\tilp.exe"; Flags: uninsdeletevalue
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\tilp.exe"; ValueType: string; ValueName: "Path"; ValueData: "{app};{code:GetLpgDllPath};{code:GetGtkDllPath}"; Flags: uninsdeletevalue;

[UninstallDelete]
Type: files; Name: "{app}\tilp2.url"
Type: files; Name: "{app}\gfm.url"

;; Taken from "http://www.dropline.net/gtk/support.php" with some customizations

[Code]
var
  WimpPath: string;

// BEGIN: Version comparison code (http://www.vincenzo.net/isxkb/index.php?title=MDAC_-_How_to_detect_version_of_MDAC_installed)
procedure DecodeVersion (verstr: String; var verint: array of Integer);
var
  i,p: Integer; s: string;
begin
  // initialize array
  verint := [0,0,0,0];
  i := 0;
  while ((Length(verstr) > 0) and (i < 4)) do
  begin
  	p := pos ('.', verstr);
  	if p > 0 then
  	begin
      if p = 1 then s:= '0' else s:= Copy (verstr, 1, p - 1);
  	  verint[i] := StrToInt(s);
  	  i := i + 1;
  	  verstr := Copy (verstr, p+1, Length(verstr));
  	end
  	else
  	begin
  	  verint[i] := StrToInt (verstr);
  	  verstr := '';
  	end;
  end;

end;

// This function compares version strings
// return -1 if ver1 < ver2
// return  0 if ver1 = ver2
// return  1 if ver1 > ver2
function CompareVersion (ver1, ver2: String) : Integer;
var
  verint1, verint2: array of Integer;
  i: integer;
begin

  SetArrayLength (verint1, 4);
  DecodeVersion (ver1, verint1);

  SetArrayLength (verint2, 4);
  DecodeVersion (ver2, verint2);

  Result := 0; i := 0;
  while ((Result = 0) and ( i < 4 )) do
  begin
  	if verint1[i] > verint2[i] then
  	  Result := 1
  	else
      if verint1[i] < verint2[i] then
  	    Result := -1
  	  else
  	    Result := 0;
  	i := i + 1;
  end;

end;
// END: Version comparison code

// Check GTK installation
function IsGtkInstalled(): Boolean;
var
  Exists: boolean;
  GtkPath: string;
begin
  Exists := RegQueryStringValue (HKLM, 'Software\GTK\2.0', 'Path', GtkPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\GTK\2.0', 'Path', GtkPath);
  end;
   Result := Exists
end;

// Get GTK installation path
function GetGtkPath(S: String): String;
var
  Exists: boolean;
  GtkPath: string;
begin
  GtkPath := '';

  Exists := RegQueryStringValue (HKLM, 'Software\GTK\2.0', 'Path', GtkPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\GTK\2.0', 'Path', GtkPath);
  end;

  Result := GtkPath
end;

// Get GTK version
function GetGtkVersion(): string;
var
  Exists: boolean;
  GtkVersion: string;
begin
  GtkVersion := '';

  Exists := RegQueryStringValue (HKLM, 'Software\GTK\2.0', 'Version', GtkVersion);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\GTK\2.0', 'Version', GtkVersion);
  end;
  
  Result := GtkVersion
end;

// Get GTK DLL path
function GetGtkDllPath(S: String): String;
var
  Exists: boolean;
  GtkDllPath: string;
begin
  GtkDllPath := '';

  Result := GetGtkPath('') + '\bin';
end;

// Get LPG installation path
function GetLpgPath(S: String): String;
var
  Exists: boolean;
  LpgPath: string;
begin
  LpgPath := '';

 Exists := RegQueryStringValue (HKLM, 'Software\LPG Shared', 'Path', LpgPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\LPG Shared', 'Path', LpgPath);
  end;

  Result := LpgPath
end;

// Get shared components path
function GetLpgDllPath (S: String): String;
var
  Exists: boolean;
  LpgPath: string;
begin
  Exists := RegQueryStringValue (HKLM, 'Software\LPG Shared', 'DllPath', LpgPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\LPG Shared', 'DllPath', LpgPath);
  end;
  Result := LpgPath;
end;

function GetLpgDllCount (S: String): Integer;
var
  Exists: boolean;
  Path: string;
  Count: Cardinal;
begin
  path := ExpandConstant('{cf}\LPG Shared\' + S);
  Exists := RegQueryDWordValue (HKLM, 'Software\Microsoft\Windows\CurrentVersion\SharedDLLs\', Path, Count);
end;

// Check for minimum USB driver version
function IsTiglUsbVersion3Mini (): Boolean;
var
  Version: String;
begin
  GetVersionNumbersString('C:\WinNT\System\TiglUsb.dll', Version);
  if CompareStr(Version, '3.0.0.0') < 0 then begin
    Result := false;
  end;
end;

// Display warning about GTK version
function DisplayWarning(I: Integer): Boolean;
var
  S: String;
begin
  if(I = 1) then begin
    S := 'The GTK+ libraries are not installed: ';
  end;
  if(I = 2) then begin
    S := 'The GTK+ libraries are installed but the version is old: ';
  end;
  MsgBox(S + 'you will need the GTK+ 2.12.x Runtime Environnement! But, the installer can download and install it for you; simply remember to check the box at the last tab/page. Otherwise, you can still download it from the start menu (start menu > programs > tilp > install gtk+ from the web).', mbError, MB_OK);
end;

// Check for previous program presence and uninstall if needed
function CheckUninstall(S: String): Boolean;
var
  Exists: boolean;
  UnInsExe: String;
  ResultCode: Integer;
  I: Integer;
  L: Integer;
begin
  Exists := RegKeyExists(HKLM, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\' + S + '_is1');
  Result := false;

  if Exists then begin
    if MsgBox('The program need to be uninstalled. Click YES to uninstall it or NO to force installation.', mbConfirmation, MB_YESNO) = IDNO
    then begin
      Result := true
    end
    else begin
      if RegQueryStringValue(HKLM, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\' + S + '_is1', 'UninstallString', uninsexe) then
      begin

        L := Length(uninsexe);
        for I:=1 to L-1
        do begin
          uninsexe[i] := uninsexe[i+1];
        end;
        SetLength(uninsexe, L-2);
        
        if not Exec(uninsexe, '', '', SW_SHOW, ewWaitUntilTerminated, ResultCode)
        then begin
            Result := false;
        end
        else begin
          if ResultCode <> 0
          then begin
            Result := false;
          end
          else begin
            Result := true;
          end;
        end;
      end;
    end;
  end
  else begin
    Result := true;
  end;
end;

// Does various checks before doing anything
function InitializeSetup(): Boolean;
begin
  // Retrieve GTK path
  if not IsGtkInstalled() then begin
    DisplayWarning(1);
  end;

  // Retrieve GTK version and compare
  if IsGtkInstalled() then begin
    if CompareVersion(GetGtkVersion(), '2.12.9') < 0 then begin
        DisplayWarning(2);
    end;
  end;

  // Check version of USB driver
  if IsTiglUsbVersion3Mini() then begin
    MsgBox('SilverLink driver v2.x has been removed of your system. Now, TiLP/TiEmu/GFM require v3.x (check out the README for download location).', mbError, MB_OK);
  end;

  // Check for non-NT and WiMP theme
  WimpPath := GetGtkPath('') + '\lib\gtk-2.0\2.4.0\engines\libwimp.dll';
  if FileExists(WimpPath) and not UsingWinNT() then begin
    MsgBox('Tip: you are running a non-NT platform with the GTK+ WiMP theme engine installed. If you get a lot of warnings about fonts in console, run the Gtk+ Theme Selector as provided in the start menu group of TiLP/TiEmu', mbError, MB_OK);
  end;
  
  // Uninstall before installing new release
  if not CheckUninstall('TiLP2') then
    Result := false
  else
    Result := true;
end;

// Delete shared DLL
procedure DeleteDll(const FileName: string);
var
  pf: string;
begin
  pf := ExpandConstant('{app}');
  DeleteFile(pf + '\' + Filename);
end;

// Delete shared EXE
procedure DeleteExe(const FileName: string);
begin
  DeleteDll(FileName);
end;

