/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_TINT_GUI_PREVIEWPANE_HPP
#define INDII_TINT_GUI_PREVIEWPANE_HPP

#include "Pane.hpp"
#include "PreviewImage.hpp"
#include "../image/ImageResource.hpp"
#include "../model/Model.hpp"
#include "../model/Controller.hpp"

#include "wx/panel.h"

namespace indii {
/**
 * Preview pane.
 */
class PreviewPane : public wxPanel {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   * @param res Image resource.
   * @param model Model.
   * @param control Controller.
   */
  PreviewPane(wxWindow* parent, ImageResource* res, Model* model,
      Controller* control = NULL);

  /**
   * Get preview image.
   */
  PreviewImage* getPreviewImage();

  /**
   * Context sensitive help.
   */
  void OnHelp(wxHelpEvent& evt);
  void OnSetFocus(wxFocusEvent& evt);

private:
  /**
   * Preview image.
   */
  PreviewImage* preview;

  DECLARE_EVENT_TABLE()

};
}

inline indii::PreviewImage* indii::PreviewPane::getPreviewImage() {
  return preview;
}

#endif
