#pragma once

/* Syscalls from  arch/mips/kernel/scall64-n32.S */
struct syscalltable syscalls_mips[] = {
	{ .entry = &syscall_read },			/* 6000 */
	{ .entry = &syscall_write },
	{ .entry = &syscall_open },
	{ .entry = &syscall_close },
	{ .entry = &syscall_newstat },
	{ .entry = &syscall_newfstat },			/* 6005 */
	{ .entry = &syscall_newlstat },
	{ .entry = &syscall_poll },
	{ .entry = &syscall_lseek },
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_mips_mmap },	*/
	{ .entry = &syscall_mprotect },			/* 6010 */
	{ .entry = &syscall_munmap },
	{ .entry = &syscall_brk },
	{ .entry = &syscall_rt_sigaction },
	{ .entry = &syscall_rt_sigprocmask },
	{ .entry = &syscall_ioctl },		/* 6015 */
	{ .entry = &syscall_pread64 },
	{ .entry = &syscall_pwrite64 },
	{ .entry = &syscall_readv },
	{ .entry = &syscall_writev },
	{ .entry = &syscall_access },			/* 6020 */
	{ .entry = &syscall_pipe },
	{ .entry = &syscall_select },
	{ .entry = &syscall_sched_yield },
	{ .entry = &syscall_mremap },
	{ .entry = &syscall_msync },			/* 6025 */
	{ .entry = &syscall_mincore },
	{ .entry = &syscall_madvise },
	{ .entry = &syscall_shmget },
	{ .entry = &syscall_shmat },
	{ .entry = &syscall_shmctl },			/* 6030 */
	{ .entry = &syscall_dup },
	{ .entry = &syscall_dup2 },
	{ .entry = &syscall_pause },
	{ .entry = &syscall_nanosleep },
	{ .entry = &syscall_getitimer },		/* 6035 */
	{ .entry = &syscall_setitimer },
	{ .entry = &syscall_alarm },
	{ .entry = &syscall_getpid },
	{ .entry = &syscall_sendfile },
	{ .entry = &syscall_socket },			/* 6040 */
	{ .entry = &syscall_connect },
	{ .entry = &syscall_accept },
	{ .entry = &syscall_sendto },
	{ .entry = &syscall_recvfrom },
	{ .entry = &syscall_sendmsg },		/* 6045 */
	{ .entry = &syscall_recvmsg },
	{ .entry = &syscall_shutdown },
	{ .entry = &syscall_bind },
	{ .entry = &syscall_listen },
	{ .entry = &syscall_getsockname },			/* 6050 */
	{ .entry = &syscall_getpeername },
	{ .entry = &syscall_socketpair },
	{ .entry = &syscall_setsockopt },
	{ .entry = &syscall_getsockopt },
	{ .entry = &syscall_clone },		/* 6055 */
	{ .entry = &syscall_fork },
	{ .entry = &syscall_execve },
	{ .entry = &syscall_exit },
	{ .entry = &syscall_wait4 },
	{ .entry = &syscall_kill },			/* 6060 */
	{ .entry = &syscall_newuname },
	{ .entry = &syscall_semget },
	{ .entry = &syscall_semop },
	{ .entry = &syscall_semctl },
	{ .entry = &syscall_shmdt },			/* 6065 */
	{ .entry = &syscall_msgget },
	{ .entry = &syscall_msgsnd },
	{ .entry = &syscall_msgrcv },
	{ .entry = &syscall_msgctl },
	{ .entry = &syscall_fcntl },		/* 6070 */
	{ .entry = &syscall_flock },
	{ .entry = &syscall_fsync },
	{ .entry = &syscall_fdatasync },
	{ .entry = &syscall_truncate },
	{ .entry = &syscall_ftruncate },			/* 6075 */
	{ .entry = &syscall_getdents },
	{ .entry = &syscall_getcwd },
	{ .entry = &syscall_chdir },
	{ .entry = &syscall_fchdir },
	{ .entry = &syscall_rename },			/* 6080 */
	{ .entry = &syscall_mkdir },
	{ .entry = &syscall_rmdir },
	{ .entry = &syscall_creat },
	{ .entry = &syscall_link },
	{ .entry = &syscall_unlink },			/* 6085 */
	{ .entry = &syscall_symlink },
	{ .entry = &syscall_readlink },
	{ .entry = &syscall_chmod },
	{ .entry = &syscall_fchmod },
	{ .entry = &syscall_chown },			/* 6090 */
	{ .entry = &syscall_fchown },
	{ .entry = &syscall_lchown },
	{ .entry = &syscall_umask },
	{ .entry = &syscall_gettimeofday },
	{ .entry = &syscall_getrlimit },		/* 6095 */
	{ .entry = &syscall_getrusage },
	{ .entry = &syscall_sysinfo },
	{ .entry = &syscall_times },
	{ .entry = &syscall_ptrace },
	{ .entry = &syscall_getuid },			/* 6100 */
	{ .entry = &syscall_syslog },
	{ .entry = &syscall_getgid },
	{ .entry = &syscall_setuid },
	{ .entry = &syscall_setgid },
	{ .entry = &syscall_geteuid },			/* 6105 */
	{ .entry = &syscall_getegid },
	{ .entry = &syscall_setpgid },
	{ .entry = &syscall_getppid },
	{ .entry = &syscall_getpgrp },
	{ .entry = &syscall_setsid },			/* 6110 */
	{ .entry = &syscall_setreuid },
	{ .entry = &syscall_setregid },
	{ .entry = &syscall_getgroups },
	{ .entry = &syscall_setgroups },
	{ .entry = &syscall_setresuid },			/* 6115 */
	{ .entry = &syscall_getresuid },
	{ .entry = &syscall_setresgid },
	{ .entry = &syscall_getresgid },
	{ .entry = &syscall_getpgid },
	{ .entry = &syscall_setfsuid },			/* 6120 */
	{ .entry = &syscall_setfsgid },
	{ .entry = &syscall_getsid },
	{ .entry = &syscall_capget },
	{ .entry = &syscall_capset },
	{ .entry = &syscall_rt_sigpending },	/* 6125 */
	{ .entry = &syscall_rt_sigtimedwait },
	{ .entry = &syscall_rt_sigqueueinfo },
	{ .entry = &syscall_rt_sigsuspend },
	{ .entry = &syscall_sigaltstack },
	{ .entry = &syscall_utime },		/* 6130 */
	{ .entry = &syscall_mknod },
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_32_personality },	*/
	{ .entry = &syscall_ustat },
	{ .entry = &syscall_statfs },
	{ .entry = &syscall_fstatfs },		/* 6135 */
	{ .entry = &syscall_sysfs },
	{ .entry = &syscall_getpriority },
	{ .entry = &syscall_setpriority },
	{ .entry = &syscall_sched_setparam },
	{ .entry = &syscall_sched_getparam },		/* 6140 */
	{ .entry = &syscall_sched_setscheduler },
	{ .entry = &syscall_sched_getscheduler },
	{ .entry = &syscall_sched_get_priority_max },
	{ .entry = &syscall_sched_get_priority_min },
	{ .entry = &syscall_sched_rr_get_interval },	/* 6145 */
	{ .entry = &syscall_mlock },
	{ .entry = &syscall_munlock },
	{ .entry = &syscall_mlockall },
	{ .entry = &syscall_munlockall },
	{ .entry = &syscall_vhangup },			/* 6150 */
	{ .entry = &syscall_pivot_root },
	{ .entry = &syscall_sysctl },
	{ .entry = &syscall_prctl },
	{ .entry = &syscall_adjtimex },
	{ .entry = &syscall_setrlimit },		/* 6155 */
	{ .entry = &syscall_chroot },
	{ .entry = &syscall_sync },
	{ .entry = &syscall_acct },
	{ .entry = &syscall_settimeofday },
	{ .entry = &syscall_mount },		/* 6160 */
	{ .entry = &syscall_umount },
	{ .entry = &syscall_swapon },
	{ .entry = &syscall_swapoff },
	{ .entry = &syscall_reboot },
	{ .entry = &syscall_sethostname },			/* 6165 */
	{ .entry = &syscall_setdomainname },
	{ .entry = &syscall_ni_syscall },			/* was create_module */
	{ .entry = &syscall_init_module },
	{ .entry = &syscall_delete_module },
	{ .entry = &syscall_ni_syscall },			/* 6170, was get_kernel_syms */
	{ .entry = &syscall_ni_syscall },			/* was query_module */
	{ .entry = &syscall_quotactl },
	{ .entry = &syscall_ni_syscall },			/* was nfsservctl */
	{ .entry = &syscall_ni_syscall },			/* res. for getpmsg */
	{ .entry = &syscall_ni_syscall },			/* 6175	 for putpmsg */
	{ .entry = &syscall_ni_syscall },			/* res. for afs_syscall */
	{ .entry = &syscall_ni_syscall },			/* res. for security */
	{ .entry = &syscall_gettid },
	{ .entry = &syscall_readahead },
	{ .entry = &syscall_setxattr },			/* 6180 */
	{ .entry = &syscall_lsetxattr },
	{ .entry = &syscall_fsetxattr },
	{ .entry = &syscall_getxattr },
	{ .entry = &syscall_lgetxattr },
	{ .entry = &syscall_fgetxattr },			/* 6185 */
	{ .entry = &syscall_listxattr },
	{ .entry = &syscall_llistxattr },
	{ .entry = &syscall_flistxattr },
	{ .entry = &syscall_removexattr },
	{ .entry = &syscall_lremovexattr },		/* 6190 */
	{ .entry = &syscall_fremovexattr },
	{ .entry = &syscall_tkill },
	{ .entry = &syscall_ni_syscall },
	{ .entry = &syscall_futex },
	{ .entry = &syscall_sched_setaffinity },	/* 6195 */
	{ .entry = &syscall_sched_getaffinity },
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_cacheflush },	*/
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_cachectl },	*/
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_sysmips },	*/
	{ .entry = &syscall_io_setup },			/* 6200 */
	{ .entry = &syscall_io_destroy },
	{ .entry = &syscall_io_getevents },
	{ .entry = &syscall_io_submit },
	{ .entry = &syscall_io_cancel },
	{ .entry = &syscall_exit_group },			/* 6205 */
	{ .entry = &syscall_lookup_dcookie },
	{ .entry = &syscall_epoll_create },
	{ .entry = &syscall_epoll_ctl },
	{ .entry = &syscall_epoll_wait },
	{ .entry = &syscall_remap_file_pages },		/* 6210 */
	{ .entry = &syscall_rt_sigreturn },
	{ .entry = &syscall_ni_syscall },
/*	{ .entry = &syscall_fcntl64 },	*/
	{ .entry = &syscall_set_tid_address },
	{ .entry = &syscall_restart_syscall },
	{ .entry = &syscall_semtimedop },			/* 6215 */
	{ .entry = &syscall_fadvise64_64 },
	{ .entry = &syscall_statfs64 },
	{ .entry = &syscall_fstatfs64 },
	{ .entry = &syscall_sendfile64 },
	{ .entry = &syscall_timer_create },		/* 6220 */
	{ .entry = &syscall_timer_settime },
	{ .entry = &syscall_timer_gettime },
	{ .entry = &syscall_timer_getoverrun },
	{ .entry = &syscall_timer_delete },
	{ .entry = &syscall_clock_settime },		/* 6225 */
	{ .entry = &syscall_clock_gettime },
	{ .entry = &syscall_clock_getres },
	{ .entry = &syscall_clock_nanosleep },
	{ .entry = &syscall_tgkill },
	{ .entry = &syscall_utimes },		/* 6230 */
	{ .entry = &syscall_mbind },
	{ .entry = &syscall_get_mempolicy },
	{ .entry = &syscall_set_mempolicy },
	{ .entry = &syscall_mq_open },
	{ .entry = &syscall_mq_unlink },			/* 6235 */
	{ .entry = &syscall_mq_timedsend },
	{ .entry = &syscall_mq_timedreceive },
	{ .entry = &syscall_mq_notify },
	{ .entry = &syscall_mq_getsetattr },
	{ .entry = &syscall_ni_syscall },			/* 6240, sys_vserver */
	{ .entry = &syscall_waitid },
	{ .entry = &syscall_ni_syscall },			/* available, was setaltroot */
	{ .entry = &syscall_add_key },
	{ .entry = &syscall_request_key },
	{ .entry = &syscall_keyctl },		/* 6245 */
	{ .entry = &syscall_ni_syscall },	/* obsolete "set_thread_area" syscall */
	{ .entry = &syscall_inotify_init },
	{ .entry = &syscall_inotify_add_watch },
	{ .entry = &syscall_inotify_rm_watch },
	{ .entry = &syscall_migrate_pages },	/* 6250 */
	{ .entry = &syscall_openat },
	{ .entry = &syscall_mkdirat },
	{ .entry = &syscall_mknodat },
	{ .entry = &syscall_fchownat },
	{ .entry = &syscall_futimesat },		/* 6255 */
	{ .entry = &syscall_newfstatat },
	{ .entry = &syscall_unlinkat },
	{ .entry = &syscall_renameat },
	{ .entry = &syscall_linkat },
	{ .entry = &syscall_symlinkat },			/* 6260 */
	{ .entry = &syscall_readlinkat },
	{ .entry = &syscall_fchmodat },
	{ .entry = &syscall_faccessat },
	{ .entry = &syscall_pselect6 },
	{ .entry = &syscall_ppoll },		/* 6265 */
	{ .entry = &syscall_unshare },
	{ .entry = &syscall_splice },
	{ .entry = &syscall_sync_file_range },
	{ .entry = &syscall_tee },
	{ .entry = &syscall_vmsplice },		/* 6270 */
	{ .entry = &syscall_move_pages },
	{ .entry = &syscall_set_robust_list },
	{ .entry = &syscall_get_robust_list },
	{ .entry = &syscall_kexec_load },
	{ .entry = &syscall_getcpu },			/* 6275 */
	{ .entry = &syscall_epoll_pwait },
	{ .entry = &syscall_ioprio_set },
	{ .entry = &syscall_ioprio_get },
	{ .entry = &syscall_utimensat },
	{ .entry = &syscall_signalfd },		/* 6280 */
	{ .entry = &syscall_ni_syscall },			/* was timerfd */
	{ .entry = &syscall_eventfd },
	{ .entry = &syscall_fallocate },
	{ .entry = &syscall_timerfd_create },
	{ .entry = &syscall_timerfd_gettime },	/* 6285 */
	{ .entry = &syscall_timerfd_settime },
	{ .entry = &syscall_signalfd4 },
	{ .entry = &syscall_eventfd2 },
	{ .entry = &syscall_epoll_create1 },
	{ .entry = &syscall_dup3 },			/* 6290 */
	{ .entry = &syscall_pipe2 },
	{ .entry = &syscall_inotify_init1 },
	{ .entry = &syscall_preadv },
	{ .entry = &syscall_pwritev },
	{ .entry = &syscall_rt_tgsigqueueinfo },	/* 6295 */
	{ .entry = &syscall_perf_event_open },
	{ .entry = &syscall_accept4 },
	{ .entry = &syscall_recvmmsg },
	{ .entry = &syscall_getdents64 },
	{ .entry = &syscall_fanotify_init },		/* 6300 */
	{ .entry = &syscall_fanotify_mark },
	{ .entry = &syscall_prlimit64 },
	{ .entry = &syscall_name_to_handle_at },
	{ .entry = &syscall_open_by_handle_at },
	{ .entry = &syscall_clock_adjtime },	/* 6305 */
	{ .entry = &syscall_syncfs },
	{ .entry = &syscall_sendmmsg },
	{ .entry = &syscall_setns },
	{ .entry = &syscall_process_vm_readv },
	{ .entry = &syscall_process_vm_writev },	/* 6310 */
	{ .entry = &syscall_kcmp },
	{ .entry = &syscall_finit_module },
	{ .entry = &syscall_sched_setattr },
	{ .entry = &syscall_sched_getattr },
	{ .entry = &syscall_renameat2 },			/* 6315 */
	{ .entry = &syscall_seccomp },
	{ .entry = &syscall_getrandom },
	{ .entry = &syscall_memfd_create },
#ifdef USE_BPF
	{ .entry = &syscall_bpf },
#else
	{ .entry = NULL },
#endif
	{ .entry = &syscall_execveat },		/* 6320 */
	{ .entry = &syscall_userfaultfd },
	{ .entry = &syscall_membarrier },
	{ .entry = &syscall_mlock2 },
	{ .entry = &syscall_copy_file_range },
	{ .entry = &syscall_preadv2 },		/* 6325 */
	{ .entry = &syscall_pwritev2 },
	{ .entry = &syscall_pkey_mprotect },
	{ .entry = &syscall_pkey_alloc },
	{ .entry = &syscall_pkey_free },
	{ .entry = &syscall_statx },			/* 6330 */
};
