/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2008-2010 Richard Hughes <richard@hughsie.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * SECTION:upower
 * @short_description: Client objects for accessing UPower
 * @see_also: #UpClient, #UpDevice
 *
 * These objects allow client programs to trivially get details about the power
 * state, and about devices on the system.
 */

#ifndef __UPOWER_H__
#define __UPOWER_H__

#define __UPOWER_H_INSIDE__

#include <libupower-glib/up-version.h>
#include <libupower-glib/up-types.h>
#include <libupower-glib/up-client.h>
#include <libupower-glib/up-device.h>
#include <libupower-glib/up-history-item.h>
#include <libupower-glib/up-stats-item.h>

#include <libupower-glib/up-autocleanups.h>

#undef __UPOWER_H_INSIDE__

#endif /* __UPOWER_H__ */
