// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SCVTF_8H_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_SCVTF_8H_2OPIMM_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_scvtf_8H_2OPIMM[] = {
  0xf6c0, 0xf6c0, 0xf680, 0xf640, 0xd800, 0xd400, 0xbc00, 0x0000,
  0xf2c0, 0xf2c0, 0xf280, 0xf240, 0xd400, 0xd000, 0xb800, 0x0000,
  0xeec0, 0xeec0, 0xee80, 0xee40, 0xd000, 0xcc00, 0xb400, 0x0000,
  0xeac0, 0xeac0, 0xea80, 0xea40, 0xcc00, 0xc800, 0xb000, 0x0000,
  0xe6c0, 0xe6c0, 0xe680, 0xe640, 0xc800, 0xc400, 0xac00, 0x0000,
  0xe2c0, 0xe2c0, 0xe280, 0xe240, 0xc400, 0xc000, 0xa800, 0x0000,
  0xdec0, 0xdec0, 0xde80, 0xde40, 0xc000, 0xbc00, 0xa400, 0x0000,
  0xdac0, 0xdac0, 0xda80, 0xda40, 0xbc00, 0xb800, 0xa000, 0x0000,
  0xd6c0, 0xd6c0, 0xd680, 0xd640, 0xb800, 0xb400, 0x9c00, 0x0000,
  0xd2c0, 0xd2c0, 0xd280, 0xd240, 0xb400, 0xb000, 0x9800, 0x0000,
  0xcec0, 0xcec0, 0xce80, 0xce40, 0xb000, 0xac00, 0x9400, 0x0000,
  0xcac0, 0xcac0, 0xca80, 0xca40, 0xac00, 0xa800, 0x9000, 0x0000,
  0xc6c0, 0xc6c0, 0xc680, 0xc640, 0xa800, 0xa400, 0x8c00, 0x0000,
  0xc2c0, 0xc2c0, 0xc280, 0xc240, 0xa400, 0xa000, 0x8800, 0x0000,
  0xbec0, 0xbec0, 0xbe80, 0xbe40, 0xa000, 0x9c00, 0x8400, 0x0000,
  0xbac0, 0xbac0, 0xba80, 0xba40, 0x9c00, 0x9800, 0x8200, 0x0000,
  0xb6c0, 0xb6c0, 0xb680, 0xb640, 0x9800, 0x9400, 0x8100, 0x0000,
  0xf6c0, 0xf680, 0xf640, 0xd800, 0xd400, 0xbc00, 0x0000, 0x3c00,
  0xf2c0, 0xf280, 0xf240, 0xd400, 0xd000, 0xb800, 0x0000, 0x3800,
  0xeec0, 0xee80, 0xee40, 0xd000, 0xcc00, 0xb400, 0x0000, 0x3400,
  0xeac0, 0xea80, 0xea40, 0xcc00, 0xc800, 0xb000, 0x0000, 0x3000,
  0xe6c0, 0xe680, 0xe640, 0xc800, 0xc400, 0xac00, 0x0000, 0x2c00,
  0xe2c0, 0xe280, 0xe240, 0xc400, 0xc000, 0xa800, 0x0000, 0x2800,
  0xdec0, 0xde80, 0xde40, 0xc000, 0xbc00, 0xa400, 0x0000, 0x2400,
  0xdac0, 0xda80, 0xda40, 0xbc00, 0xb800, 0xa000, 0x0000, 0x2000,
  0xd6c0, 0xd680, 0xd640, 0xb800, 0xb400, 0x9c00, 0x0000, 0x1c00,
  0xd2c0, 0xd280, 0xd240, 0xb400, 0xb000, 0x9800, 0x0000, 0x1800,
  0xcec0, 0xce80, 0xce40, 0xb000, 0xac00, 0x9400, 0x0000, 0x1400,
  0xcac0, 0xca80, 0xca40, 0xac00, 0xa800, 0x9000, 0x0000, 0x1000,
  0xc6c0, 0xc680, 0xc640, 0xa800, 0xa400, 0x8c00, 0x0000, 0x0c00,
  0xc2c0, 0xc280, 0xc240, 0xa400, 0xa000, 0x8800, 0x0000, 0x0800,
  0xbec0, 0xbe80, 0xbe40, 0xa000, 0x9c00, 0x8400, 0x0000, 0x0400,
  0xbac0, 0xba80, 0xba40, 0x9c00, 0x9800, 0x8200, 0x0000, 0x0200,
  0xb6c0, 0xb680, 0xb640, 0x9800, 0x9400, 0x8100, 0x0000, 0x0100,
  0xf680, 0xf640, 0xd800, 0xd400, 0xbc00, 0x0000, 0x3c00, 0x4000,
  0xf280, 0xf240, 0xd400, 0xd000, 0xb800, 0x0000, 0x3800, 0x3c00,
  0xee80, 0xee40, 0xd000, 0xcc00, 0xb400, 0x0000, 0x3400, 0x3800,
  0xea80, 0xea40, 0xcc00, 0xc800, 0xb000, 0x0000, 0x3000, 0x3400,
  0xe680, 0xe640, 0xc800, 0xc400, 0xac00, 0x0000, 0x2c00, 0x3000,
  0xe280, 0xe240, 0xc400, 0xc000, 0xa800, 0x0000, 0x2800, 0x2c00,
  0xde80, 0xde40, 0xc000, 0xbc00, 0xa400, 0x0000, 0x2400, 0x2800,
  0xda80, 0xda40, 0xbc00, 0xb800, 0xa000, 0x0000, 0x2000, 0x2400,
  0xd680, 0xd640, 0xb800, 0xb400, 0x9c00, 0x0000, 0x1c00, 0x2000,
  0xd280, 0xd240, 0xb400, 0xb000, 0x9800, 0x0000, 0x1800, 0x1c00,
  0xce80, 0xce40, 0xb000, 0xac00, 0x9400, 0x0000, 0x1400, 0x1800,
  0xca80, 0xca40, 0xac00, 0xa800, 0x9000, 0x0000, 0x1000, 0x1400,
  0xc680, 0xc640, 0xa800, 0xa400, 0x8c00, 0x0000, 0x0c00, 0x1000,
  0xc280, 0xc240, 0xa400, 0xa000, 0x8800, 0x0000, 0x0800, 0x0c00,
  0xbe80, 0xbe40, 0xa000, 0x9c00, 0x8400, 0x0000, 0x0400, 0x0800,
  0xba80, 0xba40, 0x9c00, 0x9800, 0x8200, 0x0000, 0x0200, 0x0400,
  0xb680, 0xb640, 0x9800, 0x9400, 0x8100, 0x0000, 0x0100, 0x0200,
  0xf640, 0xd800, 0xd400, 0xbc00, 0x0000, 0x3c00, 0x4000, 0x4c00,
  0xf240, 0xd400, 0xd000, 0xb800, 0x0000, 0x3800, 0x3c00, 0x4800,
  0xee40, 0xd000, 0xcc00, 0xb400, 0x0000, 0x3400, 0x3800, 0x4400,
  0xea40, 0xcc00, 0xc800, 0xb000, 0x0000, 0x3000, 0x3400, 0x4000,
  0xe640, 0xc800, 0xc400, 0xac00, 0x0000, 0x2c00, 0x3000, 0x3c00,
  0xe240, 0xc400, 0xc000, 0xa800, 0x0000, 0x2800, 0x2c00, 0x3800,
  0xde40, 0xc000, 0xbc00, 0xa400, 0x0000, 0x2400, 0x2800, 0x3400,
  0xda40, 0xbc00, 0xb800, 0xa000, 0x0000, 0x2000, 0x2400, 0x3000,
  0xd640, 0xb800, 0xb400, 0x9c00, 0x0000, 0x1c00, 0x2000, 0x2c00,
  0xd240, 0xb400, 0xb000, 0x9800, 0x0000, 0x1800, 0x1c00, 0x2800,
  0xce40, 0xb000, 0xac00, 0x9400, 0x0000, 0x1400, 0x1800, 0x2400,
  0xca40, 0xac00, 0xa800, 0x9000, 0x0000, 0x1000, 0x1400, 0x2000,
  0xc640, 0xa800, 0xa400, 0x8c00, 0x0000, 0x0c00, 0x1000, 0x1c00,
  0xc240, 0xa400, 0xa000, 0x8800, 0x0000, 0x0800, 0x0c00, 0x1800,
  0xbe40, 0xa000, 0x9c00, 0x8400, 0x0000, 0x0400, 0x0800, 0x1400,
  0xba40, 0x9c00, 0x9800, 0x8200, 0x0000, 0x0200, 0x0400, 0x1000,
  0xb640, 0x9800, 0x9400, 0x8100, 0x0000, 0x0100, 0x0200, 0x0c00,
  0xd800, 0xd400, 0xbc00, 0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0,
  0xd400, 0xd000, 0xb800, 0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0,
  0xd000, 0xcc00, 0xb400, 0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0,
  0xcc00, 0xc800, 0xb000, 0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0,
  0xc800, 0xc400, 0xac00, 0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0,
  0xc400, 0xc000, 0xa800, 0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0,
  0xc000, 0xbc00, 0xa400, 0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0,
  0xbc00, 0xb800, 0xa000, 0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0,
  0xb800, 0xb400, 0x9c00, 0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0,
  0xb400, 0xb000, 0x9800, 0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0,
  0xb000, 0xac00, 0x9400, 0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0,
  0xac00, 0xa800, 0x9000, 0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0,
  0xa800, 0xa400, 0x8c00, 0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0,
  0xa400, 0xa000, 0x8800, 0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0,
  0xa000, 0x9c00, 0x8400, 0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0,
  0x9c00, 0x9800, 0x8200, 0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0,
  0x9800, 0x9400, 0x8100, 0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0,
  0xd400, 0xbc00, 0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0,
  0xd000, 0xb800, 0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0,
  0xcc00, 0xb400, 0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0,
  0xc800, 0xb000, 0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0,
  0xc400, 0xac00, 0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0,
  0xc000, 0xa800, 0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0,
  0xbc00, 0xa400, 0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0,
  0xb800, 0xa000, 0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0,
  0xb400, 0x9c00, 0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0,
  0xb000, 0x9800, 0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0,
  0xac00, 0x9400, 0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0,
  0xa800, 0x9000, 0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0,
  0xa400, 0x8c00, 0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0,
  0xa000, 0x8800, 0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0,
  0x9c00, 0x8400, 0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0,
  0x9800, 0x8200, 0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0,
  0x9400, 0x8100, 0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0,
  0xbc00, 0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0,
  0xb800, 0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0,
  0xb400, 0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0,
  0xb000, 0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0,
  0xac00, 0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0,
  0xa800, 0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0,
  0xa400, 0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0,
  0xa000, 0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0,
  0x9c00, 0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0,
  0x9800, 0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0,
  0x9400, 0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0,
  0x9000, 0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0,
  0x8c00, 0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0,
  0x8800, 0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0,
  0x8400, 0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0,
  0x8200, 0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0,
  0x8100, 0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0,
  0x0000, 0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266,
  0x0000, 0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66,
  0x0000, 0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66,
  0x0000, 0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666,
  0x0000, 0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266,
  0x0000, 0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66,
  0x0000, 0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66,
  0x0000, 0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666,
  0x0000, 0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266,
  0x0000, 0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66,
  0x0000, 0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66,
  0x0000, 0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666,
  0x0000, 0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266,
  0x0000, 0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66,
  0x0000, 0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66,
  0x0000, 0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666,
  0x0000, 0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266,
  0x3c00, 0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555,
  0x3800, 0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155,
  0x3400, 0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55,
  0x3000, 0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955,
  0x2c00, 0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555,
  0x2800, 0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155,
  0x2400, 0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55,
  0x2000, 0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955,
  0x1c00, 0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555,
  0x1800, 0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155,
  0x1400, 0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55,
  0x1000, 0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955,
  0x0c00, 0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555,
  0x0800, 0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155,
  0x0400, 0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55,
  0x0200, 0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955,
  0x0100, 0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555,
  0x4000, 0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800,
  0x3c00, 0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400,
  0x3800, 0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000,
  0x3400, 0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00,
  0x3000, 0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800,
  0x2c00, 0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400,
  0x2800, 0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000,
  0x2400, 0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00,
  0x2000, 0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800,
  0x1c00, 0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400,
  0x1800, 0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000,
  0x1400, 0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00,
  0x1000, 0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800,
  0x0c00, 0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400,
  0x0800, 0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000,
  0x0400, 0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00,
  0x0200, 0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800,
  0x4c00, 0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800, 0x7800,
  0x4800, 0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400,
  0x4400, 0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000,
  0x4000, 0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00,
  0x3c00, 0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800, 0x6800,
  0x3800, 0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400,
  0x3400, 0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000,
  0x3000, 0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00,
  0x2c00, 0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800, 0x5800,
  0x2800, 0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400,
  0x2400, 0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000,
  0x2000, 0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00,
  0x1c00, 0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800, 0x4800,
  0x1800, 0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400,
  0x1400, 0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000,
  0x1000, 0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00,
  0x0c00, 0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800, 0x3800,
  0x57d0, 0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800, 0x7800, 0x7800,
  0x53d0, 0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400, 0x7400,
  0x4fd0, 0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000,
  0x4bd0, 0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00,
  0x47d0, 0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800, 0x6800, 0x6800,
  0x43d0, 0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400, 0x6400,
  0x3fd0, 0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000,
  0x3bd0, 0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00,
  0x37d0, 0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800, 0x5800, 0x5800,
  0x33d0, 0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400, 0x5400,
  0x2fd0, 0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000,
  0x2bd0, 0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00,
  0x27d0, 0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800, 0x4800, 0x4800,
  0x23d0, 0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400, 0x4400,
  0x1fd0, 0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000,
  0x1bd0, 0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00,
  0x17d0, 0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800, 0x3800, 0x3800,
  0x57e0, 0x57f0, 0x7266, 0x7555, 0x7800, 0x7800, 0x7800, 0xf800,
  0x53e0, 0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400, 0x7400, 0xf400,
  0x4fe0, 0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000, 0xf000,
  0x4be0, 0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00, 0xec00,
  0x47e0, 0x47f0, 0x6266, 0x6555, 0x6800, 0x6800, 0x6800, 0xe800,
  0x43e0, 0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400, 0x6400, 0xe400,
  0x3fe0, 0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000, 0xe000,
  0x3be0, 0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00, 0xdc00,
  0x37e0, 0x37f0, 0x5266, 0x5555, 0x5800, 0x5800, 0x5800, 0xd800,
  0x33e0, 0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400, 0x5400, 0xd400,
  0x2fe0, 0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000, 0xd000,
  0x2be0, 0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00, 0xcc00,
  0x27e0, 0x27f0, 0x4266, 0x4555, 0x4800, 0x4800, 0x4800, 0xc800,
  0x23e0, 0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400, 0x4400, 0xc400,
  0x1fe0, 0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000, 0xc000,
  0x1be0, 0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00, 0xbc00,
  0x17e0, 0x17f0, 0x3266, 0x3555, 0x3800, 0x3800, 0x3800, 0xb800,
  0x57f0, 0x7266, 0x7555, 0x7800, 0x7800, 0x7800, 0xf800, 0xf800,
  0x53f0, 0x6e66, 0x7155, 0x7400, 0x7400, 0x7400, 0xf400, 0xf400,
  0x4ff0, 0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000, 0xf000, 0xf000,
  0x4bf0, 0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00, 0xec00, 0xec00,
  0x47f0, 0x6266, 0x6555, 0x6800, 0x6800, 0x6800, 0xe800, 0xe800,
  0x43f0, 0x5e66, 0x6155, 0x6400, 0x6400, 0x6400, 0xe400, 0xe400,
  0x3ff0, 0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000, 0xe000, 0xe000,
  0x3bf0, 0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00, 0xdc00, 0xdc00,
  0x37f0, 0x5266, 0x5555, 0x5800, 0x5800, 0x5800, 0xd800, 0xd800,
  0x33f0, 0x4e66, 0x5155, 0x5400, 0x5400, 0x5400, 0xd400, 0xd400,
  0x2ff0, 0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000, 0xd000, 0xd000,
  0x2bf0, 0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00, 0xcc00, 0xcc00,
  0x27f0, 0x4266, 0x4555, 0x4800, 0x4800, 0x4800, 0xc800, 0xc800,
  0x23f0, 0x3e66, 0x4155, 0x4400, 0x4400, 0x4400, 0xc400, 0xc400,
  0x1ff0, 0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000, 0xc000, 0xc000,
  0x1bf0, 0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00, 0xbc00, 0xbc00,
  0x17f0, 0x3266, 0x3555, 0x3800, 0x3800, 0x3800, 0xb800, 0xb800,
  0x7266, 0x7555, 0x7800, 0x7800, 0x7800, 0xf800, 0xf800, 0xf555,
  0x6e66, 0x7155, 0x7400, 0x7400, 0x7400, 0xf400, 0xf400, 0xf155,
  0x6a66, 0x6d55, 0x7000, 0x7000, 0x7000, 0xf000, 0xf000, 0xed55,
  0x6666, 0x6955, 0x6c00, 0x6c00, 0x6c00, 0xec00, 0xec00, 0xe955,
  0x6266, 0x6555, 0x6800, 0x6800, 0x6800, 0xe800, 0xe800, 0xe555,
  0x5e66, 0x6155, 0x6400, 0x6400, 0x6400, 0xe400, 0xe400, 0xe155,
  0x5a66, 0x5d55, 0x6000, 0x6000, 0x6000, 0xe000, 0xe000, 0xdd55,
  0x5666, 0x5955, 0x5c00, 0x5c00, 0x5c00, 0xdc00, 0xdc00, 0xd955,
  0x5266, 0x5555, 0x5800, 0x5800, 0x5800, 0xd800, 0xd800, 0xd555,
  0x4e66, 0x5155, 0x5400, 0x5400, 0x5400, 0xd400, 0xd400, 0xd155,
  0x4a66, 0x4d55, 0x5000, 0x5000, 0x5000, 0xd000, 0xd000, 0xcd55,
  0x4666, 0x4955, 0x4c00, 0x4c00, 0x4c00, 0xcc00, 0xcc00, 0xc955,
  0x4266, 0x4555, 0x4800, 0x4800, 0x4800, 0xc800, 0xc800, 0xc555,
  0x3e66, 0x4155, 0x4400, 0x4400, 0x4400, 0xc400, 0xc400, 0xc155,
  0x3a66, 0x3d55, 0x4000, 0x4000, 0x4000, 0xc000, 0xc000, 0xbd55,
  0x3666, 0x3955, 0x3c00, 0x3c00, 0x3c00, 0xbc00, 0xbc00, 0xb955,
  0x3266, 0x3555, 0x3800, 0x3800, 0x3800, 0xb800, 0xb800, 0xb555,
  0x7555, 0x7800, 0x7800, 0x7800, 0xf800, 0xf800, 0xf555, 0xf266,
  0x7155, 0x7400, 0x7400, 0x7400, 0xf400, 0xf400, 0xf155, 0xee66,
  0x6d55, 0x7000, 0x7000, 0x7000, 0xf000, 0xf000, 0xed55, 0xea66,
  0x6955, 0x6c00, 0x6c00, 0x6c00, 0xec00, 0xec00, 0xe955, 0xe666,
  0x6555, 0x6800, 0x6800, 0x6800, 0xe800, 0xe800, 0xe555, 0xe266,
  0x6155, 0x6400, 0x6400, 0x6400, 0xe400, 0xe400, 0xe155, 0xde66,
  0x5d55, 0x6000, 0x6000, 0x6000, 0xe000, 0xe000, 0xdd55, 0xda66,
  0x5955, 0x5c00, 0x5c00, 0x5c00, 0xdc00, 0xdc00, 0xd955, 0xd666,
  0x5555, 0x5800, 0x5800, 0x5800, 0xd800, 0xd800, 0xd555, 0xd266,
  0x5155, 0x5400, 0x5400, 0x5400, 0xd400, 0xd400, 0xd155, 0xce66,
  0x4d55, 0x5000, 0x5000, 0x5000, 0xd000, 0xd000, 0xcd55, 0xca66,
  0x4955, 0x4c00, 0x4c00, 0x4c00, 0xcc00, 0xcc00, 0xc955, 0xc666,
  0x4555, 0x4800, 0x4800, 0x4800, 0xc800, 0xc800, 0xc555, 0xc266,
  0x4155, 0x4400, 0x4400, 0x4400, 0xc400, 0xc400, 0xc155, 0xbe66,
  0x3d55, 0x4000, 0x4000, 0x4000, 0xc000, 0xc000, 0xbd55, 0xba66,
  0x3955, 0x3c00, 0x3c00, 0x3c00, 0xbc00, 0xbc00, 0xb955, 0xb666,
  0x3555, 0x3800, 0x3800, 0x3800, 0xb800, 0xb800, 0xb555, 0xb266,
  0x7800, 0x7800, 0x7800, 0xf800, 0xf800, 0xf555, 0xf266, 0xd800,
  0x7400, 0x7400, 0x7400, 0xf400, 0xf400, 0xf155, 0xee66, 0xd400,
  0x7000, 0x7000, 0x7000, 0xf000, 0xf000, 0xed55, 0xea66, 0xd000,
  0x6c00, 0x6c00, 0x6c00, 0xec00, 0xec00, 0xe955, 0xe666, 0xcc00,
  0x6800, 0x6800, 0x6800, 0xe800, 0xe800, 0xe555, 0xe266, 0xc800,
  0x6400, 0x6400, 0x6400, 0xe400, 0xe400, 0xe155, 0xde66, 0xc400,
  0x6000, 0x6000, 0x6000, 0xe000, 0xe000, 0xdd55, 0xda66, 0xc000,
  0x5c00, 0x5c00, 0x5c00, 0xdc00, 0xdc00, 0xd955, 0xd666, 0xbc00,
  0x5800, 0x5800, 0x5800, 0xd800, 0xd800, 0xd555, 0xd266, 0xb800,
  0x5400, 0x5400, 0x5400, 0xd400, 0xd400, 0xd155, 0xce66, 0xb400,
  0x5000, 0x5000, 0x5000, 0xd000, 0xd000, 0xcd55, 0xca66, 0xb000,
  0x4c00, 0x4c00, 0x4c00, 0xcc00, 0xcc00, 0xc955, 0xc666, 0xac00,
  0x4800, 0x4800, 0x4800, 0xc800, 0xc800, 0xc555, 0xc266, 0xa800,
  0x4400, 0x4400, 0x4400, 0xc400, 0xc400, 0xc155, 0xbe66, 0xa400,
  0x4000, 0x4000, 0x4000, 0xc000, 0xc000, 0xbd55, 0xba66, 0xa000,
  0x3c00, 0x3c00, 0x3c00, 0xbc00, 0xbc00, 0xb955, 0xb666, 0x9c00,
  0x3800, 0x3800, 0x3800, 0xb800, 0xb800, 0xb555, 0xb266, 0x9800,
  0x7800, 0x7800, 0xf800, 0xf800, 0xf555, 0xf266, 0xd800, 0xd7f0,
  0x7400, 0x7400, 0xf400, 0xf400, 0xf155, 0xee66, 0xd400, 0xd3f0,
  0x7000, 0x7000, 0xf000, 0xf000, 0xed55, 0xea66, 0xd000, 0xcff0,
  0x6c00, 0x6c00, 0xec00, 0xec00, 0xe955, 0xe666, 0xcc00, 0xcbf0,
  0x6800, 0x6800, 0xe800, 0xe800, 0xe555, 0xe266, 0xc800, 0xc7f0,
  0x6400, 0x6400, 0xe400, 0xe400, 0xe155, 0xde66, 0xc400, 0xc3f0,
  0x6000, 0x6000, 0xe000, 0xe000, 0xdd55, 0xda66, 0xc000, 0xbff0,
  0x5c00, 0x5c00, 0xdc00, 0xdc00, 0xd955, 0xd666, 0xbc00, 0xbbf0,
  0x5800, 0x5800, 0xd800, 0xd800, 0xd555, 0xd266, 0xb800, 0xb7f0,
  0x5400, 0x5400, 0xd400, 0xd400, 0xd155, 0xce66, 0xb400, 0xb3f0,
  0x5000, 0x5000, 0xd000, 0xd000, 0xcd55, 0xca66, 0xb000, 0xaff0,
  0x4c00, 0x4c00, 0xcc00, 0xcc00, 0xc955, 0xc666, 0xac00, 0xabf0,
  0x4800, 0x4800, 0xc800, 0xc800, 0xc555, 0xc266, 0xa800, 0xa7f0,
  0x4400, 0x4400, 0xc400, 0xc400, 0xc155, 0xbe66, 0xa400, 0xa3f0,
  0x4000, 0x4000, 0xc000, 0xc000, 0xbd55, 0xba66, 0xa000, 0x9ff0,
  0x3c00, 0x3c00, 0xbc00, 0xbc00, 0xb955, 0xb666, 0x9c00, 0x9bf0,
  0x3800, 0x3800, 0xb800, 0xb800, 0xb555, 0xb266, 0x9800, 0x97f0,
  0x7800, 0xf800, 0xf800, 0xf555, 0xf266, 0xd800, 0xd7f0, 0xd7e0,
  0x7400, 0xf400, 0xf400, 0xf155, 0xee66, 0xd400, 0xd3f0, 0xd3e0,
  0x7000, 0xf000, 0xf000, 0xed55, 0xea66, 0xd000, 0xcff0, 0xcfe0,
  0x6c00, 0xec00, 0xec00, 0xe955, 0xe666, 0xcc00, 0xcbf0, 0xcbe0,
  0x6800, 0xe800, 0xe800, 0xe555, 0xe266, 0xc800, 0xc7f0, 0xc7e0,
  0x6400, 0xe400, 0xe400, 0xe155, 0xde66, 0xc400, 0xc3f0, 0xc3e0,
  0x6000, 0xe000, 0xe000, 0xdd55, 0xda66, 0xc000, 0xbff0, 0xbfe0,
  0x5c00, 0xdc00, 0xdc00, 0xd955, 0xd666, 0xbc00, 0xbbf0, 0xbbe0,
  0x5800, 0xd800, 0xd800, 0xd555, 0xd266, 0xb800, 0xb7f0, 0xb7e0,
  0x5400, 0xd400, 0xd400, 0xd155, 0xce66, 0xb400, 0xb3f0, 0xb3e0,
  0x5000, 0xd000, 0xd000, 0xcd55, 0xca66, 0xb000, 0xaff0, 0xafe0,
  0x4c00, 0xcc00, 0xcc00, 0xc955, 0xc666, 0xac00, 0xabf0, 0xabe0,
  0x4800, 0xc800, 0xc800, 0xc555, 0xc266, 0xa800, 0xa7f0, 0xa7e0,
  0x4400, 0xc400, 0xc400, 0xc155, 0xbe66, 0xa400, 0xa3f0, 0xa3e0,
  0x4000, 0xc000, 0xc000, 0xbd55, 0xba66, 0xa000, 0x9ff0, 0x9fe0,
  0x3c00, 0xbc00, 0xbc00, 0xb955, 0xb666, 0x9c00, 0x9bf0, 0x9be0,
  0x3800, 0xb800, 0xb800, 0xb555, 0xb266, 0x9800, 0x97f0, 0x97e0,
  0xf800, 0xf800, 0xf555, 0xf266, 0xd800, 0xd7f0, 0xd7e0, 0xd7d0,
  0xf400, 0xf400, 0xf155, 0xee66, 0xd400, 0xd3f0, 0xd3e0, 0xd3d0,
  0xf000, 0xf000, 0xed55, 0xea66, 0xd000, 0xcff0, 0xcfe0, 0xcfd0,
  0xec00, 0xec00, 0xe955, 0xe666, 0xcc00, 0xcbf0, 0xcbe0, 0xcbd0,
  0xe800, 0xe800, 0xe555, 0xe266, 0xc800, 0xc7f0, 0xc7e0, 0xc7d0,
  0xe400, 0xe400, 0xe155, 0xde66, 0xc400, 0xc3f0, 0xc3e0, 0xc3d0,
  0xe000, 0xe000, 0xdd55, 0xda66, 0xc000, 0xbff0, 0xbfe0, 0xbfd0,
  0xdc00, 0xdc00, 0xd955, 0xd666, 0xbc00, 0xbbf0, 0xbbe0, 0xbbd0,
  0xd800, 0xd800, 0xd555, 0xd266, 0xb800, 0xb7f0, 0xb7e0, 0xb7d0,
  0xd400, 0xd400, 0xd155, 0xce66, 0xb400, 0xb3f0, 0xb3e0, 0xb3d0,
  0xd000, 0xd000, 0xcd55, 0xca66, 0xb000, 0xaff0, 0xafe0, 0xafd0,
  0xcc00, 0xcc00, 0xc955, 0xc666, 0xac00, 0xabf0, 0xabe0, 0xabd0,
  0xc800, 0xc800, 0xc555, 0xc266, 0xa800, 0xa7f0, 0xa7e0, 0xa7d0,
  0xc400, 0xc400, 0xc155, 0xbe66, 0xa400, 0xa3f0, 0xa3e0, 0xa3d0,
  0xc000, 0xc000, 0xbd55, 0xba66, 0xa000, 0x9ff0, 0x9fe0, 0x9fd0,
  0xbc00, 0xbc00, 0xb955, 0xb666, 0x9c00, 0x9bf0, 0x9be0, 0x9bd0,
  0xb800, 0xb800, 0xb555, 0xb266, 0x9800, 0x97f0, 0x97e0, 0x97d0,
  0xf800, 0xf555, 0xf266, 0xd800, 0xd7f0, 0xd7e0, 0xd7d0, 0xcc00,
  0xf400, 0xf155, 0xee66, 0xd400, 0xd3f0, 0xd3e0, 0xd3d0, 0xc800,
  0xf000, 0xed55, 0xea66, 0xd000, 0xcff0, 0xcfe0, 0xcfd0, 0xc400,
  0xec00, 0xe955, 0xe666, 0xcc00, 0xcbf0, 0xcbe0, 0xcbd0, 0xc000,
  0xe800, 0xe555, 0xe266, 0xc800, 0xc7f0, 0xc7e0, 0xc7d0, 0xbc00,
  0xe400, 0xe155, 0xde66, 0xc400, 0xc3f0, 0xc3e0, 0xc3d0, 0xb800,
  0xe000, 0xdd55, 0xda66, 0xc000, 0xbff0, 0xbfe0, 0xbfd0, 0xb400,
  0xdc00, 0xd955, 0xd666, 0xbc00, 0xbbf0, 0xbbe0, 0xbbd0, 0xb000,
  0xd800, 0xd555, 0xd266, 0xb800, 0xb7f0, 0xb7e0, 0xb7d0, 0xac00,
  0xd400, 0xd155, 0xce66, 0xb400, 0xb3f0, 0xb3e0, 0xb3d0, 0xa800,
  0xd000, 0xcd55, 0xca66, 0xb000, 0xaff0, 0xafe0, 0xafd0, 0xa400,
  0xcc00, 0xc955, 0xc666, 0xac00, 0xabf0, 0xabe0, 0xabd0, 0xa000,
  0xc800, 0xc555, 0xc266, 0xa800, 0xa7f0, 0xa7e0, 0xa7d0, 0x9c00,
  0xc400, 0xc155, 0xbe66, 0xa400, 0xa3f0, 0xa3e0, 0xa3d0, 0x9800,
  0xc000, 0xbd55, 0xba66, 0xa000, 0x9ff0, 0x9fe0, 0x9fd0, 0x9400,
  0xbc00, 0xb955, 0xb666, 0x9c00, 0x9bf0, 0x9be0, 0x9bd0, 0x9000,
  0xb800, 0xb555, 0xb266, 0x9800, 0x97f0, 0x97e0, 0x97d0, 0x8c00,
  0xf555, 0xf266, 0xd800, 0xd7f0, 0xd7e0, 0xd7d0, 0xcc00, 0xc200,
  0xf155, 0xee66, 0xd400, 0xd3f0, 0xd3e0, 0xd3d0, 0xc800, 0xbe00,
  0xed55, 0xea66, 0xd000, 0xcff0, 0xcfe0, 0xcfd0, 0xc400, 0xba00,
  0xe955, 0xe666, 0xcc00, 0xcbf0, 0xcbe0, 0xcbd0, 0xc000, 0xb600,
  0xe555, 0xe266, 0xc800, 0xc7f0, 0xc7e0, 0xc7d0, 0xbc00, 0xb200,
  0xe155, 0xde66, 0xc400, 0xc3f0, 0xc3e0, 0xc3d0, 0xb800, 0xae00,
  0xdd55, 0xda66, 0xc000, 0xbff0, 0xbfe0, 0xbfd0, 0xb400, 0xaa00,
  0xd955, 0xd666, 0xbc00, 0xbbf0, 0xbbe0, 0xbbd0, 0xb000, 0xa600,
  0xd555, 0xd266, 0xb800, 0xb7f0, 0xb7e0, 0xb7d0, 0xac00, 0xa200,
  0xd155, 0xce66, 0xb400, 0xb3f0, 0xb3e0, 0xb3d0, 0xa800, 0x9e00,
  0xcd55, 0xca66, 0xb000, 0xaff0, 0xafe0, 0xafd0, 0xa400, 0x9a00,
  0xc955, 0xc666, 0xac00, 0xabf0, 0xabe0, 0xabd0, 0xa000, 0x9600,
  0xc555, 0xc266, 0xa800, 0xa7f0, 0xa7e0, 0xa7d0, 0x9c00, 0x9200,
  0xc155, 0xbe66, 0xa400, 0xa3f0, 0xa3e0, 0xa3d0, 0x9800, 0x8e00,
  0xbd55, 0xba66, 0xa000, 0x9ff0, 0x9fe0, 0x9fd0, 0x9400, 0x8a00,
  0xb955, 0xb666, 0x9c00, 0x9bf0, 0x9be0, 0x9bd0, 0x9000, 0x8600,
  0xb555, 0xb266, 0x9800, 0x97f0, 0x97e0, 0x97d0, 0x8c00, 0x8300,
  0xf266, 0xd800, 0xd7f0, 0xd7e0, 0xd7d0, 0xcc00, 0xc200, 0xc000,
  0xee66, 0xd400, 0xd3f0, 0xd3e0, 0xd3d0, 0xc800, 0xbe00, 0xbc00,
  0xea66, 0xd000, 0xcff0, 0xcfe0, 0xcfd0, 0xc400, 0xba00, 0xb800,
  0xe666, 0xcc00, 0xcbf0, 0xcbe0, 0xcbd0, 0xc000, 0xb600, 0xb400,
  0xe266, 0xc800, 0xc7f0, 0xc7e0, 0xc7d0, 0xbc00, 0xb200, 0xb000,
  0xde66, 0xc400, 0xc3f0, 0xc3e0, 0xc3d0, 0xb800, 0xae00, 0xac00,
  0xda66, 0xc000, 0xbff0, 0xbfe0, 0xbfd0, 0xb400, 0xaa00, 0xa800,
  0xd666, 0xbc00, 0xbbf0, 0xbbe0, 0xbbd0, 0xb000, 0xa600, 0xa400,
  0xd266, 0xb800, 0xb7f0, 0xb7e0, 0xb7d0, 0xac00, 0xa200, 0xa000,
  0xce66, 0xb400, 0xb3f0, 0xb3e0, 0xb3d0, 0xa800, 0x9e00, 0x9c00,
  0xca66, 0xb000, 0xaff0, 0xafe0, 0xafd0, 0xa400, 0x9a00, 0x9800,
  0xc666, 0xac00, 0xabf0, 0xabe0, 0xabd0, 0xa000, 0x9600, 0x9400,
  0xc266, 0xa800, 0xa7f0, 0xa7e0, 0xa7d0, 0x9c00, 0x9200, 0x9000,
  0xbe66, 0xa400, 0xa3f0, 0xa3e0, 0xa3d0, 0x9800, 0x8e00, 0x8c00,
  0xba66, 0xa000, 0x9ff0, 0x9fe0, 0x9fd0, 0x9400, 0x8a00, 0x8800,
  0xb666, 0x9c00, 0x9bf0, 0x9be0, 0x9bd0, 0x9000, 0x8600, 0x8400,
  0xb266, 0x9800, 0x97f0, 0x97e0, 0x97d0, 0x8c00, 0x8300, 0x8200,
  0xd800, 0xd7f0, 0xd7e0, 0xd7d0, 0xcc00, 0xc200, 0xc000, 0xbc00,
  0xd400, 0xd3f0, 0xd3e0, 0xd3d0, 0xc800, 0xbe00, 0xbc00, 0xb800,
  0xd000, 0xcff0, 0xcfe0, 0xcfd0, 0xc400, 0xba00, 0xb800, 0xb400,
  0xcc00, 0xcbf0, 0xcbe0, 0xcbd0, 0xc000, 0xb600, 0xb400, 0xb000,
  0xc800, 0xc7f0, 0xc7e0, 0xc7d0, 0xbc00, 0xb200, 0xb000, 0xac00,
  0xc400, 0xc3f0, 0xc3e0, 0xc3d0, 0xb800, 0xae00, 0xac00, 0xa800,
  0xc000, 0xbff0, 0xbfe0, 0xbfd0, 0xb400, 0xaa00, 0xa800, 0xa400,
  0xbc00, 0xbbf0, 0xbbe0, 0xbbd0, 0xb000, 0xa600, 0xa400, 0xa000,
  0xb800, 0xb7f0, 0xb7e0, 0xb7d0, 0xac00, 0xa200, 0xa000, 0x9c00,
  0xb400, 0xb3f0, 0xb3e0, 0xb3d0, 0xa800, 0x9e00, 0x9c00, 0x9800,
  0xb000, 0xaff0, 0xafe0, 0xafd0, 0xa400, 0x9a00, 0x9800, 0x9400,
  0xac00, 0xabf0, 0xabe0, 0xabd0, 0xa000, 0x9600, 0x9400, 0x9000,
  0xa800, 0xa7f0, 0xa7e0, 0xa7d0, 0x9c00, 0x9200, 0x9000, 0x8c00,
  0xa400, 0xa3f0, 0xa3e0, 0xa3d0, 0x9800, 0x8e00, 0x8c00, 0x8800,
  0xa000, 0x9ff0, 0x9fe0, 0x9fd0, 0x9400, 0x8a00, 0x8800, 0x8400,
  0x9c00, 0x9bf0, 0x9be0, 0x9bd0, 0x9000, 0x8600, 0x8400, 0x8200,
  0x9800, 0x97f0, 0x97e0, 0x97d0, 0x8c00, 0x8300, 0x8200, 0x8100,
  0xd7f0, 0xd7e0, 0xd7d0, 0xcc00, 0xc200, 0xc000, 0xbc00, 0x0000,
  0xd3f0, 0xd3e0, 0xd3d0, 0xc800, 0xbe00, 0xbc00, 0xb800, 0x0000,
  0xcff0, 0xcfe0, 0xcfd0, 0xc400, 0xba00, 0xb800, 0xb400, 0x0000,
  0xcbf0, 0xcbe0, 0xcbd0, 0xc000, 0xb600, 0xb400, 0xb000, 0x0000,
  0xc7f0, 0xc7e0, 0xc7d0, 0xbc00, 0xb200, 0xb000, 0xac00, 0x0000,
  0xc3f0, 0xc3e0, 0xc3d0, 0xb800, 0xae00, 0xac00, 0xa800, 0x0000,
  0xbff0, 0xbfe0, 0xbfd0, 0xb400, 0xaa00, 0xa800, 0xa400, 0x0000,
  0xbbf0, 0xbbe0, 0xbbd0, 0xb000, 0xa600, 0xa400, 0xa000, 0x0000,
  0xb7f0, 0xb7e0, 0xb7d0, 0xac00, 0xa200, 0xa000, 0x9c00, 0x0000,
  0xb3f0, 0xb3e0, 0xb3d0, 0xa800, 0x9e00, 0x9c00, 0x9800, 0x0000,
  0xaff0, 0xafe0, 0xafd0, 0xa400, 0x9a00, 0x9800, 0x9400, 0x0000,
  0xabf0, 0xabe0, 0xabd0, 0xa000, 0x9600, 0x9400, 0x9000, 0x0000,
  0xa7f0, 0xa7e0, 0xa7d0, 0x9c00, 0x9200, 0x9000, 0x8c00, 0x0000,
  0xa3f0, 0xa3e0, 0xa3d0, 0x9800, 0x8e00, 0x8c00, 0x8800, 0x0000,
  0x9ff0, 0x9fe0, 0x9fd0, 0x9400, 0x8a00, 0x8800, 0x8400, 0x0000,
  0x9bf0, 0x9be0, 0x9bd0, 0x9000, 0x8600, 0x8400, 0x8200, 0x0000,
  0x97f0, 0x97e0, 0x97d0, 0x8c00, 0x8300, 0x8200, 0x8100, 0x0000,
  0xd7e0, 0xd7d0, 0xcc00, 0xc200, 0xc000, 0xbc00, 0x0000, 0x3c00,
  0xd3e0, 0xd3d0, 0xc800, 0xbe00, 0xbc00, 0xb800, 0x0000, 0x3800,
  0xcfe0, 0xcfd0, 0xc400, 0xba00, 0xb800, 0xb400, 0x0000, 0x3400,
  0xcbe0, 0xcbd0, 0xc000, 0xb600, 0xb400, 0xb000, 0x0000, 0x3000,
  0xc7e0, 0xc7d0, 0xbc00, 0xb200, 0xb000, 0xac00, 0x0000, 0x2c00,
  0xc3e0, 0xc3d0, 0xb800, 0xae00, 0xac00, 0xa800, 0x0000, 0x2800,
  0xbfe0, 0xbfd0, 0xb400, 0xaa00, 0xa800, 0xa400, 0x0000, 0x2400,
  0xbbe0, 0xbbd0, 0xb000, 0xa600, 0xa400, 0xa000, 0x0000, 0x2000,
  0xb7e0, 0xb7d0, 0xac00, 0xa200, 0xa000, 0x9c00, 0x0000, 0x1c00,
  0xb3e0, 0xb3d0, 0xa800, 0x9e00, 0x9c00, 0x9800, 0x0000, 0x1800,
  0xafe0, 0xafd0, 0xa400, 0x9a00, 0x9800, 0x9400, 0x0000, 0x1400,
  0xabe0, 0xabd0, 0xa000, 0x9600, 0x9400, 0x9000, 0x0000, 0x1000,
  0xa7e0, 0xa7d0, 0x9c00, 0x9200, 0x9000, 0x8c00, 0x0000, 0x0c00,
  0xa3e0, 0xa3d0, 0x9800, 0x8e00, 0x8c00, 0x8800, 0x0000, 0x0800,
  0x9fe0, 0x9fd0, 0x9400, 0x8a00, 0x8800, 0x8400, 0x0000, 0x0400,
  0x9be0, 0x9bd0, 0x9000, 0x8600, 0x8400, 0x8200, 0x0000, 0x0200,
  0x97e0, 0x97d0, 0x8c00, 0x8300, 0x8200, 0x8100, 0x0000, 0x0100,
  0xd7d0, 0xcc00, 0xc200, 0xc000, 0xbc00, 0x0000, 0x3c00, 0x6400,
  0xd3d0, 0xc800, 0xbe00, 0xbc00, 0xb800, 0x0000, 0x3800, 0x6000,
  0xcfd0, 0xc400, 0xba00, 0xb800, 0xb400, 0x0000, 0x3400, 0x5c00,
  0xcbd0, 0xc000, 0xb600, 0xb400, 0xb000, 0x0000, 0x3000, 0x5800,
  0xc7d0, 0xbc00, 0xb200, 0xb000, 0xac00, 0x0000, 0x2c00, 0x5400,
  0xc3d0, 0xb800, 0xae00, 0xac00, 0xa800, 0x0000, 0x2800, 0x5000,
  0xbfd0, 0xb400, 0xaa00, 0xa800, 0xa400, 0x0000, 0x2400, 0x4c00,
  0xbbd0, 0xb000, 0xa600, 0xa400, 0xa000, 0x0000, 0x2000, 0x4800,
  0xb7d0, 0xac00, 0xa200, 0xa000, 0x9c00, 0x0000, 0x1c00, 0x4400,
  0xb3d0, 0xa800, 0x9e00, 0x9c00, 0x9800, 0x0000, 0x1800, 0x4000,
  0xafd0, 0xa400, 0x9a00, 0x9800, 0x9400, 0x0000, 0x1400, 0x3c00,
  0xabd0, 0xa000, 0x9600, 0x9400, 0x9000, 0x0000, 0x1000, 0x3800,
  0xa7d0, 0x9c00, 0x9200, 0x9000, 0x8c00, 0x0000, 0x0c00, 0x3400,
  0xa3d0, 0x9800, 0x8e00, 0x8c00, 0x8800, 0x0000, 0x0800, 0x3000,
  0x9fd0, 0x9400, 0x8a00, 0x8800, 0x8400, 0x0000, 0x0400, 0x2c00,
  0x9bd0, 0x9000, 0x8600, 0x8400, 0x8200, 0x0000, 0x0200, 0x2800,
  0x97d0, 0x8c00, 0x8300, 0x8200, 0x8100, 0x0000, 0x0100, 0x2400,
  0xcc00, 0xc200, 0xc000, 0xbc00, 0x0000, 0x3c00, 0x6400, 0x6401,
  0xc800, 0xbe00, 0xbc00, 0xb800, 0x0000, 0x3800, 0x6000, 0x6001,
  0xc400, 0xba00, 0xb800, 0xb400, 0x0000, 0x3400, 0x5c00, 0x5c01,
  0xc000, 0xb600, 0xb400, 0xb000, 0x0000, 0x3000, 0x5800, 0x5801,
  0xbc00, 0xb200, 0xb000, 0xac00, 0x0000, 0x2c00, 0x5400, 0x5401,
  0xb800, 0xae00, 0xac00, 0xa800, 0x0000, 0x2800, 0x5000, 0x5001,
  0xb400, 0xaa00, 0xa800, 0xa400, 0x0000, 0x2400, 0x4c00, 0x4c01,
  0xb000, 0xa600, 0xa400, 0xa000, 0x0000, 0x2000, 0x4800, 0x4801,
  0xac00, 0xa200, 0xa000, 0x9c00, 0x0000, 0x1c00, 0x4400, 0x4401,
  0xa800, 0x9e00, 0x9c00, 0x9800, 0x0000, 0x1800, 0x4000, 0x4001,
  0xa400, 0x9a00, 0x9800, 0x9400, 0x0000, 0x1400, 0x3c00, 0x3c01,
  0xa000, 0x9600, 0x9400, 0x9000, 0x0000, 0x1000, 0x3800, 0x3801,
  0x9c00, 0x9200, 0x9000, 0x8c00, 0x0000, 0x0c00, 0x3400, 0x3401,
  0x9800, 0x8e00, 0x8c00, 0x8800, 0x0000, 0x0800, 0x3000, 0x3001,
  0x9400, 0x8a00, 0x8800, 0x8400, 0x0000, 0x0400, 0x2c00, 0x2c01,
  0x9000, 0x8600, 0x8400, 0x8200, 0x0000, 0x0200, 0x2800, 0x2801,
  0x8c00, 0x8300, 0x8200, 0x8100, 0x0000, 0x0100, 0x2400, 0x2401,
  0xc200, 0xc000, 0xbc00, 0x0000, 0x3c00, 0x6400, 0x6401, 0x6476,
  0xbe00, 0xbc00, 0xb800, 0x0000, 0x3800, 0x6000, 0x6001, 0x6076,
  0xba00, 0xb800, 0xb400, 0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76,
  0xb600, 0xb400, 0xb000, 0x0000, 0x3000, 0x5800, 0x5801, 0x5876,
  0xb200, 0xb000, 0xac00, 0x0000, 0x2c00, 0x5400, 0x5401, 0x5476,
  0xae00, 0xac00, 0xa800, 0x0000, 0x2800, 0x5000, 0x5001, 0x5076,
  0xaa00, 0xa800, 0xa400, 0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76,
  0xa600, 0xa400, 0xa000, 0x0000, 0x2000, 0x4800, 0x4801, 0x4876,
  0xa200, 0xa000, 0x9c00, 0x0000, 0x1c00, 0x4400, 0x4401, 0x4476,
  0x9e00, 0x9c00, 0x9800, 0x0000, 0x1800, 0x4000, 0x4001, 0x4076,
  0x9a00, 0x9800, 0x9400, 0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76,
  0x9600, 0x9400, 0x9000, 0x0000, 0x1000, 0x3800, 0x3801, 0x3876,
  0x9200, 0x9000, 0x8c00, 0x0000, 0x0c00, 0x3400, 0x3401, 0x3476,
  0x8e00, 0x8c00, 0x8800, 0x0000, 0x0800, 0x3000, 0x3001, 0x3076,
  0x8a00, 0x8800, 0x8400, 0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76,
  0x8600, 0x8400, 0x8200, 0x0000, 0x0200, 0x2800, 0x2801, 0x2876,
  0x8300, 0x8200, 0x8100, 0x0000, 0x0100, 0x2400, 0x2401, 0x2476,
  0xc000, 0xbc00, 0x0000, 0x3c00, 0x6400, 0x6401, 0x6476, 0x6800,
  0xbc00, 0xb800, 0x0000, 0x3800, 0x6000, 0x6001, 0x6076, 0x6400,
  0xb800, 0xb400, 0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000,
  0xb400, 0xb000, 0x0000, 0x3000, 0x5800, 0x5801, 0x5876, 0x5c00,
  0xb000, 0xac00, 0x0000, 0x2c00, 0x5400, 0x5401, 0x5476, 0x5800,
  0xac00, 0xa800, 0x0000, 0x2800, 0x5000, 0x5001, 0x5076, 0x5400,
  0xa800, 0xa400, 0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000,
  0xa400, 0xa000, 0x0000, 0x2000, 0x4800, 0x4801, 0x4876, 0x4c00,
  0xa000, 0x9c00, 0x0000, 0x1c00, 0x4400, 0x4401, 0x4476, 0x4800,
  0x9c00, 0x9800, 0x0000, 0x1800, 0x4000, 0x4001, 0x4076, 0x4400,
  0x9800, 0x9400, 0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000,
  0x9400, 0x9000, 0x0000, 0x1000, 0x3800, 0x3801, 0x3876, 0x3c00,
  0x9000, 0x8c00, 0x0000, 0x0c00, 0x3400, 0x3401, 0x3476, 0x3800,
  0x8c00, 0x8800, 0x0000, 0x0800, 0x3000, 0x3001, 0x3076, 0x3400,
  0x8800, 0x8400, 0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000,
  0x8400, 0x8200, 0x0000, 0x0200, 0x2800, 0x2801, 0x2876, 0x2c00,
  0x8200, 0x8100, 0x0000, 0x0100, 0x2400, 0x2401, 0x2476, 0x2800,
  0xbc00, 0x0000, 0x3c00, 0x6400, 0x6401, 0x6476, 0x6800, 0x6800,
  0xb800, 0x0000, 0x3800, 0x6000, 0x6001, 0x6076, 0x6400, 0x6400,
  0xb400, 0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000,
  0xb000, 0x0000, 0x3000, 0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00,
  0xac00, 0x0000, 0x2c00, 0x5400, 0x5401, 0x5476, 0x5800, 0x5800,
  0xa800, 0x0000, 0x2800, 0x5000, 0x5001, 0x5076, 0x5400, 0x5400,
  0xa400, 0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000,
  0xa000, 0x0000, 0x2000, 0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00,
  0x9c00, 0x0000, 0x1c00, 0x4400, 0x4401, 0x4476, 0x4800, 0x4800,
  0x9800, 0x0000, 0x1800, 0x4000, 0x4001, 0x4076, 0x4400, 0x4400,
  0x9400, 0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000,
  0x9000, 0x0000, 0x1000, 0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00,
  0x8c00, 0x0000, 0x0c00, 0x3400, 0x3401, 0x3476, 0x3800, 0x3800,
  0x8800, 0x0000, 0x0800, 0x3000, 0x3001, 0x3076, 0x3400, 0x3400,
  0x8400, 0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000,
  0x8200, 0x0000, 0x0200, 0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00,
  0x8100, 0x0000, 0x0100, 0x2400, 0x2401, 0x2476, 0x2800, 0x2800,
  0x0000, 0x3c00, 0x6400, 0x6401, 0x6476, 0x6800, 0x6800, 0x6a00,
  0x0000, 0x3800, 0x6000, 0x6001, 0x6076, 0x6400, 0x6400, 0x6600,
  0x0000, 0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200,
  0x0000, 0x3000, 0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00,
  0x0000, 0x2c00, 0x5400, 0x5401, 0x5476, 0x5800, 0x5800, 0x5a00,
  0x0000, 0x2800, 0x5000, 0x5001, 0x5076, 0x5400, 0x5400, 0x5600,
  0x0000, 0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200,
  0x0000, 0x2000, 0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00,
  0x0000, 0x1c00, 0x4400, 0x4401, 0x4476, 0x4800, 0x4800, 0x4a00,
  0x0000, 0x1800, 0x4000, 0x4001, 0x4076, 0x4400, 0x4400, 0x4600,
  0x0000, 0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200,
  0x0000, 0x1000, 0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00,
  0x0000, 0x0c00, 0x3400, 0x3401, 0x3476, 0x3800, 0x3800, 0x3a00,
  0x0000, 0x0800, 0x3000, 0x3001, 0x3076, 0x3400, 0x3400, 0x3600,
  0x0000, 0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200,
  0x0000, 0x0200, 0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00,
  0x0000, 0x0100, 0x2400, 0x2401, 0x2476, 0x2800, 0x2800, 0x2a00,
  0x3c00, 0x6400, 0x6401, 0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00,
  0x3800, 0x6000, 0x6001, 0x6076, 0x6400, 0x6400, 0x6600, 0x6600,
  0x3400, 0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200, 0x6200,
  0x3000, 0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00,
  0x2c00, 0x5400, 0x5401, 0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00,
  0x2800, 0x5000, 0x5001, 0x5076, 0x5400, 0x5400, 0x5600, 0x5600,
  0x2400, 0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200, 0x5200,
  0x2000, 0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00,
  0x1c00, 0x4400, 0x4401, 0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00,
  0x1800, 0x4000, 0x4001, 0x4076, 0x4400, 0x4400, 0x4600, 0x4600,
  0x1400, 0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200, 0x4200,
  0x1000, 0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00,
  0x0c00, 0x3400, 0x3401, 0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00,
  0x0800, 0x3000, 0x3001, 0x3076, 0x3400, 0x3400, 0x3600, 0x3600,
  0x0400, 0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200, 0x3200,
  0x0200, 0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00,
  0x0100, 0x2400, 0x2401, 0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00,
  0x6400, 0x6401, 0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00,
  0x6000, 0x6001, 0x6076, 0x6400, 0x6400, 0x6600, 0x6600, 0x6800,
  0x5c00, 0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200, 0x6200, 0x6400,
  0x5800, 0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000,
  0x5400, 0x5401, 0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00,
  0x5000, 0x5001, 0x5076, 0x5400, 0x5400, 0x5600, 0x5600, 0x5800,
  0x4c00, 0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200, 0x5200, 0x5400,
  0x4800, 0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000,
  0x4400, 0x4401, 0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00,
  0x4000, 0x4001, 0x4076, 0x4400, 0x4400, 0x4600, 0x4600, 0x4800,
  0x3c00, 0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200, 0x4200, 0x4400,
  0x3800, 0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000,
  0x3400, 0x3401, 0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00,
  0x3000, 0x3001, 0x3076, 0x3400, 0x3400, 0x3600, 0x3600, 0x3800,
  0x2c00, 0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200, 0x3200, 0x3400,
  0x2800, 0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000,
  0x2400, 0x2401, 0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00,
  0x6401, 0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00,
  0x6001, 0x6076, 0x6400, 0x6400, 0x6600, 0x6600, 0x6800, 0x6800,
  0x5c01, 0x5c76, 0x6000, 0x6000, 0x6200, 0x6200, 0x6400, 0x6400,
  0x5801, 0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000,
  0x5401, 0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00,
  0x5001, 0x5076, 0x5400, 0x5400, 0x5600, 0x5600, 0x5800, 0x5800,
  0x4c01, 0x4c76, 0x5000, 0x5000, 0x5200, 0x5200, 0x5400, 0x5400,
  0x4801, 0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000,
  0x4401, 0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00,
  0x4001, 0x4076, 0x4400, 0x4400, 0x4600, 0x4600, 0x4800, 0x4800,
  0x3c01, 0x3c76, 0x4000, 0x4000, 0x4200, 0x4200, 0x4400, 0x4400,
  0x3801, 0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000,
  0x3401, 0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00,
  0x3001, 0x3076, 0x3400, 0x3400, 0x3600, 0x3600, 0x3800, 0x3800,
  0x2c01, 0x2c76, 0x3000, 0x3000, 0x3200, 0x3200, 0x3400, 0x3400,
  0x2801, 0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000,
  0x2401, 0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00,
  0x6476, 0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00,
  0x6076, 0x6400, 0x6400, 0x6600, 0x6600, 0x6800, 0x6800, 0x6900,
  0x5c76, 0x6000, 0x6000, 0x6200, 0x6200, 0x6400, 0x6400, 0x6500,
  0x5876, 0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100,
  0x5476, 0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00,
  0x5076, 0x5400, 0x5400, 0x5600, 0x5600, 0x5800, 0x5800, 0x5900,
  0x4c76, 0x5000, 0x5000, 0x5200, 0x5200, 0x5400, 0x5400, 0x5500,
  0x4876, 0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100,
  0x4476, 0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00,
  0x4076, 0x4400, 0x4400, 0x4600, 0x4600, 0x4800, 0x4800, 0x4900,
  0x3c76, 0x4000, 0x4000, 0x4200, 0x4200, 0x4400, 0x4400, 0x4500,
  0x3876, 0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100,
  0x3476, 0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00,
  0x3076, 0x3400, 0x3400, 0x3600, 0x3600, 0x3800, 0x3800, 0x3900,
  0x2c76, 0x3000, 0x3000, 0x3200, 0x3200, 0x3400, 0x3400, 0x3500,
  0x2876, 0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100,
  0x2476, 0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00,
  0x6800, 0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00,
  0x6400, 0x6400, 0x6600, 0x6600, 0x6800, 0x6800, 0x6900, 0x6900,
  0x6000, 0x6000, 0x6200, 0x6200, 0x6400, 0x6400, 0x6500, 0x6500,
  0x5c00, 0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100, 0x6100,
  0x5800, 0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00,
  0x5400, 0x5400, 0x5600, 0x5600, 0x5800, 0x5800, 0x5900, 0x5900,
  0x5000, 0x5000, 0x5200, 0x5200, 0x5400, 0x5400, 0x5500, 0x5500,
  0x4c00, 0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100, 0x5100,
  0x4800, 0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00,
  0x4400, 0x4400, 0x4600, 0x4600, 0x4800, 0x4800, 0x4900, 0x4900,
  0x4000, 0x4000, 0x4200, 0x4200, 0x4400, 0x4400, 0x4500, 0x4500,
  0x3c00, 0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100, 0x4100,
  0x3800, 0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00,
  0x3400, 0x3400, 0x3600, 0x3600, 0x3800, 0x3800, 0x3900, 0x3900,
  0x3000, 0x3000, 0x3200, 0x3200, 0x3400, 0x3400, 0x3500, 0x3500,
  0x2c00, 0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100, 0x3100,
  0x2800, 0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00,
  0x6800, 0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00,
  0x6400, 0x6600, 0x6600, 0x6800, 0x6800, 0x6900, 0x6900, 0x6a00,
  0x6000, 0x6200, 0x6200, 0x6400, 0x6400, 0x6500, 0x6500, 0x6600,
  0x5c00, 0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100, 0x6100, 0x6200,
  0x5800, 0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00,
  0x5400, 0x5600, 0x5600, 0x5800, 0x5800, 0x5900, 0x5900, 0x5a00,
  0x5000, 0x5200, 0x5200, 0x5400, 0x5400, 0x5500, 0x5500, 0x5600,
  0x4c00, 0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100, 0x5100, 0x5200,
  0x4800, 0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00,
  0x4400, 0x4600, 0x4600, 0x4800, 0x4800, 0x4900, 0x4900, 0x4a00,
  0x4000, 0x4200, 0x4200, 0x4400, 0x4400, 0x4500, 0x4500, 0x4600,
  0x3c00, 0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100, 0x4100, 0x4200,
  0x3800, 0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00,
  0x3400, 0x3600, 0x3600, 0x3800, 0x3800, 0x3900, 0x3900, 0x3a00,
  0x3000, 0x3200, 0x3200, 0x3400, 0x3400, 0x3500, 0x3500, 0x3600,
  0x2c00, 0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100, 0x3100, 0x3200,
  0x2800, 0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00,
  0x6a00, 0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00,
  0x6600, 0x6600, 0x6800, 0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00,
  0x6200, 0x6200, 0x6400, 0x6400, 0x6500, 0x6500, 0x6600, 0x6700,
  0x5e00, 0x5e00, 0x6000, 0x6000, 0x6100, 0x6100, 0x6200, 0x6300,
  0x5a00, 0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00,
  0x5600, 0x5600, 0x5800, 0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00,
  0x5200, 0x5200, 0x5400, 0x5400, 0x5500, 0x5500, 0x5600, 0x5700,
  0x4e00, 0x4e00, 0x5000, 0x5000, 0x5100, 0x5100, 0x5200, 0x5300,
  0x4a00, 0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00,
  0x4600, 0x4600, 0x4800, 0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00,
  0x4200, 0x4200, 0x4400, 0x4400, 0x4500, 0x4500, 0x4600, 0x4700,
  0x3e00, 0x3e00, 0x4000, 0x4000, 0x4100, 0x4100, 0x4200, 0x4300,
  0x3a00, 0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00,
  0x3600, 0x3600, 0x3800, 0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00,
  0x3200, 0x3200, 0x3400, 0x3400, 0x3500, 0x3500, 0x3600, 0x3700,
  0x2e00, 0x2e00, 0x3000, 0x3000, 0x3100, 0x3100, 0x3200, 0x3300,
  0x2a00, 0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00,
  0x6a00, 0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8,
  0x6600, 0x6800, 0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8,
  0x6200, 0x6400, 0x6400, 0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8,
  0x5e00, 0x6000, 0x6000, 0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8,
  0x5a00, 0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8,
  0x5600, 0x5800, 0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8,
  0x5200, 0x5400, 0x5400, 0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8,
  0x4e00, 0x5000, 0x5000, 0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8,
  0x4a00, 0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8,
  0x4600, 0x4800, 0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8,
  0x4200, 0x4400, 0x4400, 0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8,
  0x3e00, 0x4000, 0x4000, 0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8,
  0x3a00, 0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8,
  0x3600, 0x3800, 0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8,
  0x3200, 0x3400, 0x3400, 0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8,
  0x2e00, 0x3000, 0x3000, 0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8,
  0x2a00, 0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8,
  0x6c00, 0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc,
  0x6800, 0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc,
  0x6400, 0x6400, 0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc,
  0x6000, 0x6000, 0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc,
  0x5c00, 0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc,
  0x5800, 0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc,
  0x5400, 0x5400, 0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc,
  0x5000, 0x5000, 0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc,
  0x4c00, 0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc,
  0x4800, 0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc,
  0x4400, 0x4400, 0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc,
  0x4000, 0x4000, 0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc,
  0x3c00, 0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc,
  0x3800, 0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc,
  0x3400, 0x3400, 0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc,
  0x3000, 0x3000, 0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc,
  0x2c00, 0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc,
  0x6c00, 0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800,
  0x6800, 0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400,
  0x6400, 0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000,
  0x6000, 0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00,
  0x5c00, 0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800,
  0x5800, 0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400,
  0x5400, 0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000,
  0x5000, 0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00,
  0x4c00, 0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800,
  0x4800, 0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400,
  0x4400, 0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000,
  0x4000, 0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00,
  0x3c00, 0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800,
  0x3800, 0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400,
  0x3400, 0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000,
  0x3000, 0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00,
  0x2c00, 0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800,
  0x6d00, 0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800, 0xf800,
  0x6900, 0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400, 0xf400,
  0x6500, 0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000, 0xf000,
  0x6100, 0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0xec00,
  0x5d00, 0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800, 0xe800,
  0x5900, 0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400, 0xe400,
  0x5500, 0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000, 0xe000,
  0x5100, 0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0xdc00,
  0x4d00, 0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800, 0xd800,
  0x4900, 0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400, 0xd400,
  0x4500, 0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000, 0xd000,
  0x4100, 0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0xcc00,
  0x3d00, 0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800, 0xc800,
  0x3900, 0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400, 0xc400,
  0x3500, 0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000, 0xc000,
  0x3100, 0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0xbc00,
  0x2d00, 0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800, 0xb800,
  0x6d00, 0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800, 0xf800, 0xf800,
  0x6900, 0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400, 0xf400, 0xf400,
  0x6500, 0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000, 0xf000, 0xf000,
  0x6100, 0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0xec00, 0xec00,
  0x5d00, 0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800, 0xe800, 0xe800,
  0x5900, 0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400, 0xe400, 0xe400,
  0x5500, 0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000, 0xe000, 0xe000,
  0x5100, 0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0xdc00, 0xdc00,
  0x4d00, 0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800, 0xd800, 0xd800,
  0x4900, 0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400, 0xd400, 0xd400,
  0x4500, 0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000, 0xd000, 0xd000,
  0x4100, 0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0xcc00, 0xcc00,
  0x3d00, 0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800, 0xc800, 0xc800,
  0x3900, 0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400, 0xc400, 0xc400,
  0x3500, 0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000, 0xc000, 0xc000,
  0x3100, 0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0xbc00, 0xbc00,
  0x2d00, 0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800, 0xb800, 0xb800,
  0x6e00, 0x6f00, 0x77f8, 0x77fc, 0x7800, 0xf800, 0xf800, 0xf7c0,
  0x6a00, 0x6b00, 0x73f8, 0x73fc, 0x7400, 0xf400, 0xf400, 0xf3c0,
  0x6600, 0x6700, 0x6ff8, 0x6ffc, 0x7000, 0xf000, 0xf000, 0xefc0,
  0x6200, 0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0xec00, 0xec00, 0xebc0,
  0x5e00, 0x5f00, 0x67f8, 0x67fc, 0x6800, 0xe800, 0xe800, 0xe7c0,
  0x5a00, 0x5b00, 0x63f8, 0x63fc, 0x6400, 0xe400, 0xe400, 0xe3c0,
  0x5600, 0x5700, 0x5ff8, 0x5ffc, 0x6000, 0xe000, 0xe000, 0xdfc0,
  0x5200, 0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0xdc00, 0xdc00, 0xdbc0,
  0x4e00, 0x4f00, 0x57f8, 0x57fc, 0x5800, 0xd800, 0xd800, 0xd7c0,
  0x4a00, 0x4b00, 0x53f8, 0x53fc, 0x5400, 0xd400, 0xd400, 0xd3c0,
  0x4600, 0x4700, 0x4ff8, 0x4ffc, 0x5000, 0xd000, 0xd000, 0xcfc0,
  0x4200, 0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0xcc00, 0xcc00, 0xcbc0,
  0x3e00, 0x3f00, 0x47f8, 0x47fc, 0x4800, 0xc800, 0xc800, 0xc7c0,
  0x3a00, 0x3b00, 0x43f8, 0x43fc, 0x4400, 0xc400, 0xc400, 0xc3c0,
  0x3600, 0x3700, 0x3ff8, 0x3ffc, 0x4000, 0xc000, 0xc000, 0xbfc0,
  0x3200, 0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0xbc00, 0xbc00, 0xbbc0,
  0x2e00, 0x2f00, 0x37f8, 0x37fc, 0x3800, 0xb800, 0xb800, 0xb7c0,
  0x6f00, 0x77f8, 0x77fc, 0x7800, 0xf800, 0xf800, 0xf7c0, 0xf7c0,
  0x6b00, 0x73f8, 0x73fc, 0x7400, 0xf400, 0xf400, 0xf3c0, 0xf3c0,
  0x6700, 0x6ff8, 0x6ffc, 0x7000, 0xf000, 0xf000, 0xefc0, 0xefc0,
  0x6300, 0x6bf8, 0x6bfc, 0x6c00, 0xec00, 0xec00, 0xebc0, 0xebc0,
  0x5f00, 0x67f8, 0x67fc, 0x6800, 0xe800, 0xe800, 0xe7c0, 0xe7c0,
  0x5b00, 0x63f8, 0x63fc, 0x6400, 0xe400, 0xe400, 0xe3c0, 0xe3c0,
  0x5700, 0x5ff8, 0x5ffc, 0x6000, 0xe000, 0xe000, 0xdfc0, 0xdfc0,
  0x5300, 0x5bf8, 0x5bfc, 0x5c00, 0xdc00, 0xdc00, 0xdbc0, 0xdbc0,
  0x4f00, 0x57f8, 0x57fc, 0x5800, 0xd800, 0xd800, 0xd7c0, 0xd7c0,
  0x4b00, 0x53f8, 0x53fc, 0x5400, 0xd400, 0xd400, 0xd3c0, 0xd3c0,
  0x4700, 0x4ff8, 0x4ffc, 0x5000, 0xd000, 0xd000, 0xcfc0, 0xcfc0,
  0x4300, 0x4bf8, 0x4bfc, 0x4c00, 0xcc00, 0xcc00, 0xcbc0, 0xcbc0,
  0x3f00, 0x47f8, 0x47fc, 0x4800, 0xc800, 0xc800, 0xc7c0, 0xc7c0,
  0x3b00, 0x43f8, 0x43fc, 0x4400, 0xc400, 0xc400, 0xc3c0, 0xc3c0,
  0x3700, 0x3ff8, 0x3ffc, 0x4000, 0xc000, 0xc000, 0xbfc0, 0xbfc0,
  0x3300, 0x3bf8, 0x3bfc, 0x3c00, 0xbc00, 0xbc00, 0xbbc0, 0xbbc0,
  0x2f00, 0x37f8, 0x37fc, 0x3800, 0xb800, 0xb800, 0xb7c0, 0xb7c0,
  0x77f8, 0x77fc, 0x7800, 0xf800, 0xf800, 0xf7c0, 0xf7c0, 0xf7b9,
  0x73f8, 0x73fc, 0x7400, 0xf400, 0xf400, 0xf3c0, 0xf3c0, 0xf3b9,
  0x6ff8, 0x6ffc, 0x7000, 0xf000, 0xf000, 0xefc0, 0xefc0, 0xefb9,
  0x6bf8, 0x6bfc, 0x6c00, 0xec00, 0xec00, 0xebc0, 0xebc0, 0xebb9,
  0x67f8, 0x67fc, 0x6800, 0xe800, 0xe800, 0xe7c0, 0xe7c0, 0xe7b9,
  0x63f8, 0x63fc, 0x6400, 0xe400, 0xe400, 0xe3c0, 0xe3c0, 0xe3b9,
  0x5ff8, 0x5ffc, 0x6000, 0xe000, 0xe000, 0xdfc0, 0xdfc0, 0xdfb9,
  0x5bf8, 0x5bfc, 0x5c00, 0xdc00, 0xdc00, 0xdbc0, 0xdbc0, 0xdbb9,
  0x57f8, 0x57fc, 0x5800, 0xd800, 0xd800, 0xd7c0, 0xd7c0, 0xd7b9,
  0x53f8, 0x53fc, 0x5400, 0xd400, 0xd400, 0xd3c0, 0xd3c0, 0xd3b9,
  0x4ff8, 0x4ffc, 0x5000, 0xd000, 0xd000, 0xcfc0, 0xcfc0, 0xcfb9,
  0x4bf8, 0x4bfc, 0x4c00, 0xcc00, 0xcc00, 0xcbc0, 0xcbc0, 0xcbb9,
  0x47f8, 0x47fc, 0x4800, 0xc800, 0xc800, 0xc7c0, 0xc7c0, 0xc7b9,
  0x43f8, 0x43fc, 0x4400, 0xc400, 0xc400, 0xc3c0, 0xc3c0, 0xc3b9,
  0x3ff8, 0x3ffc, 0x4000, 0xc000, 0xc000, 0xbfc0, 0xbfc0, 0xbfb9,
  0x3bf8, 0x3bfc, 0x3c00, 0xbc00, 0xbc00, 0xbbc0, 0xbbc0, 0xbbb9,
  0x37f8, 0x37fc, 0x3800, 0xb800, 0xb800, 0xb7c0, 0xb7c0, 0xb7b9,
  0x77fc, 0x7800, 0xf800, 0xf800, 0xf7c0, 0xf7c0, 0xf7b9, 0xf780,
  0x73fc, 0x7400, 0xf400, 0xf400, 0xf3c0, 0xf3c0, 0xf3b9, 0xf380,
  0x6ffc, 0x7000, 0xf000, 0xf000, 0xefc0, 0xefc0, 0xefb9, 0xef80,
  0x6bfc, 0x6c00, 0xec00, 0xec00, 0xebc0, 0xebc0, 0xebb9, 0xeb80,
  0x67fc, 0x6800, 0xe800, 0xe800, 0xe7c0, 0xe7c0, 0xe7b9, 0xe780,
  0x63fc, 0x6400, 0xe400, 0xe400, 0xe3c0, 0xe3c0, 0xe3b9, 0xe380,
  0x5ffc, 0x6000, 0xe000, 0xe000, 0xdfc0, 0xdfc0, 0xdfb9, 0xdf80,
  0x5bfc, 0x5c00, 0xdc00, 0xdc00, 0xdbc0, 0xdbc0, 0xdbb9, 0xdb80,
  0x57fc, 0x5800, 0xd800, 0xd800, 0xd7c0, 0xd7c0, 0xd7b9, 0xd780,
  0x53fc, 0x5400, 0xd400, 0xd400, 0xd3c0, 0xd3c0, 0xd3b9, 0xd380,
  0x4ffc, 0x5000, 0xd000, 0xd000, 0xcfc0, 0xcfc0, 0xcfb9, 0xcf80,
  0x4bfc, 0x4c00, 0xcc00, 0xcc00, 0xcbc0, 0xcbc0, 0xcbb9, 0xcb80,
  0x47fc, 0x4800, 0xc800, 0xc800, 0xc7c0, 0xc7c0, 0xc7b9, 0xc780,
  0x43fc, 0x4400, 0xc400, 0xc400, 0xc3c0, 0xc3c0, 0xc3b9, 0xc380,
  0x3ffc, 0x4000, 0xc000, 0xc000, 0xbfc0, 0xbfc0, 0xbfb9, 0xbf80,
  0x3bfc, 0x3c00, 0xbc00, 0xbc00, 0xbbc0, 0xbbc0, 0xbbb9, 0xbb80,
  0x37fc, 0x3800, 0xb800, 0xb800, 0xb7c0, 0xb7c0, 0xb7b9, 0xb780,
  0x7800, 0xf800, 0xf800, 0xf7c0, 0xf7c0, 0xf7b9, 0xf780, 0xf780,
  0x7400, 0xf400, 0xf400, 0xf3c0, 0xf3c0, 0xf3b9, 0xf380, 0xf380,
  0x7000, 0xf000, 0xf000, 0xefc0, 0xefc0, 0xefb9, 0xef80, 0xef80,
  0x6c00, 0xec00, 0xec00, 0xebc0, 0xebc0, 0xebb9, 0xeb80, 0xeb80,
  0x6800, 0xe800, 0xe800, 0xe7c0, 0xe7c0, 0xe7b9, 0xe780, 0xe780,
  0x6400, 0xe400, 0xe400, 0xe3c0, 0xe3c0, 0xe3b9, 0xe380, 0xe380,
  0x6000, 0xe000, 0xe000, 0xdfc0, 0xdfc0, 0xdfb9, 0xdf80, 0xdf80,
  0x5c00, 0xdc00, 0xdc00, 0xdbc0, 0xdbc0, 0xdbb9, 0xdb80, 0xdb80,
  0x5800, 0xd800, 0xd800, 0xd7c0, 0xd7c0, 0xd7b9, 0xd780, 0xd780,
  0x5400, 0xd400, 0xd400, 0xd3c0, 0xd3c0, 0xd3b9, 0xd380, 0xd380,
  0x5000, 0xd000, 0xd000, 0xcfc0, 0xcfc0, 0xcfb9, 0xcf80, 0xcf80,
  0x4c00, 0xcc00, 0xcc00, 0xcbc0, 0xcbc0, 0xcbb9, 0xcb80, 0xcb80,
  0x4800, 0xc800, 0xc800, 0xc7c0, 0xc7c0, 0xc7b9, 0xc780, 0xc780,
  0x4400, 0xc400, 0xc400, 0xc3c0, 0xc3c0, 0xc3b9, 0xc380, 0xc380,
  0x4000, 0xc000, 0xc000, 0xbfc0, 0xbfc0, 0xbfb9, 0xbf80, 0xbf80,
  0x3c00, 0xbc00, 0xbc00, 0xbbc0, 0xbbc0, 0xbbb9, 0xbb80, 0xbb80,
  0x3800, 0xb800, 0xb800, 0xb7c0, 0xb7c0, 0xb7b9, 0xb780, 0xb780,
  0xf800, 0xf800, 0xf7c0, 0xf7c0, 0xf7b9, 0xf780, 0xf780, 0xf740,
  0xf400, 0xf400, 0xf3c0, 0xf3c0, 0xf3b9, 0xf380, 0xf380, 0xf340,
  0xf000, 0xf000, 0xefc0, 0xefc0, 0xefb9, 0xef80, 0xef80, 0xef40,
  0xec00, 0xec00, 0xebc0, 0xebc0, 0xebb9, 0xeb80, 0xeb80, 0xeb40,
  0xe800, 0xe800, 0xe7c0, 0xe7c0, 0xe7b9, 0xe780, 0xe780, 0xe740,
  0xe400, 0xe400, 0xe3c0, 0xe3c0, 0xe3b9, 0xe380, 0xe380, 0xe340,
  0xe000, 0xe000, 0xdfc0, 0xdfc0, 0xdfb9, 0xdf80, 0xdf80, 0xdf40,
  0xdc00, 0xdc00, 0xdbc0, 0xdbc0, 0xdbb9, 0xdb80, 0xdb80, 0xdb40,
  0xd800, 0xd800, 0xd7c0, 0xd7c0, 0xd7b9, 0xd780, 0xd780, 0xd740,
  0xd400, 0xd400, 0xd3c0, 0xd3c0, 0xd3b9, 0xd380, 0xd380, 0xd340,
  0xd000, 0xd000, 0xcfc0, 0xcfc0, 0xcfb9, 0xcf80, 0xcf80, 0xcf40,
  0xcc00, 0xcc00, 0xcbc0, 0xcbc0, 0xcbb9, 0xcb80, 0xcb80, 0xcb40,
  0xc800, 0xc800, 0xc7c0, 0xc7c0, 0xc7b9, 0xc780, 0xc780, 0xc740,
  0xc400, 0xc400, 0xc3c0, 0xc3c0, 0xc3b9, 0xc380, 0xc380, 0xc340,
  0xc000, 0xc000, 0xbfc0, 0xbfc0, 0xbfb9, 0xbf80, 0xbf80, 0xbf40,
  0xbc00, 0xbc00, 0xbbc0, 0xbbc0, 0xbbb9, 0xbb80, 0xbb80, 0xbb40,
  0xb800, 0xb800, 0xb7c0, 0xb7c0, 0xb7b9, 0xb780, 0xb780, 0xb740,
  0xf800, 0xf7c0, 0xf7c0, 0xf7b9, 0xf780, 0xf780, 0xf740, 0xf740,
  0xf400, 0xf3c0, 0xf3c0, 0xf3b9, 0xf380, 0xf380, 0xf340, 0xf340,
  0xf000, 0xefc0, 0xefc0, 0xefb9, 0xef80, 0xef80, 0xef40, 0xef40,
  0xec00, 0xebc0, 0xebc0, 0xebb9, 0xeb80, 0xeb80, 0xeb40, 0xeb40,
  0xe800, 0xe7c0, 0xe7c0, 0xe7b9, 0xe780, 0xe780, 0xe740, 0xe740,
  0xe400, 0xe3c0, 0xe3c0, 0xe3b9, 0xe380, 0xe380, 0xe340, 0xe340,
  0xe000, 0xdfc0, 0xdfc0, 0xdfb9, 0xdf80, 0xdf80, 0xdf40, 0xdf40,
  0xdc00, 0xdbc0, 0xdbc0, 0xdbb9, 0xdb80, 0xdb80, 0xdb40, 0xdb40,
  0xd800, 0xd7c0, 0xd7c0, 0xd7b9, 0xd780, 0xd780, 0xd740, 0xd740,
  0xd400, 0xd3c0, 0xd3c0, 0xd3b9, 0xd380, 0xd380, 0xd340, 0xd340,
  0xd000, 0xcfc0, 0xcfc0, 0xcfb9, 0xcf80, 0xcf80, 0xcf40, 0xcf40,
  0xcc00, 0xcbc0, 0xcbc0, 0xcbb9, 0xcb80, 0xcb80, 0xcb40, 0xcb40,
  0xc800, 0xc7c0, 0xc7c0, 0xc7b9, 0xc780, 0xc780, 0xc740, 0xc740,
  0xc400, 0xc3c0, 0xc3c0, 0xc3b9, 0xc380, 0xc380, 0xc340, 0xc340,
  0xc000, 0xbfc0, 0xbfc0, 0xbfb9, 0xbf80, 0xbf80, 0xbf40, 0xbf40,
  0xbc00, 0xbbc0, 0xbbc0, 0xbbb9, 0xbb80, 0xbb80, 0xbb40, 0xbb40,
  0xb800, 0xb7c0, 0xb7c0, 0xb7b9, 0xb780, 0xb780, 0xb740, 0xb740,
  0xf7c0, 0xf7c0, 0xf7b9, 0xf780, 0xf780, 0xf740, 0xf740, 0xf700,
  0xf3c0, 0xf3c0, 0xf3b9, 0xf380, 0xf380, 0xf340, 0xf340, 0xf300,
  0xefc0, 0xefc0, 0xefb9, 0xef80, 0xef80, 0xef40, 0xef40, 0xef00,
  0xebc0, 0xebc0, 0xebb9, 0xeb80, 0xeb80, 0xeb40, 0xeb40, 0xeb00,
  0xe7c0, 0xe7c0, 0xe7b9, 0xe780, 0xe780, 0xe740, 0xe740, 0xe700,
  0xe3c0, 0xe3c0, 0xe3b9, 0xe380, 0xe380, 0xe340, 0xe340, 0xe300,
  0xdfc0, 0xdfc0, 0xdfb9, 0xdf80, 0xdf80, 0xdf40, 0xdf40, 0xdf00,
  0xdbc0, 0xdbc0, 0xdbb9, 0xdb80, 0xdb80, 0xdb40, 0xdb40, 0xdb00,
  0xd7c0, 0xd7c0, 0xd7b9, 0xd780, 0xd780, 0xd740, 0xd740, 0xd700,
  0xd3c0, 0xd3c0, 0xd3b9, 0xd380, 0xd380, 0xd340, 0xd340, 0xd300,
  0xcfc0, 0xcfc0, 0xcfb9, 0xcf80, 0xcf80, 0xcf40, 0xcf40, 0xcf00,
  0xcbc0, 0xcbc0, 0xcbb9, 0xcb80, 0xcb80, 0xcb40, 0xcb40, 0xcb00,
  0xc7c0, 0xc7c0, 0xc7b9, 0xc780, 0xc780, 0xc740, 0xc740, 0xc700,
  0xc3c0, 0xc3c0, 0xc3b9, 0xc380, 0xc380, 0xc340, 0xc340, 0xc300,
  0xbfc0, 0xbfc0, 0xbfb9, 0xbf80, 0xbf80, 0xbf40, 0xbf40, 0xbf00,
  0xbbc0, 0xbbc0, 0xbbb9, 0xbb80, 0xbb80, 0xbb40, 0xbb40, 0xbb00,
  0xb7c0, 0xb7c0, 0xb7b9, 0xb780, 0xb780, 0xb740, 0xb740, 0xb700,
  0xf7c0, 0xf7b9, 0xf780, 0xf780, 0xf740, 0xf740, 0xf700, 0xf700,
  0xf3c0, 0xf3b9, 0xf380, 0xf380, 0xf340, 0xf340, 0xf300, 0xf300,
  0xefc0, 0xefb9, 0xef80, 0xef80, 0xef40, 0xef40, 0xef00, 0xef00,
  0xebc0, 0xebb9, 0xeb80, 0xeb80, 0xeb40, 0xeb40, 0xeb00, 0xeb00,
  0xe7c0, 0xe7b9, 0xe780, 0xe780, 0xe740, 0xe740, 0xe700, 0xe700,
  0xe3c0, 0xe3b9, 0xe380, 0xe380, 0xe340, 0xe340, 0xe300, 0xe300,
  0xdfc0, 0xdfb9, 0xdf80, 0xdf80, 0xdf40, 0xdf40, 0xdf00, 0xdf00,
  0xdbc0, 0xdbb9, 0xdb80, 0xdb80, 0xdb40, 0xdb40, 0xdb00, 0xdb00,
  0xd7c0, 0xd7b9, 0xd780, 0xd780, 0xd740, 0xd740, 0xd700, 0xd700,
  0xd3c0, 0xd3b9, 0xd380, 0xd380, 0xd340, 0xd340, 0xd300, 0xd300,
  0xcfc0, 0xcfb9, 0xcf80, 0xcf80, 0xcf40, 0xcf40, 0xcf00, 0xcf00,
  0xcbc0, 0xcbb9, 0xcb80, 0xcb80, 0xcb40, 0xcb40, 0xcb00, 0xcb00,
  0xc7c0, 0xc7b9, 0xc780, 0xc780, 0xc740, 0xc740, 0xc700, 0xc700,
  0xc3c0, 0xc3b9, 0xc380, 0xc380, 0xc340, 0xc340, 0xc300, 0xc300,
  0xbfc0, 0xbfb9, 0xbf80, 0xbf80, 0xbf40, 0xbf40, 0xbf00, 0xbf00,
  0xbbc0, 0xbbb9, 0xbb80, 0xbb80, 0xbb40, 0xbb40, 0xbb00, 0xbb00,
  0xb7c0, 0xb7b9, 0xb780, 0xb780, 0xb740, 0xb740, 0xb700, 0xb700,
  0xf7b9, 0xf780, 0xf780, 0xf740, 0xf740, 0xf700, 0xf700, 0xf6c0,
  0xf3b9, 0xf380, 0xf380, 0xf340, 0xf340, 0xf300, 0xf300, 0xf2c0,
  0xefb9, 0xef80, 0xef80, 0xef40, 0xef40, 0xef00, 0xef00, 0xeec0,
  0xebb9, 0xeb80, 0xeb80, 0xeb40, 0xeb40, 0xeb00, 0xeb00, 0xeac0,
  0xe7b9, 0xe780, 0xe780, 0xe740, 0xe740, 0xe700, 0xe700, 0xe6c0,
  0xe3b9, 0xe380, 0xe380, 0xe340, 0xe340, 0xe300, 0xe300, 0xe2c0,
  0xdfb9, 0xdf80, 0xdf80, 0xdf40, 0xdf40, 0xdf00, 0xdf00, 0xdec0,
  0xdbb9, 0xdb80, 0xdb80, 0xdb40, 0xdb40, 0xdb00, 0xdb00, 0xdac0,
  0xd7b9, 0xd780, 0xd780, 0xd740, 0xd740, 0xd700, 0xd700, 0xd6c0,
  0xd3b9, 0xd380, 0xd380, 0xd340, 0xd340, 0xd300, 0xd300, 0xd2c0,
  0xcfb9, 0xcf80, 0xcf80, 0xcf40, 0xcf40, 0xcf00, 0xcf00, 0xcec0,
  0xcbb9, 0xcb80, 0xcb80, 0xcb40, 0xcb40, 0xcb00, 0xcb00, 0xcac0,
  0xc7b9, 0xc780, 0xc780, 0xc740, 0xc740, 0xc700, 0xc700, 0xc6c0,
  0xc3b9, 0xc380, 0xc380, 0xc340, 0xc340, 0xc300, 0xc300, 0xc2c0,
  0xbfb9, 0xbf80, 0xbf80, 0xbf40, 0xbf40, 0xbf00, 0xbf00, 0xbec0,
  0xbbb9, 0xbb80, 0xbb80, 0xbb40, 0xbb40, 0xbb00, 0xbb00, 0xbac0,
  0xb7b9, 0xb780, 0xb780, 0xb740, 0xb740, 0xb700, 0xb700, 0xb6c0,
  0xf780, 0xf780, 0xf740, 0xf740, 0xf700, 0xf700, 0xf6c0, 0xf6c0,
  0xf380, 0xf380, 0xf340, 0xf340, 0xf300, 0xf300, 0xf2c0, 0xf2c0,
  0xef80, 0xef80, 0xef40, 0xef40, 0xef00, 0xef00, 0xeec0, 0xeec0,
  0xeb80, 0xeb80, 0xeb40, 0xeb40, 0xeb00, 0xeb00, 0xeac0, 0xeac0,
  0xe780, 0xe780, 0xe740, 0xe740, 0xe700, 0xe700, 0xe6c0, 0xe6c0,
  0xe380, 0xe380, 0xe340, 0xe340, 0xe300, 0xe300, 0xe2c0, 0xe2c0,
  0xdf80, 0xdf80, 0xdf40, 0xdf40, 0xdf00, 0xdf00, 0xdec0, 0xdec0,
  0xdb80, 0xdb80, 0xdb40, 0xdb40, 0xdb00, 0xdb00, 0xdac0, 0xdac0,
  0xd780, 0xd780, 0xd740, 0xd740, 0xd700, 0xd700, 0xd6c0, 0xd6c0,
  0xd380, 0xd380, 0xd340, 0xd340, 0xd300, 0xd300, 0xd2c0, 0xd2c0,
  0xcf80, 0xcf80, 0xcf40, 0xcf40, 0xcf00, 0xcf00, 0xcec0, 0xcec0,
  0xcb80, 0xcb80, 0xcb40, 0xcb40, 0xcb00, 0xcb00, 0xcac0, 0xcac0,
  0xc780, 0xc780, 0xc740, 0xc740, 0xc700, 0xc700, 0xc6c0, 0xc6c0,
  0xc380, 0xc380, 0xc340, 0xc340, 0xc300, 0xc300, 0xc2c0, 0xc2c0,
  0xbf80, 0xbf80, 0xbf40, 0xbf40, 0xbf00, 0xbf00, 0xbec0, 0xbec0,
  0xbb80, 0xbb80, 0xbb40, 0xbb40, 0xbb00, 0xbb00, 0xbac0, 0xbac0,
  0xb780, 0xb780, 0xb740, 0xb740, 0xb700, 0xb700, 0xb6c0, 0xb6c0,
  0xf780, 0xf740, 0xf740, 0xf700, 0xf700, 0xf6c0, 0xf6c0, 0xf680,
  0xf380, 0xf340, 0xf340, 0xf300, 0xf300, 0xf2c0, 0xf2c0, 0xf280,
  0xef80, 0xef40, 0xef40, 0xef00, 0xef00, 0xeec0, 0xeec0, 0xee80,
  0xeb80, 0xeb40, 0xeb40, 0xeb00, 0xeb00, 0xeac0, 0xeac0, 0xea80,
  0xe780, 0xe740, 0xe740, 0xe700, 0xe700, 0xe6c0, 0xe6c0, 0xe680,
  0xe380, 0xe340, 0xe340, 0xe300, 0xe300, 0xe2c0, 0xe2c0, 0xe280,
  0xdf80, 0xdf40, 0xdf40, 0xdf00, 0xdf00, 0xdec0, 0xdec0, 0xde80,
  0xdb80, 0xdb40, 0xdb40, 0xdb00, 0xdb00, 0xdac0, 0xdac0, 0xda80,
  0xd780, 0xd740, 0xd740, 0xd700, 0xd700, 0xd6c0, 0xd6c0, 0xd680,
  0xd380, 0xd340, 0xd340, 0xd300, 0xd300, 0xd2c0, 0xd2c0, 0xd280,
  0xcf80, 0xcf40, 0xcf40, 0xcf00, 0xcf00, 0xcec0, 0xcec0, 0xce80,
  0xcb80, 0xcb40, 0xcb40, 0xcb00, 0xcb00, 0xcac0, 0xcac0, 0xca80,
  0xc780, 0xc740, 0xc740, 0xc700, 0xc700, 0xc6c0, 0xc6c0, 0xc680,
  0xc380, 0xc340, 0xc340, 0xc300, 0xc300, 0xc2c0, 0xc2c0, 0xc280,
  0xbf80, 0xbf40, 0xbf40, 0xbf00, 0xbf00, 0xbec0, 0xbec0, 0xbe80,
  0xbb80, 0xbb40, 0xbb40, 0xbb00, 0xbb00, 0xbac0, 0xbac0, 0xba80,
  0xb780, 0xb740, 0xb740, 0xb700, 0xb700, 0xb6c0, 0xb6c0, 0xb680,
  0xf740, 0xf740, 0xf700, 0xf700, 0xf6c0, 0xf6c0, 0xf680, 0xf640,
  0xf340, 0xf340, 0xf300, 0xf300, 0xf2c0, 0xf2c0, 0xf280, 0xf240,
  0xef40, 0xef40, 0xef00, 0xef00, 0xeec0, 0xeec0, 0xee80, 0xee40,
  0xeb40, 0xeb40, 0xeb00, 0xeb00, 0xeac0, 0xeac0, 0xea80, 0xea40,
  0xe740, 0xe740, 0xe700, 0xe700, 0xe6c0, 0xe6c0, 0xe680, 0xe640,
  0xe340, 0xe340, 0xe300, 0xe300, 0xe2c0, 0xe2c0, 0xe280, 0xe240,
  0xdf40, 0xdf40, 0xdf00, 0xdf00, 0xdec0, 0xdec0, 0xde80, 0xde40,
  0xdb40, 0xdb40, 0xdb00, 0xdb00, 0xdac0, 0xdac0, 0xda80, 0xda40,
  0xd740, 0xd740, 0xd700, 0xd700, 0xd6c0, 0xd6c0, 0xd680, 0xd640,
  0xd340, 0xd340, 0xd300, 0xd300, 0xd2c0, 0xd2c0, 0xd280, 0xd240,
  0xcf40, 0xcf40, 0xcf00, 0xcf00, 0xcec0, 0xcec0, 0xce80, 0xce40,
  0xcb40, 0xcb40, 0xcb00, 0xcb00, 0xcac0, 0xcac0, 0xca80, 0xca40,
  0xc740, 0xc740, 0xc700, 0xc700, 0xc6c0, 0xc6c0, 0xc680, 0xc640,
  0xc340, 0xc340, 0xc300, 0xc300, 0xc2c0, 0xc2c0, 0xc280, 0xc240,
  0xbf40, 0xbf40, 0xbf00, 0xbf00, 0xbec0, 0xbec0, 0xbe80, 0xbe40,
  0xbb40, 0xbb40, 0xbb00, 0xbb00, 0xbac0, 0xbac0, 0xba80, 0xba40,
  0xb740, 0xb740, 0xb700, 0xb700, 0xb6c0, 0xb6c0, 0xb680, 0xb640,
  0xf740, 0xf700, 0xf700, 0xf6c0, 0xf6c0, 0xf680, 0xf640, 0xd800,
  0xf340, 0xf300, 0xf300, 0xf2c0, 0xf2c0, 0xf280, 0xf240, 0xd400,
  0xef40, 0xef00, 0xef00, 0xeec0, 0xeec0, 0xee80, 0xee40, 0xd000,
  0xeb40, 0xeb00, 0xeb00, 0xeac0, 0xeac0, 0xea80, 0xea40, 0xcc00,
  0xe740, 0xe700, 0xe700, 0xe6c0, 0xe6c0, 0xe680, 0xe640, 0xc800,
  0xe340, 0xe300, 0xe300, 0xe2c0, 0xe2c0, 0xe280, 0xe240, 0xc400,
  0xdf40, 0xdf00, 0xdf00, 0xdec0, 0xdec0, 0xde80, 0xde40, 0xc000,
  0xdb40, 0xdb00, 0xdb00, 0xdac0, 0xdac0, 0xda80, 0xda40, 0xbc00,
  0xd740, 0xd700, 0xd700, 0xd6c0, 0xd6c0, 0xd680, 0xd640, 0xb800,
  0xd340, 0xd300, 0xd300, 0xd2c0, 0xd2c0, 0xd280, 0xd240, 0xb400,
  0xcf40, 0xcf00, 0xcf00, 0xcec0, 0xcec0, 0xce80, 0xce40, 0xb000,
  0xcb40, 0xcb00, 0xcb00, 0xcac0, 0xcac0, 0xca80, 0xca40, 0xac00,
  0xc740, 0xc700, 0xc700, 0xc6c0, 0xc6c0, 0xc680, 0xc640, 0xa800,
  0xc340, 0xc300, 0xc300, 0xc2c0, 0xc2c0, 0xc280, 0xc240, 0xa400,
  0xbf40, 0xbf00, 0xbf00, 0xbec0, 0xbec0, 0xbe80, 0xbe40, 0xa000,
  0xbb40, 0xbb00, 0xbb00, 0xbac0, 0xbac0, 0xba80, 0xba40, 0x9c00,
  0xb740, 0xb700, 0xb700, 0xb6c0, 0xb6c0, 0xb680, 0xb640, 0x9800,
  0xf700, 0xf700, 0xf6c0, 0xf6c0, 0xf680, 0xf640, 0xd800, 0xd400,
  0xf300, 0xf300, 0xf2c0, 0xf2c0, 0xf280, 0xf240, 0xd400, 0xd000,
  0xef00, 0xef00, 0xeec0, 0xeec0, 0xee80, 0xee40, 0xd000, 0xcc00,
  0xeb00, 0xeb00, 0xeac0, 0xeac0, 0xea80, 0xea40, 0xcc00, 0xc800,
  0xe700, 0xe700, 0xe6c0, 0xe6c0, 0xe680, 0xe640, 0xc800, 0xc400,
  0xe300, 0xe300, 0xe2c0, 0xe2c0, 0xe280, 0xe240, 0xc400, 0xc000,
  0xdf00, 0xdf00, 0xdec0, 0xdec0, 0xde80, 0xde40, 0xc000, 0xbc00,
  0xdb00, 0xdb00, 0xdac0, 0xdac0, 0xda80, 0xda40, 0xbc00, 0xb800,
  0xd700, 0xd700, 0xd6c0, 0xd6c0, 0xd680, 0xd640, 0xb800, 0xb400,
  0xd300, 0xd300, 0xd2c0, 0xd2c0, 0xd280, 0xd240, 0xb400, 0xb000,
  0xcf00, 0xcf00, 0xcec0, 0xcec0, 0xce80, 0xce40, 0xb000, 0xac00,
  0xcb00, 0xcb00, 0xcac0, 0xcac0, 0xca80, 0xca40, 0xac00, 0xa800,
  0xc700, 0xc700, 0xc6c0, 0xc6c0, 0xc680, 0xc640, 0xa800, 0xa400,
  0xc300, 0xc300, 0xc2c0, 0xc2c0, 0xc280, 0xc240, 0xa400, 0xa000,
  0xbf00, 0xbf00, 0xbec0, 0xbec0, 0xbe80, 0xbe40, 0xa000, 0x9c00,
  0xbb00, 0xbb00, 0xbac0, 0xbac0, 0xba80, 0xba40, 0x9c00, 0x9800,
  0xb700, 0xb700, 0xb6c0, 0xb6c0, 0xb680, 0xb640, 0x9800, 0x9400,
  0xf700, 0xf6c0, 0xf6c0, 0xf680, 0xf640, 0xd800, 0xd400, 0xbc00,
  0xf300, 0xf2c0, 0xf2c0, 0xf280, 0xf240, 0xd400, 0xd000, 0xb800,
  0xef00, 0xeec0, 0xeec0, 0xee80, 0xee40, 0xd000, 0xcc00, 0xb400,
  0xeb00, 0xeac0, 0xeac0, 0xea80, 0xea40, 0xcc00, 0xc800, 0xb000,
  0xe700, 0xe6c0, 0xe6c0, 0xe680, 0xe640, 0xc800, 0xc400, 0xac00,
  0xe300, 0xe2c0, 0xe2c0, 0xe280, 0xe240, 0xc400, 0xc000, 0xa800,
  0xdf00, 0xdec0, 0xdec0, 0xde80, 0xde40, 0xc000, 0xbc00, 0xa400,
  0xdb00, 0xdac0, 0xdac0, 0xda80, 0xda40, 0xbc00, 0xb800, 0xa000,
  0xd700, 0xd6c0, 0xd6c0, 0xd680, 0xd640, 0xb800, 0xb400, 0x9c00,
  0xd300, 0xd2c0, 0xd2c0, 0xd280, 0xd240, 0xb400, 0xb000, 0x9800,
  0xcf00, 0xcec0, 0xcec0, 0xce80, 0xce40, 0xb000, 0xac00, 0x9400,
  0xcb00, 0xcac0, 0xcac0, 0xca80, 0xca40, 0xac00, 0xa800, 0x9000,
  0xc700, 0xc6c0, 0xc6c0, 0xc680, 0xc640, 0xa800, 0xa400, 0x8c00,
  0xc300, 0xc2c0, 0xc2c0, 0xc280, 0xc240, 0xa400, 0xa000, 0x8800,
  0xbf00, 0xbec0, 0xbec0, 0xbe80, 0xbe40, 0xa000, 0x9c00, 0x8400,
  0xbb00, 0xbac0, 0xbac0, 0xba80, 0xba40, 0x9c00, 0x9800, 0x8200,
  0xb700, 0xb6c0, 0xb6c0, 0xb680, 0xb640, 0x9800, 0x9400, 0x8100,
};
const unsigned kExpectedCount_NEON_scvtf_8H_2OPIMM = 1020;

#endif  // VIXL_SIM_SCVTF_8H_2OPIMM_TRACE_AARCH64_H_
