/*
 * keycodes.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _KEYCODES_H
#define _KEYCODES_H

enum {
     SW_MOUSE1 = 0xFE01,
     SW_MOUSE2 = 0xFE02,
     SW_MOUSE3 = 0xFE03,
     SW_MOUSE4 = 0xFE04,
     SW_MOUSE5 = 0xFE05,

     SW_BACKSPACE = 0xFF08,
     SW_TAB = 0xFF09,
     SW_ENTER = 0xFF0D,
     SW_ESCAPE = 0xFF1B,
     SW_DELETE = 0xFFFF,
     SW_INSERT = 0xFF63,

     SW_HOME = 0xFF50,
     SW_KEY_LEFT = 0xFF51,
     SW_UP = 0xFF52,
     SW_KEY_RIGHT = 0xFF53,
     SW_DOWN = 0xFF54,
     SW_PAGEUP = 0xFF55,
     SW_PAGEDN = 0xFF56,
     SW_END = 0xFF57,

     SW_F1 = 0xFFBE,
     SW_F2 = 0xFFBF,
     SW_F3 = 0xFFC0,
     SW_F4 = 0xFFC1,
     SW_F5 = 0xFFC2,
     SW_F6 = 0xFFC3,
     SW_F7 = 0xFFC4,
     SW_F8 = 0xFFC5,
     SW_F9 = 0xFFC6,
     SW_F10 = 0xFFC7,
     SW_F11 = 0xFFC8,
     SW_F12 = 0xFFC9,

     SW_SPACE = 0x0020,
     SW_EXCLAM = 0x0021,
     SW_QUOTEDBL = 0x0022,
     SW_NUMBERSIGN = 0x0023,
     SW_DOLLAR = 0x0024,
     SW_PERCENT = 0x0025,
     SW_AMPERSAND = 0x0026,
     SW_APOSTROPHE = 0x0027,
     SW_PARENLEFT = 0x0028,
     SW_PARENRIGHT = 0x0029,
     SW_ASTERISK = 0x002A,
     SW_PLUS = 0x002B,
     SW_COMMA = 0x002C,
     SW_MINUS = 0x002D,
     SW_PERIOD = 0x002E,
     SW_SLASH = 0x002F,
     SW_KEY_0 = 0x0030,
     SW_KEY_1 = 0x0031,
     SW_KEY_2 = 0x0032,
     SW_KEY_3 = 0x0033,
     SW_KEY_4 = 0x0034,
     SW_KEY_5 = 0x0035,
     SW_KEY_6 = 0x0036,
     SW_KEY_7 = 0x0037,
     SW_KEY_8 = 0x0038,
     SW_KEY_9 = 0x0039,
     SW_COLON = 0x003A,
     SW_SEMICOLON = 0x003B,
     SW_LESS = 0x003C,
     SW_EQUAL = 0x003D,
     SW_GREATER = 0x003E,
     SW_QUESTION = 0x003F,
     SW_AT = 0x0040,
     SW_KEY_A = 0x0041,
     SW_KEY_B = 0x0042,
     SW_KEY_C = 0x0043,
     SW_KEY_D = 0x0044,
     SW_KEY_E = 0x0045,
     SW_KEY_F = 0x0046,
     SW_KEY_G = 0x0047,
     SW_KEY_H = 0x0048,
     SW_KEY_I = 0x0049,
     SW_KEY_J = 0x004A,
     SW_KEY_K = 0x004B,
     SW_KEY_L = 0x004C,
     SW_KEY_M = 0x004D,
     SW_KEY_N = 0x004E,
     SW_KEY_O = 0x004F,
     SW_KEY_P = 0x0050,
     SW_KEY_Q = 0x0051,
     SW_KEY_R = 0x0052,
     SW_KEY_S = 0x0053,
     SW_KEY_T = 0x0054,
     SW_KEY_U = 0x0055,
     SW_KEY_V = 0x0056,
     SW_KEY_W = 0x0057,
     SW_KEY_X = 0x0058,
     SW_KEY_Y = 0x0059,
     SW_KEY_Z = 0x005A,
     SW_BRACKETLEFT = 0x005B,
     SW_BACKSLASH = 0x005C,
     SW_BRACKETRIGHT= 0x005D,
     SW_ASCIICIRCUM = 0x005E,
     SW_UNDERSCORE = 0x005F,
     SW_GRAVE = 0x0060,
     SW_KEY_a = 0x0061,
     SW_KEY_b = 0x0062,
     SW_KEY_c = 0x0063,
     SW_KEY_d = 0x0064,
     SW_KEY_e = 0x0065,
     SW_KEY_f = 0x0066,
     SW_KEY_g = 0x0067,
     SW_KEY_h = 0x0068,
     SW_KEY_i = 0x0069,
     SW_KEY_j = 0x006A,
     SW_KEY_k = 0x006B,
     SW_KEY_l = 0x006C,
     SW_KEY_m = 0x006D,
     SW_KEY_n = 0x006E,
     SW_KEY_o = 0x006F,
     SW_KEY_p = 0x0070,
     SW_KEY_q = 0x0071,
     SW_KEY_r = 0x0072,
     SW_KEY_s = 0x0073,
     SW_KEY_t = 0x0074,
     SW_KEY_u = 0x0075,
     SW_KEY_v = 0x0076,
     SW_KEY_w = 0x0077,
     SW_KEY_x = 0x0078,
     SW_KEY_y = 0x0079,
     SW_KEY_z = 0x007A,
     SW_BRACELEFT = 0x007B,
     SW_BAR = 0x007C,
     SW_BRACERIGHT = 0x007D,
     SW_TILDE = 0x007E
};
#endif
