#!/usr/bin/env python
import re
from glob import glob


BOILERPLATE = """\
(*  Wyrd -- a curses-based front-end for Remind
 *  Copyright (C) 2005, 2006, 2007, 2008, 2010, 2011-2013 Paul Pelzl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, Version 2,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Bug reports can be entered at http://bugs.launchpad.net/wyrd .
 *  For anything else, feel free to contact Paul Pelzl at <pelzlpj@gmail.com>.
 *)"""

boilerplate_regex = re.compile(r'\(\*.*?\*\)', re.DOTALL)

def update_boilerplate(filename):
    with open(filename, 'r') as f:
        content = f.read()
    content = boilerplate_regex.sub(BOILERPLATE, content, 1)
    with open(filename, 'w') as f:
        f.write(content)


AUTOGENERATED = ['install.ml', 'version.ml', 'setup.ml', 'make_oasis.ml']
FILENAMES     = [x for x in glob('*.ml') + glob('*.mli') + glob('*.ml.in') if x not in AUTOGENERATED]

for filename in FILENAMES:
    print 'Updating %s...' % filename
    update_boilerplate(filename)

