dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2003 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the XMPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl XMPI source distribution.
dnl
dnl $Id: mpi_check_trillium.m4,v 1.2 2003/08/23 13:35:48 jsquyres Exp $
dnl

define([LSC_MPI_CHECK_TRILLIUM],[
#
# Arguments: None
#
# Dependencies: None
# 
# Aborts if we cannot #include<lam.h>
# lam.h is ONLY installed if trilium header files are present
#

AC_MSG_CHECKING([for Trillium header files])
# See if we can find <lam.h>
touch conftest.o conftest.lo
rm -f conftest.o conftest.lo
cat > conftest.$ac_ext <<EOF
#include <lam.h>
int
main(int argc, char* argv[])
{ return 0; }
EOF
echo configure:__oline__: $ac_compile >&5
(eval $ac_compile) 2>&5
if test -f conftest.o -o -f conftest.lo ; then
    AC_MSG_RESULT([yes])
else
    echo configure:__oline__: here is the program that failed: >&5
    cat conftest.$ac_ext >&5
    AC_MSG_RESULT([no])
    AC_MSG_WARN(Can not find Trillium header files.)
    AC_MSG_WARN(LAM/MPI must be configured with the '--with-trillium')
    AC_MSG_WARN(option in order to build this application)
    AC_MSG_ERROR([cannot continue -- cannot find Trillium header files])
fi
# Kill all temporaries
rm -f conftest*
# Be social; clean up all variables used
unset lsc_prefix])dnl

